/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumStructure;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Measure;

public class Helix
extends ProteinStructure {
    Helix(AlphaPolymer alphaPolymer, int n, int n2, int n3, EnumStructure enumStructure) {
        super(alphaPolymer, EnumStructure.HELIX, n, n2, n3);
        this.subtype = enumStructure;
    }

    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        Point3f[] point3fArray = new Point3f[this.monomerCount + 1];
        for (int i = 0; i <= this.monomerCount; ++i) {
            point3fArray[i] = new Point3f();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + i, point3fArray[i]);
        }
        this.axisA = new Point3f();
        this.axisUnitVector = new Vector3f();
        Measure.calcBestAxisThroughPoints(point3fArray, this.axisA, this.axisUnitVector, this.vectorProjection, 4);
        this.axisB = new Point3f(point3fArray[this.monomerCount]);
        Measure.projectOntoAxis(this.axisB, this.axisA, this.axisUnitVector, this.vectorProjection);
    }
}

