/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Map;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlXsdReader
extends XmlReader {
    private BitSet bsBackbone = new BitSet();
    private int iChain = -1;
    private int iGroup = 0;
    private int iAtom = 0;

    @Override
    protected String[] getImplementedAttributes() {
        return new String[]{"ID", "XYZ", "Connections", "Components", "IsBackboneAtom", "Connects", "Type", "Name"};
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, Object object, XmlReader.JmolXmlHandler jmolXmlHandler) {
        xmlReader.htParams.put("backboneAtoms", this.bsBackbone);
        super.processXml(xmlReader, atomSetCollection, bufferedReader, object, jmolXmlHandler);
        atomSetCollection.clearSymbolicMap();
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        if ("Molecule".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName(map.get("Name"));
            return;
        }
        if ("LinearChain".equals(string2)) {
            this.iGroup = 0;
            ++this.iChain;
        }
        if ("RepeatUnit".equals(string2)) {
            ++this.iGroup;
        }
        if ("Atom3d".equals(string2)) {
            boolean bl;
            this.atom = new Atom();
            this.atom.elementSymbol = map.get("Components");
            this.atom.atomName = map.get("ID");
            this.atom.atomSerial = ++this.iAtom;
            if (this.iChain >= 0) {
                this.atom.chainID = (char)((this.iChain - 1) % 26 + 65);
            }
            this.atom.group3 = "UNK";
            if (this.iGroup == 0) {
                this.iGroup = 1;
            }
            this.atom.sequenceNumber = this.iGroup;
            String string4 = map.get("XYZ");
            if (string4 != null) {
                String[] stringArray = XmlXsdReader.getTokens(string4.replace(',', ' '));
                this.atom.set(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
            }
            if (bl = "1".equals(map.get("IsBackboneAtom"))) {
                this.bsBackbone.set(this.iAtom);
            }
            return;
        }
        if ("Bond".equals(string2)) {
            String[] stringArray = TextFormat.split(map.get("Connects"), ',');
            int n = 1;
            if (map.containsKey("Type")) {
                String string5 = map.get("Type");
                if (string5.equals("Double")) {
                    n = 2;
                } else if (string5.equals("Triple")) {
                    n = 3;
                }
            }
            this.atomSetCollection.addNewBond(stringArray[0], stringArray[1], n);
            return;
        }
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if ("Atom3d".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }
}

