/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    protected boolean checkLine() throws Exception {
        int n = this.parseInt(this.line);
        if (n == Integer.MIN_VALUE) {
            this.continuing = false;
            return false;
        }
        this.vibrationNumber = ++this.modelNumber;
        if (this.desiredVibrationNumber <= 0 ? this.doGetModel(this.modelNumber, null) : this.doGetVibration(this.vibrationNumber)) {
            this.readLine();
            this.checkLineForScript();
            this.atomSetCollection.newAtomSet();
            String string = this.line;
            this.readAtoms(n);
            this.applySymmetryAndSetTrajectory();
            this.atomSetCollection.setAtomSetName(string);
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        } else {
            this.skipAtomSet(n);
        }
        this.discardLinesUntilNonBlank();
        return false;
    }

    protected void finalizeReader() throws Exception {
        this.isTrajectory = false;
        super.finalizeReader();
    }

    private void skipAtomSet(int n) throws Exception {
        this.readLine();
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    private void readAtoms(int n) throws Exception {
        block9: for (int i = 0; i < n; ++i) {
            this.readLine();
            String[] stringArray = this.getTokens();
            if (stringArray.length < 4) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                continue;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            this.setElementAndIsotope(atom, stringArray[0]);
            atom.x = this.parseFloat(stringArray[1]);
            atom.y = this.parseFloat(stringArray[2]);
            atom.z = this.parseFloat(stringArray[3]);
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                atom.set(0.0f, 0.0f, 0.0f);
            }
            int n2 = 4;
            this.setAtomCoord(atom);
            switch (stringArray.length) {
                case 4: {
                    continue block9;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    if (stringArray[4].indexOf(".") >= 0) {
                        atom.partialCharge = this.parseFloat(stringArray[4]);
                    } else {
                        int n3 = this.parseInt(stringArray[4]);
                        if (n3 != Integer.MIN_VALUE) {
                            atom.formalCharge = n3;
                        }
                    }
                    switch (stringArray.length) {
                        case 5: {
                            continue block9;
                        }
                        case 6: {
                            atom.radius = this.parseFloat(stringArray[5]);
                            continue block9;
                        }
                        case 9: {
                            atom.atomSerial = this.parseInt(stringArray[8]);
                        }
                    }
                }
                default: {
                    int n4 = ++n2;
                    float f = this.parseFloat(stringArray[n4]);
                    int n5 = ++n2;
                    float f2 = this.parseFloat(stringArray[n5]);
                    int n6 = ++n2;
                    ++n2;
                    float f3 = this.parseFloat(stringArray[n6]);
                    if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue block9;
                    this.atomSetCollection.addVibrationVector(atom.atomIndex, f, f2, f3);
                }
            }
        }
    }
}

