/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.util.List;
import java.util.Map;
import jspecview.util.TextFormat;

public class Escape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";

    public static String escape(String str) {
        if (str == null) {
            return "\"\"";
        }
        boolean haveEscape = false;
        int i = 0;
        while (i < escapable.length()) {
            if (str.indexOf(escapable.charAt(i)) >= 0) {
                haveEscape = true;
                break;
            }
            i += 2;
        }
        if (haveEscape) {
            while (i < escapable.length()) {
                int pt = -1;
                char ch = escapable.charAt(i++);
                char ch2 = escapable.charAt(i++);
                StringBuffer sb = new StringBuffer();
                int pt0 = 0;
                while ((pt = str.indexOf(ch, pt + 1)) >= 0) {
                    sb.append(str.substring(pt0, pt)).append('\\').append(ch2);
                    pt0 = pt + 1;
                }
                sb.append(str.substring(pt0, str.length()));
                str = sb.toString();
            }
        }
        i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) <= '\u007f') continue;
            str = String.valueOf(str.substring(0, i)) + Escape.unicode(str.charAt(i)) + str.substring(i + 1);
        }
        return "\"" + str + "\"";
    }

    private static String unicode(char c) {
        String s = "0000" + Integer.toHexString(c);
        return "\\u" + s.substring(s.length() - 4);
    }

    public static String toJSON(String infoType, Object info) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (info == null) {
            return Escape.packageJSON(infoType, null);
        }
        if (info instanceof Integer || info instanceof Float || info instanceof Double) {
            return Escape.packageJSON(infoType, info.toString());
        }
        if (info instanceof String) {
            return Escape.packageJSON(infoType, Escape.fixString((String)info));
        }
        if (info instanceof String[]) {
            sb.append("[");
            int imax = ((String[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(Escape.fixString(((String[])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof int[]) {
            sb.append("[");
            int imax = ((int[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(((int[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof float[]) {
            sb.append("[");
            int imax = ((float[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(((float[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof String[][]) {
            sb.append("[");
            int imax = ((String[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(Escape.toJSON(null, ((String[][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof int[][]) {
            sb.append("[");
            int imax = ((int[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(Escape.toJSON(null, ((int[][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof float[][]) {
            sb.append("[");
            int imax = ((float[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(Escape.toJSON(null, ((float[][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof float[][][]) {
            sb.append("[");
            int imax = ((float[][][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(Escape.toJSON(null, ((float[][][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof List) {
            sb.append("[ ");
            int imax = ((List)info).size();
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(Escape.toJSON(null, ((List)info).get(i)));
                sep = ",";
                ++i;
            }
            sb.append(" ]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof Map) {
            sb.append("{ ");
            for (String key : ((Map)info).keySet()) {
                sb.append(sep).append(Escape.packageJSON(key, Escape.toJSON(null, ((Map)info).get(key))));
                sep = ",";
            }
            sb.append(" }");
            return Escape.packageJSON(infoType, sb);
        }
        return Escape.packageJSON(infoType, Escape.fixString(info.toString()));
    }

    private static String fixString(String s) {
        if (s == null || s.indexOf("{\"") == 0) {
            return s;
        }
        s = TextFormat.simpleReplace(s, "\"", "''");
        s = TextFormat.simpleReplace(s, "\n", " | ");
        return "\"" + s + "\"";
    }

    private static String packageJSON(String infoType, StringBuilder sb) {
        return Escape.packageJSON(infoType, sb.toString());
    }

    private static String packageJSON(String infoType, String info) {
        if (infoType == null) {
            return info;
        }
        return "\"" + infoType + "\": " + info;
    }
}

