/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;
import jspecview.util.Parser;

class CMLReader
extends XMLReader {
    private boolean specfound = false;
    String Ydelim = "";
    Vector<double[]> peakData;

    public CMLReader(String filePath) {
        super(filePath);
    }

    static JDXSource getCMLInstance(String filePath, BufferedReader br) {
        return new CMLReader(filePath).getXML(br);
    }

    private JDXSource getXML(BufferedReader br) {
        block5: {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(br);
            this.processXML(4, 10);
            if (this.checkPointCount()) break block5;
            return null;
        }
        try {
            this.populateVariables();
        }
        catch (Exception pe) {
            System.err.println("Error: " + pe.getMessage());
            pe.printStackTrace();
        }
        this.processErrors("CML");
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    protected boolean processTag(int tagId) throws Exception {
        switch (tagId) {
            case 4: {
                this.processSpectrum();
                return false;
            }
            case 9: {
                this.processSpectrumData();
                return true;
            }
            case 10: {
                this.processPeaks();
                return false;
            }
            case 8: {
                this.processSample();
                return true;
            }
            case 5: {
                this.processMetadataList();
                return true;
            }
            case 6: {
                this.processConditionList();
                return true;
            }
            case 7: {
                this.processParameterList();
                return true;
            }
            case 12: {
                this.processPeakList();
                return true;
            }
        }
        System.out.println("CMLSource not processing tag " + tagNames[tagId] + "!");
        return false;
    }

    private void processSpectrum() throws Exception {
        if (this.attrList.contains("title")) {
            this.title = this.reader.getAttrValue("title");
        } else if (this.attrList.contains("id")) {
            this.title = this.reader.getAttrValue("id");
        }
        if (this.attrList.contains("type")) {
            this.techname = String.valueOf(this.reader.getAttrValue("type").toUpperCase()) + " SPECTRUM";
        }
    }

    private void processMetadataList() throws Exception {
        if (this.tagName.equals("metadata")) {
            this.tagName = this.reader.getAttrValueLC("name");
            if (this.tagName.contains(":origin")) {
                this.origin = this.attrList.contains("content") ? this.reader.getAttrValue("content") : this.reader.thisValue();
            } else if (this.tagName.contains(":owner")) {
                this.owner = this.attrList.contains("content") ? this.reader.getAttrValue("content") : this.reader.thisValue();
            } else if (this.tagName.contains("observenucleus")) {
                this.obNucleus = this.attrList.contains("content") ? this.reader.getAttrValue("content") : this.reader.thisValue();
            }
        }
    }

    private void processParameterList() throws Exception {
        if (this.tagName.equals("parameter")) {
            String title = this.reader.getAttrValueLC("title");
            if (title.equals("nmr.observe frequency")) {
                this.StrObFreq = this.reader.qualifiedValue();
                this.obFreq = Double.parseDouble(this.StrObFreq);
            } else if (title.equals("nmr.observe nucleus")) {
                this.obNucleus = this.reader.getAttrValue("value");
            } else if (title.equals("spectrometer/data system")) {
                this.modelType = this.reader.getAttrValue("value");
            } else if (title.equals("resolution")) {
                this.resolution = this.reader.qualifiedValue();
            }
        }
    }

    private void processConditionList() throws Exception {
        String dictRef;
        if (this.tagName.equals("scalar") && (dictRef = this.reader.getAttrValueLC("dictRef")).contains(":field")) {
            this.StrObFreq = this.reader.thisValue();
            if (this.StrObFreq.charAt(0) > '/' && this.StrObFreq.charAt(0) < ':') {
                this.obFreq = Double.parseDouble(this.StrObFreq);
            }
        }
    }

    private void processSample() throws Exception {
        if (this.tagName.equals("formula")) {
            if (this.attrList.contains("concise")) {
                this.molForm = this.reader.getAttrValue("concise");
            } else if (this.attrList.contains("inline")) {
                this.molForm = this.reader.getAttrValue("inline");
            }
        } else if (this.tagName.equals("name")) {
            this.casName = this.reader.thisValue();
        }
    }

    private void processSpectrumData() throws Exception {
        if (this.tagName.equals("xaxis")) {
            if (this.attrList.contains("multipliertodata")) {
                this.xFactor = Double.parseDouble(this.reader.getAttrValue("multiplierToData"));
            }
            this.reader.nextTag();
            this.tagName = this.reader.getTagName();
            this.attrList = this.reader.getAttributeList();
            if (this.tagName.equals("array")) {
                this.xUnits = CMLReader.checkUnits(this.reader.getAttrValue("units"));
                this.npoints = Integer.parseInt(this.reader.getAttrValue("size"));
                this.xaxisData = new double[this.npoints];
                if (this.attrList.contains("start")) {
                    this.firstX = Double.parseDouble(this.reader.getAttrValue("start"));
                    this.lastX = Double.parseDouble(this.reader.getAttrValue("end"));
                    this.deltaX = (this.lastX - this.firstX) / (double)(this.npoints - 1);
                    this.increasing = this.deltaX > 0.0;
                    this.continuous = true;
                    int j = 0;
                    while (j < this.npoints) {
                        this.xaxisData[j] = this.firstX + this.deltaX * (double)j;
                        ++j;
                    }
                } else {
                    int posDelim = 0;
                    int jj = -1;
                    String tempX = "";
                    this.Ydelim = " ";
                    this.attrList = this.reader.getCharacters().replace('\n', ' ').replace('\r', ' ').trim();
                    do {
                        posDelim = this.attrList.indexOf(this.Ydelim);
                        tempX = this.attrList.substring(0, posDelim);
                        this.xaxisData[++jj] = Double.parseDouble(tempX) * this.xFactor;
                        this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                        posDelim = this.attrList.indexOf(this.Ydelim);
                        while (posDelim > 0) {
                            tempX = this.attrList.substring(0, posDelim);
                            this.xaxisData[++jj] = Double.parseDouble(tempX) * this.xFactor;
                            this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                            posDelim = this.attrList.indexOf(this.Ydelim);
                        }
                        if (jj >= this.npoints - 1) continue;
                        this.xaxisData[++jj] = Double.parseDouble(this.attrList) * this.xFactor;
                    } while (jj < this.npoints - 1);
                    this.firstX = this.xaxisData[0];
                    this.lastX = this.xaxisData[this.npoints - 1];
                    this.continuous = true;
                }
            }
        } else if (this.tagName.equals("yaxis")) {
            if (this.attrList.contains("multipliertodata")) {
                this.yFactor = Double.parseDouble(this.reader.getAttrValue("multiplierToData"));
            }
            this.reader.nextTag();
            this.tagName = this.reader.getTagName();
            this.attrList = this.reader.getAttributeList();
            if (this.tagName.equals("array")) {
                this.yUnits = CMLReader.checkUnits(this.reader.getAttrValue("units"));
                Integer npointsY = Integer.valueOf(this.reader.getAttrValue("size"));
                if (this.npoints != npointsY) {
                    System.err.println("npoints variation between X and Y arrays");
                }
                this.yaxisData = new double[this.npoints];
                this.Ydelim = this.reader.getAttrValue("delimeter");
                if (this.Ydelim.equals("")) {
                    this.Ydelim = " ";
                }
                int posDelim = 0;
                int jj = -1;
                String tempY = "";
                this.attrList = this.reader.getCharacters().replace('\n', ' ').replace('\r', ' ').trim();
                do {
                    posDelim = this.attrList.indexOf(this.Ydelim);
                    tempY = this.attrList.substring(0, posDelim);
                    this.yaxisData[++jj] = Double.parseDouble(tempY) * this.yFactor;
                    this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                    posDelim = this.attrList.indexOf(this.Ydelim);
                    while (posDelim > 0) {
                        tempY = this.attrList.substring(0, posDelim);
                        this.yaxisData[++jj] = Double.parseDouble(tempY) * this.yFactor;
                        this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                        posDelim = this.attrList.indexOf(this.Ydelim);
                    }
                    if (jj >= this.npoints - 1) continue;
                    this.yaxisData[++jj] = Double.parseDouble(this.attrList) * this.yFactor;
                } while (jj < this.npoints - 1);
            }
            this.firstY = this.yaxisData[0];
            this.specfound = true;
        }
    }

    private void processPeaks() throws Exception {
        if (this.specfound) {
            return;
        }
        this.peakData = new Vector();
        this.process(12, true);
        this.npoints = this.peakData.size();
        this.xaxisData = new double[this.npoints];
        this.yaxisData = new double[this.npoints];
        int i = 0;
        while (i < this.npoints) {
            double[] xy = this.peakData.get(i);
            this.xaxisData[i] = xy[0];
            this.yaxisData[i] = xy[1];
            ++i;
        }
        this.peakData = null;
        this.firstX = this.xaxisData[0];
        this.lastX = this.xaxisData[this.npoints - 1];
        this.firstY = this.yaxisData[0];
        this.increasing = this.lastX > this.firstX;
        this.continuous = false;
    }

    void processPeakList() {
        if (this.tagName.equals("peak") && this.attrList.contains("xvalue")) {
            double[] xy = new double[2];
            xy[1] = 50.0;
            xy[0] = Double.parseDouble(this.reader.getAttrValue("xValue"));
            if (this.attrList.contains("xunits")) {
                this.xUnits = CMLReader.checkUnits(this.reader.getAttrValue("xUnits"));
            }
            if (this.attrList.contains("yvalue")) {
                xy[1] = Double.parseDouble(this.reader.getAttrValue("yValue"));
            }
            if (this.attrList.contains("yunits")) {
                this.yUnits = CMLReader.checkUnits(this.reader.getAttrValue("yUnits"));
            }
            if (this.attrList.contains("atomrefs")) {
                xy[1] = 49 * Parser.getTokens(this.reader.getAttrValue("atomRefs")).length;
            }
            this.peakData.add(xy);
        }
    }

    private static String checkUnits(String units) {
        return (units = units.substring(units.indexOf(":") + 1).toUpperCase()).equals("RELABUNDANCE") ? "RELATIVE ABUNDANCE" : (units.contains("ARBITRARY") ? "ARBITRARY UNITS" : (units.equals("MOVERZ") ? "M/Z" : (units.equals("CM-1") ? "1/CM" : (units.equals("NM") ? "NANOMETERS" : units))));
    }
}

