/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import jspecview.common.JDXSpectrum;
import jspecview.export.XMLExporter;

class CMLExporter
extends XMLExporter {
    CMLExporter() {
    }

    String exportAsCML(String fileName, JDXSpectrum spec, int startIndex, int endIndex) throws IOException {
        if (!this.setup(spec, fileName, startIndex, endIndex)) {
            return null;
        }
        if (this.model == null || this.model.equals("")) {
            this.model = "unknown";
        }
        if (this.datatype.contains("MASS")) {
            this.spectypeInitials = "massSpectrum";
        } else if (this.datatype.contains("INFRARED")) {
            this.spectypeInitials = "infrared";
        } else if (this.datatype.contains("UV") || this.datatype.contains("VIS")) {
            this.spectypeInitials = "UV/VIS";
        } else if (this.datatype.contains("NMR")) {
            this.spectypeInitials = "NMR";
        }
        this.ident = String.valueOf(this.spectypeInitials) + "_" + this.title.substring(0, Math.min(10, this.title.length()));
        if (this.xUnits.toLowerCase().equals("m/z")) {
            this.xUnits = "moverz";
        } else if (this.xUnits.toLowerCase().equals("1/cm")) {
            this.xUnits = "cm-1";
        } else if (this.xUnits.toLowerCase().equals("nanometers")) {
            this.xUnits = "nm";
        }
        this.setContext();
        return this.writeFormType("cml");
    }
}

