/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.Annotation;
import jspecview.common.CoordComparator;
import jspecview.common.Coordinate;
import jspecview.common.Graph;
import jspecview.common.ImageScaleData;
import jspecview.common.Integral;
import jspecview.common.IntegralGraph;
import jspecview.common.JDXDataObject;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.source.JDXSourceStreamTokenizer;
import jspecview.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDXSpectrum
extends JDXDataObject
implements Graph {
    private List<JDXSpectrum> subSpectra;
    private ArrayList<PeakInfo> peakList = new ArrayList();
    private String piUnitsX;
    private String piUnitsY;
    private JDXSpectrum parent;
    private int[] buf2d;
    private IntegralGraph integration;
    private PeakInfo selectedPeak;
    private int thisWidth;
    private int thisHeight;
    private int currentSubSpectrumIndex;
    private double grayFactorLast;
    private boolean isForcedSubset;
    private String id = "";
    private Comparator<Coordinate> c;
    private JDXSpectrum convertedSpectrum;
    private double userYFactor = 1.0;
    public static final int TA_NO_CONVERT = 0;
    public static final int TO_ABS = 1;
    public static final int TO_TRANS = 2;
    public static final int IMPLIED = 3;
    public static final double MAXABS = 4.0;
    protected ArrayList<Annotation> integrationRatios;
    private boolean exportXAxisLeftToRight;

    public void finalize() {
        System.out.println("JDXSpectrum " + this + " finalized " + this.title);
    }

    @Override
    public void dispose() {
        this.buf2d = null;
        if (this.integration != null) {
            this.integration.dispose();
        }
        this.integration = null;
        this.integrationRatios = null;
        if (this.subSpectra != null) {
            int i = 0;
            while (i < this.subSpectra.size()) {
                if (this.subSpectra.get(i) != this) {
                    this.subSpectra.get(i).dispose();
                }
                ++i;
            }
        }
        this.subSpectra = null;
        this.parent = null;
        this.peakList = null;
        this.selectedPeak = null;
    }

    public boolean isForcedSubset() {
        return this.isForcedSubset;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JDXSpectrum() {
        this.headerTable = new ArrayList();
        this.xyCoords = new Coordinate[0];
    }

    public JDXSpectrum copy() {
        JDXSpectrum newSpectrum = new JDXSpectrum();
        this.copyTo(newSpectrum);
        newSpectrum.setPeakList(this.peakList, this.piUnitsX, null);
        return newSpectrum;
    }

    @Override
    public Coordinate[] getXYCoords() {
        return this.getCurrentSubSpectrum().xyCoords;
    }

    public ArrayList<PeakInfo> getPeakList() {
        return this.peakList;
    }

    public int setPeakList(ArrayList<PeakInfo> list, String piUnitsX, String piUnitsY) {
        this.peakList = list;
        this.piUnitsX = piUnitsX;
        this.piUnitsY = piUnitsY;
        int i = list.size();
        while (--i >= 0) {
            this.peakList.get((int)i).spectrum = this;
        }
        if (Logger.debugging) {
            Logger.info("Spectrum " + this.getTitle() + " peaks: " + list.size());
        }
        return list.size();
    }

    public PeakInfo selectPeakByFileIndex(String filePath, String index) {
        if (this.peakList != null && this.peakList.size() > 0) {
            int i = 0;
            while (i < this.peakList.size()) {
                if (this.peakList.get(i).checkFileIndex(filePath, index)) {
                    this.selectedPeak = this.peakList.get(i);
                    return this.selectedPeak;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean matchesPeakTypeModel(String type, String model) {
        if (this.peakList != null && this.peakList.size() > 0) {
            int i = 0;
            while (i < this.peakList.size()) {
                if (this.peakList.get(i).checkTypeModel(type, model)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setSelectedPeak(PeakInfo peak) {
        this.selectedPeak = peak;
    }

    public PeakInfo getSelectedPeak() {
        return this.selectedPeak;
    }

    public PeakInfo getModelPeakInfoForAutoSelectOnLoad() {
        int i = 0;
        while (i < this.peakList.size()) {
            if (this.peakList.get(i).autoSelectOnLoad()) {
                return this.peakList.get(i);
            }
            ++i;
        }
        return null;
    }

    public PeakInfo getAssociatedPeakInfo(Coordinate coord) {
        this.selectedPeak = this.findPeakByCoord(coord);
        return this.selectedPeak == null ? this.getBasePeakInfo() : this.selectedPeak;
    }

    public PeakInfo findPeakByCoord(Coordinate coord) {
        if (coord != null && this.peakList != null && this.peakList.size() > 0) {
            int i = 0;
            while (i < this.peakList.size()) {
                PeakInfo peak = this.peakList.get(i);
                double xVal = coord.getXVal();
                if (xVal >= peak.getXMin() && xVal <= peak.getXMax()) {
                    return peak;
                }
                ++i;
            }
        }
        return null;
    }

    public String getPeakTitle() {
        return this.selectedPeak == null ? this.getTitleLabel() : this.selectedPeak.getTitle();
    }

    public String getTitleLabel() {
        String type = this.peakList == null || this.peakList.size() == 0 ? this.dataType : this.peakList.get(0).getType();
        return String.valueOf(type != null && type.length() > 0 ? String.valueOf(type) + " " : "") + this.getTitle() + (this.parent == null ? "" : " (" + this.parent.subSpectra.size() + ")");
    }

    public int setNextPeak(Coordinate coord, int istep) {
        if (this.peakList == null || this.peakList.size() == 0) {
            return -1;
        }
        double x0 = coord.getXVal() + (double)istep * 1.0E-6;
        int ipt1 = -1;
        int ipt2 = -1;
        double dmin1 = Double.MAX_VALUE * (double)istep;
        double dmin2 = 0.0;
        int i = this.peakList.size();
        while (--i >= 0) {
            double x = this.peakList.get(i).getX();
            if (istep > 0) {
                if (x > x0 && x < dmin1) {
                    ipt1 = i;
                    dmin1 = x;
                    continue;
                }
                if (!(x < x0) || !(x - x0 < dmin2)) continue;
                ipt2 = i;
                dmin2 = x - x0;
                continue;
            }
            if (x < x0 && x > dmin1) {
                ipt1 = i;
                dmin1 = x;
                continue;
            }
            if (!(x > x0) || !(x - x0 > dmin2)) continue;
            ipt2 = i;
            dmin2 = x - x0;
        }
        if (ipt1 < 0) {
            if (ipt2 < 0) {
                return -1;
            }
            ipt1 = ipt2;
        }
        return ipt1;
    }

    public void setIntegrationRatios(ArrayList<Annotation> ratios) {
        this.integrationRatios = ratios;
    }

    public IntegralGraph getIntegrationGraph() {
        return this.integration;
    }

    public boolean hasIntegral() {
        return this.integration != null;
    }

    public void setIntegrationGraph(IntegralGraph graph) {
        this.integration = graph;
    }

    @Override
    public double getPercentYValueAt(double x) {
        if (!this.isContinuous()) {
            return Double.NaN;
        }
        return this.getYValueAt(this.xyCoords, x);
    }

    public double getYValueAt(Coordinate[] xyCoords, double x) {
        if (this.c == null) {
            this.c = new CoordComparator();
        }
        return Coordinate.getYValueAt(xyCoords, x, this.c);
    }

    public void setUserYFactor(double userYFactor) {
        this.userYFactor = userYFactor;
    }

    public double getUserYFactor() {
        return this.userYFactor;
    }

    public JDXSpectrum getConvertedSpectrum() {
        return this.convertedSpectrum;
    }

    public void setConvertedSpectrum(JDXSpectrum spectrum) {
        this.convertedSpectrum = spectrum;
    }

    public static JDXSpectrum taConvert(JDXSpectrum spectrum, int mode) {
        JDXSpectrum spec;
        if (!spectrum.isContinuous()) {
            return spectrum;
        }
        switch (mode) {
            case 1: {
                if (spectrum.isTransmittance()) break;
                return spectrum;
            }
            case 2: {
                if (spectrum.isAbsorbance()) break;
                return spectrum;
            }
            case 3: {
                break;
            }
            default: {
                return spectrum;
            }
        }
        return (spec = spectrum.getConvertedSpectrum()) != null ? spec : (spectrum.isAbsorbance() ? JDXSpectrum.toT(spectrum) : JDXSpectrum.toA(spectrum));
    }

    private static JDXSpectrum toT(JDXSpectrum spectrum) {
        if (!spectrum.isAbsorbance()) {
            return null;
        }
        Coordinate[] xyCoords = spectrum.getXYCoords();
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        if (!Coordinate.isYInRange(xyCoords, 0.0, 4.0)) {
            xyCoords = Coordinate.normalise(xyCoords, 0.0, 4.0);
        }
        int i = 0;
        while (i < xyCoords.length) {
            newXYCoords[i] = new Coordinate(xyCoords[i].getXVal(), JDXSpectrum.toTransmittance(xyCoords[i].getYVal()));
            ++i;
        }
        return JDXSpectrum.newSpectrum(spectrum, newXYCoords, "TRANSMITTANCE");
    }

    private static JDXSpectrum toA(JDXSpectrum spectrum) {
        if (!spectrum.isTransmittance()) {
            return null;
        }
        Coordinate[] xyCoords = spectrum.getXYCoords();
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        boolean isPercent = Coordinate.isYInRange(xyCoords, -2.0, 2.0);
        int i = 0;
        while (i < xyCoords.length) {
            newXYCoords[i] = new Coordinate(xyCoords[i].getXVal(), JDXSpectrum.toAbsorbance(xyCoords[i].getYVal(), isPercent));
            ++i;
        }
        return JDXSpectrum.newSpectrum(spectrum, newXYCoords, "ABSORBANCE");
    }

    public static JDXSpectrum newSpectrum(JDXSpectrum spectrum, Coordinate[] newXYCoords, String units) {
        JDXSpectrum specNew = spectrum.copy();
        specNew.setOrigin("JSpecView Converted");
        specNew.setOwner("JSpecView Generated");
        specNew.setXYCoords(newXYCoords);
        specNew.setYUnits(units);
        spectrum.setConvertedSpectrum(specNew);
        specNew.setConvertedSpectrum(spectrum);
        return specNew;
    }

    private static double toAbsorbance(double x, boolean isPercent) {
        return Math.min(4.0, isPercent ? 2.0 - JDXSpectrum.log10(x) : -JDXSpectrum.log10(x));
    }

    private static double toTransmittance(double x) {
        return x <= 0.0 ? 1.0 : Math.pow(10.0, -x);
    }

    private static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    public boolean checkIntegral(Parameters parameters, String value) {
        if (!this.canIntegrate()) {
            return false;
        }
        switch (IntegralGraph.IntMode.getMode(value)) {
            case ON: {
                this.integrate(parameters);
                break;
            }
            case OFF: {
                this.integrate(null);
                break;
            }
            case TOGGLE: {
                this.integrate(this.integration == null ? parameters : null);
                break;
            }
            case MARK: {
                if (this.integration == null) {
                    this.checkIntegral(parameters, "ON");
                }
                this.integration.addMarks(value.substring(5).trim());
            }
        }
        return true;
    }

    private boolean integrate(Parameters parameters) {
        if (parameters == null) {
            this.integration = null;
            return false;
        }
        if (!this.canIntegrate()) {
            return false;
        }
        this.setIntegrationGraph(new IntegralGraph(this, parameters, this.xUnits, this.yUnits));
        return true;
    }

    public static boolean areScalesCompatible(JDXSpectrum s1, JDXSpectrum s2, boolean allow2D2D) {
        if (!(allow2D2D ? s1.is1D() == s2.is1D() : s1.is1D() && s2.is1D()) || !s1.xUnits.equalsIgnoreCase(s2.xUnits)) {
            return false;
        }
        if (!(s1 instanceof JDXSpectrum) || !(s2 instanceof JDXSpectrum)) {
            return true;
        }
        JDXSpectrum spec1 = s1;
        JDXSpectrum spec2 = s2;
        return spec1.isHNMR() == spec2.isHNMR();
    }

    public static boolean process(List<JDXSpectrum> specs, int irMode, boolean autoIntegrate, Parameters parameters) {
        int i;
        if (irMode == 1 || irMode == 2) {
            i = 0;
            while (i < specs.size()) {
                specs.set(i, JDXSpectrum.taConvert(specs.get(i), irMode));
                ++i;
            }
        }
        if (autoIntegrate) {
            i = 0;
            while (i < specs.size()) {
                specs.get(i).integrate(parameters);
                ++i;
            }
        }
        return true;
    }

    public List<Integral> getIntegrals() {
        return this.integration == null ? null : this.integration.getIntegrals();
    }

    public List<JDXSpectrum> getSubSpectra() {
        return this.subSpectra;
    }

    public JDXSpectrum getCurrentSubSpectrum() {
        return this.subSpectra == null ? this : this.subSpectra.get(this.currentSubSpectrumIndex);
    }

    public int advanceSubSpectrum(int dir) {
        return this.setCurrentSubSpectrum(this.currentSubSpectrumIndex + dir);
    }

    public int setCurrentSubSpectrum(int n) {
        this.currentSubSpectrumIndex = Coordinate.intoRange(n, 0, this.subSpectra.size() - 1);
        return this.currentSubSpectrumIndex;
    }

    public boolean addSubSpectrum(JDXSpectrum spectrum, boolean forceSub) {
        if (!forceSub && (this.numDim < 2 || this.blockID != spectrum.blockID) || !JDXSpectrum.areScalesCompatible(this, spectrum, true)) {
            return false;
        }
        this.isForcedSubset = forceSub;
        if (this.subSpectra == null) {
            this.subSpectra = new ArrayList<JDXSpectrum>();
            this.addSubSpectrum(this, true);
        }
        this.subSpectra.add(spectrum);
        spectrum.parent = this;
        spectrum.setTitle(String.valueOf(this.subSpectra.size()) + ": " + spectrum.title);
        return true;
    }

    public int getSubIndex() {
        return this.subSpectra == null ? -1 : this.currentSubSpectrumIndex;
    }

    public void setExportXAxisDirection(boolean leftToRight) {
        this.exportXAxisLeftToRight = leftToRight;
    }

    public boolean isExportXAxisLeftToRight() {
        return this.exportXAxisLeftToRight;
    }

    public int[] get2dBuffer(int width, int height, ImageScaleData isd, boolean forceNew) {
        if (this.subSpectra == null || !this.subSpectra.get(0).isContinuous()) {
            return null;
        }
        if (!forceNew && this.thisWidth == width && this.thisHeight == height) {
            return this.buf2d;
        }
        int nSpec = this.subSpectra.size();
        this.thisWidth = width = this.xyCoords.length;
        this.thisHeight = height = nSpec;
        double grayFactor = 255.0 / (isd.maxZ - isd.minZ);
        if (!forceNew && this.buf2d != null && grayFactor == this.grayFactorLast) {
            return this.buf2d;
        }
        this.grayFactorLast = grayFactor;
        int pt = width * height;
        int[] buf = new int[pt];
        double totalGray = 0.0;
        int i = 0;
        while (i < nSpec) {
            Coordinate[] points = this.subSpectra.get((int)i).xyCoords;
            if (points.length != this.xyCoords.length) {
                return null;
            }
            double f = this.subSpectra.get(i).getUserYFactor();
            int j = 0;
            while (j < this.xyCoords.length) {
                double y = points[j].getYVal();
                int gray = 255 - Coordinate.intoRange((int)((y * f - isd.minZ) * grayFactor), 0, 255);
                buf[--pt] = gray;
                totalGray += (double)gray;
                ++j;
            }
            ++i;
        }
        System.out.println("Average gray = " + totalGray / (double)(width * height) / 255.0);
        this.buf2d = buf;
        return buf;
    }

    public Map<String, Object> getInfo(String key) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("id", this.id);
        boolean justHeader = "header" == key;
        Hashtable head = new Hashtable();
        String[][] list = this.getHeaderRowDataAsArray();
        int i = 0;
        while (i < list.length) {
            String label = JDXSourceStreamTokenizer.cleanLabel(list[i][0]);
            if (key == null || justHeader || label.equals(key)) {
                Object val = JDXSpectrum.fixInfoValue(list[i][1]);
                if (key == null) {
                    Hashtable<String, Object> data = new Hashtable<String, Object>();
                    data.put("value", val);
                    data.put("index", i + 1);
                    info.put(label, data);
                } else {
                    info.put(label, val);
                }
            }
            ++i;
        }
        info.put("header", head);
        if (!justHeader) {
            JDXSpectrum.putInfo(key, info, "titleLabel", this.getTitleLabel());
            JDXSpectrum.putInfo(key, info, "type", this.getDataType());
            JDXSpectrum.putInfo(key, info, "isHZToPPM", this.isHZtoPPM);
            JDXSpectrum.putInfo(key, info, "subSpectrumCount", this.subSpectra == null ? 0 : this.subSpectra.size());
        }
        return info;
    }

    private static Object fixInfoValue(String info) {
        try {
            return Integer.valueOf(info);
        }
        catch (Exception exception) {
            try {
                return Double.valueOf(info);
            }
            catch (Exception exception2) {
                return info;
            }
        }
    }

    public static void putInfo(String match, Map<String, Object> info, String key, Object value) {
        if (match == null || key.equalsIgnoreCase(match)) {
            info.put(key, value);
        }
    }

    public String toString() {
        return this.getTitleLabel();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        int i = 0;
        while (i < this.peakList.size()) {
            if (this.peakList.get(i).checkTypeMatch(pi)) {
                return this.peakList.get(i);
            }
            ++i;
        }
        return null;
    }

    public PeakInfo getBasePeakInfo() {
        return this.peakList.size() == 0 ? new PeakInfo() : new PeakInfo(" baseModel=\"\" " + this.peakList.get(0));
    }

    public String getAxisLabel(boolean isX) {
        String units;
        String string = units = isX ? this.piUnitsX : this.piUnitsY;
        if (units == null) {
            String string2 = units = isX ? this.xLabel : this.yLabel;
        }
        if (units == null) {
            units = isX ? this.xUnits : this.yUnits;
        }
        return units == null ? "" : units;
    }
}

