/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jspecview.common.AwtGraphSet;
import jspecview.common.AwtParameters;
import jspecview.common.GraphSet;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelPopupMenu;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PrintLayoutDialog;
import jspecview.common.ScriptToken;
import jspecview.export.Exporter;
import jspecview.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwtPanel
extends JPanel
implements JSVPanel,
Printable,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    public PanelData pd;
    JSVPanelPopupMenu popup;
    private Color coordinatesColor;
    private Color gridColor;
    private Color integralPlotColor;
    private Color plotAreaColor;
    private Color scaleColor;
    private Color titleColor;
    private Color unitsColor;
    private Color highlightColor = new Color(255, 0, 0, 200);
    private Color zoomBoxColor = new Color(100, 100, 50, 130);

    public void finalize() {
        Logger.info("JSVPanel " + this + " finalized");
    }

    @Override
    public PanelData getPanelData() {
        return this.pd;
    }

    @Override
    public JSVPanelPopupMenu getPopup() {
        return this.popup;
    }

    @Override
    public void dispose() {
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        this.pd.dispose();
        this.pd = null;
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public JDXSpectrum getSpectrum() {
        return this.pd.getSpectrum();
    }

    @Override
    public void setSpectrum(JDXSpectrum spec) {
        this.pd.setSpectrum(spec);
    }

    @Override
    public JDXSpectrum getSpectrumAt(int i) {
        return this.pd.getSpectrumAt(i);
    }

    @Override
    public void setTitle(String title) {
        this.pd.setTitle(title);
        this.setName(title);
    }

    protected void doRepaint() {
        this.repaint();
    }

    @Override
    public void doRequestFocusInWindow() {
        this.requestFocusInWindow();
    }

    @Override
    public void setPlotColors(Object oColors) {
        Color[] colors = (Color[])oColors;
        int i = this.pd.graphSets.size();
        while (--i >= 0) {
            this.pd.graphSets.get(i).setPlotColors(colors);
        }
    }

    @Override
    public void setColorOrFont(Parameters ds, ScriptToken st) {
        if (st == null) {
            Map<ScriptToken, Object> colors = ds.getColors();
            for (Map.Entry<ScriptToken, Object> entry : colors.entrySet()) {
                this.setColorOrFont(ds, entry.getKey());
            }
            this.setColorOrFont(ds, ScriptToken.DISPLAYFONTNAME);
            this.setColorOrFont(ds, ScriptToken.TITLEFONTNAME);
            return;
        }
        switch (st) {
            case DISPLAYFONTNAME: {
                this.pd.setFontName(st, ds.getDisplayFont());
                return;
            }
            case TITLEFONTNAME: {
                this.pd.setFontName(st, ds.getTitleFont());
                return;
            }
        }
        this.setColor(st, ds.getColor(st));
    }

    @Override
    public void setColor(ScriptToken st, Object oColor) {
        Color color = (Color)oColor;
        if (color != null) {
            this.pd.options.put(st, AwtParameters.colorToHexString(color));
        }
        switch (st) {
            case BACKGROUNDCOLOR: {
                this.setBackground(color);
                break;
            }
            case COORDINATESCOLOR: {
                this.coordinatesColor = color;
                break;
            }
            case GRIDCOLOR: {
                this.gridColor = color;
                break;
            }
            case HIGHLIGHTCOLOR: {
                this.highlightColor = color;
                break;
            }
            case INTEGRALPLOTCOLOR: {
                this.integralPlotColor = color;
                break;
            }
            case PLOTCOLOR: {
                int i = this.pd.graphSets.size();
                while (--i >= 0) {
                    this.pd.graphSets.get(i).setPlotColor0(color);
                }
                break;
            }
            case PLOTAREACOLOR: {
                this.plotAreaColor = color;
                break;
            }
            case SCALECOLOR: {
                this.scaleColor = color;
                break;
            }
            case TITLECOLOR: {
                this.titleColor = color;
                break;
            }
            case UNITSCOLOR: {
                this.unitsColor = color;
                break;
            }
            case ZOOMBOXCOLOR: {
                this.zoomBoxColor = color;
                break;
            }
            default: {
                Logger.warn("AwtPanel --- unrecognized color: " + (Object)((Object)st));
            }
        }
    }

    public AwtPanel(JDXSpectrum spectrum, JSVPanelPopupMenu popup) {
        this.pd = new PanelData(this);
        this.popup = popup;
        this.pd.initSingleSpectrum(spectrum);
    }

    @Override
    public JSVPanel getNewPanel(JDXSpectrum spectrum) {
        return new AwtPanel(spectrum, this.popup);
    }

    public static AwtPanel getJSVPanel(List<JDXSpectrum> specs, int startIndex, int endIndex, JSVPanelPopupMenu popup) {
        AwtPanel jsvp = new AwtPanel(specs, startIndex, endIndex, popup);
        jsvp.pd.isOverlaid = specs.size() > 1;
        return jsvp;
    }

    private AwtPanel(List<JDXSpectrum> spectra, int startIndex, int endIndex, JSVPanelPopupMenu popup) {
        this.pd = new PanelData(this);
        this.popup = popup;
        this.pd.initJSVPanel(spectra, startIndex, endIndex);
    }

    public static AwtPanel getNewPanel(JDXSpectrum spec, JSVPanelPopupMenu jsvpPopupMenu) {
        return new AwtPanel(spec, jsvpPopupMenu);
    }

    @Override
    public GraphSet getNewGraphSet() {
        return new AwtGraphSet(this);
    }

    @Override
    public Color getPlotColor(int index) {
        return ((AwtGraphSet)this.pd.currentGraphSet).getPlotColor(index);
    }

    @Override
    public Color getColor(int r, int g, int b, int a) {
        return new Color(r, g, b, a);
    }

    @Override
    public Color getColor(ScriptToken whatColor) {
        switch (whatColor) {
            default: {
                Logger.error("awtgraphset missing color " + (Object)((Object)whatColor));
                return Color.BLACK;
            }
            case ZOOMBOXCOLOR: {
                return this.zoomBoxColor;
            }
            case HIGHLIGHTCOLOR: {
                return this.highlightColor;
            }
            case INTEGRALPLOTCOLOR: {
                return this.integralPlotColor;
            }
            case GRIDCOLOR: {
                return this.gridColor;
            }
            case PLOTAREACOLOR: {
                return this.plotAreaColor;
            }
            case SCALECOLOR: {
                return this.scaleColor;
            }
            case TITLECOLOR: {
                return this.titleColor;
            }
            case UNITSCOLOR: 
        }
        return this.unitsColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isEnabled() || this.pd.graphSets == null) {
            return;
        }
        super.paintComponent(g);
        this.pd.drawGraph(g, this.getHeight(), this.getWidth());
    }

    @Override
    public void setFont(Object g, String name, int mode, int size) {
        ((Graphics)g).setFont(new Font(name, mode, size));
    }

    @Override
    public void drawTitle(Object og, int height, int width, String title) {
        Graphics g = (Graphics)og;
        this.pd.setFont(g, width, this.pd.isPrinting || this.pd.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, 14, true);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.titleColor);
        g.drawString(title, 5, height - fm.getHeight() / 2);
    }

    @Override
    public void drawCoordinates(Object og, int height, int width) {
        Graphics g = (Graphics)og;
        g.setColor(this.coordinatesColor);
        this.pd.setFont(g, width, 0, 12, true);
        g.drawString(this.pd.coordStr, (int)((double)(this.pd.plotAreaWidth + this.pd.leftPlotAreaPos) * 0.85), this.pd.topPlotAreaPos - 10);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi == 0) {
            double width;
            double height;
            Graphics2D g2D = (Graphics2D)g;
            this.pd.isPrinting = true;
            if (this.pd.printGraphPosition.equals("default")) {
                g2D.translate(pf.getImageableX(), pf.getImageableY());
                if (pf.getOrientation() == 1) {
                    height = this.pd.defaultHeight;
                    width = this.pd.defaultWidth;
                } else {
                    height = this.pd.defaultWidth;
                    width = this.pd.defaultHeight;
                }
            } else if (this.pd.printGraphPosition.equals("fit to page")) {
                g2D.translate(pf.getImageableX(), pf.getImageableY());
                height = pf.getImageableHeight();
                width = pf.getImageableWidth();
            } else {
                int y;
                int x;
                Paper paper = pf.getPaper();
                double paperHeight = paper.getHeight();
                double paperWidth = paper.getWidth();
                if (pf.getOrientation() == 1) {
                    height = this.pd.defaultHeight;
                    width = this.pd.defaultWidth;
                    x = (int)(paperWidth - width) / 2;
                    y = (int)(paperHeight - height) / 2;
                } else {
                    height = this.pd.defaultWidth;
                    width = this.pd.defaultHeight;
                    y = (int)(paperWidth - (double)this.pd.defaultWidth) / 2;
                    x = (int)(paperHeight - (double)this.pd.defaultHeight) / 2;
                }
                g2D.translate(x, y);
            }
            this.pd.drawGraph(g2D, (int)height, (int)width);
            this.pd.isPrinting = false;
            return 0;
        }
        this.pd.isPrinting = false;
        return 1;
    }

    public void printSpectrum(PrintLayoutDialog.PrintLayout pl) {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        if (pl.layout.equals("landscape")) {
            aset.add(OrientationRequested.LANDSCAPE);
        } else {
            aset.add(OrientationRequested.PORTRAIT);
        }
        aset.add(pl.paper);
        this.pd.printingFont = pl.font;
        this.pd.gridOn = pl.showGrid;
        this.pd.titleOn = pl.showTitle;
        this.pd.printGraphPosition = pl.position;
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        if (pj.printDialog()) {
            try {
                pj.print(aset);
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.pd.doMousePressed(e.getX(), e.getY(), e.isControlDown());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.pd.doMouseMoved(e.getX(), e.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.pd.doMouseDragged(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pd.doMouseReleased(e.getButton() == 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.popup.show(this, e.getX(), e.getY());
            return;
        }
        this.doRequestFocusInWindow();
        this.pd.doMouseClicked(e.getX(), e.getY(), e.getClickCount(), e.isControlDown());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.pd.currentGraphSet.escape();
            this.pd.isIntegralDrag = false;
            this.repaint();
            e.consume();
            return;
        }
        if (e.getModifiers() != 0) {
            if (e.isControlDown()) {
                switch (e.getKeyCode()) {
                    case 45: {
                        this.pd.currentGraphSet.scaleYBy(0.5);
                        e.consume();
                        break;
                    }
                    case 61: {
                        this.pd.currentGraphSet.scaleYBy(2.0);
                        e.consume();
                    }
                }
            }
            return;
        }
        switch (e.getKeyCode()) {
            case 37: {
                this.pd.currentGraphSet.toPeak(-1);
                e.consume();
                break;
            }
            case 39: {
                this.pd.currentGraphSet.toPeak(1);
                e.consume();
                break;
            }
            case 38: 
            case 40: {
                int dir;
                int n = dir = e.getKeyCode() == 40 ? -1 : 1;
                if (this.pd.getSpectrumAt(0).getSubSpectra() == null) {
                    this.pd.notifySubSpectrumChange(dir, null);
                } else {
                    this.pd.currentGraphSet.advanceSubSpectrum(dir);
                    this.repaint();
                }
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == 'z') {
            this.pd.currentGraphSet.previousView();
            e.consume();
            return;
        }
        if (e.getKeyChar() == 'y') {
            this.pd.currentGraphSet.nextView();
            e.consume();
            return;
        }
    }

    @Override
    public void setupPlatform() {
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        if (this.popup == null) {
            this.pd.coordStr = "(0,0)";
        } else {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    @Override
    public String getTitle() {
        return this.pd.getTitle();
    }

    public void paint(Object graphics) {
        super.paint((Graphics)graphics);
    }

    public String export(String type, int n) {
        if (type == null) {
            type = "XY";
        }
        if (n < -1 || this.pd.getNumberOfSpectraInCurrentSet() <= n) {
            return "only " + this.pd.getNumberOfSpectraInCurrentSet() + " spectra available.";
        }
        try {
            JDXSpectrum spec = n < 0 ? this.getSpectrum() : this.getSpectrumAt(n);
            return Exporter.exportTheSpectrum(Exporter.Type.getType(type), null, spec, 0, spec.getXYCoords().length - 1);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getSpectrumAt(0).toString();
    }
}

