/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jspecview.application.ScrollableDesktopPane;

public class WindowMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private ScrollableDesktopPane desktop;
    private JCheckBoxMenuItem stack = new JCheckBoxMenuItem("Stack");
    private JCheckBoxMenuItem cascade = new JCheckBoxMenuItem("Cascade");
    private JCheckBoxMenuItem tile = new JCheckBoxMenuItem("Tile");

    public void setMyStyle(int style) {
        this.stack.setSelected(style == 0);
        this.cascade.setSelected(style == 1);
        this.tile.setSelected(style == 2);
    }

    public WindowMenu(ScrollableDesktopPane desktop) {
        desktop.setWindowMenu(this);
        this.desktop = desktop;
        this.setText("Window");
        this.add(this.stack);
        this.stack.setSelected(true);
        this.add(this.cascade);
        this.add(this.tile);
        this.addSeparator();
        this.stack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.stackFrames();
            }
        });
        this.cascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.cascadeFrames();
            }
        });
        this.tile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.tileFrames();
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                Component[] menuItems = WindowMenu.this.getMenuComponents();
                int i = menuItems.length;
                while (--i >= 0) {
                    if (!(menuItems[i] instanceof JCheckBoxMenuItem)) break;
                    WindowMenu.this.remove(menuItems[i]);
                }
            }

            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.stack.setEnabled(array.length > 0);
        this.cascade.setEnabled(array.length > 0);
        this.tile.setEnabled(array.length > 0);
        int i = 0;
        while (i < array.length) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
            ++i;
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

