/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jspecview.applet.JSVAppletPrivatePro;
import jspecview.application.AppMenu;
import jspecview.application.AppToolBar;
import jspecview.application.CommandHistory;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.JSpecView;
import jspecview.application.PreferencesDialog;
import jspecview.application.ScrollableDesktopPane;
import jspecview.application.TextDialog;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVAppletInterface;
import jspecview.common.JSVDialog;
import jspecview.common.JSVDropTargetListener;
import jspecview.common.JSVFileFilter;
import jspecview.common.JSVFrame;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelPopupMenu;
import jspecview.common.JSVSpecNode;
import jspecview.common.JSViewer;
import jspecview.common.OverlayLegendDialog;
import jspecview.common.PanelData;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.PrintLayoutDialog;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.FileManager;
import jspecview.util.Logger;
import jspecview.util.Parser;
import jspecview.util.TextFormat;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolSyncInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame
implements JmolSyncInterface,
PanelListener,
ScriptInterface,
JSVAppletInterface {
    private static final long serialVersionUID = 1L;
    private static final int FILE_OPEN_OK = 0;
    private static final int FILE_OPEN_ALREADY = -1;
    private static final int FILE_OPEN_ERROR = -3;
    private static final int FILE_OPEN_NO_DATA = -4;
    private static final int MAX_RECENT = 10;
    private boolean toolbarOn;
    private boolean sidePanelOn;
    private boolean statusbarOn;
    private boolean showExitDialog;
    private String defaultDisplaySchemeName;
    private boolean autoOverlay;
    private boolean autoShowLegend;
    private boolean useDirLastOpened;
    private boolean useDirLastExported;
    private String dirLastOpened;
    private String dirLastExported;
    private String recentFileName;
    private String recentURL;
    private int irMode = 0;
    private boolean autoIntegrate;
    private AwtParameters parameters = new AwtParameters("application");
    private JmolSyncInterface jmol;
    private List<JSVSpecNode> specNodes = new ArrayList<JSVSpecNode>();
    private List<String> recentFilePaths = new ArrayList<String>(10);
    private JDXSource currentSource;
    private Properties properties;
    private DisplaySchemesProcessor dsp;
    private String tempDS;
    private JSVPanel selectedPanel;
    private JSVPanelPopupMenu jsvpPopupMenu = new JSVPanelPopupMenu(this);
    private AppMenu appMenu;
    private AppToolBar toolBar;
    private BorderLayout mainborderLayout = new BorderLayout();
    private JSplitPane mainSplitPane = new JSplitPane();
    private JSplitPane sideSplitPane = new JSplitPane();
    private JScrollPane scrollPane = new JScrollPane();
    private ScrollableDesktopPane desktopPane = new ScrollableDesktopPane();
    public DropTargetListener dtl;
    private JSVTreeNode rootNode;
    private DefaultTreeModel spectraTreeModel;
    private JTree spectraTree;
    private JScrollPane spectraTreePane;
    private JPanel statusPanel = new JPanel();
    private JLabel statusLabel = new JLabel();
    private JTextField commandInput = new JTextField();
    private JFileChooser fc;
    private JSVInterface jmolOrAdvancedApplet;
    private JSVAppletPrivatePro advancedApplet;
    private Image iconImage;
    private ImageIcon frameIcon;
    private CommandHistory commandHistory;
    private boolean svgForInkscape;
    private Component jmolDisplay;
    private Dimension jmolDimensionOld;
    private Container jmolFrame;
    private Dimension jmolDimensionNew = new Dimension(250, 200);
    private JPanel nullPanel = new JPanel();
    private int splitPosition;
    private int nOverlay;
    private int fileCount = 0;
    private boolean isEmbedded;
    private boolean isHidden;
    private String recentOpenURL = "http://";

    public static void main(String[] args) {
        JSpecView.main(args);
    }

    public MainFrame(Component jmolDisplay, JSVInterface jmolOrAdvancedApplet) {
        this.jmolDisplay = jmolDisplay;
        if (jmolDisplay != null) {
            this.jmolFrame = jmolDisplay.getParent();
        }
        this.jmolOrAdvancedApplet = jmolOrAdvancedApplet;
        this.advancedApplet = jmolOrAdvancedApplet instanceof JSVAppletPrivatePro ? (JSVAppletPrivatePro)jmolOrAdvancedApplet : null;
        this.onProgramStart();
    }

    void exitJSpecView(boolean withDialog) {
        this.jmolOrAdvancedApplet.saveProperties(this.properties);
        if (this.isEmbedded) {
            this.awaken(false);
            return;
        }
        this.dsp.getDisplaySchemes().remove("Current");
        this.jmolOrAdvancedApplet.exitJSpecView(withDialog && this.showExitDialog, this);
    }

    public void awaken(boolean visible) {
        if (this.jmolDisplay == null) {
            return;
        }
        try {
            if (visible) {
                this.jmolDimensionOld = new Dimension();
                this.jmolDisplay.getSize(this.jmolDimensionOld);
                this.jmolDisplay.setSize(this.jmolDimensionNew);
                this.jmolFrame.remove(this.jmolDisplay);
                this.jmolFrame.add(this.nullPanel);
                this.sideSplitPane.setBottomComponent(this.jmolDisplay);
                this.sideSplitPane.setDividerLocation(this.splitPosition);
                this.sideSplitPane.validate();
                this.jmolFrame.validate();
            } else {
                this.sideSplitPane.setBottomComponent(this.nullPanel);
                this.splitPosition = this.sideSplitPane.getDividerLocation();
                this.jmolFrame.add(this.jmolDisplay);
                this.jmolDisplay.getSize(this.jmolDimensionNew);
                this.jmolDisplay.setSize(this.jmolDimensionOld);
                this.sideSplitPane.validate();
                this.jmolFrame.validate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(visible);
    }

    private void getIcons() {
        Class<?> cl = this.getClass();
        URL iconURL = cl.getResource("icons/spec16.gif");
        this.iconImage = Toolkit.getDefaultToolkit().getImage(iconURL);
        this.frameIcon = new ImageIcon(iconURL);
    }

    private void setApplicationElements() {
        this.appMenu.setSelections(this.sidePanelOn, this.toolbarOn, this.statusbarOn, this.getSelectedPanel());
        this.toolBar.setSelections(this.getSelectedPanel());
    }

    private void onProgramStart() {
        new DropTarget(this, this.getDropListener());
        this.getIcons();
        this.properties = new Properties();
        this.properties.setProperty("recentFilePaths", "");
        this.properties.setProperty("confirmBeforeExit", "true");
        this.properties.setProperty("automaticallyOverlay", "false");
        this.properties.setProperty("automaticallyShowLegend", "false");
        this.properties.setProperty("useDirectoryLastOpenedFile", "true");
        this.properties.setProperty("useDirectoryLastExportedFile", "false");
        this.properties.setProperty("directoryLastOpenedFile", "");
        this.properties.setProperty("directoryLastExportedFile", "");
        this.properties.setProperty("showSidePanel", "true");
        this.properties.setProperty("showToolBar", "true");
        this.properties.setProperty("showStatusBar", "true");
        this.properties.setProperty("defaultDisplaySchemeName", "Default");
        this.properties.setProperty("showGrid", "false");
        this.properties.setProperty("showCoordinates", "false");
        this.properties.setProperty("showXScale", "true");
        this.properties.setProperty("showYScale", "true");
        this.properties.setProperty("svgForInkscape", "false");
        this.properties.setProperty("automaticTAConversion", "false");
        this.properties.setProperty("AtoTSeparateWindow", "false");
        this.properties.setProperty("automaticallyIntegrate", "false");
        this.properties.setProperty("integralMinY", "0.1");
        this.properties.setProperty("integralFactor", "50");
        this.properties.setProperty("integralOffset", "30");
        this.properties.setProperty("integralPlotColor", "#ff0000");
        this.jmolOrAdvancedApplet.setProperties(this.properties);
        this.dsp = new DisplaySchemesProcessor();
        if (!this.dsp.load("displaySchemes.xml") && !this.dsp.load(this.getClass().getResourceAsStream("resources/displaySchemes.xml"))) {
            this.writeStatus("Problem loading Display Scheme");
        }
        this.setApplicationProperties(true);
        this.tempDS = this.defaultDisplaySchemeName;
        this.fc = Logger.debugging ? new JFileChooser("C:/temp") : (this.useDirLastOpened ? new JFileChooser(this.dirLastOpened) : new JFileChooser());
        JSVFileFilter filter = new JSVFileFilter();
        filter = new JSVFileFilter();
        filter.addExtension("xml");
        filter.addExtension("aml");
        filter.addExtension("cml");
        filter.setDescription("CML/XML Files");
        this.fc.setFileFilter(filter);
        filter = new JSVFileFilter();
        filter.addExtension("jdx");
        filter.addExtension("dx");
        filter.setDescription("JCAMP-DX Files");
        this.fc.setFileFilter(filter);
        this.initSpectraTree();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setApplicationElements();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                MainFrame.this.windowClosing_actionPerformed();
            }
        });
        this.setSize(800, 500);
    }

    private void setApplicationProperties(boolean shouldApplySpectrumDisplaySettings) {
        String autoATConversion;
        String recentFilesString = this.properties.getProperty("recentFilePaths");
        this.recentFilePaths.clear();
        if (!recentFilesString.equals("")) {
            StringTokenizer st = new StringTokenizer(recentFilesString, ",");
            while (st.hasMoreTokens()) {
                this.recentFilePaths.add(st.nextToken().trim());
            }
        }
        this.showExitDialog = Boolean.parseBoolean(this.properties.getProperty("confirmBeforeExit"));
        this.autoOverlay = Boolean.parseBoolean(this.properties.getProperty("automaticallyOverlay"));
        this.autoShowLegend = Boolean.parseBoolean(this.properties.getProperty("automaticallyShowLegend"));
        this.useDirLastOpened = Boolean.parseBoolean(this.properties.getProperty("useDirectoryLastOpenedFile"));
        this.useDirLastExported = Boolean.parseBoolean(this.properties.getProperty("useDirectoryLastExportedFile"));
        this.dirLastOpened = this.properties.getProperty("directoryLastOpenedFile");
        this.dirLastExported = this.properties.getProperty("directoryLastExportedFile");
        this.sidePanelOn = Boolean.parseBoolean(this.properties.getProperty("showSidePanel"));
        this.toolbarOn = Boolean.parseBoolean(this.properties.getProperty("showToolBar"));
        this.statusbarOn = Boolean.parseBoolean(this.properties.getProperty("showStatusBar"));
        this.defaultDisplaySchemeName = this.properties.getProperty("defaultDisplaySchemeName");
        if (shouldApplySpectrumDisplaySettings) {
            this.parameters.setBoolean(ScriptToken.GRIDON, this.properties.getProperty("showGrid"));
            this.parameters.setBoolean(ScriptToken.COORDINATESON, this.properties.getProperty("showCoordinates"));
            this.parameters.setBoolean(ScriptToken.XSCALEON, this.properties.getProperty("showXScale"));
            this.parameters.setBoolean(ScriptToken.YSCALEON, this.properties.getProperty("showYScale"));
        }
        if ((autoATConversion = this.properties.getProperty("automaticTAConversion")).equals("AtoT")) {
            this.irMode = 2;
        } else if (autoATConversion.equals("TtoA")) {
            this.irMode = 1;
        }
        try {
            this.autoIntegrate = Boolean.parseBoolean(this.properties.getProperty("automaticallyIntegrate"));
            this.parameters.integralMinY = Double.parseDouble(this.properties.getProperty("integralMinY"));
            this.parameters.integralFactor = Double.parseDouble(this.properties.getProperty("integralFactor"));
            this.parameters.integralOffset = Double.parseDouble(this.properties.getProperty("integralOffset"));
            this.parameters.set(null, ScriptToken.INTEGRALPLOTCOLOR, this.properties.getProperty("integralPlotColor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.svgForInkscape = Boolean.parseBoolean(this.properties.getProperty("svgForInkscape"));
    }

    private void initSpectraTree() {
        this.currentSource = null;
        this.rootNode = new JSVTreeNode("Spectra", null);
        this.spectraTreeModel = new DefaultTreeModel(this.rootNode);
        this.spectraTree = new JTree(this.spectraTreeModel);
        this.spectraTree.getSelectionModel().setSelectionMode(1);
        this.spectraTree.setCellRenderer(new SpectraTreeCellRenderer());
        this.spectraTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JSVTreeNode node = (JSVTreeNode)MainFrame.this.spectraTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.isLeaf()) {
                    MainFrame.this.setFrame(node.specNode, true);
                }
                MainFrame.this.currentSource = node.specNode.source;
                MainFrame.this.appMenu.setCloseMenuItem(node.specNode.fileName);
            }
        });
        this.spectraTree.putClientProperty("JTree.lineStyle", "Angled");
        this.spectraTree.setShowsRootHandles(true);
        this.spectraTree.setEditable(false);
        this.spectraTree.setRootVisible(false);
        this.spectraTree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MainFrame.this.getSelectedPanel() != null) {
                    MainFrame.this.getSelectedPanel().getPanelData().setZoom(0.0, 0.0, 0.0, 0.0);
                    MainFrame.this.repaint();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        new DropTarget(this.spectraTree, this.getDropListener());
    }

    private DropTargetListener getDropListener() {
        if (this.dtl == null) {
            this.dtl = new JSVDropTargetListener(this, true);
        }
        return this.dtl;
    }

    private void jbInit() throws Exception {
        this.toolBar = new AppToolBar(this);
        this.appMenu = new AppMenu(this, this.jsvpPopupMenu);
        this.appMenu.setRecentMenu(this.recentFilePaths);
        this.setIconImage(this.iconImage);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.appMenu);
        this.setTitle("JSpecView");
        this.getContentPane().setLayout(this.mainborderLayout);
        this.sideSplitPane.setOrientation(0);
        this.sideSplitPane.setOneTouchExpandable(true);
        this.statusLabel.setToolTipText("");
        this.statusLabel.setHorizontalTextPosition(10);
        this.statusLabel.setText("  ");
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        BorderLayout bl = new BorderLayout();
        bl.setHgap(2);
        bl.setVgap(2);
        this.statusPanel.setLayout(bl);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(0.3);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.commandInput, "South");
        this.commandHistory = new CommandHistory(this, this.commandInput);
        this.commandInput.setFocusTraversalKeysEnabled(false);
        this.commandInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                MainFrame.this.commandHistory.keyPressed(e.getKeyCode());
                MainFrame.this.checkCommandLineForTip(e.getKeyChar());
                MainFrame.this.commandInput.requestFocusInWindow();
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.spectraTreePane = new JScrollPane(this.spectraTree);
        if (this.jmolDisplay != null) {
            JSplitPane leftPanel = new JSplitPane();
            BorderLayout bl1 = new BorderLayout();
            leftPanel.setLayout(bl1);
            JPanel jmolDisplayPanel = new JPanel();
            jmolDisplayPanel.setBackground(Color.blue);
            leftPanel.add((Component)jmolDisplayPanel, "South");
            leftPanel.add((Component)this.spectraTreePane, "North");
            this.sideSplitPane.setTopComponent(this.spectraTreePane);
            this.splitPosition = 200;
            this.sideSplitPane.setDividerLocation(200);
            this.awaken(true);
            this.mainSplitPane.setLeftComponent(this.sideSplitPane);
        } else {
            this.mainSplitPane.setLeftComponent(this.spectraTreePane);
        }
        this.scrollPane.getViewport().add(this.desktopPane);
        this.mainSplitPane.setRightComponent(this.scrollPane);
    }

    protected void checkCommandLineForTip(char c) {
        String tip;
        if (c != '\t' && (c == '\n' || c < ' ' || c > '~')) {
            return;
        }
        String cmd = String.valueOf(this.commandInput.getText()) + (Character.isISOControl(c) ? "" : "" + c);
        if (cmd.indexOf(";") >= 0) {
            cmd = cmd.substring(cmd.lastIndexOf(";") + 1);
        }
        while (cmd.startsWith(" ")) {
            cmd = cmd.substring(1);
        }
        if (cmd.length() == 0) {
            tip = "Enter a command:";
        } else {
            List<String> tokens = ScriptToken.getTokens(cmd);
            if (tokens.size() == 0) {
                return;
            }
            boolean isExact = cmd.endsWith(" ") || tokens.size() > 1;
            List<ScriptToken> list = ScriptToken.getScriptTokenList(tokens.get(0), isExact);
            switch (list.size()) {
                case 0: {
                    tip = "?";
                    break;
                }
                case 1: {
                    ScriptToken st = list.get(0);
                    tip = st.getTip();
                    tip = tip.indexOf("TRUE") >= 0 ? " (" + this.parameters.getBoolean(st) + ")" : (st.name().indexOf("COLOR") >= 0 ? " (" + AwtParameters.colorToHexString(this.parameters.getColor(st)) + ")" : "");
                    if (c == '\t' || isExact) {
                        tip = String.valueOf(st.name()) + " " + st.getTip() + tip;
                        if (c != '\t') break;
                        this.commandInput.setText(String.valueOf(st.name()) + " ");
                        break;
                    }
                    tip = String.valueOf(st.name()) + " " + tip;
                    break;
                }
                default: {
                    tip = ScriptToken.getNameList(list);
                }
            }
        }
        this.writeStatus(tip);
    }

    void showFileOpenDialog() {
        if (this.fc.showOpenDialog(this) == 0) {
            File file = this.fc.getSelectedFile();
            this.properties.setProperty("directoryLastOpenedFile", file.getParent());
            this.openFile(file.getAbsolutePath(), true);
        }
    }

    public void openFile(String fileOrURL, int firstSpec, int lastSpec) {
        this.openDataOrFile(null, null, null, fileOrURL, firstSpec, lastSpec);
    }

    private int openDataOrFile(String data, String name, List<JDXSpectrum> specs, String url, int firstSpec, int lastSpec) {
        this.writeStatus("");
        String filePath = null;
        String fileName = null;
        File file = null;
        boolean isOverlay = false;
        if (data == null) {
            if (specs != null) {
                isOverlay = true;
                fileName = filePath = "Overlay" + ++this.nOverlay;
            } else if (url != null) {
                try {
                    URL u = new URL(url);
                    fileName = FileManager.getName(url);
                    this.recentURL = filePath = u.toString();
                }
                catch (MalformedURLException e) {
                    file = new File(url);
                }
            }
        }
        if (file != null) {
            fileName = this.recentFileName = file.getName();
            filePath = file.getAbsolutePath();
            this.recentURL = null;
        }
        if (JSVSpecNode.isOpen(this.specNodes, filePath)) {
            this.writeStatus(String.valueOf(filePath) + " is already open");
            return -1;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.setCurrentSource(isOverlay ? JDXSource.createOverlay(url, specs) : FileReader.createJDXSource(FileManager.getBufferedReaderForString(data), filePath, null, false, firstSpec, lastSpec));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeStatus(e.getMessage());
            this.setCursor(Cursor.getDefaultCursor());
            return -3;
        }
        this.setCursor(Cursor.getDefaultCursor());
        System.gc();
        this.currentSource.setFilePath(filePath);
        this.appMenu.setCloseMenuItem(fileName);
        this.setTitle("JSpecView - " + filePath);
        this.appMenu.setSourceEnabled(true);
        JDXSpectrum spec = this.currentSource.getJDXSpectrum(0);
        if (spec == null) {
            return -4;
        }
        boolean autoOverlay = this.autoOverlay || spec.isAutoOverlayFromJmolClick();
        specs = this.currentSource.getSpectra();
        boolean overlay = isOverlay || autoOverlay && this.currentSource.isCompoundSource;
        JDXSpectrum.process(specs, this.irMode, this.autoIntegrate, this.parameters);
        if (overlay) {
            this.overlay(this.currentSource, isOverlay ? url : null);
        } else {
            this.splitSpectra(this.currentSource);
        }
        if (!isOverlay) {
            this.updateRecentMenus(filePath);
        }
        return 0;
    }

    private void updateRecentMenus(String filePath) {
        if (this.recentFilePaths.size() >= 10) {
            this.recentFilePaths.remove(9);
        }
        if (this.recentFilePaths.contains(filePath)) {
            this.recentFilePaths.remove(filePath);
        }
        this.recentFilePaths.add(0, filePath);
        StringBuffer filePaths = new StringBuffer();
        int n = this.recentFilePaths.size();
        int index = 0;
        while (index < n) {
            filePaths.append(", ").append(this.recentFilePaths.get(index));
            ++index;
        }
        this.properties.setProperty("recentFilePaths", n == 0 ? "" : filePaths.substring(2));
        this.appMenu.updateRecentMenus(this.recentFilePaths);
    }

    private void setCurrentSource(JDXSource source) {
        this.currentSource = source;
        boolean isError = source != null && source.getErrorLog().length() > 0;
        this.setError(isError, isError && source.getErrorLog().indexOf("Warning") >= 0);
    }

    private void setError(boolean isError, boolean isWarningOnly) {
        this.appMenu.setError(isError, isWarningOnly);
        this.toolBar.setError(isError, isWarningOnly);
    }

    public void setJSVPanelProperties(JSVPanel jsvp, boolean includeMeasures) {
        Parameters ds = this.dsp.getDisplaySchemes().get(this.defaultDisplaySchemeName);
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, ds == null ? this.dsp.getDefaultScheme() : ds, includeMeasures);
        jsvp.repaint();
    }

    private void overlay(JDXSource source, String name) {
        List<JDXSpectrum> specs = source.getSpectra();
        AwtPanel jsvp = AwtPanel.getJSVPanel(specs, 0, 0, this.jsvpPopupMenu);
        jsvp.setTitle(source.getTitle());
        this.setJSVPanelProperties(jsvp, true);
        JSVFrame frame = new JSVFrame(name == null ? source.getTitle() : name);
        frame.setFrameIcon(this.frameIcon);
        frame.setDefaultCloseOperation(2);
        frame.addInternalFrameListener(new JSVInternalFrameListener(source));
        frame.setMinimumSize(new Dimension(365, 200));
        frame.setPreferredSize(new Dimension(365, 200));
        frame.getContentPane().add(jsvp);
        this.desktopPane.add(frame);
        frame.setSize(550, 350);
        try {
            frame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        frame.show();
        JSVFrame[] frames = new JSVFrame[]{frame};
        this.createTree(source, frames);
        this.validate();
        this.repaint();
        JSVSpecNode node = JSVSpecNode.findNode(this.getSelectedPanel(), this.specNodes);
        if (this.autoShowLegend && this.getSelectedPanel().getPanelData().getNumberOfGraphSets() == 1) {
            node.setLegend(new OverlayLegendDialog((Frame)this, jsvp));
        }
        this.setMenuEnables(node);
    }

    private void splitSpectra(JDXSource source) {
        List<JDXSpectrum> specs = source.getSpectra();
        JSVFrame[] frames = new JSVFrame[specs.size()];
        int i = 0;
        while (i < specs.size()) {
            JDXSpectrum spec = specs.get(i);
            AwtPanel jsvp = AwtPanel.getNewPanel(spec, this.jsvpPopupMenu);
            this.setJSVPanelProperties(jsvp, true);
            JSVFrame frame = new JSVFrame(spec.getTitleLabel());
            frame.setFrameIcon(this.frameIcon);
            frame.setDefaultCloseOperation(2);
            frame.setMinimumSize(new Dimension(365, 200));
            frame.setPreferredSize(new Dimension(365, 200));
            frame.getContentPane().add(jsvp);
            frame.addInternalFrameListener(new JSVInternalFrameListener(source));
            frames[i] = frame;
            this.desktopPane.add(frame);
            frame.setVisible(true);
            frame.setSize(550, 350);
            try {
                frame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++i;
        }
        i = specs.size() - 1;
        while (i >= 0) {
            frames[i].toFront();
            --i;
        }
        this.createTree(source, frames);
        JSVSpecNode node = JSVSpecNode.findNode(this.getSelectedPanel(), this.specNodes);
        this.setMenuEnables(node);
        this.commandInput.requestFocusInWindow();
    }

    public void closeSource(JDXSource source) {
        String fileName = source == null ? null : source.getFilePath();
        ArrayList<JSVTreeNode> toDelete = new ArrayList<JSVTreeNode>();
        Enumeration<TreeNode> enume = this.rootNode.children();
        while (enume.hasMoreElements()) {
            JSVTreeNode node = (JSVTreeNode)enume.nextElement();
            if (fileName != null && !node.specNode.source.getFilePath().equals(fileName)) continue;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                JSVTreeNode childNode = (JSVTreeNode)e.nextElement();
                toDelete.add(childNode);
                childNode.specNode.frame.dispose();
                this.specNodes.remove(childNode.specNode);
            }
            toDelete.add(node);
            if (fileName != null) break;
        }
        int i = 0;
        while (i < toDelete.size()) {
            this.spectraTreeModel.removeNodeFromParent((MutableTreeNode)toDelete.get(i));
            ++i;
        }
        if (source == null) {
            if (this.getSelectedPanel() != null) {
                this.getSelectedPanel().dispose();
            }
            if (this.currentSource != null) {
                this.currentSource.dispose();
            }
        }
        this.appMenu.clearSourceMenu(source);
        this.setSelectedPanel(null);
        this.currentSource = null;
        System.gc();
        this.setError(false, false);
        this.setTitle("JSpecView");
        if (source != null) {
            this.setSpectrumNumberAndTreeNode(this.specNodes.size());
        }
        this.setFileCount();
        System.gc();
        Logger.checkMemory();
    }

    private void setFileCount() {
        int max = 0;
        int i = 0;
        while (i < this.specNodes.size()) {
            float f = Parser.parseFloat(this.specNodes.get((int)i).id);
            if (f >= (float)(max + 1)) {
                max = (int)Math.floor(f);
            }
            ++i;
        }
        this.fileCount = max;
    }

    public void createTree(JDXSource source, JSVFrame[] frames) {
        String fileName = FileManager.getName(source.getFilePath());
        JSVSpecNode specNode = new JSVSpecNode(null, fileName, source, null, null);
        JSVTreeNode fileNode = new JSVTreeNode(fileName, specNode);
        specNode.setTreeNode(fileNode);
        this.spectraTreeModel.insertNodeInto(fileNode, this.rootNode, this.rootNode.getChildCount());
        this.spectraTree.scrollPathToVisible(new TreePath(fileNode.getPath()));
        ++this.fileCount;
        int i = 0;
        while (i < frames.length) {
            JSVPanel jsvp = MainFrame.getPanel0(frames[i]);
            String id = String.valueOf(this.fileCount) + "." + (i + 1);
            specNode = new JSVSpecNode(id, fileName, source, frames[i], jsvp);
            JSVTreeNode treeNode = new JSVTreeNode(specNode.toString(), specNode);
            specNode.setTreeNode(treeNode);
            this.specNodes.add(specNode);
            this.spectraTreeModel.insertNodeInto(treeNode, fileNode, fileNode.getChildCount());
            this.spectraTree.scrollPathToVisible(new TreePath(treeNode.getPath()));
            ++i;
        }
        this.selectFrameNode(frames[0]);
    }

    public void showNotImplementedOptionPane() {
        JOptionPane.showMessageDialog(this, "Not Yet Implemented", "Not Yet Implemented", 1);
    }

    public JSVSpecNode selectFrameNode(JSVFrame frame) {
        JSVSpecNode node = JSVSpecNode.findNode(frame, this.specNodes);
        if (node == null) {
            return null;
        }
        this.spectraTree.setSelectionPath(new TreePath(((JSVTreeNode)node.treeNode).getPath()));
        JSViewer.setOverlayLegendVisibility(this, node.jsvp, this.appMenu.overlayKeyMenuItem.isSelected());
        return node;
    }

    private void doInternalFrameClosing(JInternalFrame frame) {
        this.closeSource(this.currentSource);
        this.setCurrentSource(null);
        if (this.specNodes.size() == 0) {
            this.setMenuEnables(null);
        }
    }

    private void setMenuEnables(JSVSpecNode node) {
        this.appMenu.setMenuEnables(node);
        this.toolBar.setMenuEnables(node);
    }

    @Override
    public JSVPanel getSelectedPanel() {
        JSVFrame frame = (JSVFrame)this.desktopPane.getSelectedFrame();
        return frame == null ? this.selectedPanel : MainFrame.getPanel0(frame);
    }

    public void processCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void runScriptNow(String peakScript) {
        JSViewer.runScriptNow(this, peakScript);
    }

    private void close(String value) {
        JDXSource source;
        if (value == null || value.equalsIgnoreCase("all")) {
            this.closeSource(null);
            return;
        }
        if ((value = value.replace('\\', '/')).endsWith("*")) {
            value = value.substring(0, value.length() - 1);
            int i = this.specNodes.size();
            while (--i >= 0) {
                if (!this.specNodes.get((int)i).fileName.startsWith(value)) continue;
                this.closeSource(this.specNodes.get((int)i).source);
            }
            return;
        }
        JDXSource jDXSource = source = value.length() == 0 ? this.currentSource : JSVSpecNode.findSourceByNameOrId(value, this.specNodes);
        if (source == null) {
            return;
        }
        this.closeSource(source);
    }

    public void setSpectrumNumberAndTreeNode(int n) {
        this.setFrameAndTreeNode(n - 1);
    }

    private void setFrameAndTreeNode(int i) {
        if (this.specNodes == null || i < 0 || i >= this.specNodes.size()) {
            return;
        }
        this.setFrameAndTreeNode(this.specNodes.get(i));
    }

    private void setFrameAndTreeNode(JSVSpecNode node) {
        this.selectFrameNode((JSVFrame)node.frame);
        this.setFrame(node, false);
    }

    @Override
    public JSVPanel setSpectrumIndex(int i) {
        if (this.specNodes != null && i >= 0 && i < this.specNodes.size()) {
            this.setFrame(this.specNodes.get(i), false);
        }
        return this.getSelectedPanel();
    }

    private void setFrame(JSVSpecNode specNode, boolean fromTree) {
        JSVFrame frame = (JSVFrame)specNode.frame;
        this.setSelectedPanel(specNode.jsvp);
        frame.setVisible(true);
        frame.moveToFront();
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (fromTree && frame.isEnabled()) {
            this.getSelectedPanel().setEnabled(true);
            this.sendFrameChange(specNode.jsvp);
            if (this.desktopPane.getStyle() == 0) {
                this.desktopPane.setAllEnabled(false);
            }
            this.getSelectedPanel().setEnabled(true);
        }
        this.setMenuEnables(specNode);
        if (this.getSelectedPanel().getSpectrum().hasIntegral()) {
            this.writeStatus("Use CTRL-LEFT-DRAG to measure an integration value.");
        } else {
            this.writeStatus("");
        }
    }

    @Override
    public void panelEvent(Object eventObj) {
        if (eventObj instanceof PeakPickEvent) {
            JSViewer.processPeakPickEvent(this, eventObj, true);
        } else if (eventObj instanceof ZoomEvent) {
            this.writeStatus("Double-Click highlighted spectrum in menu to zoom out; CTRL+/CTRL- to adjust Y scaling.");
        } else if (eventObj instanceof SubSpecChangeEvent) {
            SubSpecChangeEvent e = (SubSpecChangeEvent)eventObj;
            if (e.isValid()) {
                this.setMainTitle(e.toString());
            } else {
                this.advanceSpectrumBy(-e.getSubIndex());
            }
        }
    }

    @Override
    public void setSelectedPanel(JSVPanel jsvp) {
        this.selectedPanel = jsvp;
    }

    private void setMainTitle(String title) {
        String t = this.getSelectedPanel().getSpectrum().getTitleLabel();
        this.desktopPane.getSelectedFrame().setTitle(title == null ? t : String.valueOf(t) + " - " + title);
    }

    @Override
    public void sendFrameChange(JSVPanel jsvp) {
        JSViewer.sendFrameChange(this, jsvp);
    }

    public void setSplitPane(boolean TF) {
        if (TF) {
            this.mainSplitPane.setDividerLocation(200);
        } else {
            this.mainSplitPane.setDividerLocation(0);
        }
    }

    public void enableToolbar(boolean isEnabled) {
        if (isEnabled) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.validate();
    }

    public void showPreferences() {
        PreferencesDialog pd = new PreferencesDialog(this, "Preferences", true, this.properties, this.dsp);
        this.properties = pd.getPreferences();
        boolean shouldApplySpectrumDisplaySetting = pd.shouldApplySpectrumDisplaySettingsNow();
        this.setApplicationProperties(shouldApplySpectrumDisplaySetting);
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            this.setJSVPanelProperties(MainFrame.getPanel0((JSVFrame)frames[i]), shouldApplySpectrumDisplaySetting);
            ++i;
        }
        this.setApplicationElements();
        this.dsp.getDisplaySchemes();
        if (this.defaultDisplaySchemeName.equals("Current")) {
            this.properties.setProperty("defaultDisplaySchemeName", this.tempDS);
        }
    }

    void exportSpectrum(String command) {
        String type = command;
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        if (this.fc == null) {
            return;
        }
        if (Logger.debugging) {
            this.fc.setCurrentDirectory(new File("C:\\JCAMPDX"));
        } else if (this.useDirLastExported) {
            this.fc.setCurrentDirectory(new File(this.dirLastExported));
        }
        this.dirLastExported = Exporter.exportSpectra(jsvp, this, this.fc, type, this.recentFileName, this.dirLastExported);
    }

    protected void windowClosing_actionPerformed() {
        this.exitJSpecView(true);
    }

    private void advanceSpectrumBy(int n) {
        int i = this.specNodes.size();
        while (--i >= 0) {
            if (this.specNodes.get((int)i).jsvp == this.getSelectedPanel()) break;
        }
        this.setFrameAndTreeNode(i + n);
        this.getSelectedPanel().doRequestFocusInWindow();
    }

    static JSVPanel getPanel0(JSVFrame frame) {
        return (JSVPanel)((Object)frame.getContentPane().getComponent(0));
    }

    @Override
    public Map<String, Object> getProperty(String key) {
        if ("".equals(key)) {
            key = null;
        }
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < this.specNodes.size()) {
            JSVPanel jsvp = this.specNodes.get((int)i).jsvp;
            if (jsvp != null) {
                info.add(jsvp.getPanelData().getInfo(jsvp == this.getSelectedPanel(), key));
            }
            ++i;
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("items", info);
        return map;
    }

    @Override
    public void register(String appletID, JmolSyncInterface jmolStatusListener) {
        this.jmol = jmolStatusListener;
        this.isEmbedded = true;
    }

    @Override
    public boolean syncToJmol(String msg) {
        Logger.info("JSV>Jmol " + msg);
        if (this.jmol != null) {
            this.jmol.syncScript(msg);
            return true;
        }
        if (this.jmolOrAdvancedApplet != null) {
            return this.jmolOrAdvancedApplet.syncToJmol(msg);
        }
        return false;
    }

    @Override
    public void syncScript(String peakScript) {
        JSViewer.syncScript(this, peakScript);
    }

    @Override
    public void syncLoad(String filePath) {
        this.closeSource(null);
        this.openDataOrFile(null, null, null, filePath, -1, -1);
        if (this.currentSource == null) {
            return;
        }
        if (this.specNodes.get(0).getSpectrum().isAutoOverlayFromJmolClick()) {
            this.execOverlay("*");
        }
    }

    @Override
    public void setFrame(JSVSpecNode specNode) {
        this.setFrame(specNode, false);
    }

    @Override
    public JDXSource getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public List<JSVSpecNode> getSpecNodes() {
        return this.specNodes;
    }

    @Override
    public void execOverlay(String value) {
        ArrayList<JDXSpectrum> speclist = new ArrayList<JDXSpectrum>();
        String strlist = JSVSpecNode.fillSpecList(this.specNodes, value, speclist, this.getSelectedPanel(), "1.");
        if (speclist.size() > 1) {
            this.openDataOrFile(null, strlist, speclist, strlist, -1, -1);
        }
    }

    @Override
    public void execIntegrate(JDXSpectrum spec) {
    }

    @Override
    public String setSolutionColor(boolean showMessage) {
        String msg = this.getSelectedPanel().getPanelData().getSolutionColorHtml();
        JOptionPane.showMessageDialog(this, msg, "Predicted Colour", 1);
        return null;
    }

    @Override
    public void execClose(String value) {
        this.close(TextFormat.trimQuotes(value));
    }

    @Override
    public void execHidden(boolean b) {
        this.isHidden = this.jmol != null && b;
        this.setVisible(!this.isHidden);
    }

    @Override
    public String execLoad(String value) {
        List<String> tokens = ScriptToken.getTokens(value);
        String filename = tokens.get(0);
        int pt = 0;
        if (filename.equalsIgnoreCase("APPEND")) {
            filename = tokens.get(++pt);
        } else {
            if (filename.equals("\"\"") && this.currentSource != null) {
                filename = this.currentSource.getFilePath();
            }
            this.close("all");
        }
        filename = TextFormat.trimQuotes(filename);
        int firstSpec = pt + 1 < tokens.size() ? Integer.valueOf(tokens.get(++pt)) : -1;
        int lastSpec = pt + 1 < tokens.size() ? Integer.valueOf(tokens.get(++pt)) : firstSpec;
        this.openFile(filename, firstSpec, lastSpec);
        if (this.getSelectedPanel() == null) {
            return null;
        }
        if (!this.getSelectedPanel().getSpectrum().is1D() && this.getSelectedPanel().getPanelData().getDisplay1D()) {
            return "Click on the spectrum and use UP or DOWN keys to see subspectra.";
        }
        return null;
    }

    @Override
    public String execExport(JSVPanel jsvp, String value) {
        return Exporter.exportCmd(jsvp, ScriptToken.getTokens(value), this.svgForInkscape);
    }

    @Override
    public void execSetIntegrationRatios(String value) {
    }

    @Override
    public void execTAConvert(int mode) {
        this.irMode = 0;
    }

    @Override
    public void execSetInterface(String value) {
        if (value.equalsIgnoreCase("stack")) {
            this.desktopPane.stackFrames();
        } else if (value.equalsIgnoreCase("cascade")) {
            this.desktopPane.cascadeFrames();
        } else if (value.equalsIgnoreCase("tile")) {
            this.desktopPane.tileFrames();
        }
    }

    @Override
    public void execScriptComplete(String msg, boolean isOK) {
        this.repaint();
        if (msg != null) {
            this.writeStatus(msg);
            if (msg.length() == 0) {
                msg = null;
            }
        }
        if (msg == null) {
            this.commandInput.requestFocus();
        }
    }

    @Override
    public JSVPanel execSetSpectrum(String value) {
        if (value.indexOf(46) >= 0) {
            JSVSpecNode node = JSVSpecNode.findNodeById(value, this.specNodes);
            if (node == null) {
                return null;
            }
            this.setFrameAndTreeNode(node);
        } else {
            this.setSpectrumNumberAndTreeNode(Integer.parseInt(value));
        }
        return this.getSelectedPanel();
    }

    @Override
    public void execSetAutoIntegrate(boolean b) {
        this.autoIntegrate = b;
    }

    @Override
    public void execTest(String value) {
        this.syncScript("<PeakData file=\"c:/temp/t.jdx\" index=\"2\" type=\"MS\" id=\"2\" title=\"b-caryopholene (~93)\" peakShape=\"sharp\" model=\"caryoph\"  xMax=\"94\" xMin=\"92\"  yMax=\"100\" yMin=\"0\" />");
    }

    @Override
    public PanelData getPanelData() {
        return this.getSelectedPanel().getPanelData();
    }

    @Override
    public JSVDialog getOverlayLegend(JSVPanel jsvp) {
        return new OverlayLegendDialog((Frame)this, jsvp);
    }

    @Override
    public boolean isPro() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        this.advancedApplet.addHighlight(x1, x2, r, g, b, a);
    }

    @Override
    public String export(String type, int n) {
        return this.advancedApplet.export(type, n);
    }

    @Override
    public String getCoordinate() {
        return this.advancedApplet.getCoordinate();
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return this.advancedApplet.getPropertyAsJSON(key);
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return this.advancedApplet.getPropertyAsJavaObject(key);
    }

    @Override
    public String getSolnColour() {
        return this.advancedApplet.getSolnColour();
    }

    @Override
    public void loadInline(String data) {
        this.openDataOrFile(data, null, null, null, -1, -1);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.processCommand("load " + tmpFilePath);
    }

    @Override
    public void runScript(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void writeStatus(String msg) {
        if (msg == null) {
            msg = "Unexpected Error";
        }
        if (msg.length() == 0) {
            msg = "Enter a command:";
        }
        this.statusLabel.setText(msg);
    }

    @Override
    public void removeAllHighlights() {
        this.advancedApplet.removeAllHighlights();
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        this.advancedApplet.removeHighlight(x1, x2);
    }

    @Override
    public void reversePlot() {
        this.advancedApplet.reversePlot();
    }

    @Override
    public void setSpectrumNumber(int i) {
        this.advancedApplet.setSpectrumNumber(i);
    }

    @Override
    public void toggleCoordinate() {
        this.advancedApplet.toggleCoordinate();
    }

    @Override
    public void toggleGrid() {
        this.advancedApplet.toggleGrid();
    }

    @Override
    public void toggleIntegration() {
        this.advancedApplet.toggleIntegration();
    }

    @Override
    public void execSetCallback(ScriptToken st, String value) {
        if (this.advancedApplet != null) {
            this.advancedApplet.execSetCallback(st, value);
        }
    }

    public void openFile(String fileName, boolean closeFirst) {
        JDXSource source;
        if (closeFirst && (source = JSVSpecNode.findSourceByNameOrId(new File(fileName).getAbsolutePath(), this.specNodes)) != null) {
            this.closeSource(source);
        }
        this.openDataOrFile(null, null, null, fileName, -1, -1);
    }

    @Override
    public void showProperties() {
        TextDialog.showProperties(this, this.getPanelData().getSpectrum());
    }

    @Override
    public void updateBoolean(ScriptToken st, boolean TF) {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        switch (st) {
            case COORDINATESON: {
                this.toolBar.coordsToggleButton.setSelected(TF);
                break;
            }
            case GRIDON: {
                this.toolBar.gridToggleButton.setSelected(TF);
            }
        }
    }

    public void enableStatus(boolean TF) {
        if (TF) {
            this.getContentPane().add((Component)this.statusPanel, "South");
        } else {
            this.getContentPane().remove(this.statusPanel);
        }
        this.validate();
    }

    public void openURL() {
        String msg = this.recentURL == null ? this.recentOpenURL : this.recentURL;
        String url = (String)JOptionPane.showInputDialog(null, "Enter the URL of a JCAMP-DX File", "Open URL", -1, null, null, msg);
        if (url == null) {
            return;
        }
        this.recentOpenURL = url;
        this.openDataOrFile(null, null, null, url, -1, -1);
    }

    public void print() {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        PrintLayoutDialog.PrintLayout pl = new PrintLayoutDialog(this).getPrintLayout();
        if (pl != null) {
            ((AwtPanel)jsvp).printSpectrum(pl);
        }
    }

    public void toggleOverlayKey() {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        JSViewer.setOverlayLegendVisibility(this, jsvp, true);
    }

    public void zoomTo(int mode) {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        PanelData pd = jsvp.getPanelData();
        switch (mode) {
            case 1: {
                pd.nextView();
                break;
            }
            case -1: {
                pd.previousView();
                break;
            }
            case 0x7FFFFFFF: {
                pd.fullView();
                break;
            }
            default: {
                pd.resetView();
            }
        }
    }

    @Override
    public void checkCallbacks(String title) {
        this.setMainTitle(title);
    }

    private class JSVInternalFrameListener
    extends InternalFrameAdapter {
        JDXSource source;

        public JSVInternalFrameListener(JDXSource source) {
            this.source = source;
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            JSVFrame frame = (JSVFrame)e.getInternalFrame();
            if (!frame.isVisible()) {
                return;
            }
            MainFrame.this.setCurrentSource(this.source);
            MainFrame.this.setTitle("JSpecView - " + this.source.getFilePath());
            MainFrame.this.selectFrameNode(frame);
            MainFrame.this.setMenuEnables(MainFrame.this.selectFrameNode(frame));
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            JSVFrame frame = (JSVFrame)e.getInternalFrame();
            MainFrame.this.doInternalFrameClosing(frame);
        }

        public void internalFrameOpened(InternalFrameEvent e) {
            MainFrame.this.spectraTree.validate();
            MainFrame.this.spectraTree.repaint();
        }
    }

    public class JSVTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        public JSVSpecNode specNode;

        public JSVTreeNode(String text, JSVSpecNode specNode) {
            super(text);
            this.specNode = specNode;
        }
    }

    private class SpectraTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JSVTreeNode node;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.node = (JSVTreeNode)value;
            return this;
        }

        public Font getFont() {
            return new Font("Dialog", this.node == null || this.node.specNode == null || this.node.specNode.frame == null || this.node.specNode.frame.isVisible() ? 1 : 2, 12);
        }
    }
}

