/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmilesAromatic {
    public static final boolean isFlatSp2Ring(JmolNode[] jmolNodeArray, BitSet bitSet, BitSet bitSet2, float f) {
        Object object;
        Object object2;
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            object2 = jmolNodeArray[n];
            object = object2.getEdges();
            if (((JmolEdge[])object).length >= 3 && ((JmolEdge[])object).length > 3) {
                return false;
            }
            n = bitSet2.nextSetBit(n + 1);
        }
        if (f == Float.MAX_VALUE) {
            return true;
        }
        if (f <= 0.0f) {
            f = 0.01f;
        }
        Vector3f vector3f = new Vector3f();
        object2 = new Vector3f();
        object = new Vector3f();
        Vector3f vector3f2 = null;
        int n2 = bitSet2.cardinality();
        Vector3f[] vector3fArray = new Vector3f[n2 * 2];
        int n3 = 0;
        float f2 = 1.0f - f * 5.0f;
        int n4 = bitSet2.nextSetBit(0);
        while (n4 >= 0) {
            JmolNode jmolNode = jmolNodeArray[n4];
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = jmolEdgeArray.length;
            while (--n8 >= 0) {
                int n9 = jmolNode.getBondedAtomIndex(n8);
                if (!bitSet.get(n9)) continue;
                if (!bitSet2.get(n9)) {
                    n5 = n9;
                    continue;
                }
                if (n6 < 0) {
                    n6 = n9;
                    continue;
                }
                n7 = n9;
            }
            SmilesAromatic.getNormalThroughPoints(jmolNodeArray[n6], jmolNodeArray[n4], jmolNodeArray[n7], vector3f, (Vector3f)object2, (Vector3f)object);
            if (vector3f2 == null) {
                vector3f2 = new Vector3f();
            }
            if (!SmilesAromatic.addNormal(vector3f, vector3f2, f2)) {
                return false;
            }
            vector3fArray[n3++] = new Vector3f(vector3f);
            if (n5 >= 0) {
                SmilesAromatic.getNormalThroughPoints(jmolNodeArray[n6], jmolNodeArray[n5], jmolNodeArray[n7], vector3f, (Vector3f)object2, (Vector3f)object);
                if (!SmilesAromatic.addNormal(vector3f, vector3f2, f2)) {
                    return false;
                }
                vector3fArray[n3++] = new Vector3f(vector3f);
            }
            n4 = bitSet2.nextSetBit(n4 + 1);
        }
        n4 = SmilesAromatic.checkStandardDeviation(vector3fArray, vector3f2, n3, f) ? 1 : 0;
        return n4 != 0;
    }

    private static final boolean addNormal(Vector3f vector3f, Vector3f vector3f2, float f) {
        float f2 = vector3f2.dot(vector3f);
        if (f2 != 0.0f && Math.abs(f2) < f) {
            return false;
        }
        if (f2 < 0.0f) {
            vector3f.scale(-1.0f);
        }
        vector3f2.add(vector3f);
        vector3f2.normalize();
        return true;
    }

    private static final boolean checkStandardDeviation(Vector3f[] vector3fArray, Vector3f vector3f, int n, float f) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            float f2 = vector3fArray[i].dot(vector3f);
            d += (double)f2;
            d2 += (double)f2 * (double)f2;
        }
        return (d = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1))) < (double)f;
    }

    static float getNormalThroughPoints(JmolNode jmolNode, JmolNode jmolNode2, JmolNode jmolNode3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f2.sub((Point3f)((Object)jmolNode2), (Point3f)((Object)jmolNode));
        vector3f3.sub((Point3f)((Object)jmolNode3), (Point3f)((Object)jmolNode));
        vector3f.cross(vector3f2, vector3f3);
        vector3f.normalize();
        vector3f2.set((Point3f)((Object)jmolNode));
        return -vector3f2.dot(vector3f);
    }

    static BitSet checkAromaticDefined(JmolNode[] jmolNodeArray, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            JmolEdge[] jmolEdgeArray = jmolNodeArray[n].getEdges();
            for (int i = 0; i < jmolEdgeArray.length; ++i) {
                switch (jmolEdgeArray[i].order) {
                    case 513: 
                    case 514: 
                    case 515: {
                        bitSet2.set(jmolEdgeArray[i].getAtomIndex1());
                        bitSet2.set(jmolEdgeArray[i].getAtomIndex2());
                    }
                }
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2;
    }

    static void checkAromaticStrict(JmolNode[] jmolNodeArray, BitSet bitSet, List<Object> list, List<Object> list2) {
        BitSet bitSet2;
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        int n = list.size();
        while (--n >= 0) {
            bitSet2 = (BitSet)list.get(n);
            if (!SmilesAromatic.isAromaticRing(bitSet, bitSet4, bitSet2, 5)) continue;
            SmilesAromatic.checkAromaticStrict(jmolNodeArray, bitSet3, list, list2, bitSet2, true);
        }
        n = list2.size();
        while (--n >= 0) {
            bitSet2 = (BitSet)list2.get(n);
            if (!SmilesAromatic.isAromaticRing(bitSet, bitSet4, bitSet2, 6)) continue;
            SmilesAromatic.checkAromaticStrict(jmolNodeArray, bitSet3, list, list2, bitSet2, false);
        }
        bitSet.clear();
        bitSet.or(bitSet3);
    }

    private static boolean isAromaticRing(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, int n) {
        bitSet2.clear();
        bitSet2.or(bitSet3);
        bitSet2.and(bitSet);
        return bitSet2.cardinality() == n;
    }

    private static void checkAromaticStrict(JmolNode[] jmolNodeArray, BitSet bitSet, List<Object> list, List<Object> list2, BitSet bitSet2, boolean bl) {
        int n = SmilesAromatic.countInternalPairs(jmolNodeArray, bitSet2, bl) << 1;
        switch (n) {
            case -3: {
                break;
            }
            default: {
                int n2 = bitSet2.nextSetBit(0);
                while (n2 >= 0) {
                    JmolEdge[] jmolEdgeArray = jmolNodeArray[n2].getEdges();
                    for (int i = 0; i < jmolEdgeArray.length; ++i) {
                        BitSet bitSet3;
                        int n3;
                        if (jmolEdgeArray[i].order != 2 || bitSet2.get(n3 = jmolEdgeArray[i].getOtherAtom(jmolNodeArray[n2]).getIndex())) continue;
                        boolean bl2 = false;
                        int n4 = list.size();
                        while (--n4 >= 0 && !bl2) {
                            bitSet3 = (BitSet)list.get(n4);
                            if (!bitSet3.get(n3) || !bitSet.get(n3) && Math.abs(SmilesAromatic.countInternalPairs(jmolNodeArray, bitSet3, true)) != 3) continue;
                            bl2 = true;
                        }
                        n4 = list2.size();
                        while (--n4 >= 0 && !bl2) {
                            bitSet3 = (BitSet)list2.get(n4);
                            if (!bitSet3.get(n3) || !bitSet.get(n3) && Math.abs(SmilesAromatic.countInternalPairs(jmolNodeArray, bitSet3, false)) != 3) continue;
                            bl2 = true;
                        }
                        if (!bl2) {
                            return;
                        }
                        ++n;
                    }
                    n2 = bitSet2.nextSetBit(n2 + 1);
                }
                break block0;
            }
        }
        if (n == 6) {
            bitSet.or(bitSet2);
        }
    }

    private static int countInternalPairs(JmolNode[] jmolNodeArray, BitSet bitSet, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            JmolNode jmolNode = jmolNodeArray[n4];
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            boolean bl2 = false;
            block8: for (int i = 0; i < jmolEdgeArray.length; ++i) {
                int n5 = jmolEdgeArray[i].getOtherAtom(jmolNode).getIndex();
                if (!bitSet.get(n5)) continue;
                switch (jmolEdgeArray[i].order) {
                    case 513: 
                    case 514: 
                    case 515: {
                        ++n2;
                        continue block8;
                    }
                    case 2: {
                        ++n;
                        bl2 = true;
                    }
                }
            }
            if (bl && n2 == 0) {
                switch (jmolNode.getElementNumber()) {
                    case 7: 
                    case 8: 
                    case 16: {
                        if (bl2) break;
                        ++n3;
                    }
                }
            }
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        return n2 == 0 ? n / 2 + n3 : (n2 == (bl ? 5 : 6) ? -3 : 0);
    }
}

