/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumHBondType;
import org.jmol.constant.EnumVdw;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.modelset.Atom;
import org.jmol.script.Token;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.ContactPair;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contact
extends Isosurface {
    protected Atom[] atoms;
    private int atomCount;
    private float minData;
    private float maxData;
    private static final RadiusData rdVDW = new RadiusData(1.0f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
    private Vector3f vZ = new Vector3f();
    private Vector3f vY = new Vector3f();
    private Vector3f vX = new Vector3f();
    private Point3f pt1 = new Point3f();
    private Point3f pt2 = new Point3f();

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "contact";
    }

    @Override
    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("set" == string) {
            this.setContacts((Object[])object, !this.viewer.getTestFlag(4));
            return;
        }
        if ("init" == string) {
            this.translucentLevel = 0.0f;
        }
        super.setProperty(string, object, bitSet);
    }

    private void setContacts(Object[] objectArray, boolean bl) {
        Object object;
        Object object2;
        float f;
        Logger.startTimer();
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        boolean bl2 = (Boolean)objectArray[2];
        boolean bl3 = (Boolean)objectArray[3];
        BitSet bitSet = (BitSet)objectArray[4];
        BitSet bitSet2 = (BitSet)objectArray[5];
        RadiusData radiusData = (RadiusData)objectArray[6];
        float f2 = ((Float)objectArray[7]).floatValue();
        float[] fArray = (float[])objectArray[8];
        String string = (String)objectArray[9];
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (radiusData == null) {
            radiusData = new RadiusData(f2, RadiusData.EnumType.OFFSET, EnumVdw.AUTO);
        }
        if (bl2) {
            switch (n2) {
                case 135266319: 
                case 1073741961: 
                case 1276117510: {
                    n2 = 1276117510;
                    break;
                }
                case 4106: 
                case 3145756: 
                case 0x400000D4: 
                case 1073742136: {
                    break;
                }
                case 1074790450: {
                    bl2 = false;
                }
            }
        }
        this.atomCount = this.viewer.getAtomCount();
        this.atoms = this.viewer.getModelSet().atoms;
        int n3 = (int)(fArray == null || fArray.length < 2 ? 0.0f : fArray[1]);
        float f3 = f = bl2 && fArray != null && fArray[0] < 0.0f ? Math.abs(fArray[0]) : 0.15f;
        if (Logger.debugging) {
            Logger.info("Contact intramolecularMode " + n3);
            Logger.info("Contacts for " + bitSet.cardinality() + ": " + Escape.escape(bitSet));
            Logger.info("Contacts to " + bitSet2.cardinality() + ": " + Escape.escape(bitSet2));
        }
        super.setProperty("newObject", null, null);
        this.thisMesh.setMerged(true);
        this.thisMesh.nSets = 0;
        this.thisMesh.info = null;
        Parameters parameters = this.sg.getParams();
        String string2 = null;
        switch (n2) {
            case 1073741961: {
                string2 = "(a>b?a:b)";
                break;
            }
            case 135266319: 
            case 1074790450: {
                string2 = "a-b";
                break;
            }
            case 4106: {
                string2 = "a+b";
            }
        }
        switch (n2) {
            case 0x400000D4: {
                bl3 = false;
                BitSet bitSet3 = BitSetUtil.copy(bitSet);
                bitSet3.or(bitSet2);
                if (fArray[0] < 0.0f) {
                    fArray[0] = 0.0f;
                }
                parameters.colorDensity = bl2;
                parameters.bsSelected = bitSet3;
                parameters.bsSolvent = bitSet2;
                this.sg.setParameter("parameters", fArray);
                super.setProperty("nci", Boolean.TRUE, null);
                break;
            }
            case 3145756: 
            case 1073742136: {
                bl3 = false;
                this.thisMesh.nSets = 1;
                this.newSurface(3145756, null, bitSet, bitSet2, radiusData, null, null, bl2, null, f2);
                break;
            }
            case 1074790450: {
                bl3 = false;
                this.thisMesh.nSets = 1;
                this.newSurface(554176565, null, bitSet, bitSet2, radiusData, null, null, false, null, 0.0f);
                VolumeData volumeData = this.sg.getVolumeData();
                this.sg.initState();
                this.newSurface(135266319, null, bitSet, bitSet2, radiusData, fArray, string2, bl2, volumeData, 0.0f);
                this.mergeMesh(null);
                break;
            }
            case 1073741961: 
            case 1276117510: {
                bl3 = false;
                this.newSurface(1276117510, null, bitSet, bitSet2, radiusData, null, null, bl2, null, 0.0f);
                if (n2 == 1073741961) {
                    this.sg.initState();
                    this.newSurface(1276117510, null, bitSet2, bitSet, radiusData, fArray, string2, bl2, null, 0.0f);
                    this.mergeMesh(null);
                    break;
                }
                object2 = new MeshData();
                this.fillMeshData((MeshData)object2, 1, null);
                ((MeshData)object2).getSurfaceSet();
                this.fillMeshData((MeshData)object2, 3, null);
                break;
            }
            case 4106: 
            case 135266319: {
                float f4 = 0.0f;
                object = this.getPairs(bitSet, bitSet2, radiusData, n3, bl);
                this.thisMesh.info = object;
                this.thisMesh.calculatedVolume = Float.valueOf(f4 += this.combineSurfaces((List<ContactPair>)object, n, n2, fArray, string2, bl2, bl3));
                this.mergeMesh(null);
            }
        }
        this.thisMesh.setMerged(false);
        this.thisMesh.jvxlData.vertexDataOnly = true;
        this.thisMesh.reinitializeLightingAndColor();
        if (n != 0x400000D4) {
            this.thisMesh.bsVdw = new BitSet();
            this.thisMesh.bsVdw.or(bitSet);
            this.thisMesh.bsVdw.or(bitSet2);
        }
        super.setProperty("finalize", string, null);
        if (bl2) {
            super.setProperty("pointSize", Float.valueOf(f), null);
        } else {
            super.setProperty("token", 1073741964, null);
        }
        if (this.thisMesh.slabOptions != null) {
            this.thisMesh.slabOptions = null;
            this.thisMesh.polygonCount0 = -1;
        }
        this.discardTempData(true);
        object2 = null;
        switch (n) {
            case 1612189718: {
                object2 = "lightgreen";
                break;
            }
            case 1073741881: {
                object2 = "yellow";
                break;
            }
            case 3145756: {
                object2 = "skyblue";
            }
        }
        object = null;
        if (bl3) {
            object = this.viewer.getColorEncoder("rwb");
            ((ColorEncoder)object).setRange(-0.5f, 0.5f, false);
        } else if (object2 != null) {
            super.setProperty("color", ColorUtil.getArgbFromString((String)object2), null);
        } else if (n2 == 0x400000D4) {
            object = this.viewer.getColorEncoder("bgr");
            ((ColorEncoder)object).setRange(-0.03f, 0.03f, false);
        } else {
            object = this.viewer.getColorEncoder("rgb");
            if (bl2) {
                ((ColorEncoder)object).setRange(-0.3f, 0.3f, false);
            } else {
                ((ColorEncoder)object).setRange(-0.5f, 1.0f, false);
            }
        }
        if (object != null) {
            this.thisMesh.remapColors((ColorEncoder)object, this.translucentLevel);
        }
        Logger.checkTimer("contact");
    }

    private float combineSurfaces(List<ContactPair> list, int n, int n2, float[] fArray, Object object, boolean bl, boolean bl2) {
        VolumeData volumeData = new VolumeData();
        int n3 = Logger.getLogLevel();
        Logger.setLogLevel(0);
        float f = this.sg.getParams().resolution;
        int n4 = list.size();
        double d = 0.0;
        if (n2 == 1073741961 && f == Float.MAX_VALUE) {
            f = n4 > 1000 ? 3 : 10;
        }
        int n5 = n4;
        while (--n5 >= 0) {
            boolean bl3;
            ContactPair contactPair = list.get(n5);
            float f2 = contactPair.score;
            boolean bl4 = bl3 = n2 == 135266319 && (n == 1649412112 || n == 0) && contactPair.setForVdwClash(true);
            if (bl3) {
                contactPair.score = 0.0f;
            }
            if (n != 0 && contactPair.contactType != n) continue;
            int n6 = this.thisMesh.vertexCount;
            ++this.thisMesh.nSets;
            if (n != 0 || contactPair.contactType != 1649412112) {
                d += contactPair.volume;
            }
            this.setVolumeData(n2, volumeData, contactPair, f, n4);
            switch (n2) {
                case 1073741961: {
                    this.newSurface(n2, contactPair, null, null, null, null, object, bl, volumeData, 0.0f);
                    contactPair.switchAtoms();
                    this.newSurface(n2, contactPair, null, null, null, null, null, bl, volumeData, 0.0f);
                    break;
                }
                case 4106: 
                case 135266319: 
                case 1276117510: {
                    this.newSurface(n2, contactPair, null, null, null, fArray, object, bl, volumeData, 0.0f);
                    if (!bl3 || !contactPair.setForVdwClash(false)) break;
                    if (bl2) {
                        n6 = this.setColorByScore(contactPair.score, n6);
                    }
                    contactPair.score = f2;
                    d += contactPair.volume;
                    this.newSurface(n2, contactPair, null, null, null, fArray, object, bl, volumeData, 0.0f);
                }
            }
            if (n5 > 0 && n5 % 1000 == 0 && n3 == 4) {
                Logger.setLogLevel(4);
                Logger.info("contact..." + n5);
                Logger.setLogLevel(0);
            }
            if (!bl2) continue;
            this.setColorByScore(contactPair.contactType == 1612189718 ? 4.0f : contactPair.score, n6);
        }
        Logger.setLogLevel(n3);
        return (float)d;
    }

    private int setColorByScore(float f, int n) {
        int n2 = this.thisMesh.vertexCount;
        while (--n2 >= n) {
            this.thisMesh.vertexValues[n2] = f;
        }
        return this.thisMesh.vertexCount;
    }

    private List<ContactPair> getPairs(BitSet bitSet, BitSet bitSet2, RadiusData radiusData, int n, boolean bl) {
        int n2;
        Serializable serializable;
        ArrayList<ContactPair> arrayList = new ArrayList<ContactPair>();
        AtomData atomData = new AtomData();
        atomData.radiusData = radiusData;
        BitSet bitSet3 = BitSetUtil.copy(bitSet);
        bitSet3.or(bitSet2);
        if (bitSet3.isEmpty()) {
            return arrayList;
        }
        atomData.bsSelected = bitSet3;
        boolean bl2 = this.atoms[bitSet3.nextSetBit((int)0)].modelIndex != this.atoms[bitSet3.length() - 1].modelIndex;
        boolean bl3 = bitSet.equals(bitSet2);
        this.viewer.fillAtomData(atomData, 2 | (bl2 ? 16 : 0) | 4);
        float f = 0.0f;
        int n3 = bitSet2.nextSetBit(0);
        while (n3 >= 0) {
            if (atomData.atomRadius[n3] > f) {
                f = atomData.atomRadius[n3];
            }
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
        AtomIndexIterator atomIndexIterator = this.viewer.getSelectedAtomIterator(bitSet2, bl3, false, bl2);
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            serializable = this.atoms[n4];
            float f2 = ((Atom)serializable).getVanderwaalsRadiusFloat(this.viewer, EnumVdw.AUTO);
            if (bl2) {
                this.viewer.setIteratorForPoint(atomIndexIterator, -1, atomData.atomXyz[n4], atomData.atomRadius[n4] + f);
            } else {
                this.viewer.setIteratorForAtom(atomIndexIterator, n4, atomData.atomRadius[n4] + f);
            }
            block10: while (atomIndexIterator.hasNext()) {
                float f3;
                EnumHBondType enumHBondType;
                boolean bl4;
                int n5 = atomIndexIterator.next();
                if (bl2 && !bitSet2.get(n5)) continue;
                Atom atom = this.atoms[n5];
                boolean bl5 = bl4 = atomData.atomMolecule[n4] == atomData.atomMolecule[n5];
                if (n4 == n5 || bl4 && ((Atom)serializable).isWithinFourBonds(atom)) continue;
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (bl4 == (n == 1)) break;
                        continue block10;
                    }
                }
                float f4 = atom.getVanderwaalsRadiusFloat(this.viewer, EnumVdw.AUTO);
                float f5 = atomData.atomRadius[n4];
                float f6 = atomData.atomRadius[n5];
                float f7 = ((Point3f)serializable).distance(atom);
                if (f7 > f5 + f6) continue;
                ContactPair contactPair = new ContactPair(this.atoms, n4, n5, f5, f6, f2, f4);
                if (contactPair.score < 0.0f) {
                    Contact.getVdwClashRadius(contactPair, f5 - f2, f2, f4, f7);
                }
                EnumHBondType enumHBondType2 = (enumHBondType = EnumHBondType.getType((Atom)serializable)) == EnumHBondType.NOT ? EnumHBondType.NOT : EnumHBondType.getType(atom);
                boolean bl6 = EnumHBondType.isPossibleHBond(enumHBondType, enumHBondType2);
                float f8 = f3 = ((Atom)serializable).getElementNumber() == 1 || atom.getElementNumber() == 1 ? -1.2f : -1.0f;
                if (bl6 && contactPair.score < f3) {
                    bl6 = false;
                }
                if (bl6 && contactPair.score < 0.0f) {
                    contactPair.contactType = 1612189718;
                }
                arrayList.add(contactPair);
            }
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        atomIndexIterator = null;
        if (!bl) {
            return arrayList;
        }
        n4 = arrayList.size() - 1;
        serializable = new BitSet();
        for (n2 = 0; n2 < n4; ++n2) {
            ContactPair contactPair = (ContactPair)arrayList.get(n2);
            for (int i = n2 + 1; i <= n4; ++i) {
                ContactPair contactPair2 = (ContactPair)arrayList.get(i);
                for (int j = 0; j < 2; ++j) {
                    block14: for (int k = 0; k < 2; ++k) {
                        switch (Contact.checkCp(contactPair, contactPair2, j, k)) {
                            case 1: {
                                ((BitSet)serializable).set(n2);
                                continue block14;
                            }
                            case 2: {
                                ((BitSet)serializable).set(i);
                                continue block14;
                            }
                        }
                    }
                }
            }
        }
        n2 = ((BitSet)serializable).length();
        while (--n2 >= 0) {
            if (!((BitSet)serializable).get(n2)) continue;
            arrayList.remove(n2);
        }
        if (Logger.debugging) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                Logger.info(((ContactPair)arrayList.get(n2)).toString());
            }
        }
        Logger.info("Contact pairs: " + arrayList.size());
        return arrayList;
    }

    private static int checkCp(ContactPair contactPair, ContactPair contactPair2, int n, int n2) {
        boolean bl;
        if (contactPair.myAtoms[n] != contactPair2.myAtoms[n2]) {
            return 0;
        }
        boolean bl2 = contactPair.pt.distance(contactPair2.myAtoms[1 - n2]) < contactPair2.radii[1 - n2];
        boolean bl3 = bl = contactPair2.pt.distance(contactPair.myAtoms[1 - n]) < contactPair.radii[1 - n];
        return !bl2 && !bl ? 0 : (contactPair.score > contactPair2.score ? 1 : 2);
    }

    private void newSurface(int n, ContactPair contactPair, BitSet bitSet, BitSet bitSet2, RadiusData radiusData, float[] fArray, Object object, boolean bl, VolumeData volumeData, float f) {
        Parameters parameters = this.sg.getParams();
        parameters.isSilent = true;
        if (contactPair == null) {
            bitSet2.andNot(bitSet);
            if (bitSet.isEmpty() || bitSet2.isEmpty()) {
                return;
            }
        } else {
            parameters.contactPair = contactPair;
        }
        int n2 = 0;
        int n3 = 0;
        this.sg.initState();
        switch (n) {
            case 3145756: 
            case 554176565: 
            case 1073741961: 
            case 1073742136: 
            case 1276117510: {
                RadiusData radiusData2;
                RadiusData radiusData3;
                if (n == 3145756) {
                    radiusData3 = rdVDW;
                    radiusData2 = new RadiusData(radiusData.factorType == RadiusData.EnumType.OFFSET ? radiusData.value * 2.0f : (radiusData.value - 1.0f) * 2.0f + 1.0f, radiusData.factorType, radiusData.vdwType);
                } else {
                    radiusData3 = radiusData2 = radiusData;
                }
                parameters.colorDensity = bl;
                if (bl) {
                    super.setProperty("cutoffRange", new float[]{-100.0f, 0.0f}, null);
                }
                if (contactPair == null) {
                    parameters.atomRadiusData = radiusData3;
                    parameters.bsIgnore = BitSetUtil.copyInvert(bitSet, this.atomCount);
                    parameters.bsSelected = bitSet;
                    parameters.bsSolvent = null;
                }
                parameters.volumeData = volumeData;
                super.setProperty("sasurface", Float.valueOf(f), null);
                super.setProperty("map", Boolean.TRUE, null);
                if (contactPair == null) {
                    parameters.atomRadiusData = radiusData2;
                    parameters.bsIgnore = BitSetUtil.copyInvert(bitSet2, this.atomCount);
                    parameters.bsSelected = bitSet2;
                }
                parameters.volumeData = volumeData;
                super.setProperty("sasurface", Float.valueOf(f), null);
                switch (n) {
                    case 1073741961: 
                    case 1276117510: {
                        n2 = -100;
                        break;
                    }
                    case 3145756: 
                    case 1073742136: {
                        if (!bl) break;
                        n2 = -100;
                        break;
                    }
                    case 554176565: {
                        n3 = -100;
                    }
                }
                break;
            }
            case 4106: 
            case 135266319: {
                if (n == 4106) {
                    this.sg.setParameter("parameters", fArray);
                }
                if (contactPair == null) {
                    parameters.atomRadiusData = radiusData;
                    parameters.bsIgnore = BitSetUtil.copyInvert(bitSet2, this.atomCount);
                    parameters.bsIgnore.andNot(bitSet);
                }
                parameters.func = object;
                parameters.intersection = new BitSet[]{bitSet, bitSet2};
                parameters.volumeData = volumeData;
                parameters.colorDensity = bl;
                if (bl) {
                    super.setProperty("cutoffRange", new float[]{-5.0f, 0.0f}, null);
                }
                super.setProperty("sasurface", Float.valueOf(0.0f), null);
                super.setProperty("map", Boolean.TRUE, null);
                parameters.volumeData = volumeData;
                super.setProperty("sasurface", Float.valueOf(0.0f), null);
                if (n == 4106) break;
                n2 = -100;
            }
        }
        if (n2 != n3) {
            this.thisMesh.slabPolygons(MeshSurface.getSlabWithinRange(n2, n3), false);
        }
        if (n != 3145756) {
            this.thisMesh.setMerged(true);
        }
    }

    private void setVolumeData(int n, VolumeData volumeData, ContactPair contactPair, float f, int n2) {
        int n3;
        int n4;
        this.pt1.set(contactPair.myAtoms[0]);
        this.pt2.set(contactPair.myAtoms[1]);
        this.vX.sub(this.pt2, this.pt1);
        float f2 = this.vX.length();
        float f3 = (contactPair.radii[0] * contactPair.radii[0] + f2 * f2 - contactPair.radii[1] * contactPair.radii[1]) / (2.0f * f2 * contactPair.radii[0]);
        f3 = 2.1f * (float)((double)contactPair.radii[0] * Math.sin(Math.acos(f3)));
        Measure.getNormalToLine(this.pt1, this.pt2, this.vZ);
        this.vZ.scale(f3);
        this.vY.cross(this.vZ, this.vX);
        this.vY.normalize();
        this.vY.scale(f3);
        if (n != 4106) {
            this.vX.normalize();
            this.pt1.scaleAdd((f2 - contactPair.radii[1]) * 0.95f, this.vX, this.pt1);
            this.pt2.scaleAdd((contactPair.radii[0] - f2) * 0.95f, this.vX, this.pt2);
            this.vX.sub(this.pt2, this.pt1);
        }
        if (f == Float.MAX_VALUE) {
            f = n2 > 100 ? 3 : 10;
        }
        if ((n4 = Math.max(5, (int)(this.pt1.distance(this.pt2) * f + 1.0f))) % 2 == 0) {
            ++n4;
        }
        if ((n3 = Math.max(7, (int)(f3 * f + 1.0f))) % 2 == 0) {
            ++n3;
        }
        volumeData.setVoxelCounts(n4, n3, n3);
        this.pt1.scaleAdd(-0.5f, this.vY, this.pt1);
        this.pt1.scaleAdd(-0.5f, this.vZ, this.pt1);
        volumeData.setVolumetricOrigin(this.pt1.x, this.pt1.y, this.pt1.z);
        this.vX.scale(1.0f / (float)(n4 - 1));
        this.vY.scale(1.0f / (float)(n3 - 1));
        this.vZ.scale(1.0f / (float)(n3 - 1));
        volumeData.setVolumetricVector(0, this.vX.x, this.vX.y, this.vX.z);
        volumeData.setVolumetricVector(1, this.vY.x, this.vY.y, this.vY.z);
        volumeData.setVolumetricVector(2, this.vZ.x, this.vZ.y, this.vZ.z);
    }

    private void mergeMesh(MeshData meshData) {
        this.thisMesh.merge(meshData);
        if (this.minData != Float.MAX_VALUE) {
            if (this.jvxlData.mappedDataMin == Float.MAX_VALUE) {
                this.jvxlData.mappedDataMin = this.minData;
                this.jvxlData.mappedDataMax = this.maxData;
            } else {
                this.jvxlData.mappedDataMin = Math.min(this.minData, this.jvxlData.mappedDataMin);
                this.jvxlData.mappedDataMax = Math.max(this.maxData, this.jvxlData.mappedDataMax);
            }
        }
        this.minData = this.jvxlData.mappedDataMin;
        this.maxData = this.jvxlData.mappedDataMax;
        this.jvxlData.valueMappedToBlue = this.minData;
        this.jvxlData.valueMappedToRed = this.maxData;
    }

    @Override
    protected void addMeshInfo(IsosurfaceMesh isosurfaceMesh, Map<String, Object> map) {
        if (isosurfaceMesh.info == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        map.put("pairInfo", arrayList);
        List list = (List)isosurfaceMesh.info;
        for (int i = 0; i < list.size(); ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            arrayList.add(hashtable);
            ContactPair contactPair = (ContactPair)list.get(i);
            hashtable.put("type", Token.nameOf(contactPair.contactType));
            hashtable.put("volume", contactPair.volume);
            hashtable.put("vdwVolume", contactPair.vdwVolume);
            if (!Float.isNaN(contactPair.xVdwClash)) {
                hashtable.put("xVdwClash", Double.valueOf(contactPair.xVdwClash));
            }
            hashtable.put("score", Double.valueOf(contactPair.score));
            hashtable.put("atoms", contactPair.myAtoms);
            hashtable.put("radii", contactPair.radii);
            hashtable.put("vdws", contactPair.vdws);
        }
    }

    private static void getVdwClashRadius(ContactPair contactPair, double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d2 + d3;
        double d7 = d2 - d3;
        d7 *= d7;
        double d8 = d * d * (d6 + 1.3333333333333333 * d - d7 / d6);
        contactPair.vdwVolume = contactPair.volume - d8 * Math.PI;
        double d9 = d6 - d4;
        double d10 = d4 + 2.0 * d6 - 3.0 * d7 / d4;
        double d11 = d8 * 12.0;
        double d12 = d9 * d9;
        double d13 = d9 * d12;
        double d14 = d10 * d10;
        double d15 = d10 * d14;
        double d16 = -d9 * 2.0 / 3.0 - d10 / 6.0;
        double d17 = (4.0 * d12 - 4.0 * d9 * d10 + d14) / 36.0;
        double d18 = d13 / 27.0 - d12 * d10 / 18.0 + d9 * d14 / 36.0 - d15 / 216.0 + d11 / 4.0;
        double d19 = -d11 / 432.0 * (8.0 * d13 - 12.0 * d12 * d10 + 6.0 * d9 * d14 - d15 + 27.0 * d11);
        double d20 = Math.atan2(Math.sqrt(d19), d18);
        double d21 = Math.pow(d18 * d18 + d19, 0.16666666666666666);
        double d22 = d16 + (d17 / d21 + d21) * (d5 = Math.cos(d20 / 3.0));
        if (d22 > 0.0) {
            contactPair.xVdwClash = (float)(d22 / 2.0);
        }
    }
}

