/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.common.Event;
import com.sparshui.common.messages.events.TouchEvent;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.TouchPoint;
import java.util.ArrayList;
import java.util.List;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePointGesture
implements Gesture {
    private static final long MAXIMUM_CLICK_TIME = 200L;
    private int _nCurrent;
    private int _nMoves;
    private int _myId;
    private TouchPoint _birth;

    public String getName() {
        return "SinglePointGesture";
    }

    public int getGestureType() {
        return 4;
    }

    public List<Event> processChange(List<TouchPoint> list, TouchPoint touchPoint) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        int n = list.size();
        if (Logger.debugging) {
            Logger.info("\nSinglePointGesture " + this._myId + " nPoints: " + n);
        }
        if (n > 1) {
            if (this._myId != Integer.MAX_VALUE) {
                this._myId = Integer.MAX_VALUE;
                this._nMoves = 1000;
                this._nCurrent = 0;
                arrayList.add((Event)new TouchEvent());
            }
            return arrayList;
        }
        int n2 = touchPoint.getID();
        if (Logger.debugging) {
            Logger.info("\nSinglePointGesture id=" + n2 + " state=" + touchPoint.getState() + " ncurrent=" + this._nCurrent + " nMoves=" + this._nMoves);
        }
        switch (touchPoint.getState()) {
            case 0: {
                this._myId = n2;
                this._birth = new TouchPoint(touchPoint);
                this._nCurrent = 1;
                this._nMoves = 0;
                break;
            }
            case 2: {
                if (n2 != this._myId) {
                    return arrayList;
                }
                switch (++this._nMoves) {
                    case 2: {
                        if (!this.checkClick(touchPoint, arrayList, false)) break;
                        return arrayList;
                    }
                }
                break;
            }
            case 1: {
                if (n2 != this._myId) {
                    return arrayList;
                }
                this._nCurrent = 0;
                if (this._nMoves >= 2 || !this.checkClick(touchPoint, arrayList, true)) break;
                return arrayList;
            }
        }
        arrayList.add((Event)new TouchEvent(touchPoint));
        return arrayList;
    }

    private boolean checkClick(TouchPoint touchPoint, List<Event> list, boolean bl) {
        boolean bl2;
        long l = touchPoint.getTime() - this._birth.getTime();
        boolean bl3 = bl2 = bl && l < 200L;
        if (l < 500L && !bl2) {
            return false;
        }
        this._nMoves += 2;
        TouchPoint touchPoint2 = new TouchPoint(this._birth);
        touchPoint2.setState(1);
        list.add((Event)new TouchEvent(touchPoint2));
        touchPoint2.setState(3);
        list.add((Event)new TouchEvent(touchPoint2));
        if (bl2) {
            return true;
        }
        touchPoint2.setState(0);
        list.add((Event)new TouchEvent(touchPoint2));
        if (!bl) {
            return true;
        }
        touchPoint2.setState(1);
        list.add((Event)new TouchEvent(touchPoint2));
        touchPoint2.setState(3);
        list.add((Event)new TouchEvent(touchPoint2));
        return true;
    }
}

