/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch;

import com.sparshui.GestureType;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolTouchSimulatorInterface;
import org.jmol.multitouch.JmolMultiTouchAdapter;
import org.jmol.multitouch.JmolMultiTouchClient;
import org.jmol.util.Logger;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManagerMT
extends ActionManager
implements JmolMultiTouchClient {
    private JmolMultiTouchAdapter adapter;
    private JmolTouchSimulatorInterface simulator;
    private int groupID;
    private int simulationPhase;
    private boolean resetNeeded = true;
    private long lastLogTime = 0L;
    private boolean doneHere;
    public static final int DRAG_GESTURE = 0;
    public static final int MULTI_POINT_DRAG_GESTURE = 1;
    public static final int ROTATE_GESTURE = 2;
    public static final int SPIN_GESTURE = 3;
    public static final int TOUCH_GESTURE = 4;
    public static final int ZOOM_GESTURE = 5;
    public static final int DBLCLK_GESTURE = 6;
    public static final int FLICK_GESTURE = 7;
    public static final int RELATIVE_DRAG_GESTURE = 8;
    public static final int INVALID_GESTURE = 9;
    private static final GestureType TWO_POINT_GESTURE = new GestureType("org.jmol.multitouch.sparshui.TwoPointGesture");
    private static final GestureType SINGLE_POINT_GESTURE = new GestureType("org.jmol.multitouch.sparshui.SinglePointGesture");
    public static final int DRIVER_NONE = -2;
    public static final int SERVICE_LOST = -1;
    public static final int DRAG_EVENT = 0;
    public static final int ROTATE_EVENT = 1;
    public static final int SPIN_EVENT = 2;
    public static final int TOUCH_EVENT = 3;
    public static final int ZOOM_EVENT = 4;
    public static final int DBLCLK_EVENT = 5;
    public static final int FLICK_EVENT = 6;
    public static final int RELATIVE_DRAG_EVENT = 7;
    public static final int CLICK_EVENT = 8;
    private static final String[] eventNames = new String[]{"drag", "rotate", "spin", "touch", "zoom", "double-click", "flick", "relative-drag", "click"};
    public static final int BIRTH = 0;
    public static final int DEATH = 1;
    public static final int MOVE = 2;
    public static final int CLICK = 3;
    boolean mouseDown;

    @Override
    public void setViewer(Viewer viewer, String string) {
        boolean bl;
        super.setViewer(viewer, string);
        this.mouseWheelFactor = 1.02f;
        boolean bl2 = string.indexOf("-multitouch-sparshui") >= 0;
        boolean bl3 = string.indexOf("-multitouch-sparshui-simulated") >= 0;
        boolean bl4 = string.indexOf("-multitouch-jni") >= 0;
        boolean bl5 = string.indexOf("-multitouch-mp") >= 0;
        boolean bl6 = bl = string.indexOf("-multitouch-tab") >= 0;
        if (bl5 || bl) {
            this.haveMultiTouchInput = true;
            this.groupID = 0;
        } else {
            this.groupID = (int)(Math.random() * 1.6777215E7) << 4;
        }
        if (bl) {
            return;
        }
        String string2 = bl2 ? "multitouch.sparshui.JmolSparshClientAdapter" : "multitouch.jni.JmolJniClientAdapter";
        this.adapter = (JmolMultiTouchAdapter)Interface.getOptionInterface(string2);
        Logger.info("ActionManagerMT SparshUI groupID=" + this.groupID);
        Logger.info("ActionManagerMT adapter = " + this.adapter);
        if (bl2) {
            this.startSparshUIService(bl3);
        } else if (bl4) {
            this.adapter.setMultiTouchClient(viewer, this, false);
        }
        this.setBinding(this.binding);
        this.xyRange = 10;
    }

    private void startSparshUIService(boolean bl) {
        this.haveMultiTouchInput = false;
        if (this.adapter == null) {
            return;
        }
        if (this.simulator != null) {
            this.simulator.dispose();
            this.simulator = null;
        }
        if (bl) {
            Logger.error("ActionManagerMT -- for now just using touch simulation.\nPress CTRL-LEFT and then draw two traces on the window.");
        }
        this.isMultiTouchClient = this.adapter.setMultiTouchClient(this.viewer, this, bl);
        this.isMultiTouchServer = this.adapter.isServer();
        if (bl) {
            this.simulator = (JmolTouchSimulatorInterface)Interface.getInterface("com.sparshui.inputdevice.JmolTouchSimulator");
            if (this.simulator != null) {
                Logger.info("ActionManagerMT simulating SparshUI");
                this.simulator.startSimulator(this.viewer.getDisplay());
            }
        }
    }

    @Override
    protected void setBinding(Binding binding) {
        super.setBinding(binding);
        this.binding.unbindMouseAction(4);
        if (this.simulator != null && this.binding != null) {
            this.binding.unbindJmolAction(0);
            this.binding.unbind(274, null);
            this.binding.bind(274, 46);
        }
    }

    @Override
    public void clear() {
        this.simulationPhase = 0;
        this.resetNeeded = true;
        super.clear();
    }

    @Override
    public void dispose() {
        Logger.debug("ActionManagerMT -- dispose");
        this.doneHere = true;
        if (this.adapter != null) {
            this.adapter.dispose();
        }
        if (this.simulator != null) {
            this.simulator.dispose();
        }
        super.dispose();
    }

    private static String getEventName(int n) {
        try {
            return eventNames[n];
        }
        catch (Exception exception) {
            return "?";
        }
    }

    @Override
    public List<GestureType> getAllowedGestures(int n) {
        if (n != this.groupID || !this.viewer.allowMultiTouch()) {
            return null;
        }
        ArrayList<GestureType> arrayList = new ArrayList<GestureType>();
        arrayList.add(TWO_POINT_GESTURE);
        arrayList.add(SINGLE_POINT_GESTURE);
        return arrayList;
    }

    @Override
    public int getGroupID(int n, int n2) {
        int n3 = 0;
        try {
            if (this.viewer.hasFocus() && n >= 0 && n2 >= 0 && n < this.viewer.getScreenWidth() && n2 < this.viewer.getScreenHeight()) {
                n3 = this.groupID;
            }
            if (this.resetNeeded) {
                n3 |= 0x10000000;
                this.resetNeeded = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    @Override
    public void processEvent(int n, int n2, int n3, int n4, Point3f point3f, long l) {
        if (Logger.debugging) {
            Logger.info(this + " time=" + l + " groupID=" + n + " " + Integer.toHexString(n) + " eventType=" + n2 + "(" + ActionManagerMT.getEventName(n2) + ") iData=" + n4 + " pt=" + point3f);
        }
        switch (n2) {
            case 0: {
                if (n4 != 2) break;
                this.checkMotion(3);
                this.viewer.translateXYBy((int)point3f.x, (int)point3f.y);
                this.logEvent("Drag", point3f);
                break;
            }
            case -2: {
                if (this.simulator == null) {
                    this.haveMultiTouchInput = false;
                }
                Logger.error("SparshUI reports no driver present");
                this.viewer.log("SparshUI reports no driver present -- setting haveMultiTouchInput FALSE");
                break;
            }
            case 1: {
                this.checkMotion(3);
                this.viewer.rotateZBy((int)point3f.z, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.logEvent("Rotate", point3f);
                break;
            }
            case -1: {
                this.viewer.log("Jmol SparshUI client reports service lost -- " + (this.doneHere ? "not " : "") + " restarting");
                if (this.doneHere) break;
                this.startSparshUIService(this.simulator != null);
                break;
            }
            case 3: {
                this.haveMultiTouchInput = true;
                if (n3 == Integer.MAX_VALUE) {
                    this.mouseDown = false;
                    this.clearMouseInfo();
                    break;
                }
                switch (n4) {
                    case 0: {
                        this.mouseDown = true;
                        super.mouseAction(4, l, (int)point3f.x, (int)point3f.y, 0, 16);
                        break;
                    }
                    case 2: {
                        super.mouseAction(this.mouseDown ? 1 : 0, l, (int)point3f.x, (int)point3f.y, 0, 16);
                        break;
                    }
                    case 1: {
                        this.mouseDown = false;
                        super.mouseAction(5, l, (int)point3f.x, (int)point3f.y, 0, 16);
                        break;
                    }
                    case 3: {
                        super.mouseAction(2, l, (int)point3f.x, (int)point3f.y, 1, 16);
                    }
                }
                break;
            }
            case 4: {
                float f = point3f.z;
                if (f != -1.0f && f != 1.0f) break;
                this.zoomByFactor((int)f, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.logEvent("Zoom", point3f);
            }
        }
    }

    private void logEvent(String string, Point3f point3f) {
        if (!this.viewer.getLogGestures()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastLogTime > 10000L) {
            this.viewer.log("$NOW$ multitouch " + string + " pt= " + point3f);
            this.lastLogTime = l;
        }
    }

    @Override
    public void mouseAction(int n, long l, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                if (this.haveMultiTouchInput) {
                    return;
                }
                this.adapter.mouseMoved(n2, n3);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 1: {
                if (this.simulator == null || this.simulationPhase <= 0) break;
                this.setCurrent(l, n2, n3, n5);
                this.simulator.mouseDragged(l, n2, n3);
                return;
            }
            case 4: {
                if (this.simulator == null) break;
                int n6 = Binding.getMouseAction(1, n5);
                if (this.binding.isBound(n6, 46)) {
                    this.setCurrent(0L, n2, n3, n5);
                    this.viewer.setFocus();
                    if (this.simulationPhase++ == 0) {
                        this.simulator.startRecording();
                    }
                    this.simulator.mousePressed(l, n2, n3);
                    return;
                }
                this.simulationPhase = 0;
                break;
            }
            case 5: {
                if (this.simulator == null || this.simulationPhase <= 0) break;
                this.setCurrent(l, n2, n3, n5);
                this.viewer.spinXYBy(0, 0, 0.0f);
                this.simulator.mouseReleased(l, n2, n3);
                if (this.simulationPhase >= 2) {
                    this.resetNeeded = true;
                    this.simulator.endRecording();
                    this.simulationPhase = 0;
                }
                return;
            }
        }
        if (!this.haveMultiTouchInput) {
            super.mouseAction(n, l, n2, n3, n4, n5);
        }
    }

    @Override
    protected float getExitRate() {
        long l = this.dragGesture.getTimeDifference(2);
        System.out.println("ActionManMT getExitRate " + l + " " + 5L);
        return l > 40L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(2, 1);
    }

    @Override
    protected float getDegrees(int n, int n2) {
        int n3 = n2 == 0 ? this.viewer.getScreenWidth() : this.viewer.getScreenHeight();
        return (float)n / (float)n3 * 180.0f * this.mouseDragFactor;
    }
}

