/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Quadric;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelLoader {
    private Viewer viewer;
    private ModelSet modelSet;
    private ModelSet mergeModelSet;
    private boolean merging;
    private String jmolData;
    private String[] group3Lists;
    private int[][] group3Counts;
    private final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    private boolean someModelsHaveUnitcells;
    private boolean isTrajectory;
    private boolean doMinimize;
    private boolean doAddHydrogens;
    private boolean doRemoveAddedHydrogens;
    private String fileHeader;
    private JmolBioResolver jbr;
    private boolean isPDB;
    private Group[] groups;
    private int groupCount;
    private final Map<Object, Atom> htAtomMap = new Hashtable<Object, Atom>();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private char currentChainID;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode;
    private String currentGroup3;
    private Group nullGroup;
    private int baseModelIndex = 0;
    private int baseModelCount = 0;
    private int baseAtomIndex = 0;
    private int baseGroupIndex = 0;
    private int baseTrajectoryCount = 0;
    private boolean appendNew;
    private int adapterModelCount = 0;
    private int adapterTrajectoryCount = 0;
    private boolean noAutoBond;
    private boolean is2D;
    private Group[] mergeGroups;
    private List<Bond> vStereo;
    private BitSet structuresDefinedInFile = new BitSet();

    public ModelLoader(Viewer viewer, String string) {
        this.viewer = viewer;
        this.modelSet = new ModelSet(viewer, string);
        viewer.resetShapes(false);
        this.modelSet.preserveState = viewer.getPreserveState();
        this.initializeInfo(string, null);
        this.createModelSet(null, null, null);
        viewer.setStringProperty("_fileType", "");
    }

    public ModelLoader(Viewer viewer, StringBuffer stringBuffer, Object object, ModelSet modelSet, String string, BitSet bitSet) {
        this.viewer = viewer;
        this.modelSet = new ModelSet(viewer, string);
        this.mergeModelSet = modelSet;
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        boolean bl = this.merging = modelSet != null && modelSet.atomCount > 0;
        if (this.merging) {
            this.modelSet.canSkipLoad = false;
        } else {
            viewer.resetShapes(false);
        }
        this.modelSet.preserveState = viewer.getPreserveState();
        if (!this.modelSet.preserveState) {
            this.modelSet.canSkipLoad = false;
        }
        Map<String, Object> map = jmolAdapter.getAtomSetCollectionAuxiliaryInfo(object);
        map.put("loadScript", stringBuffer);
        this.initializeInfo(jmolAdapter.getFileTypeName(object).toLowerCase().intern(), map);
        this.createModelSet(jmolAdapter, object, bitSet);
    }

    private void initializeInfo(String string, Map<String, Object> map) {
        this.modelSet.g3d = this.viewer.getGraphics3D();
        this.modelSet.modelSetTypeName = string;
        this.modelSet.isXYZ = string == "xyz";
        this.modelSet.modelSetAuxiliaryInfo = map;
        this.modelSet.modelSetProperties = (Properties)this.modelSet.getModelSetAuxiliaryInfo("properties");
        this.isPDB = this.modelSet.isPDB = this.modelSet.getModelSetAuxiliaryInfoBoolean("isPDB");
        if (this.isPDB) {
            try {
                Class<?> clazz = Class.forName("org.jmol.modelsetbio.Resolver");
                this.jbr = (JmolBioResolver)clazz.newInstance();
                this.jbr.initialize(this.modelSet);
            }
            catch (Exception exception) {
                Logger.error("developer error: org.jmol.modelsetbio.Resolver could not be found");
            }
        }
        this.jmolData = (String)this.modelSet.getModelSetAuxiliaryInfo("jmolData");
        this.fileHeader = (String)this.modelSet.getModelSetAuxiliaryInfo("fileHeader");
        this.modelSet.trajectorySteps = (List)this.modelSet.getModelSetAuxiliaryInfo("trajectorySteps");
        this.modelSet.vibrationSteps = (List)this.modelSet.getModelSetAuxiliaryInfo("vibrationSteps");
        boolean bl = this.isTrajectory = this.modelSet.trajectorySteps != null;
        if (this.isTrajectory) {
            map.remove("trajectorySteps");
            map.remove("vibrationSteps");
        }
        boolean bl2 = this.doAddHydrogens = this.jbr != null && !this.isTrajectory && this.modelSet.getModelSetAuxiliaryInfo("pdbNoHydrogens") == null && this.viewer.getBooleanProperty("pdbAddHydrogens");
        if (map != null) {
            map.remove("pdbNoHydrogens");
        }
        this.noAutoBond = this.modelSet.getModelSetAuxiliaryInfoBoolean("noAutoBond");
        this.is2D = this.modelSet.getModelSetAuxiliaryInfoBoolean("is2D");
        this.doMinimize = this.is2D && this.modelSet.getModelSetAuxiliaryInfoBoolean("doMinimize");
        this.adapterTrajectoryCount = this.modelSet.trajectorySteps == null ? 0 : this.modelSet.trajectorySteps.size();
        this.modelSet.someModelsHaveSymmetry = this.modelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.modelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.modelSet.someModelsHaveFractionalCoordinates = this.modelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.modelSet.isPDB |= this.mergeModelSet.isPDB;
            this.modelSet.someModelsHaveSymmetry |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.modelSet.someModelsHaveFractionalCoordinates |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
            this.modelSet.someModelsHaveAromaticBonds |= this.mergeModelSet.someModelsHaveAromaticBonds;
            this.modelSet.modelSetAuxiliaryInfo.put("someModelsHaveSymmetry", this.modelSet.someModelsHaveSymmetry);
            this.modelSet.modelSetAuxiliaryInfo.put("someModelsHaveUnitcells", this.someModelsHaveUnitcells);
            this.modelSet.modelSetAuxiliaryInfo.put("someModelsHaveFractionalCoordinates", this.modelSet.someModelsHaveFractionalCoordinates);
            this.modelSet.modelSetAuxiliaryInfo.put("someModelsHaveAromaticBonds", this.modelSet.someModelsHaveAromaticBonds);
        }
    }

    public String getGroup3(int n) {
        return n >= this.group3Of.length ? null : this.group3Of[n];
    }

    public int getFirstAtomIndex(int n) {
        return this.firstAtomIndexes[n];
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public int getAtomCount() {
        return this.modelSet.atomCount;
    }

    private void createModelSet(JmolAdapter jmolAdapter, Object object, BitSet bitSet) {
        int n;
        int n2 = n = jmolAdapter == null ? 0 : jmolAdapter.getAtomCount(object);
        if (n > 0) {
            Logger.info("reading " + n + " atoms");
        }
        this.adapterModelCount = jmolAdapter == null ? 1 : jmolAdapter.getAtomSetCount(object);
        this.appendNew = !this.merging || jmolAdapter == null || this.adapterModelCount > 1 || this.isTrajectory || this.viewer.getAppendNew();
        this.htAtomMap.clear();
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
        if (this.merging) {
            this.baseModelCount = this.mergeModelSet.modelCount;
            this.baseTrajectoryCount = this.mergeModelSet.getTrajectoryCount();
            if (this.baseTrajectoryCount > 0) {
                if (this.isTrajectory) {
                    int n3;
                    if (this.mergeModelSet.vibrationSteps == null) {
                        this.mergeModelSet.vibrationSteps = new ArrayList();
                        n3 = this.mergeModelSet.trajectorySteps.size();
                        while (--n3 >= 0) {
                            this.mergeModelSet.vibrationSteps.add(null);
                        }
                    }
                    for (n3 = 0; n3 < this.modelSet.trajectorySteps.size(); ++n3) {
                        this.mergeModelSet.trajectorySteps.add(this.modelSet.trajectorySteps.get(n3));
                        this.mergeModelSet.vibrationSteps.add(this.modelSet.vibrationSteps.get(n3));
                    }
                }
                this.modelSet.trajectorySteps = this.mergeModelSet.trajectorySteps;
                this.modelSet.vibrationSteps = this.mergeModelSet.vibrationSteps;
            }
        }
        this.initializeAtomBondModelCounts(n);
        if (bitSet != null && (this.doMinimize || this.is2D)) {
            bitSet.set(this.baseAtomIndex, this.baseAtomIndex + n);
        }
        if (jmolAdapter == null) {
            this.setModelNameNumberProperties(0, -1, "", 1, null, null, null);
        } else {
            Quaternion quaternion;
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.modelSet.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.modelSet.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.modelSet.modelCount == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them.");
            }
            if ((quaternion = (Quaternion)this.modelSet.getModelSetAuxiliaryInfo("defaultOrientationQuaternion")) != null) {
                Logger.info("defaultOrientationQuaternion = " + quaternion);
                Logger.info("Use \"set autoLoadOrientation TRUE\" before loading or \"restore orientation DEFAULT\" after loading to view this orientation.");
            }
            this.iterateOverAllNewModels(jmolAdapter, object);
            this.iterateOverAllNewAtoms(jmolAdapter, object);
            this.iterateOverAllNewBonds(jmolAdapter, object);
            if (jmolAdapter != null && this.merging && !this.appendNew) {
                Map<String, Object> map = jmolAdapter.getAtomSetAuxiliaryInfo(object, 0);
                this.modelSet.setModelAuxiliaryInfo(this.baseModelIndex, "initialAtomCount", map.get("initialAtomCount"));
                this.modelSet.setModelAuxiliaryInfo(this.baseModelIndex, "initialBondCount", map.get("initialBondCount"));
            }
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        if (this.is2D) {
            this.applyStereochemistry();
        }
        if (this.doAddHydrogens) {
            this.jbr.finalizeHydrogens();
        }
        if (jmolAdapter != null) {
            this.modelSet.calculatePolymers(this.groups, this.groupCount, this.baseGroupIndex, null);
            this.iterateOverAllNewStructures(jmolAdapter, object);
            jmolAdapter.finish(object);
        }
        this.setDefaultRendering(this.viewer.getSmallMoleculeMaxAtoms());
        RadiusData radiusData = this.viewer.getDefaultRadiusData();
        int n4 = this.modelSet.atomCount;
        Atom[] atomArray = this.modelSet.atoms;
        for (int i = this.baseAtomIndex; i < n4; ++i) {
            atomArray[i].setMadAtom(this.viewer, radiusData);
        }
        Model[] modelArray = this.modelSet.models;
        for (int i = modelArray[this.baseModelIndex].firstAtomIndex; i < n4; ++i) {
            modelArray[atomArray[i].modelIndex].bsAtoms.set(i);
        }
        this.setAtomProperties();
        this.freeze();
        this.finalizeShapes();
        if (this.mergeModelSet != null) {
            this.mergeModelSet.releaseModelSet();
        }
        this.mergeModelSet = null;
    }

    private void setDefaultRendering(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.modelSet.modelCount;
        Model[] modelArray = this.modelSet.models;
        for (int i = this.baseModelIndex; i < n2; ++i) {
            if (!modelArray[i].isBioModel) continue;
            modelArray[i].getDefaultLargePDBRendering(stringBuffer, n);
        }
        if (stringBuffer.length() == 0) {
            return;
        }
        stringBuffer.append("select *;");
        String string = (String)this.modelSet.getModelSetAuxiliaryInfo("jmolscript");
        if (string == null) {
            string = "";
        }
        stringBuffer.append(string);
        this.modelSet.modelSetAuxiliaryInfo.put("jmolscript", stringBuffer.toString());
    }

    private void setAtomProperties() {
        int n = this.baseAtomIndex;
        int n2 = 0;
        int n3 = this.modelSet.modelCount;
        Model[] modelArray = this.modelSet.models;
        for (int i = this.baseModelIndex; i < n3; ++i) {
            n2 = modelArray[i].bsAtoms.cardinality();
            Map map = (Map)this.modelSet.getModelAuxiliaryInfo(i, "atomProperties");
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    BitSet bitSet = this.modelSet.getModelAtomBitSetIncludingDeleted(i, true);
                    if (this.doAddHydrogens) {
                        string2 = this.jbr.fixPropertyValue(bitSet, string2);
                    }
                    string = "property_" + string.toLowerCase();
                    Logger.info("creating " + string + " for model " + this.modelSet.getModelName(i));
                    this.viewer.setData(string, new Object[]{string, string2, bitSet}, this.modelSet.atomCount, 0, 0, Integer.MAX_VALUE, 0);
                }
            }
            n += n2;
        }
    }

    private void initializeAtomBondModelCounts(int n) {
        int n2 = this.adapterTrajectoryCount;
        if (this.merging) {
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.modelSet.modelCount = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.viewer.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.modelSet.modelCount = this.baseModelCount;
            }
            this.modelSet.atomCount = this.baseAtomIndex = this.mergeModelSet.atomCount;
            this.modelSet.bondCount = this.mergeModelSet.bondCount;
            this.mergeGroups = this.mergeModelSet.getGroups();
            this.groupCount = this.baseGroupIndex = this.mergeGroups.length;
            this.modelSet.mergeModelArrays(this.mergeModelSet);
            this.modelSet.growAtomArrays(this.modelSet.atomCount + n);
        } else {
            this.modelSet.modelCount = this.adapterModelCount;
            this.modelSet.atomCount = 0;
            this.modelSet.bondCount = 0;
            this.modelSet.atoms = new Atom[n];
            this.modelSet.bonds = new Bond[250 + n];
        }
        if (this.doAddHydrogens) {
            this.jbr.initializeHydrogenAddition(this, this.modelSet.bondCount);
        }
        if (n2 > 1) {
            this.modelSet.modelCount += n2 - 1;
        }
        this.modelSet.models = (Model[])ArrayUtil.setLength(this.modelSet.models, this.modelSet.modelCount);
        this.modelSet.modelFileNumbers = ArrayUtil.setLength(this.modelSet.modelFileNumbers, this.modelSet.modelCount);
        this.modelSet.modelNumbers = ArrayUtil.setLength(this.modelSet.modelNumbers, this.modelSet.modelCount);
        this.modelSet.modelNumbersForAtomLabel = ArrayUtil.setLength(this.modelSet.modelNumbersForAtomLabel, this.modelSet.modelCount);
        this.modelSet.modelNames = ArrayUtil.setLength(this.modelSet.modelNames, this.modelSet.modelCount);
        this.modelSet.frameTitles = ArrayUtil.setLength(this.modelSet.frameTitles, this.modelSet.modelCount);
        if (this.merging) {
            for (int i = 0; i < this.mergeModelSet.modelCount; ++i) {
                this.modelSet.models[i] = this.mergeModelSet.models[i];
                this.mergeModelSet.models[i].modelSet = this.modelSet;
            }
        }
    }

    private void mergeGroups() {
        Map<String, Object> map = this.mergeModelSet.getAuxiliaryInfo(null);
        String[] stringArray = (String[])map.get("group3Lists");
        int[][] nArray = (int[][])map.get("group3Counts");
        if (stringArray != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i + 1] = stringArray[i + 1];
                this.group3Counts[i + 1] = nArray[i + 1];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[0] = stringArray[0];
            this.group3Counts[0] = nArray[0];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
    }

    private void iterateOverAllNewModels(JmolAdapter jmolAdapter, Object object) {
        int n;
        Serializable serializable;
        String[] stringArray;
        CharSequence charSequence;
        this.group3Lists = new String[this.modelSet.modelCount + 1];
        this.group3Counts = new int[this.modelSet.modelCount + 1][];
        this.structuresDefinedInFile = new BitSet();
        if (this.merging) {
            this.mergeGroups();
        }
        int n2 = this.isTrajectory ? this.baseTrajectoryCount : -1;
        int n3 = this.baseModelIndex;
        int n4 = 0;
        while (n4 < this.adapterModelCount) {
            int n5 = jmolAdapter.getAtomSetNumber(object, n4);
            charSequence = jmolAdapter.getAtomSetName(object, n4);
            stringArray = jmolAdapter.getAtomSetAuxiliaryInfo(object, n4);
            if (stringArray.containsKey("modelID")) {
                stringArray.put((String)"modelID0", (Object)stringArray.get("modelID"));
            }
            serializable = (Properties)stringArray.get("modelProperties");
            this.viewer.setStringProperty("_fileType", (String)stringArray.get("fileType"));
            if (charSequence == null) {
                CharSequence charSequence2 = this.jmolData != null && this.jmolData.indexOf(";") > 2 ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf(";")) : (charSequence = this.appendNew ? "" + n5 % 1000000 : "");
            }
            if ((n = this.setModelNameNumberProperties(n3, n2, (String)charSequence, n5, (Properties)serializable, (Map<String, Object>)stringArray, this.jmolData)) != 0) {
                this.group3Lists[n3 + 1] = JmolConstants.group3List;
                this.group3Counts[n3 + 1] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[0] == null) {
                    this.group3Lists[0] = JmolConstants.group3List;
                    this.group3Counts[0] = new int[JmolConstants.group3Count + 10];
                }
            }
            if (this.modelSet.getModelAuxiliaryInfo(n3, "periodicOriginXyz") != null) {
                this.modelSet.someModelsHaveSymmetry = true;
            }
            ++n4;
            ++n3;
        }
        Model model = this.modelSet.models[this.baseModelIndex];
        this.viewer.setSmilesString((String)this.modelSet.modelSetAuxiliaryInfo.get("smilesString"));
        String string = (String)this.modelSet.modelSetAuxiliaryInfo.remove("loadState");
        charSequence = (StringBuffer)this.modelSet.modelSetAuxiliaryInfo.remove("loadScript");
        if (((StringBuffer)charSequence).indexOf("Viewer.AddHydrogens") < 0 || !model.isModelKit) {
            stringArray = TextFormat.split(string, '\n');
            serializable = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                int n6 = model.loadState.indexOf(stringArray[n]);
                if (n6 >= 0 && n6 == model.loadState.lastIndexOf(stringArray[n])) continue;
                ((StringBuffer)serializable).append(stringArray[n]).append('\n');
            }
            model.loadState = model.loadState + model.loadScript.toString() + ((StringBuffer)serializable).toString();
            model.loadScript = new StringBuffer();
            model.loadScript.append("  ").append((StringBuffer)charSequence).append(";\n");
        }
        if (this.isTrajectory) {
            int n7 = this.modelSet.modelCount - n3 + 1;
            Logger.info(n7 + " trajectory steps read");
            this.modelSet.setModelAuxiliaryInfo(this.baseModelCount, "trajectoryStepCount", n7);
            int n8 = this.adapterModelCount;
            n = n3;
            while (n < this.modelSet.modelCount) {
                this.modelSet.models[n] = this.modelSet.models[this.baseModelCount];
                this.modelSet.modelNumbers[n] = jmolAdapter.getAtomSetNumber(object, n8);
                this.modelSet.modelNames[n] = jmolAdapter.getAtomSetName(object, n8);
                this.structuresDefinedInFile.set(n);
                ++n;
                ++n8;
            }
        }
        this.finalizeModels(this.baseModelCount);
    }

    private boolean setModelNameNumberProperties(int n, int n2, String string, int n3, Properties properties, Map<String, Object> map, String string2) {
        boolean bl;
        Model[] modelArray;
        boolean bl2;
        boolean bl3 = bl2 = map != null && Boolean.TRUE.equals(map.get("isPDB"));
        if (this.appendNew) {
            this.modelSet.models[n] = bl2 ? this.jbr.getBioModel(this.modelSet, n, n2, string2, properties, map) : new Model(this.modelSet, n, n2, string2, properties, map);
            this.modelSet.modelNumbers[n] = n3;
            this.modelSet.modelNames[n] = string;
        } else {
            modelArray = map.get("PDB_CONECT_firstAtom_count_max");
            if (modelArray != null) {
                this.modelSet.setModelAuxiliaryInfo(n, "PDB_CONECT_firstAtom_count_max", modelArray);
            }
        }
        modelArray = this.modelSet.models;
        Atom[] atomArray = this.modelSet.atoms;
        modelArray[n].bsAtoms.set(atomArray.length + 1);
        modelArray[n].bsAtoms.clear(atomArray.length + 1);
        String string3 = (String)this.modelSet.getModelAuxiliaryInfo(n, "altLocs");
        modelArray[n].setNAltLocs(string3 == null ? 0 : string3.length());
        if (string3 != null) {
            char[] cArray = string3.toCharArray();
            Arrays.sort(cArray);
            string3 = String.valueOf(cArray);
            this.modelSet.setModelAuxiliaryInfo(n, "altLocs", string3);
        }
        string3 = (String)this.modelSet.getModelAuxiliaryInfo(n, "insertionCodes");
        modelArray[n].setNInsertions(string3 == null ? 0 : string3.length());
        modelArray[n].isModelKit = bl = this.modelSet.modelSetName != null && this.modelSet.modelSetName.startsWith("Jmol Model Kit") || string.startsWith("Jmol Model Kit") || "Jme".equals(this.modelSet.getModelAuxiliaryInfo(n, "fileType"));
        return bl2;
    }

    private void finalizeModels(int n) {
        int n2;
        int n3;
        int n4 = this.modelSet.modelCount;
        if (n4 == n) {
            return;
        }
        int n5 = 0;
        int n6 = -1;
        int[] nArray = this.modelSet.modelNumbers;
        String[] stringArray = this.modelSet.modelNames;
        if (this.isTrajectory) {
            n3 = n;
            while (++n3 < this.modelSet.modelCount) {
                nArray[n3] = nArray[n3 - 1] + 1;
            }
        }
        if (n > 0) {
            if (nArray[0] < 1000000) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (stringArray[n3].length() == 0) {
                        stringArray[n3] = "" + nArray[n3];
                    }
                    int n7 = n3;
                    nArray[n7] = nArray[n7] + 1000000;
                    this.modelSet.modelNumbersForAtomLabel[n3] = "1." + (n3 + 1);
                }
            }
            n3 = nArray[n - 1];
            n3 -= n3 % 1000000;
            if (nArray[n] < 1000000) {
                n3 += 1000000;
            }
            n2 = n;
            while (n2 < n4) {
                int n8 = n2++;
                nArray[n8] = nArray[n8] + n3;
            }
        }
        Model[] modelArray = this.modelSet.models;
        for (n2 = n; n2 < n4; ++n2) {
            String string;
            int n9;
            if (this.fileHeader != null) {
                this.modelSet.setModelAuxiliaryInfo(n2, "fileHeader", this.fileHeader);
            }
            if ((n9 = nArray[n2] / 1000000) != n6) {
                n5 = 0;
                n6 = n9;
            }
            ++n5;
            if (n9 == 0) {
                string = "" + this.modelSet.getModelNumber(n2);
                n9 = 1;
            } else {
                string = n9 + "." + n5;
            }
            this.modelSet.modelNumbersForAtomLabel[n2] = string;
            modelArray[n2].fileIndex = n9 - 1;
            this.modelSet.modelFileNumbers[n2] = n9 * 1000000 + n5;
            if (stringArray[n2] != null && stringArray[n2].length() != 0) continue;
            stringArray[n2] = string;
        }
        if (this.merging) {
            for (n2 = 0; n2 < n; ++n2) {
                modelArray[n2].modelSet = this.modelSet;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.modelSet.setModelAuxiliaryInfo(n2, "modelName", stringArray[n2]);
            this.modelSet.setModelAuxiliaryInfo(n2, "modelNumber", nArray[n2] % 1000000);
            this.modelSet.setModelAuxiliaryInfo(n2, "modelFileNumber", this.modelSet.modelFileNumbers[n2]);
            this.modelSet.setModelAuxiliaryInfo(n2, "modelNumberDotted", this.modelSet.getModelNumberDotted(n2));
            String string = (String)this.modelSet.getModelAuxiliaryInfo(n2, "altLocs");
            if (string == null) continue;
            Logger.info("model " + this.modelSet.getModelNumberDotted(n2) + " alternative locations: " + string);
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter jmolAdapter, Object object) {
        Object object2;
        short s;
        Object object3;
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        JmolAdapter.AtomIterator atomIterator = jmolAdapter.getAtomIterator(object);
        int n2 = 0;
        Model[] modelArray = this.modelSet.models;
        if (this.modelSet.modelCount > 0) {
            this.nullGroup = new Group(new Chain(this.modelSet.models[this.baseModelIndex], ' '), "", 0, -1, -1);
        }
        while (atomIterator.hasNext()) {
            ++n2;
            int n3 = atomIterator.getAtomSetIndex() + this.baseModelIndex;
            if (n3 != n) {
                this.currentModelIndex = n3;
                this.currentModel = modelArray[n3];
                this.currentChainID = (char)65535;
                modelArray[n3].bsAtoms.clear();
                bl = modelArray[n3].isBioModel;
                n = n3;
                boolean bl3 = bl2 = bl && this.doAddHydrogens;
                if (this.jbr != null) {
                    this.jbr.setHaveHsAlready(false);
                }
            }
            object3 = atomIterator.getGroup3();
            this.checkNewGroup(jmolAdapter, atomIterator.getChainID(), (String)object3, atomIterator.getSequenceNumber(), atomIterator.getInsertionCode(), bl2);
            s = atomIterator.getElementNumber();
            if (bl2 && Elements.getElementNumber(s) == 1) {
                this.jbr.setHaveHsAlready(true);
            }
            object2 = atomIterator.getAtomName();
            int n4 = bl2 ? this.getPdbCharge((String)object3, (String)object2) : atomIterator.getFormalCharge();
            this.addAtom(bl, atomIterator.getAtomSymmetry(), atomIterator.getAtomSite(), atomIterator.getUniqueID(), s, (String)object2, n4, atomIterator.getPartialCharge(), atomIterator.getEllipsoid(), atomIterator.getOccupancy(), atomIterator.getBfactor(), atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), atomIterator.getIsHetero(), atomIterator.getAtomSerial(), (String)object3, atomIterator.getVectorX(), atomIterator.getVectorY(), atomIterator.getVectorZ(), atomIterator.getAlternateLocationID(), atomIterator.getRadius());
        }
        if (this.groupCount > 0 && bl2) {
            this.jbr.addImplicitHydrogenAtoms(jmolAdapter, this.groupCount - 1);
        }
        n = -1;
        Object object4 = null;
        object3 = this.modelSet.atoms;
        for (s = 0; s < this.modelSet.atomCount; ++s) {
            if (object3[s].modelIndex == n) continue;
            n = object3[s].modelIndex;
            modelArray[n].firstAtomIndex = s;
            object2 = this.modelSet.getDefaultVdwType(n);
            if (object2 == object4) continue;
            Logger.info("Default Van der Waals type for model set to " + ((EnumVdw)((Object)object2)).getVdwLabel());
            object4 = object2;
        }
        Logger.info(n2 + " atoms created");
    }

    private int getPdbCharge(String string, String string2) {
        if (string.equals("ARG") && string2.equals("NH1") || string.equals("LYS") && string2.equals("NZ") || string.equals("HIS") && string2.equals("ND1")) {
            return 1;
        }
        return 0;
    }

    private void addAtom(boolean bl, BitSet bitSet, int n, Object object, short s, String string, int n2, float f, Quadric[] quadricArray, int n3, float f2, float f3, float f4, float f5, boolean bl2, int n4, String string2, float f6, float f7, float f8, char c, float f9) {
        byte by = 0;
        if (string != null) {
            if (bl && string.indexOf(42) >= 0) {
                string = string.replace('*', '\'');
            }
            by = JmolConstants.lookupSpecialAtomID(string);
            if (bl && by == 2 && "CA".equalsIgnoreCase(string2)) {
                by = 0;
            }
        }
        Atom atom = this.modelSet.addAtom(this.currentModelIndex, this.nullGroup, s, string, n4, n, f3, f4, f5, f9, f6, f7, f8, n2, f, n3, f2, quadricArray, bl2, c, by, bitSet);
        this.htAtomMap.put(object, atom);
    }

    private void checkNewGroup(JmolAdapter jmolAdapter, char c, String string, int n, char c2, boolean bl) {
        String string2;
        String string3 = string2 = string == null ? null : string.intern();
        if (c != this.currentChainID) {
            this.currentChainID = c;
            this.currentChain = this.getOrAllocateChain(this.currentModel, c);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (n != this.currentGroupSequenceNumber || c2 != this.currentGroupInsertionCode || string2 != this.currentGroup3) {
            if (this.groupCount > 0 && bl) {
                this.jbr.addImplicitHydrogenAtoms(jmolAdapter, this.groupCount - 1);
                this.jbr.setHaveHsAlready(false);
            }
            this.currentGroupSequenceNumber = n;
            this.currentGroupInsertionCode = c2;
            this.currentGroup3 = string2;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])ArrayUtil.doubleLength(this.chainOf);
                this.group3Of = ArrayUtil.doubleLength(this.group3Of);
                this.seqcodes = ArrayUtil.doubleLength(this.seqcodes);
                this.firstAtomIndexes = ArrayUtil.doubleLength(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = this.modelSet.atomCount;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = string;
            this.seqcodes[this.groupCount] = Group.getSeqcode(n, c2);
            ++this.groupCount;
        }
    }

    private Chain getOrAllocateChain(Model model, char c) {
        Chain chain = model.getChain(c);
        if (chain != null) {
            return chain;
        }
        if (model.chainCount == model.chains.length) {
            model.chains = (Chain[])ArrayUtil.doubleLength(model.chains);
        }
        Chain chain2 = new Chain(model, c);
        model.chains[model.chainCount++] = chain2;
        return chain2;
    }

    private void iterateOverAllNewBonds(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.BondIterator bondIterator = jmolAdapter.getBondIterator(object);
        if (bondIterator == null) {
            return;
        }
        short s = this.viewer.getMadBond();
        this.modelSet.defaultCovalentMad = this.jmolData == null ? s : (short)0;
        boolean bl = false;
        while (bondIterator.hasNext()) {
            short s2 = (short)bondIterator.getEncodedOrder();
            this.bondAtoms(bondIterator.getAtomUniqueID1(), bondIterator.getAtomUniqueID2(), s2);
            if (s2 <= 1 || s2 == 1025 || s2 == 1041) continue;
            bl = true;
        }
        if (bl && this.modelSet.someModelsHaveSymmetry && !this.viewer.getApplySymmetryToBonds()) {
            Logger.info("ModelSet: use \"set appletSymmetryToBonds TRUE \" to apply the file-based multiple bonds to symmetry-generated atoms.");
        }
        this.modelSet.defaultCovalentMad = s;
    }

    private void bondAtoms(Object object, Object object2, short s) {
        Bond bond;
        boolean bl;
        Atom atom = this.htAtomMap.get(object);
        if (atom == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + object);
            return;
        }
        Atom atom2 = this.htAtomMap.get(object2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + object2);
            return;
        }
        if (atom.isBonded(atom2)) {
            return;
        }
        boolean bl2 = s == 1025;
        boolean bl3 = bl = s == 1041;
        if (bl2 || bl) {
            bond = this.modelSet.bondMutually(atom, atom2, this.is2D ? s : (short)1, this.modelSet.getDefaultMadFromOrder(1), 0.0f);
            if (this.vStereo == null) {
                this.vStereo = new ArrayList<Bond>();
            }
            this.vStereo.add(bond);
        } else {
            bond = this.modelSet.bondMutually(atom, atom2, s, this.modelSet.getDefaultMadFromOrder(s), 0.0f);
            if (bond.isAromatic()) {
                this.modelSet.someModelsHaveAromaticBonds = true;
            }
        }
        if (this.modelSet.bondCount == this.modelSet.bonds.length) {
            this.modelSet.bonds = (Bond[])ArrayUtil.setLength(this.modelSet.bonds, this.modelSet.bondCount + 250);
        }
        this.modelSet.setBond(this.modelSet.bondCount++, bond);
    }

    private void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.StructureIterator structureIterator = jmolAdapter.getStructureIterator(object);
        if (structureIterator != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType() == EnumStructure.TURN) continue;
                this.defineStructure(structureIterator.getModelIndex(), structureIterator.getSubstructureType(), structureIterator.getStructureID(), structureIterator.getSerialID(), structureIterator.getStrandCount(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
        if ((structureIterator = jmolAdapter.getStructureIterator(object)) != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType() != EnumStructure.TURN) continue;
                this.defineStructure(structureIterator.getModelIndex(), structureIterator.getSubstructureType(), structureIterator.getStructureID(), 1, 1, structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
    }

    private void defineStructure(int n, EnumStructure enumStructure, String string, int n2, int n3, char c, int n4, char c2, char c3, int n5, char c4) {
        EnumStructure enumStructure2 = enumStructure == EnumStructure.NOT ? EnumStructure.NONE : enumStructure;
        int n6 = Group.getSeqcode(n4, c2);
        int n7 = Group.getSeqcode(n5, c4);
        Model[] modelArray = this.modelSet.models;
        if (n >= 0 || this.isTrajectory) {
            if (this.isTrajectory) {
                n = 0;
            }
            this.structuresDefinedInFile.set(n += this.baseModelIndex);
            modelArray[n].addSecondaryStructure(enumStructure2, string, n2, n3, c, n6, c3, n7);
            return;
        }
        for (int i = this.baseModelIndex; i < this.modelSet.modelCount; ++i) {
            this.structuresDefinedInFile.set(i);
            modelArray[i].addSecondaryStructure(enumStructure2, string, n2, n3, c, n6, c3, n7);
        }
    }

    private void initializeUnitCellAndSymmetry() {
        int n;
        int n2;
        if (this.someModelsHaveUnitcells) {
            this.modelSet.unitCells = new SymmetryInterface[this.modelSet.modelCount];
            boolean bl = this.mergeModelSet != null && this.mergeModelSet.unitCells != null;
            for (n2 = 0; n2 < this.modelSet.modelCount; ++n2) {
                if (bl && n2 < this.baseModelCount) {
                    this.modelSet.unitCells[n2] = this.mergeModelSet.unitCells[n2];
                    continue;
                }
                this.modelSet.unitCells[n2] = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                this.modelSet.unitCells[n2].setSymmetryInfo(n2, this.modelSet.getModelAuxiliaryInfo(n2));
            }
        }
        if (this.appendNew && this.modelSet.someModelsHaveSymmetry) {
            this.modelSet.getAtomBits(1089470478, null);
            Atom[] atomArray = this.modelSet.atoms;
            short s = -1;
            n = 0;
            for (n2 = this.baseAtomIndex; n2 < this.modelSet.atomCount; ++n2) {
                if (atomArray[n2].modelIndex != s) {
                    s = atomArray[n2].modelIndex;
                    n = this.baseAtomIndex + this.modelSet.getModelAuxiliaryInfoInt(s, "presymmetryAtomIndex") + this.modelSet.getModelAuxiliaryInfoInt(s, "presymmetryAtomCount");
                }
                if (n2 < n) continue;
                this.modelSet.bsSymmetry.set(n2);
            }
        }
        if (this.appendNew && this.modelSet.someModelsHaveFractionalCoordinates) {
            Atom[] atomArray = this.modelSet.atoms;
            n2 = -1;
            SymmetryInterface symmetryInterface = null;
            for (n = this.baseAtomIndex; n < this.modelSet.atomCount; ++n) {
                if (atomArray[n].modelIndex != n2) {
                    n2 = atomArray[n].modelIndex;
                    symmetryInterface = this.modelSet.getUnitCell(n2);
                }
                if (symmetryInterface == null || !symmetryInterface.getCoordinatesAreFractional()) continue;
                symmetryInterface.toCartesian(atomArray[n], false);
            }
        }
    }

    private void initializeBonding() {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.modelSet.getModelSetAuxiliaryInfo("someModelsHaveCONECT") == null ? null : new BitSet();
        if (bitSet != null) {
            this.modelSet.setPdbConectBonding(this.baseAtomIndex, this.baseModelIndex, bitSet);
        }
        int n = this.baseAtomIndex;
        int n2 = 0;
        boolean bl = this.viewer.getApplySymmetryToBonds();
        boolean bl2 = this.viewer.getAutoBond();
        boolean bl3 = this.viewer.getForceAutoBond();
        BitSet bitSet3 = null;
        boolean bl4 = false;
        int n3 = this.modelSet.modelCount;
        Model[] modelArray = this.modelSet.models;
        if (!this.noAutoBond) {
            for (int i = this.baseModelIndex; i < n3; ++i) {
                boolean bl5;
                n2 = modelArray[i].bsAtoms.cardinality();
                int n4 = this.modelSet.getModelAuxiliaryInfoInt(i, "initialBondCount");
                boolean bl6 = modelArray[i].isBioModel;
                if (n4 < 0) {
                    n4 = this.modelSet.bondCount;
                }
                boolean bl7 = this.modelSet.getModelAuxiliaryInfoBoolean(i, "hasSymmetry");
                boolean bl8 = bl5 = bl3 || bl2 && (n4 == 0 || bl6 && this.jmolData == null && n4 < n2 / 2 || bl7 && !bl && !this.modelSet.getModelAuxiliaryInfoBoolean(i, "hasBonds"));
                if (bl5) {
                    bl4 = true;
                    if (this.merging || n3 > 1) {
                        if (bitSet3 == null) {
                            bitSet3 = new BitSet(this.modelSet.atomCount);
                        }
                        if (i == this.baseModelIndex || !this.isTrajectory) {
                            bitSet3.or(modelArray[i].bsAtoms);
                        }
                    }
                }
                n += n2;
            }
        }
        if (bl4) {
            this.modelSet.autoBond(bitSet3, bitSet3, bitSet, null, this.modelSet.defaultCovalentMad, this.viewer.checkAutoBondLegacy());
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
        } else {
            Logger.info("ModelSet: not autobonding; use  forceAutobond=true  to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        int n;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (n = 0; n < this.mergeGroups.length; ++n) {
                this.groups[n] = this.mergeGroups[n];
                this.groups[n].setModelSet(this.modelSet);
            }
        }
        for (n = this.baseGroupIndex; n < this.groupCount; ++n) {
            this.distinguishAndPropagateGroup(n, this.chainOf[n], this.group3Of[n], this.seqcodes[n], this.firstAtomIndexes[n], n == this.groupCount - 1 ? this.modelSet.atomCount : this.firstAtomIndexes[n + 1]);
        }
        if (this.group3Lists != null && this.modelSet.modelSetAuxiliaryInfo != null) {
            this.modelSet.modelSetAuxiliaryInfo.put("group3Lists", this.group3Lists);
            this.modelSet.modelSetAuxiliaryInfo.put("group3Counts", this.group3Counts);
        }
    }

    private void distinguishAndPropagateGroup(int n, Chain chain, String string, int n2, int n3, int n4) {
        String string2;
        int n5 = n4 - 1;
        if (n5 < n3) {
            throw new NullPointerException();
        }
        short s = this.modelSet.atoms[n3].modelIndex;
        Group group = null;
        if (string != null && this.jbr != null) {
            group = this.jbr.distinguishAndPropagateGroup(chain, string, n2, n3, n4, s, this.specialAtomIndexes, this.modelSet.atoms);
        }
        if (group == null) {
            group = new Group(chain, string, n2, n3, n5);
            string2 = "o>";
        } else {
            String string3 = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (string2 = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (string != null) {
            this.countGroup(s, string2, string);
        }
        this.addGroup(chain, group);
        this.groups[n] = group;
        group.setGroupIndex(n);
        int n6 = n4;
        while (--n6 >= n3) {
            this.modelSet.atoms[n6].setGroup(group);
        }
    }

    private void addGroup(Chain chain, Group group) {
        if (chain.groupCount == chain.groups.length) {
            chain.groups = (Group[])ArrayUtil.doubleLength(chain.groups);
        }
        chain.groups[chain.groupCount++] = group;
    }

    private void countGroup(int n, String string, String string2) {
        int n2 = n + 1;
        if (this.group3Lists == null || this.group3Lists[n2] == null) {
            return;
        }
        String string3 = (string2 + "   ").substring(0, 3);
        int n3 = this.group3Lists[n2].indexOf(string3);
        if (n3 < 0) {
            int n4 = n2;
            this.group3Lists[n4] = this.group3Lists[n4] + ",[" + string3 + "]";
            n3 = this.group3Lists[n2].indexOf(string3);
            this.group3Counts[n2] = ArrayUtil.setLength(this.group3Counts[n2], this.group3Counts[n2].length + 10);
        }
        int[] nArray = this.group3Counts[n2];
        int n5 = n3 / 6;
        nArray[n5] = nArray[n5] + 1;
        n3 = this.group3Lists[n2].indexOf(",[" + string3);
        if (n3 >= 0) {
            this.group3Lists[n2] = this.group3Lists[n2].substring(0, n3) + string + this.group3Lists[n2].substring(n3 + 2);
        }
        if (n >= 0) {
            this.countGroup(-1, string, string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void freeze() {
        Object object;
        void var1_2;
        this.htAtomMap.clear();
        if (this.modelSet.atomCount < this.modelSet.atoms.length) {
            this.modelSet.growAtomArrays(this.modelSet.atomCount);
        }
        if (this.modelSet.bondCount < this.modelSet.bonds.length) {
            this.modelSet.bonds = (Bond[])ArrayUtil.setLength(this.modelSet.bonds, this.modelSet.bondCount);
        }
        int bl = 5;
        while (--var1_2 > 0) {
            this.modelSet.numCached[var1_2] = 0;
            object = this.modelSet.freeBonds[var1_2];
            int n = ((Bond[][])object).length;
            while (--n >= 0) {
                object[n] = null;
            }
        }
        this.modelSet.setAtomNamesAndNumbers(0, this.baseAtomIndex, this.mergeModelSet);
        this.findElementsPresent();
        this.modelSet.resetMolecules();
        this.currentModel = null;
        this.currentChain = null;
        if (!this.isPDB) {
            this.modelSet.freezeModels();
            return;
        }
        boolean bl2 = this.viewer.getDefaultStructureDSSP();
        object = this.modelSet.calculateStructuresAllExcept(this.structuresDefinedInFile, bl2, false, true, true, bl2);
        if (((String)object).length() > 0) {
            Logger.info((String)object);
        }
    }

    private void findElementsPresent() {
        int n;
        this.modelSet.elementsPresent = new BitSet[this.modelSet.modelCount];
        for (n = 0; n < this.modelSet.modelCount; ++n) {
            this.modelSet.elementsPresent[n] = new BitSet(64);
        }
        n = this.modelSet.atomCount;
        while (--n >= 0) {
            int n2 = this.modelSet.atoms[n].getAtomicAndIsotopeNumber();
            if (n2 >= Elements.elementNumberMax) {
                n2 = Elements.elementNumberMax + Elements.altElementIndexFromNumber(n2);
            }
            this.modelSet.elementsPresent[this.modelSet.atoms[n].modelIndex].set(n2);
        }
    }

    private void applyStereochemistry() {
        this.set2dZ(this.baseAtomIndex, this.modelSet.atomCount);
        if (this.vStereo != null) {
            BitSet bitSet = new BitSet();
            bitSet.set(this.baseAtomIndex, this.modelSet.atomCount);
            int n = this.vStereo.size();
            while (--n >= 0) {
                Bond bond = this.vStereo.get(n);
                float f = bond.order == 1025 ? 3 : -3;
                bond.order = 1;
                if (bond.atom2.z != bond.atom1.z && f < 0.0f == bond.atom2.z < bond.atom1.z) {
                    f /= 3.0f;
                }
                BitSet bitSet2 = JmolMolecule.getBranchBitSet(this.modelSet.atoms, bond.atom2.index, bitSet, null, bond.atom1.index, false, true);
                bitSet2.set(bond.atom2.index);
                int n2 = bitSet2.nextSetBit(0);
                while (n2 >= 0) {
                    this.modelSet.atoms[n2].z += f;
                    n2 = bitSet2.nextSetBit(n2 + 1);
                }
                bond.atom2.x = (bond.atom1.x + bond.atom2.x) / 2.0f;
                bond.atom2.y = (bond.atom1.y + bond.atom2.y) / 2.0f;
            }
            this.vStereo = null;
        }
        this.is2D = false;
    }

    private void set2dZ(int n, int n2) {
        BitSet bitSet = new BitSet(n2);
        BitSet bitSet2 = new BitSet();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f();
        BitSet bitSet3 = new BitSet();
        bitSet3.set(n, n2);
        for (int i = n; i < n2; ++i) {
            if (bitSet.get(i) || bitSet2.get(i)) continue;
            bitSet2 = this.getBranch2dZ(i, -1, bitSet3, bitSet2, vector3f, vector3f2, vector3f3);
            bitSet.or(bitSet2);
        }
    }

    private BitSet getBranch2dZ(int n, int n2, BitSet bitSet, BitSet bitSet2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        BitSet bitSet3 = new BitSet(this.modelSet.atomCount);
        if (n < 0) {
            return bitSet3;
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.or(bitSet);
        if (n2 >= 0) {
            bitSet4.clear(n2);
        }
        ModelLoader.setBranch2dZ(this.modelSet.atoms[n], bitSet3, bitSet4, vector3f, vector3f2, vector3f3);
        return bitSet3;
    }

    private static void setBranch2dZ(Atom atom, BitSet bitSet, BitSet bitSet2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        int n = atom.index;
        if (!bitSet2.get(n)) {
            return;
        }
        bitSet2.clear(n);
        bitSet.set(n);
        if (atom.bonds == null) {
            return;
        }
        int n2 = atom.bonds.length;
        while (--n2 >= 0) {
            Bond bond = atom.bonds[n2];
            if (bond.isHydrogen()) continue;
            Atom atom2 = bond.getOtherAtom(atom);
            ModelLoader.setAtom2dZ(atom, atom2, vector3f, vector3f2, vector3f3);
            ModelLoader.setBranch2dZ(atom2, bitSet, bitSet2, vector3f, vector3f2, vector3f3);
        }
    }

    private static void setAtom2dZ(Atom atom, Atom atom2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f.set(atom2);
        vector3f.sub(atom);
        vector3f.z = 0.0f;
        vector3f.normalize();
        vector3f3.cross(vector3f2, vector3f);
        double d = Math.acos(vector3f.dot(vector3f2));
        atom2.z = atom.z + (float)((double)0.8f * Math.sin(4.0 * d));
    }

    private void finalizeShapes() {
        this.modelSet.shapeManager = this.viewer.getShapeManager();
        if (!this.merging) {
            this.modelSet.shapeManager.resetShapes();
        }
        this.modelSet.shapeManager.loadDefaultShapes(this.modelSet);
        if (this.modelSet.someModelsHaveAromaticBonds && this.viewer.getSmartAromatic()) {
            this.modelSet.assignAromaticBonds(false);
        }
        if (this.merging && this.baseModelCount == 1) {
            this.modelSet.shapeManager.setShapeProperty(6, "clearModelIndex", null, null);
        }
    }

    public void undeleteAtom(int n) {
        this.modelSet.atoms[n].valence = 0;
    }

    public void deleteAtoms(BitSet bitSet) {
        this.doRemoveAddedHydrogens = true;
        if (this.doRemoveAddedHydrogens) {
            int n;
            int[] nArray = new int[this.modelSet.atomCount];
            int[] nArray2 = new int[this.modelSet.atomCount - bitSet.cardinality()];
            int n2 = this.baseAtomIndex;
            Model[] modelArray = this.modelSet.models;
            Atom[] atomArray = this.modelSet.atoms;
            for (n = this.baseAtomIndex; n < this.modelSet.atomCount; ++n) {
                modelArray[atomArray[n].modelIndex].bsAtoms.clear(n);
                modelArray[atomArray[n].modelIndex].bsAtomsDeleted.clear(n);
                if (bitSet.get(n)) {
                    nArray[n] = n2 - 1;
                    --modelArray[atomArray[n].modelIndex].atomCount;
                    continue;
                }
                nArray2[n2] = n;
                nArray[n] = n2++;
            }
            this.modelSet.modelSetAuxiliaryInfo.put("bsDeletedAtoms", bitSet);
            for (n = this.baseGroupIndex; n < this.groups.length; ++n) {
                Group group = this.groups[n];
                if (group.firstAtomIndex < this.baseAtomIndex) continue;
                group.firstAtomIndex = nArray[group.firstAtomIndex];
                group.lastAtomIndex = nArray[group.lastAtomIndex];
                if (group.leadAtomIndex < 0) continue;
                group.leadAtomIndex = nArray[group.leadAtomIndex];
            }
            this.modelSet.adjustAtomArrays(nArray2, this.baseAtomIndex, n2);
        } else {
            this.modelSet.viewer.deleteAtoms(bitSet, false);
        }
        this.modelSet.calcBoundBoxDimensions(null, 1.0f);
        this.modelSet.resetMolecules();
        this.modelSet.validateBspf(false);
    }

    public static void createAtomDataSet(Viewer viewer, ModelSet modelSet, int n, Object object, BitSet bitSet) {
        int n2;
        if (object == null) {
            return;
        }
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Atom[] atomArray = modelSet.atoms;
        float f = viewer.getLoadAtomDataTolerance();
        if (modelSet.unitCells != null) {
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (atomArray[n2].getAtomSymmetry() != null) {
                    f = -f;
                    break;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        n2 = -1;
        int n3 = 0;
        boolean bl = BitSetUtil.cardinalityOf(bitSet) == viewer.getAtomCount();
        Object object2 = jmolAdapter.getAtomIterator(object);
        while (((JmolAdapter.AtomIterator)object2).hasNext()) {
            float f2;
            float f3;
            float f4 = ((JmolAdapter.AtomIterator)object2).getX();
            if (Float.isNaN(f4 + (f3 = ((JmolAdapter.AtomIterator)object2).getY()) + (f2 = ((JmolAdapter.AtomIterator)object2).getZ()))) continue;
            if (n == 1146095626) {
                if ((n2 = bitSet.nextSetBit(n2 + 1)) < 0) break;
                ++n3;
                if (Logger.debugging) {
                    Logger.debug("atomIndex = " + n2 + ": " + atomArray[n2] + " --> (" + f4 + "," + f3 + "," + f2);
                }
                modelSet.setAtomCoord(n2, f4, f3, f2);
                continue;
            }
            point3f.set(f4, f3, f2);
            BitSet bitSet2 = new BitSet(modelSet.atomCount);
            modelSet.getAtomsWithin(f, point3f, bitSet2, -1);
            bitSet2.and(bitSet);
            if (bl) {
                n3 = BitSetUtil.cardinalityOf(bitSet2);
                if (n3 == 0) {
                    Logger.warn("createAtomDataSet: no atom found at position " + point3f);
                    continue;
                }
                if (n3 > 1 && Logger.debugging) {
                    Logger.debug("createAtomDataSet: " + n3 + " atoms found at position " + point3f);
                }
            }
            switch (n) {
                case 1146095630: {
                    float f5 = ((JmolAdapter.AtomIterator)object2).getVectorX();
                    float f6 = ((JmolAdapter.AtomIterator)object2).getVectorY();
                    float f7 = ((JmolAdapter.AtomIterator)object2).getVectorZ();
                    if (Float.isNaN(f5 + f6 + f7)) break;
                    point3f2.set(f5, f6, f7);
                    if (Logger.debugging) {
                        Logger.info("xyz: " + point3f + " vib: " + point3f2);
                    }
                    modelSet.setAtomCoord(bitSet2, 1146095630, point3f2);
                    break;
                }
                case 1129318401: {
                    modelSet.setAtomProperty(bitSet2, n, ((JmolAdapter.AtomIterator)object2).getOccupancy(), 0.0f, null, null, null);
                    break;
                }
                case 1112541196: {
                    modelSet.setAtomProperty(bitSet2, n, 0, ((JmolAdapter.AtomIterator)object2).getPartialCharge(), null, null, null);
                    break;
                }
                case 1112541199: {
                    modelSet.setAtomProperty(bitSet2, n, 0, ((JmolAdapter.AtomIterator)object2).getBfactor(), null, null, null);
                }
            }
        }
        switch (n) {
            case 1146095630: {
                object2 = jmolAdapter.getAtomSetName(object, 0);
                Logger.info("_vibrationName = " + (String)object2);
                viewer.setStringProperty("_vibrationName", (String)object2);
                break;
            }
            case 1146095626: {
                Logger.info(n3 + " atom positions read");
                modelSet.recalculateLeadMidpointsAndWingVectors(-1);
            }
        }
    }
}

