/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Parser;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected BinaryDocument binarydoc;
    protected OutputStream os;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator);
        this.br = bufferedReader;
    }

    protected void setOutputStream(OutputStream outputStream) {
        if (this.binarydoc == null) {
            this.os = outputStream;
        } else {
            this.sg.setOutputStream(this.binarydoc, outputStream);
        }
    }

    protected void closeReader() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    void discardTempData(boolean bl) {
        this.closeReader();
        super.discardTempData(bl);
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line, 0);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    protected float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    protected int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    protected int parseIntNext(String string) {
        return Parser.parseInt(string, this.next);
    }

    protected float[] parseFloatArray(String string) {
        this.next[0] = 0;
        return Parser.parseFloatArray(string, this.next);
    }

    protected float[] parseFloatArray() {
        return Parser.parseFloatArray(this.line, this.next);
    }

    protected String getNextQuotedString() {
        return Parser.getNextQuotedString(this.line, this.next);
    }

    protected void skipTo(String string, String string2) throws Exception {
        if (string != null) {
            while (this.readLine().indexOf(string) < 0) {
            }
        }
        if (string2 != null) {
            this.next[0] = this.line.indexOf(string2) + string2.length() + 2;
        }
    }

    protected String readLine() throws Exception {
        this.line = this.br.readLine();
        if (this.line != null) {
            this.nBytes += (long)this.line.length();
            if (this.os != null) {
                this.os.write(this.line.getBytes());
                this.os.write(10);
            }
        }
        return this.line;
    }
}

