/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jmol.api.Interface;
import org.jmol.api.JmolImageCreatorInterface;
import org.jmol.api.JmolPdfCreatorInterface;
import org.jmol.api.JmolViewer;
import org.jmol.export.image.GifEncoder;
import org.jmol.export.image.ImageSelection;
import org.jmol.export.image.PngEncoder;
import org.jmol.export.image.PpmEncoder;
import org.jmol.util.Base64;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class ImageCreator
implements JmolImageCreatorInterface {
    private Viewer viewer;
    private double privateKey;

    public ImageCreator() {
    }

    public ImageCreator(JmolViewer jmolViewer) {
        this.viewer = (Viewer)jmolViewer;
    }

    public void setViewer(JmolViewer jmolViewer, double d) {
        this.viewer = (Viewer)jmolViewer;
        this.privateKey = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clipImage(String string) {
        String string2;
        try {
            if (string == null) {
                Image image = (Image)this.viewer.getScreenImage(null);
                ImageSelection.setClipboard(image);
                string2 = "OK image to clipboard: " + image.getWidth(null) * image.getHeight(null);
            } else {
                ImageSelection.setClipboard(string);
                string2 = "OK text to clipboard: " + string.length();
            }
        }
        catch (Error error) {
            string2 = this.viewer.getErrorMessage();
        }
        finally {
            if (string == null) {
                this.viewer.releaseScreenImage();
            }
        }
        return string2;
    }

    public String getClipboardText() {
        return ImageSelection.getClipboardText();
    }

    public static String getClipboardTextStatic() {
        return ImageSelection.getClipboardText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createImage(String string, String string2, Object object, int n) {
        String string3;
        long l;
        block41: {
            Object object2;
            if (!this.viewer.checkPrivateKey(this.privateKey)) {
                return "NO SECURITY";
            }
            boolean bl = object instanceof byte[] || object instanceof Image;
            boolean bl2 = object instanceof Object[];
            if (bl2) {
                object = ((Object[])object)[0];
            }
            String string4 = bl ? null : (String)object;
            boolean bl3 = n == Integer.MIN_VALUE;
            FileOutputStream fileOutputStream = null;
            l = -1L;
            try {
                if ("OutputStream".equals(string2)) {
                    FileOutputStream fileOutputStream2 = new FileOutputStream(string);
                    return fileOutputStream2;
                }
                if ((bl3 || bl) && object == null) {
                    String string5 = "NO DATA";
                    return string5;
                }
                if (bl) {
                    if (object instanceof Image) {
                        this.getImageBytes(string2, n, string, object, null);
                        String string6 = string;
                        return string6;
                    }
                    l = ((byte[])object).length;
                    fileOutputStream = new FileOutputStream(string);
                    fileOutputStream.write((byte[])object);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    break block41;
                }
                if (bl3) {
                    fileOutputStream = new FileOutputStream(string);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, 8192);
                    l = string4.length();
                    bufferedWriter.write(string4);
                    bufferedWriter.close();
                    fileOutputStream = null;
                } else {
                    l = 1L;
                    Object object3 = this.getImageBytes(string2, n, string, bl2 ? object : null, null);
                    if (object3 instanceof String) {
                        Object object4 = object3;
                        return object4;
                    }
                    object2 = (byte[])object3;
                    if (object2 != null) {
                        String string7 = new String((byte[])object2);
                        return string7;
                    }
                    l = new File(string).length();
                }
            }
            catch (IOException iOException) {
                if (iOException != null) {
                    Logger.error("IO Exception", iOException);
                    object2 = iOException.toString();
                    return object2;
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (l < 0L) {
            string3 = "Creation of " + string + " failed: " + this.viewer.getErrorMessageUntranslated();
            return string3;
        }
        string3 = "OK " + string2 + " " + l + " " + string + (n == Integer.MIN_VALUE ? "" : "; quality=" + n);
        return string3;
    }

    public Object getImageBytes(String string, int n, String string2, Object object, OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        String string3 = null;
        string = string.toUpperCase();
        boolean bl = string.equals("PDF");
        boolean bl2 = outputStream == null && string2 != null && !bl;
        boolean bl3 = outputStream == null && string2 == null && !bl;
        boolean bl4 = object instanceof Image;
        Image image = (Image)(bl4 ? object : this.viewer.getScreenImage(null));
        try {
            if (image == null) {
                string3 = this.viewer.getErrorMessage();
            } else {
                boolean bl5;
                Object object2 = null;
                boolean bl6 = bl5 = bl3 && string.equals("PNGJ") || !bl3 && object == null;
                if (string.equals("PNGJ") && bl5) {
                    object2 = this.viewer.getWrappedState(true, true, image.getWidth(null), image.getHeight(null));
                }
                if (bl2) {
                    outputStream = new FileOutputStream(string2);
                }
                if (string.equals("JPEG") || string.equals("JPG")) {
                    if (n <= 0) {
                        n = 75;
                    }
                    if (bl3) {
                        byArray = JpegEncoder.getBytes(this.viewer.getApiPlatform(), image, n, Viewer.getJmolVersion());
                    } else {
                        JpegEncoder.write(this.viewer.getApiPlatform(), image, n, outputStream, (String)this.viewer.getWrappedState(true, false, image.getWidth(null), image.getHeight(null)));
                        byArray = null;
                    }
                } else if (string.equals("JPG64") || string.equals("JPEG64")) {
                    if (n <= 0) {
                        n = 75;
                    }
                    byArray = JpegEncoder.getBytes(this.viewer.getApiPlatform(), image, n, Viewer.getJmolVersion());
                    if (bl3) {
                        byArray = Base64.getBytes64(byArray);
                    } else {
                        Base64.write(byArray, outputStream);
                        byArray = null;
                    }
                } else if (string.startsWith("PNG")) {
                    byte[] byArray2;
                    if (n < 0) {
                        n = 2;
                    } else if (n > 9) {
                        n = 9;
                    }
                    int n2 = string.equals("PNGT") ? this.viewer.getBackgroundArgb() : 0;
                    byArray = PngEncoder.getBytes(image, n, n2, string);
                    byte[] byArray3 = null;
                    if (bl5) {
                        byArray2 = ("" + byArray.length).getBytes();
                        byArray3 = byArray;
                        int n3 = byArray2.length;
                        int n4 = 63;
                        while (--n3 >= 0) {
                            byArray3[n4] = byArray2[n3];
                            --n4;
                        }
                        if (object2 == null) {
                            object2 = this.viewer.getWrappedState(true, false, image.getWidth(null), image.getHeight(null));
                        }
                        byArray = object2 instanceof byte[] ? (byte[])object2 : ((String)object2).getBytes();
                        byArray2 = ("" + byArray.length).getBytes();
                        n3 = byArray2.length;
                        n4 = 73;
                        while (--n3 >= 0) {
                            byArray3[n4] = byArray2[n3];
                            --n4;
                        }
                    }
                    if (!bl3) {
                        if (byArray3 != null) {
                            outputStream.write(byArray3);
                        }
                        outputStream.write(byArray);
                        byArray = null;
                        byArray3 = null;
                    } else if (byArray3 != null) {
                        byArray2 = new byte[byArray3.length + byArray.length];
                        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                        System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
                        byArray = byArray2;
                        byArray2 = null;
                        byArray3 = null;
                    }
                } else if (string.equals("PPM")) {
                    if (bl3) {
                        byArray = PpmEncoder.getBytes(image);
                    } else {
                        PpmEncoder.write(image, outputStream);
                        byArray = null;
                    }
                } else if (string.equals("GIF")) {
                    if (bl3) {
                        byArray = GifEncoder.getBytes(image);
                    } else {
                        GifEncoder.write(image, outputStream);
                        byArray = null;
                    }
                } else if (string.equals("PDF")) {
                    JmolPdfCreatorInterface jmolPdfCreatorInterface = (JmolPdfCreatorInterface)Interface.getApplicationInterface("jmolpanel.PdfCreator");
                    string3 = jmolPdfCreatorInterface.createPdfDocument(string2, image);
                }
                if (object != null && outputStream != null) {
                    byte[] byArray4;
                    Object object3 = object instanceof byte[] ? (byte[])object : (byArray4 = (Object)(object instanceof String ? ((String)object).getBytes() : null));
                    if (byArray4 != null) {
                        outputStream.write(byArray4);
                    }
                }
                if (outputStream != null) {
                    outputStream.flush();
                }
                if (bl2) {
                    outputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            if (!bl4) {
                this.viewer.releaseScreenImage();
            }
            throw new IOException("" + iOException);
        }
        catch (Error error) {
            if (!bl4) {
                this.viewer.releaseScreenImage();
            }
            throw new Error(error);
        }
        if (!bl4) {
            this.viewer.releaseScreenImage();
        }
        if (string3 != null) {
            return string3;
        }
        return byArray;
    }
}

