/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Geodesic;
import org.jmol.util.MeshSurface;

class MeshData {
    MeshData() {
    }

    static MeshSurface getCircleData() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            nArrayArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        Tuple3f[] tuple3fArray2 = new Point3f[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            tuple3fArray[i] = new Point3f(f, f2, 0.0f);
            tuple3fArray2[i] = new Point3f(0.0f, 0.0f, 1.0f);
        }
        tuple3fArray[n2] = new Point3f(0.0f, 0.0f, 0.0f);
        tuple3fArray2[n2] = new Point3f(0.0f, 0.0f, 1.0f);
        return new MeshSurface(nArrayArray, tuple3fArray, 0, tuple3fArray2, 0);
    }

    static MeshSurface getTriangleData(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Tuple3f[] tuple3fArray = new Point3f[]{point3f, point3f2, point3f3};
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        vector3f.set(point3f3);
        vector3f.sub(point3f);
        vector3f2.set(point3f2);
        vector3f2.sub(point3f);
        vector3f2.cross(vector3f2, vector3f);
        vector3f2.normalize();
        Tuple3f[] tuple3fArray2 = new Vector3f[]{vector3f2, vector3f2, vector3f2};
        int[][] nArrayArray = new int[][]{{0, 1, 2}};
        return new MeshSurface(nArrayArray, tuple3fArray, 0, tuple3fArray2, 0);
    }

    static MeshSurface getConeData() {
        int n = 10;
        int n2 = 360 / n;
        Tuple3f[] tuple3fArray = new Point3f[n2 + 1];
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            nArrayArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        double d = (double)n / 180.0 * Math.PI;
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)i * d);
            float f2 = (float)Math.sin((double)i * d);
            tuple3fArray[i] = new Point3f(f, f2, 0.0f);
        }
        tuple3fArray[n2] = new Point3f(0.0f, 0.0f, 1.0f);
        return new MeshSurface(nArrayArray, tuple3fArray, 0, tuple3fArray, 0);
    }

    static MeshSurface getCylinderData(boolean bl) {
        float f;
        float f2;
        int n;
        int n2 = 10;
        int n3 = 360 / n2 * 2;
        int n4 = n3 / 2;
        int[][] nArrayArray = new int[n3][];
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                nArrayArray[++n5] = new int[]{i + n4, (i + 1) % n4, i};
                nArrayArray[++n5] = new int[]{i + n4, (i + 1) % n4 + n4, (i + 1) % n4};
                continue;
            }
            nArrayArray[++n5] = new int[]{i, (i + 1) % n4, i + n4};
            nArrayArray[++n5] = new int[]{(i + 1) % n4, (i + 1) % n4 + n4, i + n4};
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        Tuple3f[] tuple3fArray2 = new Point3f[n3];
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos((double)(n * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n * n2) / 180.0 * Math.PI);
            tuple3fArray[n] = new Point3f(f2, f, 0.0f);
            tuple3fArray2[n] = new Point3f(f2, f, 0.0f);
        }
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            tuple3fArray[n + n4] = new Point3f(f2, f, 1.0f);
            tuple3fArray2[n + n4] = tuple3fArray2[n];
        }
        if (bl) {
            for (n = 0; n < n4; ++n) {
                tuple3fArray2[n].scale(-1.0f);
            }
        }
        return new MeshSurface(nArrayArray, tuple3fArray, 0, tuple3fArray2, 0);
    }

    static MeshSurface getSphereData() {
        int n = Geodesic.getVertexCount(2);
        short[] sArray = Geodesic.getFaceVertexes(2);
        int n2 = sArray.length / 3;
        int[][] nArrayArray = new int[n2][];
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            nArrayArray[i] = new int[]{sArray[++n3], sArray[++n3], sArray[++n3]};
        }
        Tuple3f[] tuple3fArray = new Vector3f[n];
        for (int i = 0; i < n; ++i) {
            tuple3fArray[i] = Geodesic.getVertexVector(i);
        }
        return new MeshSurface(nArrayArray, tuple3fArray, 0, tuple3fArray, 0);
    }

    static class Data {
        private int[][] faces;
        private Tuple3f[] normals;
        private int nVertices;
        private int nNormals;

        Data() {
        }

        int[][] getFaces() {
            return this.faces;
        }

        int getVertexCount() {
            return this.nVertices;
        }

        int getNormalCount() {
            return this.nNormals;
        }

        Tuple3f[] getNormals() {
            return this.normals;
        }
    }
}

