/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jmol.adapter.readers.cifpdb.CifReader;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlCmlReader
extends XmlReader {
    protected String[] tokens = new String[16];
    private int atomCount;
    private Atom[] atomArray = new Atom[100];
    private int bondCount;
    private Bond[] bondArray = new Bond[100];
    private int tokenCount;
    private int nModules = 0;
    private int moduleNestingLevel = 0;
    private boolean haveMolecule = false;
    private String localSpaceGroupName;
    private boolean processing = true;
    protected static final int START = 0;
    protected static final int CML = 1;
    protected static final int CRYSTAL = 2;
    protected static final int CRYSTAL_SCALAR = 3;
    protected static final int CRYSTAL_SYMMETRY = 4;
    protected static final int CRYSTAL_SYMMETRY_TRANSFORM3 = 5;
    protected static final int MOLECULE = 6;
    protected static final int MOLECULE_ATOM_ARRAY = 7;
    protected static final int MOLECULE_ATOM = 8;
    protected static final int MOLECULE_ATOM_SCALAR = 9;
    protected static final int MOLECULE_BOND_ARRAY = 10;
    protected static final int MOLECULE_BOND = 11;
    protected static final int MOLECULE_FORMULA = 12;
    protected static final int MOLECULE_ATOM_BUILTIN = 13;
    protected static final int MOLECULE_BOND_BUILTIN = 14;
    protected static final int MODULE = 15;
    protected static final int SYMMETRY = 17;
    protected static final int LATTICE_VECTOR = 18;
    protected int state = 0;
    private String scalarDictRef;
    private String scalarDictValue;
    private String scalarTitle;
    private String cellParameterType;
    private boolean checkedSerial;
    private boolean isSerial;
    private int moleculeNesting = 0;
    private int latticeVectorPtr = 0;
    private boolean embeddedCrystal = false;
    private Properties atomIdNames;

    XmlCmlReader() {
    }

    @Override
    protected String[] getImplementedAttributes() {
        return new String[]{"id", "title", "label", "name", "x3", "y3", "z3", "x2", "y2", "isotope", "elementType", "formalCharge", "atomId", "atomRefs2", "order", "atomRef1", "atomRef2", "dictRef", "spaceGroup"};
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        if (!this.processing) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (string2.equals("molecule")) {
                    this.state = 6;
                    this.haveMolecule = true;
                    if (this.moleculeNesting == 0) {
                        this.createNewAtomSet(map);
                    }
                    ++this.moleculeNesting;
                    break;
                }
                if (string2.equals("crystal")) {
                    this.state = 2;
                    break;
                }
                if (string2.equals("symmetry")) {
                    this.state = 17;
                    if (map.containsKey("spaceGroup")) {
                        this.localSpaceGroupName = map.get("spaceGroup");
                        break;
                    }
                    this.localSpaceGroupName = "P1";
                    this.parent.clearUnitCell();
                    break;
                }
                if (string2.equals("module")) {
                    ++this.moduleNestingLevel;
                    ++this.nModules;
                    break;
                }
                if (!string2.equals("latticeVector")) break;
                this.state = 18;
                this.setKeepChars(true);
                break;
            }
            case 2: {
                this.checkedSerial = true;
                this.isSerial = false;
                if (string2.equals("scalar")) {
                    this.state = 3;
                    this.setKeepChars(true);
                    this.scalarTitle = map.get("title");
                    this.getDictRefValue(map);
                    break;
                }
                if (string2.equals("symmetry")) {
                    this.state = 4;
                    if (!map.containsKey("spaceGroup")) break;
                    this.localSpaceGroupName = map.get("spaceGroup");
                    for (int i = 0; i < this.localSpaceGroupName.length(); ++i) {
                        if (this.localSpaceGroupName.charAt(i) != '_') continue;
                        this.localSpaceGroupName = this.localSpaceGroupName.substring(0, i) + this.localSpaceGroupName.substring(i-- + 1);
                    }
                    break;
                }
                if (!string2.equals("cellParameter") || !map.containsKey("parameterType")) break;
                this.cellParameterType = map.get("parameterType");
                this.setKeepChars(true);
                break;
            }
            case 18: {
                this.setKeepChars(true);
                break;
            }
            case 3: 
            case 4: 
            case 17: {
                if (!string2.equals("transform3")) break;
                this.state = 5;
                this.setKeepChars(true);
                break;
            }
            case 5: 
            case 6: {
                int n;
                if (string2.equals("crystal")) {
                    this.state = 2;
                    this.embeddedCrystal = true;
                }
                if (string2.equals("molecule")) {
                    this.state = 6;
                    ++this.moleculeNesting;
                }
                if (string2.equals("bondArray")) {
                    this.state = 10;
                    this.bondCount = 0;
                    if (map.containsKey("order")) {
                        this.breakOutBondTokens(map.get("order"));
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].order = this.parseBondToken(this.tokens[n]);
                        }
                    }
                    if (map.containsKey("atomRef1")) {
                        this.breakOutBondTokens(map.get("atomRef1"));
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].atomIndex1 = this.atomSetCollection.getAtomIndexFromName(this.tokens[n]);
                        }
                    }
                    if (map.containsKey("atomRef2")) {
                        this.breakOutBondTokens(map.get("atomRef2"));
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].atomIndex2 = this.atomSetCollection.getAtomIndexFromName(this.tokens[n]);
                        }
                    }
                }
                if (string2.equals("atomArray")) {
                    int n2;
                    this.state = 7;
                    this.atomCount = 0;
                    n = 0;
                    if (map.containsKey("atomID")) {
                        this.breakOutAtomTokens(map.get("atomID"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].atomName = this.tokens[n2];
                        }
                    }
                    if (map.containsKey("x3")) {
                        n = 1;
                        this.breakOutAtomTokens(map.get("x3"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].x = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (map.containsKey("y3")) {
                        this.breakOutAtomTokens(map.get("y3"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].y = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (map.containsKey("z3")) {
                        this.breakOutAtomTokens(map.get("z3"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].z = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (map.containsKey("x2")) {
                        this.breakOutAtomTokens(map.get("x2"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].x = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (map.containsKey("y2")) {
                        this.breakOutAtomTokens(map.get("y2"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].y = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (map.containsKey("elementType")) {
                        this.breakOutAtomTokens(map.get("elementType"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].elementSymbol = this.tokens[n2];
                        }
                    }
                    n2 = this.atomCount;
                    while (--n2 >= 0) {
                        Atom atom = this.atomArray[n2];
                        if (n == 0) {
                            atom.z = 0.0f;
                        }
                        this.addAtom(atom);
                    }
                }
                if (!string2.equals("formula")) break;
                this.state = 12;
                break;
            }
            case 10: {
                if (!string2.equals("bond")) break;
                this.state = 11;
                int n = -1;
                this.tokenCount = 0;
                if (map.containsKey("atomRefs2")) {
                    this.breakOutTokens(map.get("atomRefs2"));
                }
                if (map.containsKey("order")) {
                    n = this.parseBondToken(map.get("order"));
                }
                if (this.tokenCount != 2 || n <= 0) break;
                this.addNewBond(this.tokens[0], this.tokens[1], n);
                break;
            }
            case 7: {
                if (!string2.equals("atom")) break;
                this.state = 8;
                this.atom = new Atom();
                this.parent.setFractionalCoordinates(false);
                String string4 = map.get("id");
                this.atom.atomName = map.containsKey("name") ? map.get("name") : (map.containsKey("title") ? map.get("title") : (map.containsKey("label") ? map.get("label") : string4));
                if (!this.checkedSerial) {
                    this.isSerial = string4 != null && string4.length() > 1 && string4.startsWith("a") && Parser.parseInt((String)string4.substring(1)) != Integer.MIN_VALUE;
                    this.checkedSerial = true;
                }
                if (this.isSerial) {
                    this.atom.atomSerial = Parser.parseInt((String)string4.substring(1));
                }
                if (map.containsKey("xFract") && (this.parent.iHaveUnitCell || !map.containsKey("x3"))) {
                    this.parent.setFractionalCoordinates(true);
                    this.atom.set(this.parseFloat(map.get("xFract")), this.parseFloat(map.get("yFract")), this.parseFloat(map.get("zFract")));
                } else if (map.containsKey("x3")) {
                    this.atom.set(this.parseFloat(map.get("x3")), this.parseFloat(map.get("y3")), this.parseFloat(map.get("z3")));
                } else if (map.containsKey("x2")) {
                    this.atom.set(this.parseFloat(map.get("x2")), this.parseFloat(map.get("y2")), 0.0f);
                }
                if (map.containsKey("elementType")) {
                    String string5 = map.get("elementType");
                    if (map.containsKey("isotope")) {
                        this.atom.elementNumber = (short)((this.parseInt(map.get("isotope")) << 7) + JmolAdapter.getElementNumber((String)string5));
                    }
                    this.atom.elementSymbol = string5;
                }
                if (!map.containsKey("formalCharge")) break;
                this.atom.formalCharge = this.parseInt(map.get("formalCharge"));
                break;
            }
            case 11: {
                if (!map.containsKey("builtin")) break;
                this.setKeepChars(true);
                this.state = 14;
                this.scalarDictValue = map.get("builtin");
                break;
            }
            case 8: {
                if (string2.equals("scalar")) {
                    this.state = 9;
                    this.setKeepChars(true);
                    this.scalarTitle = map.get("title");
                    this.getDictRefValue(map);
                    break;
                }
                if (!map.containsKey("builtin")) break;
                this.setKeepChars(true);
                this.state = 13;
                this.scalarDictValue = map.get("builtin");
                break;
            }
            case 9: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
        }
    }

    private void addNewBond(String string, String string2, int n) {
        this.parent.applySymmetryToBonds = true;
        if (this.isSerial) {
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(Parser.parseInt((String)string.substring(1)), Parser.parseInt((String)string2.substring(1)), n);
        } else {
            this.atomSetCollection.addNewBond(string, string2, n);
        }
    }

    private void getDictRefValue(Map<String, String> map) {
        this.scalarDictRef = map.get("dictRef");
        if (this.scalarDictRef != null) {
            int n = this.scalarDictRef.indexOf(":");
            this.scalarDictValue = this.scalarDictRef.substring(n + 1);
        }
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if (!this.processing) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (!string2.equals("module") || --this.moduleNestingLevel != 0) break;
                if (this.parent.iHaveUnitCell) {
                    this.applySymmetryAndSetTrajectory();
                }
                this.atomIdNames = this.atomSetCollection.setAtomNames(this.atomIdNames);
                break;
            }
            case 2: {
                if (string2.equals("crystal")) {
                    if (this.embeddedCrystal) {
                        this.state = 6;
                        this.embeddedCrystal = false;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                if (!string2.equals("cellParameter") || !this.keepChars) break;
                String[] stringArray = XmlCmlReader.getTokens((String)this.chars);
                this.setKeepChars(false);
                if (stringArray.length == 3 && this.cellParameterType != null) {
                    if (this.cellParameterType.equals("length")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i, this.parseFloat(stringArray[i]));
                        }
                        break;
                    }
                    if (this.cellParameterType.equals("angle")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i + 3, this.parseFloat(stringArray[i]));
                        }
                        break;
                    }
                }
                Logger.error((String)("bad cellParameter information: parameterType=" + this.cellParameterType + " data=" + this.chars));
                this.parent.setFractionalCoordinates(false);
                break;
            }
            case 3: {
                if (string2.equals("scalar")) {
                    this.state = 2;
                    if (this.scalarTitle != null) {
                        this.checkUnitCellItem(AtomSetCollection.notionalUnitcellTags, this.scalarTitle);
                    } else if (this.scalarDictRef != null) {
                        this.checkUnitCellItem(CifReader.cellParamNames, this.scalarDictValue.startsWith("_") ? this.scalarDictValue : "_" + this.scalarDictValue);
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 5: {
                if (!string2.equals("transform3")) break;
                this.setKeepChars(false);
                this.state = 4;
                break;
            }
            case 18: {
                float[] fArray = XmlCmlReader.getTokensFloat((String)this.chars, null, (int)3);
                this.parent.addPrimitiveLatticeVector(this.latticeVectorPtr, fArray, 0);
                this.latticeVectorPtr = (this.latticeVectorPtr + 1) % 3;
                this.setKeepChars(false);
                this.state = 0;
                break;
            }
            case 4: 
            case 17: {
                if (string2.equals("symmetry")) {
                    int n = this.state = this.state == 4 ? 2 : 0;
                }
                if (this.moduleNestingLevel != 0 || !this.parent.iHaveUnitCell || this.embeddedCrystal) break;
                this.applySymmetryAndSetTrajectory();
                break;
            }
            case 6: {
                if (!string2.equals("molecule")) break;
                if (--this.moleculeNesting == 0) {
                    this.applySymmetryAndSetTrajectory();
                    this.atomIdNames = this.atomSetCollection.setAtomNames(this.atomIdNames);
                    this.state = 0;
                    break;
                }
                this.state = 6;
                break;
            }
            case 10: {
                if (!string2.equals("bondArray")) break;
                this.state = 6;
                for (int i = 0; i < this.bondCount; ++i) {
                    this.atomSetCollection.addBond(this.bondArray[i]);
                }
                this.parent.applySymmetryToBonds = true;
                break;
            }
            case 7: {
                if (!string2.equals("atomArray")) break;
                this.state = 6;
                for (int i = 0; i < this.atomCount; ++i) {
                    this.addAtom(this.atomArray[i]);
                }
                break;
            }
            case 11: {
                if (!string2.equals("bond")) break;
                this.state = 10;
                break;
            }
            case 8: {
                if (!string2.equals("atom")) break;
                this.state = 7;
                this.addAtom(this.atom);
                this.atom = null;
                break;
            }
            case 9: {
                if (string2.equals("scalar")) {
                    this.state = 8;
                    if ("jmol:charge".equals(this.scalarDictRef)) {
                        this.atom.partialCharge = this.parseFloat(this.chars);
                    } else if (this.scalarDictRef != null && "_atom_site_label".equals(this.scalarDictValue)) {
                        if (this.atomIdNames == null) {
                            this.atomIdNames = new Properties();
                        }
                        this.atomIdNames.put(this.atom.atomName, this.chars);
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 13: {
                this.state = 8;
                if (this.scalarDictValue.equals("x3")) {
                    this.atom.x = this.parseFloat(this.chars);
                } else if (this.scalarDictValue.equals("y3")) {
                    this.atom.y = this.parseFloat(this.chars);
                } else if (this.scalarDictValue.equals("z3")) {
                    this.atom.z = this.parseFloat(this.chars);
                } else if (this.scalarDictValue.equals("elementType")) {
                    this.atom.elementSymbol = this.chars;
                }
                this.setKeepChars(false);
                break;
            }
            case 14: {
                int n;
                this.state = 11;
                if (this.scalarDictValue.equals("atomRef")) {
                    if (this.tokenCount == 0) {
                        this.tokens = new String[2];
                    }
                    if (this.tokenCount < 2) {
                        this.tokens[this.tokenCount++] = this.chars;
                    }
                } else if (this.scalarDictValue.equals("order") && (n = this.parseBondToken(this.chars)) > 0 && this.tokenCount == 2) {
                    this.addNewBond(this.tokens[0], this.tokens[1], n);
                }
                this.setKeepChars(false);
                break;
            }
            case 12: {
                this.state = 6;
            }
        }
    }

    private void checkUnitCellItem(String[] stringArray, String string) {
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            this.parent.setUnitCellItem(n, this.parseFloat(this.chars));
            return;
        }
    }

    private void addAtom(Atom atom) {
        if (atom.elementSymbol == null && atom.elementNumber < 0 || Float.isNaN(atom.z)) {
            return;
        }
        this.parent.setAtomCoord(atom);
        if (this.isSerial) {
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        } else {
            this.atomSetCollection.addAtomWithMappedName(atom);
        }
    }

    int parseBondToken(String string) {
        float f = this.parseFloat(string);
        if (Float.isNaN(f) && string.length() >= 1) {
            string = string.toUpperCase();
            switch (string.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
                case 'P': {
                    return 66;
                }
            }
            return this.parseInt(string);
        }
        if ((double)f == 1.5) {
            return 515;
        }
        if (f == 2.0f) {
            return 2;
        }
        if (f == 3.0f) {
            return 3;
        }
        return 1;
    }

    void breakOutTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.tokenCount = stringTokenizer.countTokens();
        if (this.tokenCount > this.tokens.length) {
            this.tokens = new String[this.tokenCount];
        }
        for (int i = 0; i < this.tokenCount; ++i) {
            try {
                this.tokens[i] = stringTokenizer.nextToken();
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.tokens[i] = null;
            }
        }
    }

    void breakOutAtomTokens(String string) {
        this.breakOutTokens(string);
        this.checkAtomArrayLength(this.tokenCount);
    }

    void checkAtomArrayLength(int n) {
        if (this.atomCount == 0) {
            if (n > this.atomArray.length) {
                this.atomArray = new Atom[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.atomArray[n2] = new Atom();
            }
            this.atomCount = n;
        } else if (n != this.atomCount) {
            throw new IndexOutOfBoundsException("bad atom attribute length");
        }
    }

    void breakOutBondTokens(String string) {
        this.breakOutTokens(string);
        this.checkBondArrayLength(this.tokenCount);
    }

    void checkBondArrayLength(int n) {
        if (this.bondCount == 0) {
            if (n > this.bondArray.length) {
                this.bondArray = new Bond[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.bondArray[n2] = new Bond();
            }
            this.bondCount = n;
        } else if (n != this.bondCount) {
            throw new IndexOutOfBoundsException("bad bond attribute length");
        }
    }

    private void createNewAtomSet(Map<String, String> map) {
        this.atomSetCollection.newAtomSet();
        String string = null;
        if (map.containsKey("title")) {
            string = map.get("title");
        } else if (map.containsKey("id")) {
            string = map.get("id");
        }
        if (string != null) {
            this.atomSetCollection.setAtomSetName(string);
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() {
        if (this.moduleNestingLevel > 0 || !this.haveMolecule || this.localSpaceGroupName == null) {
            return;
        }
        this.parent.setSpaceGroupName(this.localSpaceGroupName);
        this.parent.iHaveSymmetryOperators = this.iHaveSymmetryOperators;
        this.parent.applySymmetryAndSetTrajectory();
    }
}

