/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlChem3dReader
extends XmlReader {
    private List<Map<String, Object>> orbitals = new ArrayList<Map<String, Object>>();
    private Map<String, Object> moData;

    XmlChem3dReader() {
    }

    @Override
    protected String[] getImplementedAttributes() {
        return new String[]{"id", "symbol", "cartCoords", "bondAtom1", "bondAtom2", "bondOrder", "gridDatXDim", "gridDatYDim", "gridDatZDim", "gridDatXSize", "gridDatYSize", "gridDatZSize", "gridDatOrigin", "gridDatDat", "calcPartialCharges", "calcAtoms"};
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, Object object, XmlReader.JmolXmlHandler jmolXmlHandler) {
        super.processXml(xmlReader, atomSetCollection, bufferedReader, object, jmolXmlHandler);
        this.setMOData(this.moData);
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        int n;
        String[] stringArray;
        if ("model".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string2)) {
            this.atom = new Atom();
            this.atom.atomName = map.get("id");
            this.atom.elementSymbol = map.get("symbol");
            if (map.containsKey("cartCoords")) {
                String string4 = map.get("cartCoords");
                String[] stringArray2 = XmlChem3dReader.getTokens((String)string4);
                this.atom.set(this.parseFloat(stringArray2[0]), this.parseFloat(stringArray2[1]), this.parseFloat(stringArray2[2]));
            }
            return;
        }
        if ("bond".equals(string2)) {
            String string5 = map.get("bondAtom1");
            String string6 = map.get("bondAtom2");
            int n2 = 1;
            if (map.containsKey("bondOrder")) {
                n2 = this.parseInt(map.get("bondOrder"));
            }
            this.atomSetCollection.addNewBond(string5, string6, n2);
            return;
        }
        if ("electronicStructureCalculation".equals(string2)) {
            stringArray = XmlChem3dReader.getTokens((String)map.get("calcPartialCharges"));
            String[] stringArray3 = XmlChem3dReader.getTokens((String)map.get("calcAtoms"));
            n = this.parseInt(stringArray[0]);
            while (--n >= 0) {
                this.atomSetCollection.mapPartialCharge(stringArray3[n + 1], this.parseFloat(stringArray[n + 1]));
            }
        }
        if ("gridData".equals(string2)) {
            int n3;
            int n4;
            int n5;
            int n6 = this.parseInt(map.get("gridDatXDim"));
            n = this.parseInt(map.get("gridDatYDim"));
            int n7 = this.parseInt(map.get("gridDatZDim"));
            float f = this.parseFloat(map.get("gridDatXSize")) / (float)n6;
            float f2 = this.parseFloat(map.get("gridDatYSize")) / (float)n;
            float f3 = this.parseFloat(map.get("gridDatZSize")) / (float)n7;
            stringArray = XmlChem3dReader.getTokens((String)map.get("gridDatOrigin"));
            float f4 = this.parseFloat(stringArray[0]);
            float f5 = this.parseFloat(stringArray[1]);
            float f6 = this.parseFloat(stringArray[2]);
            stringArray = XmlChem3dReader.getTokens((String)map.get("gridDatData"));
            int n8 = 1;
            float[][][] fArray = new float[n6][n][n7];
            float f7 = 0.0f;
            for (n5 = 0; n5 < n7; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        float f8;
                        fArray[n3][n4][n5] = f8 = this.parseFloat(stringArray[n8++]);
                        f7 += f8 * f8;
                    }
                }
            }
            f7 = (float)(1.0 / Math.sqrt(f7));
            for (n5 = 0; n5 < n7; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        float[] fArray2 = fArray[n3][n4];
                        int n9 = n5;
                        fArray2[n9] = fArray2[n9] * f7;
                    }
                }
            }
            VolumeDataInterface volumeDataInterface = (VolumeDataInterface)Interface.getOptionInterface((String)"jvxl.data.VolumeData");
            volumeDataInterface.setVoxelCounts(n6, n, n7);
            volumeDataInterface.setVolumetricVector(0, f, 0.0f, 0.0f);
            volumeDataInterface.setVolumetricVector(1, 0.0f, f2, 0.0f);
            volumeDataInterface.setVolumetricVector(2, 0.0f, 0.0f, f3);
            volumeDataInterface.setVolumetricOrigin(f4, f5, f6);
            volumeDataInterface.setVoxelData(fArray);
            if (this.moData == null) {
                this.moData = new Hashtable<String, Object>();
                this.moData.put("defaultCutoff", Float.valueOf(0.01f));
                this.moData.put("haveVolumeData", Boolean.TRUE);
                this.moData.put("calculationType", "Chem3D");
                this.orbitals = new ArrayList<Map<String, Object>>();
                this.moData.put("mos", this.orbitals);
            }
            Hashtable<String, VolumeDataInterface> hashtable = new Hashtable<String, VolumeDataInterface>();
            hashtable.put("volumeData", volumeDataInterface);
            this.orbitals.add(hashtable);
            Logger.info((String)("Chem3D molecular orbital data displayable using ISOSURFACE MO " + this.orbitals.size()));
            return;
        }
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if ("atom".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }
}

