/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SiestaReader
extends AtomSetCollectionReader {
    private int noAtoms;
    private float[] unitCellData = new float[9];

    protected void initializeReader() {
        this.doApplySymmetry = true;
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains("%block LatticeVectors")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readCellThenAtomsCartesian();
            }
            return true;
        }
        if (this.line.contains("outcoor: Atomic coordinates")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomsCartGeomThenCell();
            }
            return true;
        }
        return true;
    }

    private void setCell() throws Exception {
        this.fillFloatArray(null, 0, this.unitCellData);
        this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
        this.addPrimitiveLatticeVector(1, this.unitCellData, 3);
        this.addPrimitiveLatticeVector(2, this.unitCellData, 6);
    }

    private void readCellThenAtomsCartesian() throws Exception {
        this.newAtomSet();
        this.setCell();
        this.discardLinesUntilContains("AtomicCoordinatesFormat Ang");
        this.readLine();
        this.setFractionalCoordinates(false);
        while (this.readLine() != null && this.line.indexOf("%endblock Atomic") < 0) {
            String[] stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = stringArray[4];
            float f = this.parseFloat(stringArray[0]);
            float f2 = this.parseFloat(stringArray[1]);
            float f3 = this.parseFloat(stringArray[2]);
            this.setAtomCoord(atom, f, f2, f3);
        }
        this.noAtoms = this.atomSetCollection.getAtomCount();
    }

    private void newAtomSet() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.atomSetCollection.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readAtomsCartGeomThenCell() throws Exception {
        this.readLines(1);
        this.newAtomSet();
        int n = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < this.noAtoms; ++i) {
            String[] stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = stringArray[4];
            float f = this.parseFloat(stringArray[0]);
            float f2 = this.parseFloat(stringArray[1]);
            float f3 = this.parseFloat(stringArray[2]);
            atom.set(f, f2, f3);
            this.readLine();
        }
        this.discardLinesUntilContains("outcell: Unit cell vectors");
        this.setCell();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n2 = this.atomSetCollection.getAtomCount();
        for (int i = n; i < n2; ++i) {
            this.setAtomCoord(atomArray[i]);
        }
        this.discardLinesUntilContains("siesta: E_KS(eV) = ");
        String[] stringArray = this.getTokens();
        Double d = Double.parseDouble(stringArray[3]);
        this.atomSetCollection.setAtomSetEnergy("" + d, d.floatValue());
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Energy", (Object)d);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Energy", (Object)d);
        this.atomSetCollection.setAtomSetName("Energy = " + d + " eV");
    }
}

