/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class AimsReader
extends AtomSetCollectionReader {
    private boolean globalDoApplySymmetry;
    private boolean isFractional;
    private int nLatticeVectors;

    protected void initializeReader() {
        this.globalDoApplySymmetry = this.doApplySymmetry;
        this.doApplySymmetry = true;
        this.isFractional = true;
    }

    protected boolean checkLine() {
        String[] stringArray = this.getTokens();
        if (stringArray.length == 0) {
            return true;
        }
        if (stringArray[0].equals("lattice_vector")) {
            this.readLatticeVector(stringArray);
            return true;
        }
        if (stringArray[0].equals("atom")) {
            this.readAtom(stringArray, false);
            return true;
        }
        if (stringArray[0].equals("atom_frac")) {
            this.readAtom(stringArray, true);
            return true;
        }
        if (stringArray[0].equals("multipole")) {
            this.readMultipole(stringArray);
            return true;
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        this.doApplySymmetry = this.globalDoApplySymmetry;
        if (this.nLatticeVectors == 1 || this.nLatticeVectors == 2) {
            Logger.warn((String)"ignoring translation symmetry for more or less than 3 dimensions(which is currently neither supported by FHI-aims");
        }
        super.finalizeReader();
    }

    private void readLatticeVector(String[] stringArray) {
        if (stringArray.length < 4) {
            Logger.warn((String)("cannot read line with FHI-aims lattice vector: " + this.line));
        } else if (this.nLatticeVectors == 3) {
            Logger.warn((String)("more than 3 FHI-aims lattice vectors found with line: " + this.line));
        } else {
            this.addPrimitiveLatticeVector(this.nLatticeVectors++, new float[]{this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3])}, 0);
            this.setFractionalCoordinates(this.nLatticeVectors == 3);
        }
    }

    private void readAtom(String[] stringArray, boolean bl) {
        if (stringArray.length < 5) {
            Logger.warn((String)("cannot read line with FHI-aims line: " + this.line));
            return;
        }
        if (this.isFractional != bl) {
            this.isFractional = bl;
            this.setFractionalCoordinates(this.isFractional);
        }
        Atom atom = this.atomSetCollection.addNewAtom();
        this.setAtomCoord(atom, this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        atom.elementSymbol = stringArray[4];
    }

    private void readMultipole(String[] stringArray) {
        if (stringArray.length < 6) {
            Logger.warn((String)("cannot read line with FHI-aims atom data: " + this.line));
            return;
        }
        int n = this.parseInt(stringArray[4]);
        if (n > 0) {
            Logger.warn((String)("multipole line ignored since only monopoles are currently supported: " + this.line));
            return;
        }
        if (this.isFractional) {
            this.isFractional = false;
            this.setFractionalCoordinates(false);
        }
        Atom atom = this.atomSetCollection.addNewAtom();
        this.setAtomCoord(atom, this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        atom.partialCharge = this.parseFloat(stringArray[5]);
    }
}

