/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumStructure;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AminoPolymer
extends AlphaPolymer {
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.25f;
    private static int[][] sheetOffsets = new int[][]{{0, -1, 1, 0, 1, 0, 0, -1}, {0, 0, 0, 0, 1, -1, 1, -1}};
    private Map<EnumStructure, float[]> structureList;

    AminoPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 1;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)monomerArray[i]).hasOAtom()) continue;
            return;
        }
        this.hasWingPoints = true;
    }

    @Override
    protected void resetHydrogenPoints() {
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                proteinStructure = proteinStructure2;
                proteinStructure.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    @Override
    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles(AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        Atom atom = aminoMonomer.getNitrogenAtom();
        Atom atom2 = aminoMonomer.getLeadAtom();
        Atom atom3 = aminoMonomer.getCarbonylCarbonAtom();
        Atom atom4 = aminoMonomer2.getNitrogenAtom();
        Atom atom5 = aminoMonomer2.getLeadAtom();
        Atom atom6 = aminoMonomer2.getCarbonylCarbonAtom();
        aminoMonomer2.setGroupParameter(1112539143, Measure.computeTorsion((Tuple3f)atom3, (Tuple3f)atom4, (Tuple3f)atom5, (Tuple3f)atom6, (boolean)true));
        aminoMonomer.setGroupParameter(1112539144, Measure.computeTorsion((Tuple3f)atom, (Tuple3f)atom2, (Tuple3f)atom3, (Tuple3f)atom4, (boolean)true));
        aminoMonomer.setGroupParameter(1112539142, Measure.computeTorsion((Tuple3f)atom2, (Tuple3f)atom3, (Tuple3f)atom4, (Tuple3f)atom5, (boolean)true));
    }

    @Override
    protected float calculateRamachandranHelixAngle(int n, char c) {
        float f = n == 0 ? Float.NaN : this.monomers[n - 1].getGroupParameter(1112539144);
        float f2 = this.monomers[n].getGroupParameter(1112539144);
        float f3 = this.monomers[n].getGroupParameter(1112539143);
        float f4 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539143);
        float f5 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539144);
        switch (c) {
            default: {
                float f6 = (float)((double)((f4 - f3) / 2.0f) * Math.PI / 180.0);
                float f7 = (float)((double)((f5 - f2) / 2.0f) * Math.PI / 180.0);
                return (float)(114.59155902616465 * Math.acos(Math.cos(f7) * Math.cos(f6) - Math.sin(f7) * Math.sin(f6) / 3.0));
            }
            case 'C': 
            case 'c': 
        }
        return f2 - f + f4 - f3;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BitSet bitSet, BitSet bitSet2, List<Bond> list, int n, int[][][] nArray, boolean bl, boolean bl2) {
        if (bioPolymer == null) {
            bioPolymer = this;
        }
        if (!(bioPolymer instanceof AminoPolymer)) {
            return;
        }
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        int[][] nArray2 = nArray == null ? new int[2][3] : (int[][])null;
        for (int i = 1; i < this.monomerCount; ++i) {
            boolean bl3;
            if (nArray == null) {
                int n2 = this.bioPolymerIndexInModel;
                nArray2[1][0] = n2;
                nArray2[0][0] = n2;
                nArray2[1][1] = Integer.MIN_VALUE;
                nArray2[0][1] = Integer.MIN_VALUE;
                nArray2[1][2] = 0;
                nArray2[0][2] = 0;
            } else {
                nArray2 = nArray[i];
            }
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[i];
            if (!aminoMonomer.getNHPoint(point3f, vector3f, bl, bl2)) continue;
            boolean bl4 = bl3 = bitSet == null || bitSet.get(aminoMonomer.getNitrogenAtom().index);
            if (!bl3 || !bl && aminoMonomer.getCarbonylOxygenAtom() == null) continue;
            this.checkRasmolHydrogenBond(aminoMonomer, bioPolymer, i, point3f, bl3 ? bitSet2 : bitSet, list, nArray2, bl);
        }
    }

    private void checkRasmolHydrogenBond(AminoMonomer aminoMonomer, BioPolymer bioPolymer, int n, Point3f point3f, BitSet bitSet, List<Bond> list, int[][] nArray, boolean bl) {
        Atom atom = aminoMonomer.getLeadAtom();
        Atom atom2 = aminoMonomer.getNitrogenAtom();
        Atom atom3 = aminoMonomer.getNitrogenAtom();
        int n2 = bioPolymer.monomerCount;
        while (--n2 >= 0) {
            int[] nArray2;
            Atom atom4;
            float f;
            AminoMonomer aminoMonomer2;
            Atom atom5;
            if (bioPolymer == this && (n2 == n || n2 + 1 == n) || (atom5 = (aminoMonomer2 = (AminoMonomer)bioPolymer.monomers[n2]).getCarbonylOxygenAtom()) == null || bitSet != null && !bitSet.get(atom5.index) || (f = atom.distanceSquared((Point3f)(atom4 = aminoMonomer2.getLeadAtom()))) >= 81.0f) continue;
            int n3 = this.calcHbondEnergy((Point3f)atom2, point3f, aminoMonomer2, bl);
            if (n3 < nArray[0][2]) {
                nArray2 = nArray[1];
                nArray[1] = nArray[0];
                nArray[0] = nArray2;
            } else {
                if (n3 >= nArray[1][2]) continue;
                nArray2 = nArray[1];
            }
            nArray2[0] = bioPolymer.bioPolymerIndexInModel;
            nArray2[1] = n3 < -500 ? n2 : -1 - n2;
            nArray2[2] = n3;
        }
        if (list != null) {
            for (n2 = 0; n2 < 2; ++n2) {
                if (nArray[n2][1] < 0) continue;
                this.addResidueHydrogenBond(atom3, ((AminoMonomer)((AminoPolymer)bioPolymer).monomers[nArray[n2][1]]).getCarbonylOxygenAtom(), bioPolymer == this ? n : -99, nArray[n2][1], (float)nArray[n2][2] / 1000.0f, list);
            }
        }
    }

    private int calcHbondEnergy(Point3f point3f, Point3f point3f2, AminoMonomer aminoMonomer, boolean bl) {
        double d;
        double d2;
        double d3;
        Atom atom = aminoMonomer.getCarbonylOxygenAtom();
        if (atom == null) {
            return 0;
        }
        float f = atom.distanceSquared(point3f);
        if (f < 0.25f) {
            return 0;
        }
        float f2 = atom.distanceSquared(point3f2);
        if (f2 < 0.25f) {
            return 0;
        }
        Atom atom2 = aminoMonomer.getCarbonylCarbonAtom();
        float f3 = atom2.distanceSquared(point3f2);
        if (f3 < 0.25f) {
            return 0;
        }
        float f4 = atom2.distanceSquared(point3f);
        if (f4 < 0.25f) {
            return 0;
        }
        double d4 = Math.sqrt(f2);
        int n = HBond.getEnergy((double)d4, (double)(d3 = Math.sqrt(f3)), (double)(d2 = Math.sqrt(f4)), (double)(d = Math.sqrt(f)));
        boolean bl2 = n < -500 && (!bl || d2 > d3 && d4 <= 3.0);
        return !bl2 && bl || n < -9900 ? 0 : n;
    }

    private void addResidueHydrogenBond(Atom atom, Atom atom2, int n, int n2, float f, List<Bond> list) {
        int n3;
        switch (n - n2) {
            case 2: {
                n3 = 6144;
                break;
            }
            case 3: {
                n3 = 8192;
                break;
            }
            case 4: {
                n3 = 10240;
                break;
            }
            case 5: {
                n3 = 12288;
                break;
            }
            case -3: {
                n3 = 14336;
                break;
            }
            case -4: {
                n3 = 16384;
                break;
            }
            default: {
                n3 = 4096;
            }
        }
        list.add((Bond)new HBond(atom, atom2, n3, f));
    }

    protected static String calculateStructuresDssp(BioPolymer[] bioPolymerArray, int n, List<Bond> list, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (n == 0) {
            return "";
        }
        Model model = bioPolymerArray[0].model;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Jmol ").append(Viewer.getJmolVersion()).append(" DSSP analysis for model ").append(model.getModelNumberDotted()).append(" - ").append(model.getModelTitle()).append("\n");
        if (model.modelIndex == 0) {
            stringBuffer.append("\nW. Kabsch and C. Sander, Biopolymers, vol 22, 1983, pp 2577-2637\n").append("\nWe thank Wolfgang Kabsch and Chris Sander for writing the DSSP software,\n").append("and we thank the CMBI for maintaining it to the extent that it was easy to\n").append("re-engineer for our purposes. At this point in time, we make no guarantee\n").append("that this code gives precisely the same analysis as the code available via license\n").append("from CMBI at http://swift.cmbi.ru.nl/gv/dssp\n");
        }
        if (bl3 && model.modelIndex == 0) {
            stringBuffer.append("\nAll bioshapes have been deleted and must be regenerated.\n");
        }
        if (model.nAltLocs > 0) {
            stringBuffer.append("\nNote: This model contains alternative locations. Use  'CONFIGURATION 1' to be consistent with CMBI DSSP.\n");
        }
        char[][] cArrayArray = new char[n][];
        BitSet[] bitSetArray = new BitSet[n];
        BitSet bitSet = new BitSet();
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            if (!(bioPolymerArray[i] instanceof AminoPolymer)) continue;
            object = (AminoPolymer)bioPolymerArray[i];
            if (!bl4 && ((AminoMonomer)((AminoPolymer)object).monomers[0]).getExplicitNH() != null) {
                if (bl2) {
                    stringBuffer.append(GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be ignored. Their positions will be approximated, as in standard DSSP analysis.\nUse {0} to not use this approximation.\n\n", (String)"SET dsspCalculateHydrogenAlways FALSE"));
                } else {
                    stringBuffer.append(GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be used. Results may differ significantly from standard DSSP analysis.\nUse {0} to ignore these hydrogen positions.\n\n", (String)"SET dsspCalculateHydrogenAlways TRUE"));
                }
                bl4 = true;
            }
            bioPolymerArray[i].recalculateLeadMidpointsAndWingVectors();
            cArrayArray[i] = new char[bioPolymerArray[i].monomerCount];
            bitSetArray[i] = new BitSet();
            for (int j = 0; j < ((AminoPolymer)object).monomerCount; ++j) {
                if (((AminoMonomer)((AminoPolymer)object).monomers[j]).getCarbonylOxygenAtom() != null) continue;
                bitSet.set(((AminoPolymer)object).monomers[j].leadAtomIndex);
            }
        }
        int[][][][] nArray = AminoPolymer.getDualHydrogenBondArray(bioPolymerArray, n, bl2);
        object = new ArrayList();
        ArrayList<Bridge> arrayList = new ArrayList<Bridge>();
        Hashtable<String, Bridge> hashtable = new Hashtable<String, Bridge>();
        Hashtable<int[][], Boolean> hashtable2 = new Hashtable<int[][], Boolean>();
        AminoPolymer.getBridges(bioPolymerArray, nArray, (List<Bridge>)object, arrayList, hashtable, hashtable2, bitSet, list, bitSetArray);
        AminoPolymer.getSheetStructures(bioPolymerArray, (List<Bridge>)object, arrayList, hashtable, hashtable2, cArrayArray, bitSetArray, bl, bl3);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == null) continue;
            stringArray[i] = ((AminoPolymer)bioPolymerArray[i]).findHelixes(nArray[i], i, bitSetArray[i], cArrayArray[i], bl, bl3, list, bitSet);
        }
        if (bl) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer.append("\n------------------------------\n");
            for (int i = 0; i < n; ++i) {
                if (cArrayArray[i] == null) continue;
                AminoPolymer aminoPolymer = (AminoPolymer)bioPolymerArray[i];
                stringBuffer2.append(aminoPolymer.dumpSummary(cArrayArray[i]));
                stringBuffer.append(stringArray[i]).append(aminoPolymer.dumpTags("$.1: " + String.valueOf(cArrayArray[i]), bitSet, 2));
            }
            if (bitSet.nextSetBit(0) >= 0) {
                stringBuffer.append("\nNOTE: '!' indicates a residue that is missing a backbone carbonyl oxygen atom.\n");
            }
            stringBuffer.append("\n").append("SUMMARY:" + stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private static int[][][][] getDualHydrogenBondArray(BioPolymer[] bioPolymerArray, int n, boolean bl) {
        int n2;
        int n3;
        int[][][][] nArrayArray = new int[n][][][];
        for (n3 = 0; n3 < n; ++n3) {
            if (!(bioPolymerArray[n3] instanceof AminoPolymer)) continue;
            n2 = bioPolymerArray[n3].monomerCount;
            nArrayArray[n3] = new int[n2][2][3];
            for (int i = 0; i < n2; ++i) {
                nArrayArray[n3][i][1][1] = Integer.MIN_VALUE;
                nArrayArray[n3][i][0][1] = Integer.MIN_VALUE;
                nArrayArray[n3][i][1][2] = 0;
                nArrayArray[n3][i][0][2] = 0;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (nArrayArray[n3] == null) continue;
            for (n2 = 0; n2 < n; ++n2) {
                if (nArrayArray[n2] == null) continue;
                bioPolymerArray[n3].calcRasmolHydrogenBonds(bioPolymerArray[n2], null, null, null, 2, nArrayArray[n3], false, bl);
            }
        }
        return nArrayArray;
    }

    private String findHelixes(int[][][] nArray, int n, BitSet bitSet, char[] cArray, boolean bl, boolean bl2, List<Bond> list, BitSet bitSet2) {
        if (Logger.debugging) {
            for (int i = 0; i < this.monomerCount; ++i) {
                Logger.debug((String)(n + "." + this.monomers[i].getResno() + "\t" + Escape.escape((Object)nArray[i])));
            }
        }
        BitSet bitSet3 = new BitSet();
        String string = this.findHelixes(4, nArray, n, EnumStructure.HELIXALPHA, 10240, bitSet, bitSet3, cArray, bl, bl2, list, bitSet2);
        String string2 = this.findHelixes(3, nArray, n, EnumStructure.HELIX310, 8192, bitSet, bitSet3, cArray, bl, bl2, list, bitSet2);
        String string3 = this.findHelixes(5, nArray, n, EnumStructure.HELIXPI, 12288, bitSet, bitSet3, cArray, bl, bl2, list, bitSet2);
        if (bl2) {
            this.setStructure(bitSet3, EnumStructure.TURN);
        }
        if (bl) {
            this.setTag(cArray, bitSet3, 'T');
            return this.dumpTags("$.5: " + string3 + "\n" + "$.4: " + string + "\n" + "$.3: " + string2, bitSet2, 1);
        }
        return "";
    }

    private String findHelixes(int n, int[][][] nArray, int n2, EnumStructure enumStructure, int n3, BitSet bitSet, BitSet bitSet2, char[] cArray, boolean bl, boolean bl2, List<Bond> list, BitSet bitSet3) {
        char[] cArray2;
        BitSet bitSet4 = new BitSet();
        BitSet bitSet5 = new BitSet();
        BitSet bitSet6 = new BitSet();
        BitSet bitSet7 = new BitSet();
        BitSet bitSet8 = new BitSet();
        String string = "";
        for (int i = n; i < this.monomerCount; ++i) {
            int n4;
            int n5;
            int n6 = i - n;
            int n7 = 0;
            if (nArray[i][0][0] != n2 || nArray[i][0][1] != n6) {
                n7 = 1;
                if (nArray[i][1][0] != n2 || nArray[i][1][1] != n6) continue;
            }
            if ((n5 = bitSet3.nextSetBit(n4 = this.monomers[n6].leadAtomIndex)) >= n4 && n5 <= this.monomers[i].leadAtomIndex) continue;
            bitSet4.set(n6);
            bitSet5.set(n6 + 1, i);
            bitSet7.set(i);
            n5 = bitSet.nextSetBit(n6);
            boolean bl3 = n5 < 0 || n5 >= i;
            boolean bl4 = false;
            if (n6 > 0 && bitSet4.get(n6 - 1) && (n == 4 || bl3)) {
                bitSet8.set(n6, i);
                if (!bl3) {
                    string = string + "  WARNING! Bridge to helix at " + (Object)((Object)this.monomers[n5]);
                }
                bl4 = true;
            } else if (bl3 || bitSet.nextClearBit(n5) < i) {
                bl4 = true;
            }
            if (bitSet7.get(n6)) {
                bitSet6.set(n6);
            }
            if (!bl4 || list == null) continue;
            AminoPolymer.addHbond(list, this.monomers[i], this.monomers[n6], nArray[i][n7][2], n3, null);
        }
        if (bl) {
            cArray2 = new char[this.monomerCount];
            this.setTag(cArray2, bitSet5, (char)(48 + n));
            this.setTag(cArray2, bitSet4, '>');
            this.setTag(cArray2, bitSet7, '<');
            this.setTag(cArray2, bitSet6, 'X');
        } else {
            cArray2 = null;
        }
        bitSet.or(bitSet8);
        bitSet5.andNot(bitSet);
        bitSet2.or(bitSet5);
        bitSet2.andNot(bitSet8);
        if (bl2) {
            this.setStructure(bitSet8, enumStructure);
        }
        if (bl) {
            this.setTag(cArray, bitSet8, (char)(68 + n));
            return String.valueOf(cArray2) + string;
        }
        return "";
    }

    private static void getBridges(BioPolymer[] bioPolymerArray, int[][][][] nArray, List<Bridge> list, List<Bridge> list2, Map<String, Bridge> map, Map<int[][], Boolean> map2, BitSet bitSet, List<Bond> list3, BitSet[] bitSetArray) {
        Atom[] atomArray = bioPolymerArray[0].model.getModelSet().atoms;
        Bridge bridge = null;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (int i = 0; i < nArray.length; ++i) {
            if (!(bioPolymerArray[i] instanceof AminoPolymer)) continue;
            AminoPolymer aminoPolymer = (AminoPolymer)bioPolymerArray[i];
            int n = nArray[i].length - 1;
            for (int j = 1; j < n; ++j) {
                int n2 = aminoPolymer.monomers[j].leadAtomIndex;
                if (bitSet.get(n2)) continue;
                for (int k = i; k < nArray.length; ++k) {
                    int n3;
                    if (!(bioPolymerArray[k] instanceof AminoPolymer)) continue;
                    int n4 = n3 = i == k ? j + 3 : 1;
                    while (n3 < nArray[k].length - 1) {
                        block8: {
                            int n5;
                            block9: {
                                AminoPolymer aminoPolymer2 = (AminoPolymer)bioPolymerArray[k];
                                n5 = aminoPolymer2.monomers[n3].leadAtomIndex;
                                if (bitSet.get(n5)) break block8;
                                bridge = AminoPolymer.getBridge(nArray, i, j, k, n3, list2, atomArray[n2], atomArray[n5], aminoPolymer, aminoPolymer2, list3, hashtable, false, map2);
                                if (bridge != null) break block9;
                                bridge = AminoPolymer.getBridge(nArray, i, j, k, n3, list, atomArray[n2], atomArray[n5], aminoPolymer, aminoPolymer2, list3, hashtable, true, map2);
                                if (bridge == null) break block8;
                                bridge.isAntiparallel = true;
                            }
                            if (Logger.debugging) {
                                Logger.debug((String)("Bridge found " + bridge));
                            }
                            bitSetArray[i].set(j);
                            bitSetArray[k].set(n3);
                            map.put(n2 + "-" + n5, bridge);
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private static Bridge getBridge(int[][][][] nArray, int n, int n2, int n3, int n4, List<Bridge> list, Atom atom, Atom atom2, AminoPolymer aminoPolymer, AminoPolymer aminoPolymer2, List<Bond> list2, Map<String, Boolean> map, boolean bl, Map<int[][], Boolean> map2) {
        block5: {
            int[] nArray2;
            int n5;
            int[] nArray3;
            int[] nArray4;
            block4: {
                nArray4 = null;
                nArray3 = null;
                n5 = 0;
                nArray2 = bl ? sheetOffsets[1] : sheetOffsets[0];
                nArray4 = AminoPolymer.isHbonded(n2 + nArray2[0], n4 + nArray2[1], n, n3, nArray);
                if (nArray4 != null && (nArray3 = AminoPolymer.isHbonded(n4 + nArray2[2], n2 + nArray2[3], n3, n, nArray)) != null) break block4;
                n5 = 4;
                nArray4 = AminoPolymer.isHbonded(n2 + nArray2[4], n4 + nArray2[5], n, n3, nArray);
                if (nArray4 == null || (nArray3 = AminoPolymer.isHbonded(n4 + nArray2[6], n2 + nArray2[7], n3, n, nArray)) == null) break block5;
            }
            AminoPolymer aminoPolymer3 = aminoPolymer;
            aminoPolymer3.getClass();
            Bridge bridge = aminoPolymer3.new Bridge(atom, atom2, map2);
            list.add(bridge);
            if (list2 != null) {
                int n6 = bl ? 14336 : 6144;
                AminoPolymer.addHbond(list2, aminoPolymer.monomers[n2 + nArray2[n5]], aminoPolymer2.monomers[n4 + nArray2[++n5]], nArray4[2], n6, map);
                AminoPolymer.addHbond(list2, aminoPolymer2.monomers[n4 + nArray2[++n5]], aminoPolymer.monomers[n2 + nArray2[++n5]], nArray3[2], n6, map);
            }
            return bridge;
        }
        return null;
    }

    private static void addHbond(List<Bond> list, Monomer monomer, Monomer monomer2, int n, int n2, Map<String, Boolean> map) {
        Atom atom = ((AminoMonomer)monomer).getNitrogenAtom();
        Atom atom2 = ((AminoMonomer)monomer2).getCarbonylOxygenAtom();
        if (map != null) {
            String string = atom.index + " " + atom2.index;
            if (map.containsKey(string)) {
                return;
            }
            map.put(string, Boolean.TRUE);
        }
        list.add((Bond)new HBond(atom, atom2, n2, (float)n / 1000.0f));
    }

    private static void getSheetStructures(BioPolymer[] bioPolymerArray, List<Bridge> list, List<Bridge> list2, Map<String, Bridge> map, Map<int[][], Boolean> map2, char[][] cArray, BitSet[] bitSetArray, boolean bl, boolean bl2) {
        Object object2;
        if (list.size() == 0 && list2.size() == 0) {
            return;
        }
        AminoPolymer.createLadders(list, map, map2, true);
        AminoPolymer.createLadders(list2, map, map2, false);
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        for (Object object2 : map2.keySet()) {
            if (object2[0][0] == object2[0][1] && object2[1][0] == object2[1][1]) {
                bitSet2.set((int)object2[0][0]);
                bitSet2.set((int)object2[1][0]);
                continue;
            }
            bitSet.set(object2[0][0], (int)(object2[0][1] + true));
            bitSet.set((int)object2[1][0], (int)(object2[1][1] + true));
        }
        object2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = bioPolymerArray.length;
        while (--n >= 0) {
            if (!(bioPolymerArray[n] instanceof AminoPolymer)) continue;
            object2.clear();
            bitSet3.clear();
            AminoPolymer aminoPolymer = (AminoPolymer)bioPolymerArray[n];
            int n2 = 0;
            while (n2 < aminoPolymer.monomerCount) {
                int n3 = aminoPolymer.monomers[n2].leadAtomIndex;
                if (bitSet.get(n3)) {
                    int n4;
                    for (n4 = n2 + 1; n4 < aminoPolymer.monomerCount && bitSet.get(aminoPolymer.monomers[n4].leadAtomIndex); ++n4) {
                    }
                    object2.set(n2, n4);
                    n2 = n4;
                    continue;
                }
                if (bitSet2.get(n3)) {
                    bitSet3.set(n2);
                }
                ++n2;
            }
            if (bl) {
                aminoPolymer.setTag(cArray[n], bitSet3, 'B');
                aminoPolymer.setTag(cArray[n], (BitSet)object2, 'E');
            }
            if (bl2) {
                aminoPolymer.setStructure((BitSet)object2, EnumStructure.SHEET);
            }
            bitSetArray[n].or((BitSet)object2);
            bitSetArray[n].or(bitSet3);
        }
    }

    private static void createLadders(List<Bridge> list, Map<String, Bridge> map, Map<int[][], Boolean> map2, boolean bl) {
        int n;
        int n2 = bl ? -1 : 1;
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            AminoPolymer.checkBridge(list.get(n), map, map2, bl, 1, n2);
        }
        for (n = 0; n < n3; ++n) {
            AminoPolymer.checkBulge(list.get(n), map, map2, bl, 1);
        }
    }

    private static boolean checkBridge(Bridge bridge, Map<String, Bridge> map, Map<int[][], Boolean> map2, boolean bl, int n, int n2) {
        Bridge bridge2 = map.get(bridge.a.getOffsetResidueAtom("0", n) + "-" + bridge.b.getOffsetResidueAtom("0", n2));
        return bridge2 != null && bridge.addBridge(bridge2, map2);
    }

    private static void checkBulge(Bridge bridge, Map<String, Bridge> map, Map<int[][], Boolean> map2, boolean bl, int n) {
        int n2 = bl ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            int n3;
            int n4 = n3 = i == 0 ? 1 : 0;
            while (n3 < 6) {
                AminoPolymer.checkBridge(bridge, map, map2, bl, i * n, n3 * n2);
                if (n3 > i) {
                    AminoPolymer.checkBridge(bridge, map, map2, bl, n3 * n, i * n2);
                }
                ++n3;
            }
        }
    }

    private void setStructure(BitSet bitSet, EnumStructure enumStructure) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            int n2 = bitSet.nextClearBit(n);
            if (n2 < 0) {
                n2 = this.monomerCount;
            }
            this.addSecondaryStructure(enumStructure, null, 0, 0, n, n2 - 1);
            n = n2;
            n = bitSet.nextSetBit(n + 1);
        }
    }

    private static int[] isHbonded(int n, int n2, int n3, int n4, int[][][][] nArray) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int[][][] nArray2 = nArray[n3];
        int[][][] nArray3 = nArray[n4];
        if (n >= nArray2.length || n2 >= nArray3.length) {
            return null;
        }
        return nArray2[n][0][0] == n4 && nArray2[n][0][1] == n2 ? nArray2[n][0] : (nArray2[n][1][0] == n4 && nArray2[n][1][1] == n2 ? nArray2[n][1] : null);
    }

    private void setTag(char[] cArray, BitSet bitSet, char c) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            cArray[n] = c;
            n = bitSet.nextSetBit(n + 1);
        }
    }

    private String dumpSummary(char[] cArray) {
        char c = this.monomers[0].getLeadAtom().getChainID();
        String string = c == '\u0000' ? "" : String.valueOf(c) + ":";
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        int n = -1;
        int n2 = -1;
        for (int i = 0; i <= this.monomerCount; ++i) {
            if (i == this.monomerCount || cArray[i] != c2) {
                if (c2 != '\u0000') {
                    stringBuffer.append('\n').append(c2).append(" : ").append(string).append(n).append(c3 == '\u0000' ? "" : String.valueOf(c3)).append("_").append(string).append(n2).append(c4 == '\u0000' ? "" : String.valueOf(c4));
                }
                if (i == this.monomerCount) break;
                c2 = cArray[i];
                n = this.monomers[i].getResno();
                c3 = this.monomers[i].getInsertionCode();
            }
            n2 = this.monomers[i].getResno();
            c4 = this.monomers[i].getInsertionCode();
        }
        return stringBuffer.toString();
    }

    private String dumpTags(String string, BitSet bitSet, int n) {
        String string2 = this.monomers[0].getLeadAtom().getChainID() + "." + (this.bioPolymerIndexInModel + 1);
        string = TextFormat.simpleReplace((String)string, (String)"$", (String)string2);
        int n2 = this.monomers[0].getResno();
        String string3 = "\n" + string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string3 + ".8: ");
        StringBuffer stringBuffer3 = new StringBuffer(string3 + ".7: ");
        StringBuffer stringBuffer4 = new StringBuffer(string3 + ".6: ");
        StringBuffer stringBuffer5 = new StringBuffer(string3 + ".0: ");
        int n3 = n2;
        for (int i = 0; i < this.monomerCount; ++i) {
            n3 = this.monomers[i].getResno();
            stringBuffer2.append(n3 % 100 == 0 ? "" + n3 / 100 % 100 : " ");
            stringBuffer3.append(n3 % 10 == 0 ? "" + n3 / 10 % 10 : " ");
            stringBuffer4.append(n3 % 10);
            stringBuffer5.append(bitSet.get(this.monomers[i].leadAtomIndex) ? (char)'!' : this.monomers[i].getGroup1());
        }
        if ((n & 1) == 1) {
            stringBuffer.append(stringBuffer2).append(stringBuffer3).append(stringBuffer4);
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        if ((n & 2) == 2) {
            stringBuffer.append(stringBuffer5);
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString().replace('\u0000', '.');
    }

    @Override
    public void calculateStructures(boolean bl) {
        int n;
        if (bl) {
            return;
        }
        if (this.structureList == null) {
            this.structureList = this.model.getModelSet().getStructureList();
        }
        char[] cArray = new char[this.monomerCount];
        for (n = 0; n < this.monomerCount - 1; ++n) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n + 1];
            float f = aminoMonomer2.getGroupParameter(1112539143);
            float f2 = aminoMonomer.getGroupParameter(1112539144);
            cArray[n] = this.isHelix(f2, f) ? (f < 0.0f && f2 < 25.0f ? 52 : 51) : (this.isSheet(f2, f) ? 115 : (this.isTurn(f2, f) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug((String)('\u0000' + this.monomers[0].getChainID() + " aminopolymer:" + n + " " + aminoMonomer2.getGroupParameter(1112539143) + "," + aminoMonomer.getGroupParameter(1112539144) + " " + cArray[n]));
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n2;
            if (cArray[n] != '4') continue;
            for (n2 = n + 1; n2 < this.monomerCount && cArray[n2] == '4'; ++n2) {
            }
            if (--n2 >= n + 3) {
                this.addSecondaryStructure(EnumStructure.HELIX, null, 0, 0, n, n2);
            }
            n = n2;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n3;
            if (cArray[n] != '3') continue;
            for (n3 = n + 1; n3 < this.monomerCount && cArray[n3] == '3'; ++n3) {
            }
            if (--n3 >= n + 3) {
                this.addSecondaryStructure(EnumStructure.HELIX, null, 0, 0, n, n3);
            }
            n = n3;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n4;
            if (cArray[n] != 's') continue;
            for (n4 = n + 1; n4 < this.monomerCount && cArray[n4] == 's'; ++n4) {
            }
            if (--n4 >= n + 2) {
                this.addSecondaryStructure(EnumStructure.SHEET, null, 0, 0, n, n4);
            }
            n = n4;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n5;
            if (cArray[n] != 't') continue;
            for (n5 = n + 1; n5 < this.monomerCount && cArray[n5] == 't'; ++n5) {
            }
            if (--n5 >= n + 2) {
                this.addSecondaryStructure(EnumStructure.TURN, null, 0, 0, n, n5);
            }
            n = n5;
        }
    }

    private boolean isTurn(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.TURN), f, f2);
    }

    private boolean isSheet(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.SHEET), f, f2);
    }

    private boolean isHelix(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.HELIX), f, f2);
    }

    private static boolean checkPhiPsi(float[] fArray, float f, float f2) {
        for (int i = 0; i < fArray.length; i += 4) {
            if (!(f2 >= fArray[i]) || !(f2 <= fArray[i + 1]) || !(f >= fArray[i + 2]) || !(f <= fArray[i + 3])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setStructureList(Map<EnumStructure, float[]> map) {
        this.structureList = map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bridge {
        protected Atom a;
        protected Atom b;
        protected int[][] ladder;
        protected boolean isAntiparallel;

        protected Bridge(Atom atom, Atom atom2, Map<int[][], Boolean> map) {
            this.a = atom;
            this.b = atom2;
            this.ladder = new int[2][2];
            int n = Math.min(atom.index, atom2.index);
            this.ladder[0][1] = n;
            this.ladder[0][0] = n;
            int n2 = Math.max(atom.index, atom2.index);
            this.ladder[1][1] = n2;
            this.ladder[1][0] = n2;
            this.addLadder(map);
        }

        private void addLadder(Map<int[][], Boolean> map) {
            map.put(this.ladder, this.isAntiparallel ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return (this.isAntiparallel ? "a " : "p ") + this.a + " - " + this.b + "\t" + Escape.escape((Object)this.ladder);
        }

        protected boolean addBridge(Bridge bridge, Map<int[][], Boolean> map) {
            if (bridge == null || bridge.isAntiparallel != this.isAntiparallel || !this.canAdd(bridge) || !bridge.canAdd(this)) {
                return false;
            }
            this.extendLadder(bridge.ladder[0][0], bridge.ladder[1][0]);
            this.extendLadder(bridge.ladder[0][1], bridge.ladder[1][1]);
            bridge.ladder = this.ladder;
            if (bridge.ladder != this.ladder) {
                map.remove(bridge.ladder);
                this.addLadder(map);
            }
            return true;
        }

        private boolean canAdd(Bridge bridge) {
            int n = bridge.a.index;
            int n2 = bridge.b.index;
            return this.isAntiparallel ? n >= this.ladder[0][1] && n2 <= this.ladder[1][0] || n <= this.ladder[0][0] && n2 >= this.ladder[1][1] : n <= this.ladder[0][0] && n2 <= this.ladder[1][0] || n >= this.ladder[0][1] && n2 >= this.ladder[1][1];
        }

        private void extendLadder(int n, int n2) {
            if (this.ladder[0][0] > n) {
                this.ladder[0][0] = n;
            }
            if (this.ladder[0][1] < n) {
                this.ladder[0][1] = n;
            }
            if (this.ladder[1][0] > n2) {
                this.ladder[1][0] = n2;
            }
            if (this.ladder[1][1] < n2) {
                this.ladder[1][1] = n2;
            }
        }
    }
}

