/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.OutputStringBuffer;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaPolymer
extends BioPolymer {
    AlphaPolymer(Monomer[] monomerArray) {
        super(monomerArray);
    }

    @Override
    protected Point3f getControlPoint(int n, Vector3f vector3f) {
        if (!this.monomers[n].isSheet()) {
            return this.leadPoints[n];
        }
        vector3f.sub((Tuple3f)this.leadMidpoints[n], (Tuple3f)this.leadPoints[n]);
        vector3f.scale(this.sheetSmoothing);
        Point3f point3f = new Point3f(this.leadPoints[n]);
        point3f.add((Tuple3f)vector3f);
        return point3f;
    }

    @Override
    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OutputStringBuffer outputStringBuffer, StringBuffer stringBuffer, BitSet bitSet3) {
        AlphaPolymer.getPdbData(viewer, this, c, c2, n, n2, bitSet, bitSet2, bl, bl2, bl3, labelTokenArray, outputStringBuffer, stringBuffer, bitSet3);
    }

    @Override
    public void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, char c, int n3, char c2, int n4) {
        int n5;
        int n6 = this.getIndex(c, n3);
        if (n6 == -1 || (n5 = this.getIndex(c2, n4)) == -1) {
            return;
        }
        this.addSecondaryStructure(enumStructure, string, n, n2, n6, n5);
    }

    protected void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            Logger.error((String)("AlphaPolymer:addSecondaryStructure error:  indexStart:" + n3 + " indexEnd:" + n4));
            return;
        }
        int n5 = n4 - n3 + 1;
        ProteinStructure proteinStructure = null;
        if (enumStructure == null) {
            System.out.println("alhapoly null type");
        }
        switch (enumStructure) {
            case HELIX: 
            case HELIXALPHA: 
            case HELIX310: 
            case HELIXPI: {
                proteinStructure = new Helix(this, n3, n5, 0, enumStructure);
                break;
            }
            case SHEET: {
                proteinStructure = new Sheet(this, n3, n5, 0, enumStructure);
                break;
            }
            case TURN: {
                proteinStructure = new Turn(this, n3, n5, 0);
                break;
            }
            default: {
                Logger.error((String)"unrecognized secondary structure type");
                return;
            }
        }
        proteinStructure.structureID = string;
        proteinStructure.serialID = n;
        proteinStructure.strandCount = n2;
        for (int i = n3; i <= n4; ++i) {
            this.monomers[i].setStructure(proteinStructure);
        }
    }

    @Override
    public List<Atom[]> calculateStruts(ModelSet modelSet, BitSet bitSet, BitSet bitSet2, List<Atom> list, float f, int n, boolean bl) {
        return this.calculateStrutsStatic(modelSet, bitSet, bitSet2, list, f, n, bl);
    }

    private List<Atom[]> calculateStrutsStatic(ModelSet modelSet, BitSet bitSet, BitSet bitSet2, List<Atom> list, float f, int n, boolean bl) {
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        ArrayList<Atom[]> arrayList = new ArrayList<Atom[]>();
        float f3 = f * f;
        int n9 = list.size();
        int n10 = 3;
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        BitSet bitSet5 = new BitSet();
        Atom atom = list.get(0);
        int n11 = modelSet.getBioPolymerCountInModel((int)atom.modelIndex);
        int[][] nArray = new int[n11][n10 * 2];
        for (int i = 0; i < n9; ++i) {
            atom = list.get(i);
            n8 = atom.getPolymerIndexInModel();
            n7 = atom.getMonomerIndex();
            n6 = n7;
            if (n6 < n10) {
                nArray[n8][n6] = i + 1;
            }
            if ((n6 = ((Monomer)atom.getGroup()).getBioPolymerLength() - n7 - 1) >= n10) continue;
            nArray[n8][n10 + n6] = i + 1;
        }
        float[] fArray = new float[n9 * (n9 - 1) / 2];
        for (n8 = 0; n8 < n9; ++n8) {
            atom = list.get(n8);
            for (n7 = n8 + 1; n7 < n9; ++n7) {
                n6 = AlphaPolymer.strutPoint(n8, n7, n9);
                Atom atom2 = list.get(n7);
                n5 = atom.getResno();
                n4 = atom.getPolymerIndexInModel();
                n3 = atom2.getResno();
                n2 = atom2.getPolymerIndexInModel();
                if (n4 == n2 && Math.abs(n3 - n5) < n) {
                    bitSet5.set(n6);
                }
                if (!((f2 = (fArray[n6] = atom.distanceSquared((Point3f)atom2))) >= f3)) continue;
                bitSet4.set(n6);
            }
        }
        n8 = 5;
        while (--n8 >= 0) {
            f3 = (f - (float)n8) * (f - (float)n8);
            for (n7 = 0; n7 < n9; ++n7) {
                if (!bl && bitSet3.get(n7)) continue;
                for (n6 = n7 + 1; n6 < n9; ++n6) {
                    n5 = AlphaPolymer.strutPoint(n7, n6, n9);
                    if (bitSet4.get(n5) || bitSet5.get(n5) || !bl && bitSet3.get(n6) || !(fArray[n5] <= f3)) continue;
                    AlphaPolymer.setStrut(n7, n6, n9, list, bitSet, bitSet2, arrayList, bitSet3, bitSet4, bitSet5, n);
                }
            }
        }
        for (n8 = 0; n8 < n11; ++n8) {
            for (n7 = 0; n7 < n10 * 2; ++n7) {
                n6 = nArray[n8][n7] - 1;
                if (n6 < 0 || !bitSet3.get(n6)) continue;
                for (n5 = 0; n5 < n10; ++n5) {
                    n4 = n7 / n10 * n10 + n5;
                    n6 = nArray[n8][n4] - 1;
                    if (n6 >= 0) {
                        bitSet3.set(n6);
                    }
                    nArray[n8][n4] = -1;
                }
            }
            if (nArray[n8][0] == -1 && nArray[n8][n10] == -1) continue;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            f2 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n10 * 2; ++j) {
                    int n12;
                    int n13 = nArray[n8][j] - 1;
                    if (n13 == -2) {
                        j = (j / n10 + 1) * n10 - 1;
                        continue;
                    }
                    if (i == n13 || n13 == -1 || bitSet5.get(n12 = AlphaPolymer.strutPoint(n13, i, n9)) || fArray[n12] > (j < n10 ? f2 : f4)) continue;
                    if (j < n10) {
                        if (bitSet4.get(n12)) {
                            n7 = 1;
                        }
                        n4 = i;
                        n5 = n13;
                        f2 = fArray[n12];
                        continue;
                    }
                    if (bitSet4.get(n12)) {
                        n6 = 1;
                    }
                    n2 = i;
                    n3 = n13;
                    f4 = fArray[n12];
                }
            }
            if (n7 != 0) {
                AlphaPolymer.setStrut(n5, n4, n9, list, bitSet, bitSet2, arrayList, bitSet3, bitSet4, bitSet5, n);
            }
            if (n6 == 0) continue;
            AlphaPolymer.setStrut(n3, n2, n9, list, bitSet, bitSet2, arrayList, bitSet3, bitSet4, bitSet5, n);
        }
        return arrayList;
    }

    private static int strutPoint(int n, int n2, int n3) {
        return n2 < n ? n2 * (2 * n3 - n2 - 1) / 2 + n - n2 - 1 : n * (2 * n3 - n - 1) / 2 + n2 - n - 1;
    }

    private static void setStrut(int n, int n2, int n3, List<Atom> list, BitSet bitSet, BitSet bitSet2, List<Atom[]> list2, BitSet bitSet3, BitSet bitSet4, BitSet bitSet5, int n4) {
        Atom atom = list.get(n);
        Atom atom2 = list.get(n2);
        if (!bitSet.get(atom.index) || !bitSet2.get(atom2.index)) {
            return;
        }
        list2.add(new Atom[]{atom, atom2});
        bitSet3.set(n);
        bitSet3.set(n2);
        for (int i = Math.max(0, n - n4); i <= n + n4 && i < n3; ++i) {
            for (int j = Math.max(0, n2 - n4); j <= n2 + n4 && j < n3; ++j) {
                int n5;
                if (i == j || bitSet5.get(n5 = AlphaPolymer.strutPoint(i, j, n3))) continue;
                bitSet4.set(n5);
            }
        }
    }

    @Override
    public void calculateStructures(boolean bl) {
        if (this.monomerCount < 4) {
            return;
        }
        float[] fArray = this.calculateAnglesInDegrees();
        Code[] codeArray = this.calculateCodes(fArray);
        this.checkBetaSheetAlphaHelixOverlap(codeArray, fArray);
        EnumStructure[] enumStructureArray = this.calculateRunsFourOrMore(codeArray);
        this.extendRuns(enumStructureArray);
        this.searchForTurns(codeArray, fArray, enumStructureArray);
        this.addStructuresFromTags(enumStructureArray);
    }

    private float[] calculateAnglesInDegrees() {
        float[] fArray = new float[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            fArray[n] = Measure.computeTorsion((Tuple3f)this.monomers[n - 2].getLeadAtom(), (Tuple3f)this.monomers[n - 1].getLeadAtom(), (Tuple3f)this.monomers[n].getLeadAtom(), (Tuple3f)this.monomers[n + 1].getLeadAtom(), (boolean)true);
        }
        return fArray;
    }

    private Code[] calculateCodes(float[] fArray) {
        Code[] codeArray = new Code[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            float f = fArray[n];
            codeArray[n] = f >= 10.0f && f < 120.0f ? Code.RIGHT_HELIX : (f >= 120.0f || f < -90.0f ? Code.BETA_SHEET : (f >= -90.0f && f < 0.0f ? Code.LEFT_HELIX : Code.NADA));
        }
        return codeArray;
    }

    private void checkBetaSheetAlphaHelixOverlap(Code[] codeArray, float[] fArray) {
        int n = this.monomerCount - 2;
        while (--n >= 2) {
            if (codeArray[n] != Code.BETA_SHEET || !(fArray[n] <= 140.0f) || codeArray[n - 2] != Code.RIGHT_HELIX || codeArray[n - 1] != Code.RIGHT_HELIX || codeArray[n + 1] != Code.RIGHT_HELIX || codeArray[n + 2] != Code.RIGHT_HELIX) continue;
            codeArray[n] = Code.RIGHT_HELIX;
        }
    }

    private EnumStructure[] calculateRunsFourOrMore(Code[] codeArray) {
        EnumStructure[] enumStructureArray = new EnumStructure[this.monomerCount];
        EnumStructure enumStructure = EnumStructure.NONE;
        Code code = Code.NADA;
        int n = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (codeArray[i] == code && code != Code.NADA && code != Code.BETA_SHEET) {
                if (++n == 4) {
                    enumStructure = code == Code.BETA_SHEET ? EnumStructure.SHEET : EnumStructure.HELIX;
                    int n2 = 4;
                    while (--n2 >= 0) {
                        enumStructureArray[i - n2] = enumStructure;
                    }
                    continue;
                }
                if (n <= 4) continue;
                enumStructureArray[i] = enumStructure;
                continue;
            }
            n = 1;
            code = codeArray[i];
        }
        return enumStructureArray;
    }

    private void extendRuns(EnumStructure[] enumStructureArray) {
        for (int i = 1; i < this.monomerCount - 4; ++i) {
            if (enumStructureArray[i] != EnumStructure.NONE || enumStructureArray[i + 1] == EnumStructure.NONE) continue;
            enumStructureArray[i] = enumStructureArray[i + 1];
        }
        enumStructureArray[0] = enumStructureArray[1];
        enumStructureArray[this.monomerCount - 1] = enumStructureArray[this.monomerCount - 2];
    }

    private void searchForTurns(Code[] codeArray, float[] fArray, EnumStructure[] enumStructureArray) {
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            codeArray[n] = Code.NADA;
            if (enumStructureArray[n] != null && enumStructureArray[n] != EnumStructure.NONE) continue;
            float f = fArray[n];
            if (f >= -90.0f && f < 0.0f) {
                codeArray[n] = Code.LEFT_TURN;
                continue;
            }
            if (!(f >= 0.0f) || !(f < 90.0f)) continue;
            codeArray[n] = Code.RIGHT_TURN;
        }
        n = this.monomerCount - 1;
        while (--n >= 0) {
            if (codeArray[n] == Code.NADA || codeArray[n + 1] != codeArray[n] || enumStructureArray[n] != EnumStructure.NONE) continue;
            enumStructureArray[n] = EnumStructure.TURN;
        }
    }

    private void addStructuresFromTags(EnumStructure[] enumStructureArray) {
        int n = 0;
        while (n < this.monomerCount) {
            int n2;
            EnumStructure enumStructure = enumStructureArray[n];
            if (enumStructure == null || enumStructure == EnumStructure.NONE) {
                ++n;
                continue;
            }
            for (n2 = n + 1; n2 < this.monomerCount && enumStructureArray[n2] == enumStructure; ++n2) {
            }
            this.addSecondaryStructure(enumStructure, null, 0, 0, n, n2 - 1);
            n = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Code {
        NADA,
        RIGHT_HELIX,
        BETA_SHEET,
        LEFT_HELIX,
        LEFT_TURN,
        RIGHT_TURN;

    }
}

