/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class TlsDataOnlyReader
extends AtomSetCollectionReader {
    private List<Map<String, Object>> vTlsModels;
    private StringBuffer sbTlsErrors;
    private int tlsGroupID;
    private static final String[] TLnn = new String[]{"11", "22", "33", "12", "13", "23"};
    private static final String[] Snn = new String[]{"22", "11", "12", "13", "23", "21", "31", "32"};

    protected void initializeReader() throws Exception {
        this.readTlsData();
        this.continuing = false;
    }

    private void readTlsData() throws Exception {
        Object object;
        this.vTlsModels = new ArrayList<Map<String, Object>>();
        Hashtable<String, Object> hashtable = null;
        ArrayList arrayList = null;
        Hashtable<String, Object> hashtable2 = null;
        ArrayList arrayList2 = new ArrayList();
        while (this.readLine() != null) {
            int n;
            int n2;
            char c;
            object = TlsDataOnlyReader.getTokens((String)this.line.replace('\'', ' '));
            if (((String[])object).length == 0) continue;
            if (object[0].equals("TLS")) {
                hashtable = new Hashtable<String, Object>();
                arrayList = new ArrayList();
                hashtable.put("ranges", arrayList);
                arrayList2.add(hashtable);
                hashtable.put("id", ++this.tlsGroupID);
                continue;
            }
            if (object[0].equals("RANGE")) {
                hashtable2 = new Hashtable<String, Object>();
                c = ((String)object[1]).charAt(0);
                char c2 = ((String)object[3]).charAt(0);
                int n3 = Parser.parseInt((String)object[2]);
                n2 = Parser.parseInt((String)object[4]);
                if (c == c2) {
                    hashtable2.put("chains", "" + c + c2);
                    if (n3 <= n2) {
                        hashtable2.put("residues", new int[]{n3, n2});
                        arrayList.add(hashtable2);
                        continue;
                    }
                    this.tlsAddError(" TLS group residues are not in order (range ignored)");
                    continue;
                }
                this.tlsAddError(" TLS group chains are different (range ignored)");
                continue;
            }
            if (((String)object[0]).equals("ORIGIN")) {
                Point3f point3f = new Point3f();
                hashtable.put("origin", point3f);
                point3f.set(this.parseFloat((String)object[1]), this.parseFloat((String)object[2]), this.parseFloat((String)object[3]));
                if (!Float.isNaN(point3f.x) && !Float.isNaN(point3f.y) && !Float.isNaN(point3f.z)) continue;
                point3f.set(Float.NaN, Float.NaN, Float.NaN);
                this.tlsAddError("invalid origin: " + this.line);
                continue;
            }
            if (!((String)object[0]).equals("T") && !((String)object[0]).equals("L") && !((String)object[0]).equals("S")) continue;
            c = ((String)object[0]).charAt(0);
            String[] stringArray = c == 'S' ? Snn : TLnn;
            float[][] fArray = new float[3][3];
            hashtable.put("t" + c, fArray);
            for (n2 = 1; n2 < ((Object)object).length; ++n2) {
                n = stringArray[n2].charAt(0) - 49;
                int n4 = stringArray[n2].charAt(1) - 49;
                fArray[n][n4] = this.parseFloat((String)object[++n2]);
                if (n >= n4) continue;
                fArray[n4][n] = fArray[n][n4];
            }
            if (c == 'S') {
                fArray[0][0] = -fArray[0][0];
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!Float.isNaN(fArray[n2][n])) continue;
                    this.tlsAddError("invalid tensor: " + Escape.escapeArray((Object)fArray));
                }
            }
        }
        Logger.info((String)(this.tlsGroupID + " TLS groups read"));
        object = new Hashtable();
        ((Hashtable)object).put("groupCount", this.tlsGroupID);
        ((Hashtable)object).put("groups", arrayList2);
        this.vTlsModels.add((Map<String, Object>)object);
        this.htParams.put("vTlsModels", this.vTlsModels);
    }

    private void tlsAddError(String string) {
        if (this.sbTlsErrors == null) {
            this.sbTlsErrors = new StringBuffer();
        }
        this.sbTlsErrors.append(this.fileName).append('\t').append("TLS group ").append(this.tlsGroupID).append('\t').append(string).append('\n');
    }
}

