/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class NWChemReader
extends MOReader {
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;
    private List<String> atomTypes;
    private boolean readROHFonly;
    int nBasisFunctions;
    private static String DS_LIST = "d2-   d1-   d0    d1+   d2+";
    private static String FS_LIST = "f3-   f2-   f1-   f0    f1+   f2+   f3+";
    private static String DC_LIST = "DXX   DXY   DXZ   DYY   DYZ   DZZ";
    private static String FC_LIST = "XXX   XXY   XXZ   XYY   XYZ   XZZ   YYY   YYZ   YZZ   ZZZ";
    private Map<Integer, Map<String, Object>> moInfo;
    int moCount;
    private boolean purging;

    protected void initializeReader() {
        this.readROHFonly = this.filter != null && this.filter.indexOf("ROHF") >= 0;
        this.calculationType = "(NWCHEM)";
    }

    protected boolean checkLine() throws Exception {
        if (this.line.trim().startsWith("NWChem")) {
            boolean bl = this.inInput = this.line.indexOf("NWChem Input Module") >= 0;
        }
        if (this.line.startsWith("          Step")) {
            this.init();
            return true;
        }
        if (this.line.indexOf("  wavefunction    = ") >= 0) {
            this.calculationType = this.line.substring(this.line.indexOf("=") + 1).trim() + "(NWCHEM)";
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("Total") >= 0) {
            this.readTotal();
            return true;
        }
        if (this.line.indexOf("@") >= 0) {
            this.readAtSign();
            return true;
        }
        if (this.line.startsWith(" Task  times")) {
            this.init();
            ++this.taskNumber;
            return true;
        }
        if (this.line.startsWith("      Optimization converged")) {
            this.converged = true;
            return true;
        }
        if (this.line.startsWith("      Symmetry information")) {
            this.readSymmetry();
            return true;
        }
        if (this.line.indexOf("Output coordinates in angstroms") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            this.readAtoms();
            return true;
        }
        if (this.line.indexOf("NWChem Nuclear Hessian and Frequency Analysis") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("ENERGY GRADIENTS") >= 0) {
            ++this.equivalentAtomSets;
            this.readGradients();
            return true;
        }
        if (this.line.startsWith("  Mulliken analysis of the total density")) {
            if (this.equivalentAtomSets == 0) {
                return true;
            }
            this.readPartialCharges();
            return true;
        }
        if (this.line.contains("Basis \"ao basis\"") && this.readMolecularOrbitals) {
            return this.readBasis();
        }
        if (this.line.contains("Final Molecular Orbital Analysis")) {
            if (this.equivalentAtomSets == 0) {
                return true;
            }
            return this.readMolecularOrbitalAnalysis(true);
        }
        if (this.line.contains("Final Alpha Molecular Orbital Analysis")) {
            if (this.equivalentAtomSets == 0) {
                return true;
            }
            this.alphaBeta = "alpha ";
            return this.readMolecularOrbitalAnalysis(true);
        }
        if (this.line.contains("Final Beta Molecular Orbital Analysis")) {
            if (this.equivalentAtomSets == 0) {
                return true;
            }
            return this.readMolecularOrbitalAnalysis(false);
        }
        if (!this.readROHFonly && this.line.contains("Final MO vectors")) {
            if (this.equivalentAtomSets == 0) {
                return true;
            }
            return this.readMolecularOrbitalVectors();
        }
        return true;
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String string, String string2, int n) {
        this.energyKey = string;
        this.energyValue = string2;
        this.atomSetCollection.setAtomSetPropertyForSets(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyValue, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetEnergy(string2, this.parseFloat(string2));
        this.haveEnergy = true;
    }

    private void setEnergy(String string, String string2) {
        this.energyKey = string;
        this.energyValue = string2;
        this.atomSetCollection.setAtomSetModelProperty(this.energyKey, this.energyValue);
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry() throws Exception {
        String[] stringArray = NWChemReader.getTokens((String)this.readLines(3));
        this.atomSetCollection.setAtomSetPropertyForSets("Symmetry group name", stringArray[stringArray.length - 1], this.equivalentAtomSets);
    }

    private void readTotal() {
        String[] stringArray = this.getTokens();
        try {
            if (stringArray[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + stringArray[1] + ")", stringArray[stringArray.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readAtSign() throws Exception {
        if (this.line.charAt(2) == 'S' && this.readLines(2) == null) {
            return;
        }
        String[] stringArray = this.getTokens();
        if (!this.haveEnergy) {
            this.setEnergies("E", stringArray[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.atomSetCollection.setAtomSetPropertyForSets("Step", stringArray[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void readAtoms() throws Exception {
        String[] stringArray;
        this.readLines(3);
        this.haveEnergy = false;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? SmarterJmolAdapter.PATH_SEPARATOR + "Input" : SmarterJmolAdapter.PATH_SEPARATOR + "Geometry"));
        this.atomTypes = new ArrayList<String>();
        while (this.readLine() != null && this.line.length() > 0 && (stringArray = this.getTokens()).length >= 6) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(stringArray[1]);
            this.atomTypes.add(atom.atomName);
            this.setAtomCoord(atom, this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.atomSetCollection.setAtomSetModelProperty("Step", "converged");
        } else if (this.inInput) {
            this.atomSetCollection.setAtomSetName("Input");
        }
    }

    private void readGradients() throws Exception {
        String[] stringArray;
        this.readLines(3);
        this.atomSetCollection.newAtomSet();
        if (this.equivalentAtomSets > 1) {
            this.atomSetCollection.cloneLastAtomSetProperties();
        }
        this.atomSetCollection.setAtomSetModelProperty("vector", "gradient");
        this.atomSetCollection.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        while (this.readLine() != null && this.line.length() > 0 && (stringArray = this.getTokens()).length >= 8) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(stringArray[1]);
            this.setAtomCoord(atom, this.parseFloat(stringArray[2]) * 0.5291772f, this.parseFloat(stringArray[3]) * 0.5291772f, this.parseFloat(stringArray[4]) * 0.5291772f);
            this.atomSetCollection.addVibrationVector(atom.atomIndex, -this.parseFloat(stringArray[5]), -this.parseFloat(stringArray[6]), -this.parseFloat(stringArray[7]));
        }
    }

    private void readFrequencies() throws Exception {
        int n;
        int n2;
        int n3;
        String[] stringArray;
        int n4 = this.atomSetCollection.getAtomSetCount();
        String string = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        this.discardLinesUntilContains("Atom information");
        this.readLines(2);
        this.atomSetCollection.newAtomSet();
        while (this.readLine() != null && this.line.indexOf("---") < 0) {
            stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(stringArray[0]);
            this.setAtomCoord(atom, this.parseFloat(stringArray[2]) * 0.5291772f, this.parseFloat(stringArray[3]) * 0.5291772f, this.parseFloat(stringArray[4]) * 0.5291772f);
        }
        this.discardLinesUntilContains("(Projected Frequencies expressed in cm-1)");
        this.readLines(3);
        boolean bl = true;
        while (this.readLine() != null && this.line.indexOf("P.Frequency") >= 0) {
            stringArray = NWChemReader.getTokens((String)this.line, (int)12);
            n3 = stringArray.length;
            n2 = this.atomSetCollection.getAtomCount();
            n = this.atomSetCollection.getLastAtomSetAtomCount();
            if (bl) {
                n2 -= n;
            }
            System.out.println("freq " + bl + " " + n2 + " " + n);
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl2 = blArray[i] = stringArray[i].equals("0.00") || !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                if (!bl) {
                    this.atomSetCollection.cloneLastAtomSet();
                }
                bl = false;
                this.atomSetCollection.setAtomSetFrequency(string, null, stringArray[i], null);
            }
            this.readLines(1);
            this.fillFrequencyData(n2, n, n, blArray, false, 0, 0, null, 0);
            this.readLines(3);
        }
        try {
            this.discardLinesUntilContains("Projected Infra Red Intensities");
            this.readLines(2);
            n3 = this.vibrationNumber;
            n2 = n4;
            while (--n3 >= 0) {
                if (this.readLine() == null) {
                    return;
                }
                if (!this.doGetVibration(n3 + 1)) continue;
                stringArray = this.getTokens();
                n = this.atomSetCollection.getCurrentAtomSetIndex();
                this.atomSetCollection.setCurrentAtomSetIndex(n2++);
                this.atomSetCollection.setAtomSetFrequency(null, null, stringArray[n3], null);
                this.atomSetCollection.setAtomSetModelProperty("IRIntensity", stringArray[5] + " KM/mol");
                this.atomSetCollection.setCurrentAtomSetIndex(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void readPartialCharges() throws Exception {
        this.readLines(4);
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            String[] stringArray;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            do {
                if (this.readLine() != null && this.line.length() >= 3) continue;
                return;
            } while ((stringArray = this.getTokens())[0].indexOf(".") >= 0);
            atomArray[i].partialCharge = (float)this.parseInt(stringArray[2]) - this.parseFloat(stringArray[3]);
        }
    }

    private String fixTag(String string) {
        if (string.equalsIgnoreCase("bq")) {
            return "X";
        }
        if (string.toLowerCase().startsWith("bq")) {
            string = string.substring(2) + "-Bq";
        }
        return "" + Character.toUpperCase(string.charAt(0)) + (string.length() == 1 ? "" : "" + Character.toLowerCase(string.charAt(1)));
    }

    private boolean readBasis() throws Exception {
        int n;
        Object[] objectArray;
        int n2;
        boolean bl;
        this.gaussianCount = 0;
        this.shellCount = 0;
        this.nBasisFunctions = 0;
        boolean bl2 = bl = this.line.indexOf("cartesian") >= 0;
        if (bl) {
            this.getDFMap(DC_LIST, JmolAdapter.SHELL_D_CARTESIAN, CANONICAL_DC_LIST, 3);
            this.getDFMap(FC_LIST, JmolAdapter.SHELL_F_CARTESIAN, CANONICAL_FC_LIST, 3);
        } else {
            this.getDFMap(DS_LIST, JmolAdapter.SHELL_D_SPHERICAL, CANONICAL_DS_LIST, 2);
            this.getDFMap(FS_LIST, JmolAdapter.SHELL_F_SPHERICAL, CANONICAL_FS_LIST, 2);
        }
        this.shells = new ArrayList();
        Hashtable hashtable = new Hashtable();
        String string = null;
        ArrayList arrayList = null;
        List<Object[]> list = null;
        while (this.line != null) {
            n2 = 0;
            while (this.line.length() < 3 || this.line.charAt(2) == ' ') {
                list = new ArrayList();
                this.readLine();
                if (this.line.length() >= 3) continue;
                ++n2;
            }
            if (n2 >= 2) break;
            if (this.parseInt(this.line) == Integer.MIN_VALUE) {
                string = this.getTokens()[0];
                arrayList = new ArrayList();
                hashtable.put(string, arrayList);
                this.readLine();
                this.readLine();
                continue;
            }
            while (this.line != null && this.line.length() > 3) {
                String[] stringArray = this.getTokens();
                objectArray = new Object[]{stringArray[1], new float[]{this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3])}};
                list.add(objectArray);
                this.readLine();
            }
            arrayList.add(list);
        }
        n2 = bl ? 6 : 5;
        int n3 = bl ? 10 : 7;
        objectArray = new ArrayList();
        for (n = 0; n < this.atomTypes.size(); ++n) {
            arrayList = (ArrayList)hashtable.get(this.atomTypes.get(n));
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                ++this.shellCount;
                list = (List)arrayList.get(i);
                int n5 = list.size();
                String string2 = (String)((Object[])list.get(0))[0];
                switch (string2.charAt(0)) {
                    case 'S': {
                        ++this.nBasisFunctions;
                        break;
                    }
                    case 'P': {
                        this.nBasisFunctions += 3;
                        break;
                    }
                    case 'D': {
                        this.nBasisFunctions += n2;
                        break;
                    }
                    case 'F': {
                        this.nBasisFunctions += n3;
                    }
                }
                int[] nArray = new int[]{n, bl ? JmolAdapter.getQuantumShellTagID((String)string2) : JmolAdapter.getQuantumShellTagIDSpherical((String)string2), this.gaussianCount, n5};
                this.shells.add(nArray);
                for (int j = 0; j < n5; ++j) {
                    objectArray.add((float[])((Object[])list.get(j))[1]);
                }
                this.gaussianCount += n5;
            }
        }
        this.gaussians = new float[this.gaussianCount][];
        for (n = 0; n < this.gaussianCount; ++n) {
            this.gaussians[n] = (float[])objectArray.get(n);
        }
        return true;
    }

    private boolean readMolecularOrbitalAnalysis(boolean bl) throws Exception {
        if (this.shells == null) {
            return true;
        }
        int n = 0;
        boolean bl2 = false;
        if (bl && !this.readROHFonly) {
            this.moInfo = new Hashtable<Integer, Map<String, Object>>();
        }
        while (this.line != null) {
            while ((this.line.length() < 3 || this.line.charAt(1) == ' ') && this.line.indexOf("Final") < 0) {
                this.readLine();
            }
            Logger.info((String)this.line);
            if (this.line.indexOf("Final") >= 0) {
                if (this.line.indexOf("MO") >= 0) break;
                if (this.line.indexOf("Final Beta") >= 0) {
                    bl2 = true;
                }
                this.readLine();
                continue;
            }
            if (this.line.charAt(1) != 'V') break;
            this.line = this.line.replace('=', ' ');
            String[] stringArray = this.getTokens();
            int n2 = this.parseInt(stringArray[1]);
            float f = this.parseFloat(stringArray[3]);
            float f2 = this.parseFloat(stringArray[5]);
            String string = stringArray[7];
            this.readLines(3);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("occupancy", Float.valueOf(f));
            hashtable.put("energy", Float.valueOf(f2));
            hashtable.put("symmetry", string);
            float[] fArray = null;
            if (this.readROHFonly) {
                this.setMO(hashtable);
                hashtable.put("type", "ROHF " + ++n);
                fArray = new float[this.nBasisFunctions];
                hashtable.put("coefficients", fArray);
            } else {
                this.moInfo.put(bl2 ? -n2 : n2, hashtable);
            }
            while (this.readLine() != null && this.line.length() > 3) {
                if (!this.readROHFonly) continue;
                stringArray = this.getTokens();
                fArray[this.parseInt((String)stringArray[0]) - 1] = this.parseFloat(stringArray[1]);
                int n3 = stringArray.length / 2;
                if (n3 != 5 && n3 != 6) continue;
                fArray[this.parseInt((String)stringArray[n3]) - 1] = this.parseFloat(stringArray[n3 + 1]);
            }
        }
        this.energyUnits = "a.u.";
        if (this.readROHFonly) {
            this.setMOData(false);
        }
        return false;
    }

    private boolean readMolecularOrbitalVectors() throws Exception {
        boolean bl;
        if (this.shells == null) {
            return true;
        }
        Map[] mapArray = null;
        List[] listArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        this.readLines(5);
        boolean bl2 = false;
        boolean bl3 = bl = !this.filterMO();
        while (this.readLine() != null) {
            int n6;
            if (this.parseInt(this.line) != n2 + 1) {
                if (this.line.indexOf("beta") < 0) break;
                this.alphaBeta = "beta ";
                if (!this.filterMO()) break;
                bl2 = true;
                n2 = 0;
                this.readLine();
                continue;
            }
            this.readLine();
            String[] stringArray = this.getTokens();
            if (Logger.debugging) {
                Logger.debug((String)(stringArray.length + " --- " + this.line));
            }
            n5 = stringArray.length;
            n3 = 6;
            n4 = 12;
            mapArray = ArrayUtil.createArrayOfHashtable((int)n5);
            listArray = ArrayUtil.createArrayOfArrayList((int)n5);
            for (n6 = 0; n6 < n5; ++n6) {
                mapArray[n6] = new Hashtable();
                listArray[n6] = new ArrayList();
            }
            while (this.readLine() != null && this.line.length() > 0) {
                n6 = 0;
                int n7 = n3;
                while (n6 < n5) {
                    listArray[n6].add(this.line.substring(n7, n7 + n4).trim());
                    ++n6;
                    n7 += n4;
                }
            }
            for (n6 = 0; n6 < n5; ++n6) {
                Map<String, Object> map;
                float[] fArray = new float[listArray[n6].size()];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.parseFloat((String)listArray[n6].get(i));
                }
                mapArray[n6].put("coefficients", fArray);
                mapArray[n6].put("type", this.alphaBeta + " " + ++n2);
                ++n;
                Map<String, Object> map2 = this.moInfo == null ? null : (map = this.moInfo.get(bl2 ? -n2 : n2));
                if (map != null) {
                    mapArray[n6].putAll(map);
                }
                if (bl && !bl2) continue;
                this.setMO(mapArray[n6]);
            }
            this.line = "";
        }
        this.energyUnits = "a.u.";
        this.setMOData(false);
        return true;
    }

    public String readLine() throws Exception {
        super.readLine();
        if (!this.purging && this.line != null && this.line.startsWith("--")) {
            this.purging = true;
            this.discardLinesUntilStartsWith("*");
            this.readLine();
            this.purging = false;
            super.readLine();
        }
        return this.line;
    }
}

