/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacSlaterReader {
    private boolean loadGeometries;
    private boolean loadVibrations;
    private boolean vibOnly;
    private boolean optOnly;
    private String orbitalType = "";
    private int modelAtomCount;
    private BitSet bsAtomOK = new BitSet();
    private BitSet bsBadIndex = new BitSet();

    protected void initializeReader() {
        this.vibOnly = this.checkFilter("VIBONLY");
        this.optOnly = this.checkFilter("OPTONLY");
        this.loadGeometries = !this.vibOnly && this.desiredVibrationNumber < 0 && !this.checkFilter("NOOPT");
        boolean bl = this.loadVibrations = !this.optOnly && this.desiredModelNumber < 0 && !this.checkFilter("NOVIB");
        this.filter = this.checkFilter("ALPHA") ? "alpha" : (this.checkFilter("BETA") ? "beta" : null);
    }

    protected boolean checkLine() throws Exception {
        if (!this.line.contains("[")) {
            return true;
        }
        this.line = this.line.toUpperCase().trim();
        if (!this.line.startsWith("[")) {
            return true;
        }
        Logger.info((String)this.line);
        if (this.line.indexOf("[ATOMS]") == 0) {
            this.readAtoms();
            this.modelAtomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
            return false;
        }
        if (this.line.indexOf("[GTO]") == 0) {
            return this.readGaussianBasis();
        }
        if (this.line.indexOf("[MO]") == 0) {
            return !this.readMolecularOrbitals || this.readMolecularOrbitals();
        }
        if (this.line.indexOf("[FREQ]") == 0) {
            return !this.loadVibrations || this.readFreqsAndModes();
        }
        if (this.line.indexOf("[GEOCONV]") == 0) {
            return !this.loadGeometries || this.readGeometryOptimization();
        }
        this.checkOrbitalType(this.line);
        return true;
    }

    public void finalizeReader() {
        if (this.bsBadIndex.isEmpty()) {
            return;
        }
        try {
            short s = 0;
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n = this.atomSetCollection.getAtomCount();
            this.bsAtomOK.set(n);
            int n2 = this.shells.size();
            block2: for (int i = 0; i < n2; ++i) {
                int n3 = ((int[])this.shells.get(i))[0];
                if (n3 != Integer.MAX_VALUE) {
                    s = atomArray[n3].elementNumber;
                    continue;
                }
                int n4 = this.bsAtomOK.nextClearBit(0);
                while (n4 >= 0) {
                    if (atomArray[n4].elementNumber == s) {
                        ((int[])this.shells.get((int)i))[0] = n4;
                        Logger.info((String)("MoldenReader assigning shells starting with " + i + " for ** to atom " + (n4 + 1) + " z " + s));
                        while (++i < n2 && !this.bsBadIndex.get(i) && ((int[])this.shells.get(i))[0] == Integer.MAX_VALUE) {
                            ((int[])this.shells.get((int)i))[0] = n4;
                        }
                        --i;
                        this.bsAtomOK.set(n4);
                        continue block2;
                    }
                    n4 = this.bsAtomOK.nextClearBit(n4 + 1);
                }
            }
        }
        catch (Exception exception) {
            Logger.error((String)"Molden reader could not assign shells -- abandoning MOs");
            this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", null);
        }
    }

    private void readAtoms() throws Exception {
        float f;
        boolean bl;
        String string = this.getTokens()[1];
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = string.indexOf("ANGS") < 0;
        if (bl && string.indexOf("AU") < 0) {
            throw new Exception("invalid coordinate unit " + string + " in [Atoms]");
        }
        float f2 = f = bl ? 0.5291772f : 1.0f;
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 6) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = stringArray[0];
            n2 = this.parseInt(stringArray[1]);
            if (n > 0 && n2 != n + 1) {
                throw new Exception("out of order atom in [Atoms]");
            }
            n = n2;
            atom.elementNumber = (short)this.parseInt(stringArray[2]);
            this.setAtomCoord(atom, this.parseFloat(stringArray[3]) * f, this.parseFloat(stringArray[4]) * f, this.parseFloat(stringArray[5]) * f);
        }
    }

    private boolean readGaussianBasis() throws Exception {
        Object object;
        this.shells = new ArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (this.readLine() != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            object = this.getTokens();
            n = this.parseInt((String)object[0]) - 1;
            if (n == Integer.MAX_VALUE) {
                this.bsBadIndex.set(this.shells.size());
            } else {
                this.bsAtomOK.set(n);
            }
            while (this.readLine() != null && this.line.trim().length() > 0) {
                object = this.getTokens();
                String string = object[0].toUpperCase();
                int n4 = this.parseInt((String)object[1]);
                int[] nArray = new int[]{n, JmolAdapter.getQuantumShellTagID((String)string), n2, n4};
                n3 += this.getDfCoefMaps()[nArray[1]].length;
                int n5 = n4;
                while (--n5 >= 0) {
                    String[] stringArray = MoldenReader.getTokens((String)this.readLine());
                    int n6 = stringArray.length;
                    float[] fArray = new float[n6];
                    for (int i = 0; i < n6; ++i) {
                        fArray[i] = this.parseFloat(stringArray[i]);
                    }
                    arrayList.add(fArray);
                    ++n2;
                }
                this.shells.add(nArray);
            }
        }
        object = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])arrayList.get(i);
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", object);
        Logger.info((String)(this.shells.size() + " slater shells read"));
        Logger.info((String)(((float[][])object).length + " gaussian primitives read"));
        Logger.info((String)(n3 + " MO coefficients expected for orbital type " + this.orbitalType));
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
        return false;
    }

    private boolean readMolecularOrbitals() throws Exception {
        while (this.checkOrbitalType(this.readLine())) {
        }
        this.fixOrbitalType();
        String[] stringArray = this.getMoTokens(this.line);
        while (stringArray != null && stringArray[0].indexOf(91) < 0) {
            String string;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            ArrayList<String> arrayList = new ArrayList<String>();
            float f = Float.NaN;
            float f2 = Float.NaN;
            String string2 = null;
            while (this.parseInt(string = stringArray[0]) == Integer.MIN_VALUE) {
                if (string.startsWith("Ene")) {
                    f = this.parseFloat(stringArray[1]);
                } else if (string.startsWith("Occup")) {
                    f2 = this.parseFloat(stringArray[1]);
                } else if (string.startsWith("Sym")) {
                    string2 = stringArray[1];
                } else if (string.startsWith("Spin")) {
                    this.alphaBeta = stringArray[1].toLowerCase();
                }
                stringArray = this.getMoTokens(null);
            }
            while (stringArray != null && this.parseInt(stringArray[0]) != Integer.MIN_VALUE) {
                if (stringArray.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                arrayList.add(stringArray[1]);
                stringArray = this.getMoTokens(null);
            }
            float[] fArray = new float[arrayList.size()];
            int n = arrayList.size();
            while (--n >= 0) {
                fArray[n] = this.parseFloat((String)arrayList.get(n));
            }
            String string3 = this.line;
            this.line = "";
            if (this.filterMO()) {
                hashtable.put("coefficients", fArray);
                if (!Float.isNaN(f)) {
                    hashtable.put("energy", new Float(f));
                }
                if (!Float.isNaN(f2)) {
                    hashtable.put("occupancy", new Float(f2));
                }
                if (string2 != null) {
                    hashtable.put("symmetry", string2);
                }
                if (this.alphaBeta.length() > 0) {
                    hashtable.put("type", this.alphaBeta);
                }
                this.setMO(hashtable);
                if (Logger.debugging) {
                    Logger.debug((String)(fArray.length + " coefficients in MO " + this.orbitals.size()));
                }
            }
            this.line = string3;
        }
        Logger.debug((String)("read " + this.orbitals.size() + " MOs"));
        this.setMOs("eV");
        return false;
    }

    private String[] getMoTokens(String string) throws Exception {
        return string == null && (string = this.readLine()) == null ? null : MoldenReader.getTokens((String)string.replace('=', ' '));
    }

    private boolean checkOrbitalType(String string) {
        if (string.length() > 3 && "5D 6D 7F 10".indexOf(string.substring(1, 3)) >= 0) {
            this.orbitalType = this.orbitalType + string;
            this.fixOrbitalType();
            return true;
        }
        return false;
    }

    private void fixOrbitalType() {
        if (this.orbitalType.contains("5D")) {
            this.fixSlaterTypes(JmolAdapter.SHELL_D_CARTESIAN, JmolAdapter.SHELL_D_SPHERICAL);
            this.fixSlaterTypes(JmolAdapter.SHELL_F_CARTESIAN, JmolAdapter.SHELL_F_SPHERICAL);
        }
        if (this.orbitalType.contains("10F")) {
            this.fixSlaterTypes(JmolAdapter.SHELL_F_SPHERICAL, JmolAdapter.SHELL_F_CARTESIAN);
        }
    }

    private boolean readFreqsAndModes() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        BitSet bitSet = new BitSet();
        int n = 0;
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            String string = this.getTokens()[0];
            bitSet.set(n++, this.parseFloat(string) != 0.0f);
            arrayList.add(string);
        }
        int n2 = arrayList.size();
        this.skipTo("[FR-COORD]");
        if (!this.vibOnly) {
            this.readAtomSet("frequency base geometry", true, true);
        }
        this.skipTo("[FR-NORM-COORD]");
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            this.skipTo("vibration");
            if (!bitSet.get(i) || !this.doGetVibration(++this.vibrationNumber)) continue;
            if (bl) {
                this.atomSetCollection.cloneLastAtomSet();
            }
            bl = true;
            this.atomSetCollection.setAtomSetFrequency(null, null, Double.valueOf((String)arrayList.get(i)).toString(), null);
            int n3 = this.atomSetCollection.getLastAtomSetAtomIndex();
            for (int j = 0; j < this.modelAtomCount; ++j) {
                String[] stringArray = MoldenReader.getTokens((String)this.readLine());
                this.atomSetCollection.addVibrationVector(j + n3, this.parseFloat(stringArray[0]) * 0.5291772f, this.parseFloat(stringArray[1]) * 0.5291772f, this.parseFloat(stringArray[2]) * 0.5291772f);
            }
        }
        return true;
    }

    private boolean readGeometryOptimization() throws Exception {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readLine();
        while (this.readLine() != null && this.line.indexOf("force") < 0) {
            arrayList.add(Double.valueOf(this.line.trim()).toString());
        }
        this.skipTo("[GEOMETRIES] XYZ");
        int n2 = arrayList.size();
        this.modelNumber = n = this.optOnly || this.desiredModelNumber >= 0 ? 0 : 1;
        boolean bl = false;
        if (this.desiredModelNumber == 0 || this.desiredModelNumber == n2) {
            this.desiredModelNumber = n2;
        } else {
            this.setMOData(null);
        }
        for (int i = 0; i < n2; ++i) {
            this.readLines(2);
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomSet("Step " + (this.modelNumber - n) + "/" + n2 + ": " + (String)arrayList.get(i), false, !this.optOnly || bl);
                bl = true;
                continue;
            }
            this.readLines(this.modelAtomCount);
        }
        return true;
    }

    private void skipTo(String string) throws Exception {
        if (this.line == null || !this.line.contains(string)) {
            this.discardLinesUntilContains(string);
        }
    }

    private void readAtomSet(String string, boolean bl, boolean bl2) throws Exception {
        if (bl2 && this.desiredModelNumber < 0) {
            this.atomSetCollection.cloneFirstAtomSet(0);
        }
        float f = bl ? 0.5291772f : 1.0f;
        this.atomSetCollection.setAtomSetName(string);
        if (this.atomSetCollection.getAtomCount() == 0) {
            while (this.readLine() != null && this.line.indexOf(91) < 0) {
                String[] stringArray = this.getTokens();
                if (stringArray.length != 4) continue;
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.atomName = stringArray[0];
                this.setAtomCoord(atom, this.parseFloat(stringArray[1]) * f, this.parseFloat(stringArray[2]) * f, this.parseFloat(stringArray[3]) * f);
            }
            this.modelAtomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            return;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String[] stringArray = MoldenReader.getTokens((String)this.readLine());
            Atom atom = atomArray[i + n];
            this.setAtomCoord(atom, this.parseFloat(stringArray[1]) * f, this.parseFloat(stringArray[2]) * f, this.parseFloat(stringArray[3]) * f);
        }
    }
}

