/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class GromacsReader
extends AtomSetCollectionReader {
    protected void initializeReader() {
        this.atomSetCollection.newAtomSet();
        this.setIsPDB();
    }

    protected boolean checkLine() throws Exception {
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetName(this.line.trim());
        this.readAtoms();
        this.readUnitCell();
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        int n = this.parseInt(this.readLine());
        for (int i = 0; i < n; ++i) {
            this.readLine();
            int n2 = this.line.length();
            if (n2 != 44 && n2 != 68) {
                Logger.warn((String)("line cannot be read for GROMACS atom data: " + this.line));
                continue;
            }
            Atom atom = new Atom();
            atom.sequenceNumber = this.parseInt(this.line, 0, 5);
            this.setAtomName(atom, this.parseToken(this.line, 5, 9).trim(), this.line.substring(11, 15).trim());
            atom.atomSerial = this.parseInt(this.line, 15, 20);
            atom.x = this.parseFloat(this.line, 20, 28) * 10.0f;
            atom.y = this.parseFloat(this.line, 28, 36) * 10.0f;
            atom.z = this.parseFloat(this.line, 36, 44) * 10.0f;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn((String)("line cannot be read for GROMACS atom data: " + this.line));
                atom.set(0.0f, 0.0f, 0.0f);
            }
            this.setAtomCoord(atom);
            atom.elementSymbol = this.deduceElementSymbol(atom.group3, atom.atomName);
            if (!this.filterAtom(atom, i)) continue;
            atom.isHetero = false;
            this.atomSetCollection.addAtom(atom);
            if (n2 < 69) continue;
            float f = this.parseFloat(this.line, 44, 52) * 10.0f;
            float f2 = this.parseFloat(this.line, 52, 60) * 10.0f;
            float f3 = this.parseFloat(this.line, 60, 68) * 10.0f;
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue;
            this.atomSetCollection.addVibrationVector(atom.atomIndex, f, f2, f3);
        }
    }

    private void setAtomName(Atom atom, String string, String string2) {
        atom.atomName = string2;
        if (string.equals("SOL") && string2.length() == 3 && "OW1;HW2;HW3".indexOf(string2) >= 0) {
            string = "WAT";
        }
        atom.group3 = string;
    }

    String deduceElementSymbol(String string, String string2) {
        if (string2.length() <= 2 && string.equals(string2)) {
            return string2;
        }
        char c = string2.length() == 4 ? string2.charAt(0) : (char)'\u0000';
        char c2 = string2.charAt(string2.length() == 4 ? 1 : 0);
        boolean bl = JmolAdapter.isHetero((String)string);
        if (Atom.isValidElementSymbolNoCaseSecondChar((char)c, (char)c2)) {
            return bl || c != 'H' ? "" + c + c2 : "H";
        }
        if (Atom.isValidElementSymbol((char)c2)) {
            return "" + c2;
        }
        if (Atom.isValidElementSymbol((char)c)) {
            return "" + c;
        }
        return "Xx";
    }

    private void readUnitCell() throws Exception {
        if (this.readLine() == null) {
            return;
        }
        String[] stringArray = GromacsReader.getTokens((String)this.line);
        if (stringArray.length < 3 || !this.doApplySymmetry) {
            return;
        }
        float f = 10.0f * this.parseFloat(stringArray[0]);
        float f2 = 10.0f * this.parseFloat(stringArray[1]);
        float f3 = 10.0f * this.parseFloat(stringArray[2]);
        this.setUnitCell(f, f2, f3, 90.0f, 90.0f, 90.0f);
        this.setSpaceGroupName("P1");
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        Point3f point3f = new Point3f(0.5f, 0.5f, 0.5f);
        int n = this.atomSetCollection.getAtomCount();
        while (--n >= 0) {
            this.setAtomCoord(atomArray[n]);
            atomArray[n].add((Tuple3f)point3f);
        }
    }
}

