/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.XmlReader;

public class JvxlXmlReader
extends VolumeFileReader {
    protected String JVXL_VERSION = "2.2";
    protected int surfaceDataCount;
    protected int edgeDataCount;
    protected int colorDataCount;
    private int excludedTriangleCount;
    private int excludedVertexCount;
    private int invalidatedVertexCount;
    protected boolean haveContourData;
    private XmlReader xr;
    protected boolean isXmlFile = true;
    protected boolean thisInside;
    String tempDataXml;
    protected BitSet bsVoxelBitSet;
    private boolean includeValueNaN = true;
    private int valueCount;
    private float valueMin = Float.NaN;
    private float valueRange = Float.NaN;
    private int fractionPtr;
    private int colorPtr;
    private String strFractionTemp = "";
    boolean haveReadColorData;

    JvxlXmlReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.isXLowToHigh = false;
        this.xr = new XmlReader(bufferedReader);
    }

    protected boolean readVolumeData(boolean bl) {
        if (!super.readVolumeData(bl)) {
            return false;
        }
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
        return true;
    }

    protected boolean gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX < 0 || this.nPointsY < 0 || this.nPointsZ < 0) {
            return true;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            if (this.vertexDataOnly) {
                return true;
            }
            this.volumeData.setMappingPlane(this.params.thePlane);
            this.readSurfaceData(bl);
            this.volumeData.setMappingPlane(null);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadData("edge", this.edgeDataCount);
            }
            this.jvxlData.jvxlExcluded = new BitSet[4];
            this.params.bsExcluded = this.jvxlData.jvxlExcluded;
            boolean bl2 = this.hasColorData = this.colorDataCount > 0;
            if (this.hasColorData) {
                this.jvxlColorDataRead = this.jvxlReadData("color", this.colorDataCount);
            }
            if (this.excludedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[0] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedVertexData", null, false, false));
                if (this.xr.isNext("jvxlExcludedPlaneData")) {
                    this.jvxlData.jvxlExcluded[2] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedPlaneData", null, false, false));
                }
            }
            if (this.excludedTriangleCount > 0) {
                this.jvxlData.jvxlExcluded[3] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedTriangleData", null, false, false));
            }
            if (this.invalidatedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[1] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlInvalidatedVertexData", null, false, false));
            }
            if (this.haveContourData) {
                this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false, false));
            }
            if (this.jvxlData.nVertexColors > 0) {
                this.jvxlData.vertexColorMap = new Hashtable<String, BitSet>();
                for (int i = 0; i < this.jvxlData.nVertexColors; ++i) {
                    String string = this.xr.getXmlData("jvxlColorMap", null, true, false);
                    String string2 = XmlReader.getXmlAttrib((String)string, (String)"color");
                    BitSet bitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlColorMap", string, false, false));
                    this.jvxlData.vertexColorMap.put(string2, bitSet);
                }
            }
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
            return false;
        }
        return true;
    }

    protected void readParameters() throws Exception {
        String string = this.xr.getXmlData("jvxlFileTitle", null, false, false);
        this.jvxlFileHeaderBuffer = new StringBuffer(string);
        this.xr.toTag("jvxlVolumeData");
        String string2 = this.tempDataXml = this.xr.getXmlData("jvxlVolumeData", null, true, false);
        this.volumetricOrigin.set((Tuple3f)this.xr.getXmlPoint(string2, "origin"));
        this.isAngstroms = true;
        this.readVector(0);
        this.readVector(1);
        this.readVector(2);
        this.line = this.xr.toTag("jvxlSurfaceSet");
        this.nSurfaces = this.parseInt(XmlReader.getXmlAttrib((String)this.line, (String)"count"));
        Logger.info((String)("jvxl file surfaces: " + this.nSurfaces));
        Logger.info((String)"using default edge fraction base and range");
        Logger.info((String)"using default color fraction base and range");
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
    }

    protected void readVector(int n) throws Exception {
        String string = this.xr.getXmlData("jvxlVolumeVector", this.tempDataXml, true, true);
        this.tempDataXml = this.tempDataXml.substring(this.tempDataXml.indexOf(string) + string.length());
        int n2 = this.parseInt(XmlReader.getXmlAttrib((String)string, (String)"count"));
        if (n2 == Integer.MIN_VALUE) {
            this.vertexDataOnly = true;
        }
        this.voxelCounts[n] = n2 < 0 ? 0 : n2;
        this.volumetricVectors[n].set((Tuple3f)this.xr.getXmlPoint(string, "vector"));
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(this.volumetricVectors[n]);
        }
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + n2 + " points each"));
        }
        this.jvxlData.vertexDataOnly = n2 == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        for (int i = 0; i < n; ++i) {
            this.jvxlSkipData(n2, true);
        }
        this.xr.toTag("jvxlSurface");
        this.jvxlReadSurfaceInfo();
    }

    protected void jvxlSkipData(int n, boolean bl) throws Exception {
        this.readLine();
        this.xr.skipTag("jvxlSurface");
    }

    protected void jvxlReadSurfaceInfo() throws Exception {
        String string;
        int n;
        String string2 = this.xr.getXmlData("jvxlSurfaceInfo", null, true, true);
        this.isXLowToHigh = XmlReader.getXmlAttrib((String)string2, (String)"isXLowToHigh").equals("true");
        this.jvxlCutoff = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"cutoff"));
        if (!Float.isNaN(this.jvxlCutoff)) {
            Logger.info((String)("JVXL read: cutoff " + this.jvxlCutoff));
        }
        this.haveContourData = (n = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nContourData"))) > 0;
        this.params.isContoured = XmlReader.getXmlAttrib((String)string2, (String)"contoured").equals("true");
        if (this.params.isContoured) {
            int n2 = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nContours"));
            if (n2 <= 0) {
                n2 = 0;
            } else {
                string = XmlReader.getXmlAttrib((String)string2, (String)"contourValues");
                if (string.length() > 0) {
                    this.params.contoursDiscrete = this.parseFloatArray(string);
                    this.jvxlData.contourValues = this.params.contoursDiscrete;
                    Logger.info((String)("JVXL read: contourValues " + Escape.escapeArray((Object)this.jvxlData.contourValues)));
                }
                if ((string = XmlReader.getXmlAttrib((String)string2, (String)"contourColors")).length() > 0) {
                    this.params.contourColixes = Graphics3D.getColixArray((String)string);
                    this.jvxlData.contourColixes = this.params.contourColixes;
                    this.jvxlData.contourColors = Graphics3D.getHexCodes((short[])this.jvxlData.contourColixes);
                    Logger.info((String)("JVXL read: contourColixes " + Graphics3D.getHexCodes((short[])this.jvxlData.contourColixes)));
                }
                this.params.contourFromZero = XmlReader.getXmlAttrib((String)string2, (String)"contourFromZero").equals("true");
            }
            this.params.nContours = this.haveContourData ? n : n2;
        }
        this.jvxlData.nVertexColors = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nVertexColors"));
        this.params.isBicolorMap = XmlReader.getXmlAttrib((String)string2, (String)"bicolorMap").equals("true");
        if (this.params.isBicolorMap) {
            string = XmlReader.getXmlAttrib((String)string2, (String)"colorPositive");
            if (string.length() > 0 && this.params.colorRgb == Integer.MIN_VALUE && this.params.colorPos == -16776961) {
                this.params.colorPos = ColorUtil.getArgbFromString((String)string);
            }
            if ((string = XmlReader.getXmlAttrib((String)string2, (String)"colorNegative")).length() > 0 && this.params.colorRgb == Integer.MIN_VALUE && this.params.colorNeg == -65536) {
                this.params.colorNeg = ColorUtil.getArgbFromString((String)string);
            }
        }
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        this.jvxlDataIsColorMapped = !(this.params.colorRgb != Integer.MIN_VALUE && this.params.colorRgb != Integer.MAX_VALUE || !this.params.isBicolorMap && !XmlReader.getXmlAttrib((String)string2, (String)"colorMapped").equals("true"));
        this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib((String)string2, (String)"precisionColor").equals("true");
        this.params.colorDensity = this.params.colorRgb == Integer.MIN_VALUE && XmlReader.getXmlAttrib((String)string2, (String)"colorDensity").equals("true");
        this.jvxlData.jvxlDataIsColorDensity = this.params.colorDensity;
        string = XmlReader.getXmlAttrib((String)string2, (String)"allowVolumeRender");
        this.params.allowVolumeRender = string.length() == 0 || string.equalsIgnoreCase("true");
        this.jvxlData.allowVolumeRender = this.params.allowVolumeRender;
        string = XmlReader.getXmlAttrib((String)string2, (String)"plane");
        if (string.indexOf("{") >= 0) {
            try {
                this.params.thePlane = (Point4f)Escape.unescapePoint((String)string);
                Logger.info((String)("JVXL read: plane " + this.params.thePlane));
                if (this.params.scale3d == 0.0f) {
                    this.params.scale3d = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"scale3d"));
                }
                if (Float.isNaN(this.params.scale3d)) {
                    this.params.scale3d = 0.0f;
                }
            }
            catch (Exception exception) {
                Logger.error((String)"Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.params.thePlane = new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
            }
            this.surfaceDataCount = 0;
            this.edgeDataCount = 0;
        } else {
            this.params.thePlane = null;
            this.surfaceDataCount = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nSurfaceInts"));
            this.edgeDataCount = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nBytesUncompressedEdgeData"));
        }
        this.excludedVertexCount = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nExcludedVertexes"));
        this.excludedTriangleCount = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nExcludedTriangles"));
        this.invalidatedVertexCount = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nInvalidatedVertexes"));
        string = XmlReader.getXmlAttrib((String)string2, (String)"slabInfo");
        if (string.length() > 0) {
            this.jvxlData.slabInfo = string;
        }
        this.colorDataCount = Math.max(0, this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"nBytesUncompressedColorData")));
        this.jvxlDataIs2dContour = this.params.thePlane != null && this.jvxlDataIsColorMapped;
        this.jvxlData.color = XmlReader.getXmlAttrib((String)string2, (String)"color");
        if (this.jvxlData.color.length() == 0 || this.jvxlData.color.indexOf("null") >= 0) {
            this.jvxlData.color = "orange";
        }
        this.jvxlData.translucency = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"translucency"));
        if (Float.isNaN(this.jvxlData.translucency)) {
            this.jvxlData.translucency = 0.0f;
        }
        if ((string = XmlReader.getXmlAttrib((String)string2, (String)"meshColor")).length() > 0) {
            this.jvxlData.meshColor = string;
        }
        if ((string = XmlReader.getXmlAttrib((String)string2, (String)"rendering")).length() > 0) {
            this.jvxlData.rendering = string;
        }
        this.jvxlData.colorScheme = XmlReader.getXmlAttrib((String)string2, (String)"colorScheme");
        if (this.jvxlData.colorScheme.length() == 0) {
            this.jvxlData.colorScheme = null;
        }
        this.jvxlData.slabValue = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"slabValue"));
        this.jvxlData.isSlabbable = XmlReader.getXmlAttrib((String)string2, (String)"slabbable").equalsIgnoreCase("true");
        this.jvxlData.diameter = this.parseInt(XmlReader.getXmlAttrib((String)string2, (String)"diameter"));
        if (this.jvxlData.diameter == Integer.MIN_VALUE) {
            this.jvxlData.diameter = 0;
        }
        if (this.jvxlDataIs2dContour) {
            this.params.isContoured = true;
        }
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        boolean bl = XmlReader.getXmlAttrib((String)string2, (String)"insideOut").equals("true");
        float f = Float.NaN;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        if (this.jvxlDataIsColorMapped) {
            f = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"dataMinimum"));
            f2 = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"dataMaximum"));
            f3 = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"valueMappedToRed"));
            f4 = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"valueMappedToBlue"));
            if (Float.isNaN(f)) {
                f3 = -1.0f;
                f = -1.0f;
                f4 = 1.0f;
                f2 = 1.0f;
            }
        }
        this.jvxlSetColorRanges(f, f2, f3, f4, bl);
    }

    protected void jvxlSetColorRanges(float f, float f2, float f3, float f4, boolean bl) {
        if (this.jvxlDataIsColorMapped) {
            if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                if (f2 == 0.0f && f == 0.0f) {
                    f = -1.0f;
                    f2 = 1.0f;
                }
                this.params.mappedDataMin = f;
                this.params.mappedDataMax = f2;
                Logger.info((String)("JVXL read: data_min/max " + this.params.mappedDataMin + "/" + this.params.mappedDataMax));
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(f3) && !Float.isNaN(f4)) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        f3 = -1.0f;
                        f4 = 1.0f;
                    }
                    this.params.valueMappedToRed = Math.min(f3, f4);
                    this.params.valueMappedToBlue = Math.max(f3, f4);
                    this.params.isColorReversed = f3 > f4;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info((String)("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue));
        }
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        this.jvxlData.insideOut = bl;
        if (this.params.insideOut) {
            this.jvxlData.insideOut = !this.jvxlData.insideOut;
        }
        this.params.insideOut = this.jvxlData.insideOut;
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        boolean bl2 = this.thisInside = !this.params.isContoured;
        if (this.readSurfaceData()) {
            return;
        }
        this.tempDataXml = this.xr.getXmlData("jvxlEdgeData", null, true, false);
        this.bsVoxelBitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlEdgeData", this.tempDataXml, false, false));
        this.readVolumeFileSurfaceData();
    }

    protected boolean readSurfaceData() throws Exception {
        if (this.vertexDataOnly) {
            this.getEncodedVertexData();
            return true;
        }
        if (this.params.thePlane != null) {
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            this.setVolumeData(this.volumeData);
            this.params.cutoff = 0.0f;
            this.jvxlData.setSurfaceInfo(this.params.thePlane, 0, "");
            this.jvxlData.scale3d = this.params.scale3d;
            return true;
        }
        return false;
    }

    protected void readVolumeFileSurfaceData() throws Exception {
        super.readSurfaceData(false);
        this.volumeData.setMappingPlane(null);
    }

    protected String jvxlReadData(String string, int n) {
        String string2;
        try {
            if (string.equals("edge")) {
                string2 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)this.tempDataXml, (String)"data"));
            } else {
                String string3 = this.xr.getXmlData("jvxlColorData", null, true, false);
                this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib((String)string3, (String)"encoding").endsWith("2");
                string2 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)string3, (String)"data"));
            }
        }
        catch (Exception exception) {
            Logger.error((String)("Error reading " + string + " data " + exception));
            throw new NullPointerException();
        }
        return string2;
    }

    protected BitSet getVoxelBitSet(int n) throws Exception {
        if (this.bsVoxelBitSet != null) {
            return this.bsVoxelBitSet;
        }
        BitSet bitSet = new BitSet();
        if (this.surfaceDataCount <= 0) {
            return bitSet;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = this.parseInt();
            if (n2 == Integer.MIN_VALUE) {
                this.readLine();
                if (this.line == null || (n2 = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error((String)("end of file in JvxlReader? line=" + this.line));
                    }
                    this.endOfData = true;
                    n2 = 10000;
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
            if (!this.thisInside) continue;
            bitSet.set(i, i + n2);
        }
        return bitSet;
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, int n, int n2, int n3, int n4, int n5, float[] fArray, Point3f point3f2) {
        if (this.edgeDataCount <= 0) {
            return super.getSurfacePointAndFraction(f, bl, f2, f3, point3f, vector3f, n, n2, n3, n4, n5, fArray, point3f2);
        }
        fArray[0] = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        point3f2.scaleAdd(fArray[0], (Tuple3f)vector3f, (Tuple3f)point3f);
        if (Float.isNaN(this.valueMin)) {
            this.setValueMinMax();
        }
        return this.valueCount == 0 || this.includeValueNaN && Float.isNaN(fArray[0]) ? fArray[0] : this.getNextValue();
    }

    private float getNextValue() {
        float f = Float.NaN;
        if (this.colorPtr < this.valueCount && Float.isNaN(f)) {
            f = this.jvxlData.isJvxlPrecisionColor ? JvxlCoder.jvxlFractionFromCharacter2(this.jvxlColorDataRead.charAt(this.colorPtr), this.jvxlColorDataRead.charAt(this.colorPtr++ + this.valueCount), this.colorFractionBase, this.colorFractionRange) : JvxlCoder.jvxlFractionFromCharacter(this.jvxlColorDataRead.charAt(this.colorPtr++), this.colorFractionBase, this.colorFractionRange, 0.5f);
        }
        return this.valueMin + f * this.valueRange;
    }

    private void setValueMinMax() {
        this.valueCount = this.jvxlColorDataRead.length();
        if (this.jvxlData.isJvxlPrecisionColor) {
            this.valueCount /= 2;
        }
        boolean bl = this.includeValueNaN = this.valueCount != this.jvxlEdgeDataRead.length();
        float f = !this.jvxlData.isJvxlPrecisionColor ? this.params.valueMappedToRed : (this.valueMin = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin);
        this.valueRange = (!this.jvxlData.isJvxlPrecisionColor ? this.params.valueMappedToBlue : (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax)) - this.valueMin;
        this.haveReadColorData = true;
    }

    private float jvxlGetNextFraction(int n, int n2, float f) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error((String)"end of file reading compressed fraction data");
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)n;
            this.fractionPtr = 0;
        }
        return JvxlCoder.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), n, n2, f);
    }

    protected String readColorData() {
        float f;
        int n;
        int n2 = this.jvxlData.vertexCount = this.meshData.vertexCount;
        short[] sArray = this.meshData.vertexColixes;
        float[] fArray = this.meshData.vertexValues;
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null);
        }
        this.params.colorEncoder.setColorScheme(null, false);
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        Logger.info((String)("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + n2 + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange));
        Logger.info((String)("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlData.isJvxlPrecisionColor));
        boolean bl = Float.isNaN(this.valueMin);
        if (bl) {
            this.setValueMinMax();
        }
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        if (sArray == null || sArray.length < n2) {
            this.meshData.vertexColixes = sArray = new short[n2];
        }
        short s = 0;
        short s2 = 0;
        if (this.params.colorBySign) {
            s2 = Graphics3D.getColix((int)(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos));
            s = Graphics3D.getColix((int)(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg));
        }
        int n3 = this.meshData.vertexIncrement;
        boolean bl2 = this.params.mappedDataMin == Float.MAX_VALUE;
        for (n = 0; n < n2; n += n3) {
            f = bl ? (fArray[n] = this.getNextValue()) : fArray[n];
            if (!bl2) continue;
            if (f < f2) {
                f2 = f;
            }
            if (!(f > f3)) continue;
            f3 = f;
        }
        if (bl2) {
            this.params.mappedDataMin = f2;
            this.params.mappedDataMax = f3;
        }
        if (this.jvxlData.colorScheme != null) {
            for (n = 0; n < n2; n += n3) {
                f = fArray[n];
                if (this.marchingSquares != null && this.params.isContoured) {
                    this.marchingSquares.setContourData(n, f);
                    continue;
                }
                short s3 = !this.params.colorBySign ? this.params.colorEncoder.getColorIndex(f) : ((this.params.isColorReversed ? f > 0.0f : f <= 0.0f) ? s : s2);
                sArray[n] = Graphics3D.getColixTranslucent((short)s3, (boolean)true, (float)this.jvxlData.translucency);
            }
        }
        return this.jvxlColorDataRead + "\n";
    }

    protected void getEncodedVertexData() throws Exception {
        String string = this.xr.getXmlData("jvxlSurfaceData", null, true, false);
        String string2 = this.xr.getXmlData("jvxlTriangleData", string, true, false);
        String string3 = this.xr.getXmlData("jvxlTriangleEdgeData", string, true, false);
        this.jvxlDecodeVertexData(this.xr.getXmlData("jvxlVertexData", string, true, false), false);
        String string4 = this.xr.getXmlData("jvxlPolygonColorData", string, false, false);
        this.jvxlDecodeTriangleData(string2, string3, string4);
        Logger.info((String)"Checking for vertex values");
        string = this.xr.getXmlData("jvxlColorData", string, true, false);
        this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib((String)string, (String)"encoding").endsWith("2");
        this.jvxlColorDataRead = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)string, (String)"data"));
        if (this.jvxlColorDataRead.length() == 0) {
            this.jvxlColorDataRead = this.xr.getXmlData("jvxlColorData", string, false, false);
        }
        boolean bl = this.jvxlDataIsColorMapped = (this.params.colorRgb == Integer.MIN_VALUE || this.params.colorRgb == Integer.MAX_VALUE) && this.jvxlColorDataRead.length() > 0;
        if (this.haveContourData) {
            this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false, false));
        }
    }

    public Point3f[] jvxlDecodeVertexData(String string, boolean bl) throws Exception {
        int n = this.parseInt(XmlReader.getXmlAttrib((String)string, (String)"count"));
        if (!bl) {
            Logger.info((String)("Reading " + n + " vertices"));
        }
        Point3f point3f = this.xr.getXmlPoint(string, "min");
        Point3f point3f2 = this.xr.getXmlPoint(string, "max");
        point3f2.sub((Tuple3f)point3f);
        int n2 = this.jvxlData.colorFractionBase;
        int n3 = this.jvxlData.colorFractionRange;
        int n4 = n * 3;
        Point3f[] point3fArray = bl ? new Point3f[n] : null;
        Point3f point3f3 = bl ? null : new Point3f();
        String string2 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)string, (String)"data"));
        if (string2.length() == 0) {
            string2 = this.xr.getXmlData("jvxlVertexData", string, false, false);
        }
        int n5 = -1;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                point3f3 = point3fArray[i] = new Point3f();
            }
            float f = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(++n5), string2.charAt(n5 + n4), n2, n3);
            point3f3.x = point3f.x + f * point3f2.x;
            f = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(++n5), string2.charAt(n5 + n4), n2, n3);
            point3f3.y = point3f.y + f * point3f2.y;
            f = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(++n5), string2.charAt(n5 + n4), n2, n3);
            point3f3.z = point3f.z + f * point3f2.z;
            if (bl) continue;
            this.addVertexCopy(point3f3, 0.0f, i);
        }
        return point3fArray;
    }

    int[][] jvxlDecodeTriangleData(String string, String string2, String string3) throws Exception {
        int n = string3 == null ? -1 : 0;
        int n2 = 0;
        int n3 = this.parseInt(XmlReader.getXmlAttrib((String)string, (String)"count"));
        if (n3 < 0) {
            return null;
        }
        Logger.info((String)("Reading " + n3 + " triangles"));
        int[][] nArray = null;
        int[] nArray2 = new int[3];
        String string4 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)string, (String)"data"));
        if (string4.length() == 0) {
            string4 = this.xr.getXmlData("jvxlTriangleData", string, false, false);
        }
        String string5 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)string2, (String)"data")).trim();
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n4 = 7;
        boolean bl = string5.length() == n3;
        int n5 = 0;
        int n6 = 0;
        int n7 = 92;
        int n8 = 0;
        int n9 = -1;
        block5: while (n8 < n3) {
            int n10;
            char c = string4.charAt(++n9);
            switch (c) {
                case '!': {
                    n10 = 0;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '+': 
                case ',': 
                case '.': {
                    continue block5;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nArray3[0] = n9;
                    n10 = Parser.parseInt((String)string4, (int[])nArray3);
                    n9 = nArray3[0] - 1;
                    break;
                }
                default: {
                    n10 = c - n7;
                }
            }
            nArray2[n6] = n5 += n10;
            if (++n6 % 3 != 0) continue;
            if (bl && ((n4 = string5.charAt(n8) - 48) < 0 || n4 > 7)) {
                n4 = 7;
            }
            if (n >= 0) {
                if (n == 0) {
                    n = Parser.parseInt((String)string3, (int[])nArray4);
                    n2 = Parser.parseInt((String)string3, (int[])nArray4);
                    if (n2 == Integer.MIN_VALUE) {
                        n = 0;
                        n2 = 0;
                    }
                }
                --n;
            }
            this.addTriangleCheck(nArray2[0], nArray2[1], nArray2[2], n4, 0, false, n2);
            ++n8;
            n6 = 0;
        }
        return nArray;
    }

    protected void jvxlDecodeContourData(JvxlData jvxlData, String string) throws Exception {
        ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = -1;
        jvxlData.vContours = null;
        if (string == null) {
            return;
        }
        while ((n = string.indexOf("<jvxlContour", n + 1)) >= 0) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String string2 = this.xr.getXmlData("jvxlContour", string.substring(n), true, false);
            float f = this.parseFloat(XmlReader.getXmlAttrib((String)string2, (String)"value"));
            stringBuffer.append(" ").append(f);
            short s = Graphics3D.getColix((int)ColorUtil.getArgbFromString((String)XmlReader.getXmlAttrib((String)string2, (String)"color")));
            int n2 = Graphics3D.getArgb((short)s);
            stringBuffer2.append(" ").append(Escape.escapeColor((int)n2));
            String string3 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib((String)string2, (String)"data"));
            BitSet bitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlContour", string2, false, false));
            int n3 = bitSet.length();
            IsosurfaceMesh.setContourVector(arrayList2, n3, bitSet, f, s, n2, new StringBuffer(string3));
            arrayList.add(arrayList2);
        }
        int n4 = arrayList.size();
        if (n4 > 0) {
            jvxlData.vContours = ArrayUtil.createArrayOfArrayList((int)n4);
            this.params.contourColixes = new short[n4];
            jvxlData.contourColixes = this.params.contourColixes;
            this.params.contoursDiscrete = new float[n4];
            jvxlData.contourValues = this.params.contoursDiscrete;
            for (int i = 0; i < n4; ++i) {
                jvxlData.vContours[i] = (List)arrayList.get(i);
                jvxlData.contourValues[i] = ((Float)jvxlData.vContours[i].get(2)).floatValue();
                jvxlData.contourColixes[i] = ((short[])jvxlData.vContours[i].get(3))[0];
            }
            jvxlData.contourColors = Graphics3D.getHexCodes((short[])jvxlData.contourColixes);
            Logger.info((String)("JVXL read: " + n4 + " discrete contours"));
            Logger.info((String)("JVXL read: contour values: " + stringBuffer));
            Logger.info((String)("JVXL read: contour colors: " + stringBuffer2));
        }
    }

    protected void postProcessVertices() {
        BitSet bitSet = this.params.bsExcluded[1];
        if (bitSet != null) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.meshData.invalidateVertices(bitSet);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 4, null);
                this.meshData = new MeshData();
            }
            this.updateTriangles();
        }
    }
}

