/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Random;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

class IsoShapeReader
extends VolumeDataReader {
    private int psi_n = 2;
    private int psi_l = 1;
    private int psi_m = 1;
    private float psi_Znuc = 1.0f;
    private float sphere_radiusAngstroms;
    private int monteCarloCount;
    private Random random;
    private boolean allowNegative = true;
    private double[] rfactor = new double[10];
    private double[] pfactor = new double[10];
    private static final double A0 = 0.52918;
    private static final double ROOT2 = 1.414214;
    private static final float ATOMIC_ORBITAL_ZERO_CUT_OFF = 1.0E-7f;
    private float radius;
    private final Point3f ptPsi = new Point3f();
    private static final float[] fact = new float[20];
    private double psi_normalization = 1.0 / (2.0 * Math.sqrt(Math.PI));
    private double aoMax;
    private double aoMax2;
    private double angMax2;
    private Vector3f planeU;
    private Vector3f planeV;
    private Point3f planeCenter;
    private float planeRadius;
    private double rnl;
    private boolean monteCarloDone;
    private int nTries;

    IsoShapeReader(SurfaceGenerator surfaceGenerator, float f) {
        super(surfaceGenerator);
        this.sphere_radiusAngstroms = f;
    }

    IsoShapeReader(SurfaceGenerator surfaceGenerator, int n, int n2, int n3, float f, int n4) {
        super(surfaceGenerator);
        this.psi_n = n;
        this.psi_l = n2;
        this.psi_m = n3;
        this.psi_Znuc = f;
        this.sphere_radiusAngstroms = 0.0f;
        this.monteCarloCount = n4;
    }

    protected void setup(boolean bl) {
        this.volumeData.sr = this;
        this.precalculateVoxelData = false;
        this.isQuiet = true;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        String string = "sphere";
        switch (this.dataType) {
            case 1294: {
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.autoScaleOrbital();
                this.ptsPerAngstrom = 5.0f;
                this.maxGrid = 40;
                string = "hydrogen-like orbital";
                if (this.monteCarloCount > 0) {
                    this.vertexDataOnly = true;
                    this.random = new Random(this.params.randomSeed);
                    break;
                }
                this.isQuiet = false;
                break;
            }
            case 70: 
            case 71: {
                string = "lp";
                this.vertexDataOnly = true;
                this.radius = 0.0f;
                this.ptsPerAngstrom = 1.0f;
                this.maxGrid = 1;
                break;
            }
            case 68: {
                this.allowNegative = false;
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.psi_normalization = 1.0;
                this.radius = 1.1f * this.eccentricityRatio * this.eccentricityScale;
                if (this.eccentricityScale > 0.0f && this.eccentricityScale < 1.0f) {
                    this.radius /= this.eccentricityScale;
                }
                this.ptsPerAngstrom = 10.0f;
                this.maxGrid = 21;
                string = "lobe";
                break;
            }
            case 67: {
                string = "ellipsoid(thermal)";
                this.radius = 3.0f * this.sphere_radiusAngstroms;
                this.ptsPerAngstrom = 10.0f;
                this.maxGrid = 22;
                break;
            }
            case 66: {
                string = "ellipsoid";
            }
            default: {
                this.radius = 1.2f * this.sphere_radiusAngstroms * this.eccentricityScale;
                this.ptsPerAngstrom = 10.0f;
                this.maxGrid = 22;
            }
        }
        if (this.monteCarloCount == 0) {
            this.setVolumeData();
        }
        this.setHeader(string + "\n");
    }

    protected void setVolumeData() {
        this.setVoxelRange(0, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid);
        this.setVoxelRange(1, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid);
        if (this.allowNegative) {
            this.setVoxelRange(2, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid);
        } else {
            this.setVoxelRange(2, 0.0f, this.radius / this.eccentricityRatio, this.ptsPerAngstrom, this.maxGrid);
        }
    }

    public float getValue(int n, int n2, int n3, int n4) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptPsi);
        return this.getValueAtPoint(this.ptPsi);
    }

    public float getValueAtPoint(Point3f point3f) {
        this.ptTemp.set((Tuple3f)point3f);
        this.ptTemp.sub((Tuple3f)this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.transform((Tuple3f)this.ptTemp);
        }
        if (this.isAnisotropic) {
            this.ptTemp.x /= this.anisotropy[0];
            this.ptTemp.y /= this.anisotropy[1];
            this.ptTemp.z /= this.anisotropy[2];
        }
        if (this.sphere_radiusAngstroms > 0.0f) {
            if (this.params.anisoB != null) {
                return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptTemp.x * this.ptTemp.x + this.ptTemp.y * this.ptTemp.y + this.ptTemp.z * this.ptTemp.z) / (float)Math.sqrt(this.params.anisoB[0] * this.ptTemp.x * this.ptTemp.x + this.params.anisoB[1] * this.ptTemp.y * this.ptTemp.y + this.params.anisoB[2] * this.ptTemp.z * this.ptTemp.z + this.params.anisoB[3] * this.ptTemp.x * this.ptTemp.y + this.params.anisoB[4] * this.ptTemp.x * this.ptTemp.z + this.params.anisoB[5] * this.ptTemp.y * this.ptTemp.z);
            }
            return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptTemp.x * this.ptTemp.x + this.ptTemp.y * this.ptTemp.y + this.ptTemp.z * this.ptTemp.z);
        }
        float f = (float)this.hydrogenAtomPsi(this.ptTemp);
        if (Math.abs(f) < 1.0E-7f) {
            f = 0.0f;
        }
        return this.allowNegative || f >= 0.0f ? f : 0.0f;
    }

    private void setHeader(String string) {
        this.jvxlFileHeaderBuffer = new StringBuffer(string);
        if (this.sphere_radiusAngstroms > 0.0f) {
            this.jvxlFileHeaderBuffer.append(" rad=").append(this.sphere_radiusAngstroms);
        } else {
            this.jvxlFileHeaderBuffer.append(" n=").append(this.psi_n).append(", l=").append(this.psi_l).append(", m=").append(this.psi_m).append(" Znuc=").append(this.psi_Znuc).append(" res=").append(this.ptsPerAngstrom).append(" rad=").append(this.radius);
        }
        this.jvxlFileHeaderBuffer.append(this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")\n" : "\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    private void calcFactors(int n, int n2, int n3) {
        int n4;
        int n5 = Math.abs(n3);
        double d = Math.pow((double)(2.0f * this.psi_Znuc / (float)n) / 0.52918, 1.5) * Math.sqrt(fact[n - n2 - 1] * fact[n + n2] / 2.0f / (float)n);
        double d2 = Math.pow(2.0, -n2) * (double)fact[n2] * (double)fact[n2 + n5] * Math.sqrt((float)(2 * n2 + 1) * fact[n2 - n5] / 2.0f / fact[n2 + n5]);
        for (n4 = 0; n4 <= n - n2 - 1; ++n4) {
            this.rfactor[n4] = d / (double)fact[n4] / (double)fact[n - n2 - n4 - 1] / (double)fact[2 * n2 + n4 + 1];
        }
        for (n4 = n5; n4 <= n2; ++n4) {
            this.pfactor[n4] = Math.pow(-1.0, n2 - n4) * d2 / (double)fact[n4] / (double)fact[n2 + n5 - n4] / (double)fact[n2 - n4] / (double)fact[n4 - n5];
        }
    }

    private void autoScaleOrbital() {
        double d;
        double d2;
        this.aoMax = 0.0;
        float f = 0.0f;
        this.aoMax2 = 0.0;
        float f2 = 0.0f;
        if (this.params.distance == 0.0f) {
            for (int i = 0; i < 1000; ++i) {
                float f3 = (float)i / 10.0f;
                d2 = Math.abs(this.radialPart(f3));
                if (Logger.debugging) {
                    Logger.debug((String)("R\t" + f3 + "\t" + d2));
                }
                if (d2 >= this.aoMax) {
                    f = f3;
                    this.aoMax = d2;
                }
                if (!((d2 *= d2 * (double)f3 * (double)f3) >= this.aoMax2)) continue;
                f2 = f3;
                this.aoMax2 = d2;
            }
        } else {
            this.aoMax = Math.abs(this.radialPart(this.params.distance));
            this.aoMax2 = this.aoMax * this.aoMax * (double)this.params.distance * (double)this.params.distance;
            f = f2 = this.params.distance;
        }
        Logger.info((String)("Atomic Orbital radial max = " + this.aoMax + " at " + f));
        Logger.info((String)("Atomic Orbital r2R2 max = " + this.aoMax2 + " at " + f2));
        if (this.monteCarloCount >= 0) {
            this.angMax2 = 0.0;
            for (float f4 = 0.0f; f4 < 180.0f; f4 += 1.0f) {
                double d3 = (double)f4 / (Math.PI * 2);
                d2 = Math.abs(this.angularPart(d3, 0.0, 0));
                if (Logger.debugging) {
                    Logger.debug((String)("A\t" + f4 + "\t" + d2));
                }
                if (!(d2 > this.angMax2)) continue;
                this.angMax2 = d2;
            }
            this.angMax2 *= this.angMax2;
            if (this.psi_m != 0) {
                this.angMax2 *= 2.0;
            }
            Logger.info((String)("Atomic Orbital phi^2theta^2 max = " + this.angMax2));
        }
        if (this.params.cutoff == 0.0f) {
            d = this.monteCarloCount > 0 ? this.aoMax * (double)0.01f : (double)0.01f;
        } else if (this.monteCarloCount > 0) {
            this.aoMax = Math.abs(this.params.cutoff);
            d = this.aoMax * (double)0.01f;
        } else {
            d = Math.abs(this.params.cutoff / 2.0f);
            if (this.params.isSquared) {
                d = Math.sqrt(d / 2.0);
            }
        }
        float f5 = 0.0f;
        int n = 1000;
        while (--n >= 0) {
            float f6 = (float)n / 10.0f;
            d2 = Math.abs(this.radialPart(f6));
            if (d2 >= d) {
                f5 = f6;
                break;
            }
            --n;
        }
        this.radius = f5 + (float)(this.monteCarloCount == 0 ? 1 : 0);
        if (this.isAnisotropic) {
            float f7 = 0.0f;
            int n2 = 3;
            while (--n2 >= 0) {
                if (!(this.anisotropy[n2] > f7)) continue;
                f7 = this.anisotropy[n2];
            }
            this.radius *= f7;
        }
        Logger.info((String)("Atomic Orbital radial extent set to " + this.radius + " for cutoff " + this.params.cutoff));
        if (this.params.thePlane != null && this.monteCarloCount > 0) {
            this.planeCenter = new Point3f();
            this.planeU = new Vector3f();
            Measure.getPlaneProjection((Point3f)this.center, (Point4f)this.params.thePlane, (Point3f)this.planeCenter, (Vector3f)this.planeU);
            this.planeU.set(this.params.thePlane.x, this.params.thePlane.y, this.params.thePlane.z);
            this.planeU.normalize();
            this.planeV = new Vector3f(1.0f, 0.0f, 0.0f);
            if (Math.abs(this.planeU.dot(this.planeV)) > 0.5f) {
                this.planeV.set(0.0f, 1.0f, 0.0f);
            }
            this.planeV.cross(this.planeU, this.planeV);
            this.planeU.cross(this.planeU, this.planeV);
            this.aoMax2 = 0.0;
            d2 = this.center.distance(this.planeCenter);
            if (d2 < (double)this.radius) {
                this.planeRadius = (float)Math.sqrt((double)(this.radius * this.radius) - d2 * d2);
                int n3 = (int)(this.planeRadius * 10.0f);
                for (int i = -n3; i <= n3; ++i) {
                    for (int j = -n3; j <= n3; ++j) {
                        this.ptPsi.set((Tuple3f)this.planeU);
                        this.ptPsi.scale((float)i / 10.0f);
                        this.ptPsi.scaleAdd((float)j / 10.0f, (Tuple3f)this.planeV, (Tuple3f)this.ptPsi);
                        d2 = this.hydrogenAtomPsi(this.ptPsi);
                        d2 = Math.abs(this.hydrogenAtomPsi(this.ptPsi));
                        if (!(d2 > this.aoMax2)) continue;
                        this.aoMax2 = d2;
                    }
                }
                this.aoMax2 = this.aoMax2 < (double)0.001f ? 0.0 : (this.aoMax2 *= this.aoMax2);
            }
        }
    }

    private double radialPart(double d) {
        double d2 = 2.0 * (double)this.psi_Znuc * d / (double)this.psi_n / 0.52918;
        double d3 = 0.0;
        for (int i = 0; i <= this.psi_n - this.psi_l - 1; ++i) {
            d3 += Math.pow(-d2, i) * this.rfactor[i];
        }
        return Math.exp(-d2 / 2.0) * Math.pow(d2, this.psi_l) * d3;
    }

    private double hydrogenAtomPsi(Point3f point3f) {
        double d = point3f.x * point3f.x + point3f.y * point3f.y;
        this.rnl = this.radialPart(Math.sqrt(d + (double)(point3f.z * point3f.z)));
        double d2 = Math.atan2(point3f.y, point3f.x);
        double d3 = Math.atan2(Math.sqrt(d), point3f.z);
        double d4 = this.angularPart(d3, d2, this.psi_m);
        return this.rnl * d4;
    }

    private double angularPart(double d, double d2, int n) {
        double d3;
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        boolean bl = n == 0 && this.psi_l == 0;
        int n2 = Math.abs(n);
        double d6 = 0.0;
        if (bl) {
            d6 = this.pfactor[0];
        } else {
            for (int i = n2; i <= this.psi_l; ++i) {
                d6 += (i == n2 ? 1.0 : Math.pow(1.0 + d4, i - n2)) * (i == this.psi_l ? 1.0 : Math.pow(1.0 - d4, this.psi_l - i)) * this.pfactor[i];
            }
        }
        double d7 = d3 = n2 == 0 ? d6 : Math.abs(Math.pow(d5, n2)) * d6;
        double d8 = n == 0 ? 1.0 : (n > 0 ? Math.cos((double)n * d2) * 1.414214 : Math.sin((double)n * d2) * 1.414214);
        return Math.abs(d8) < 1.0E-10 ? 0.0 : d3 * d8 * this.psi_normalization;
    }

    private void createMonteCarloOrbital() {
        if (this.monteCarloDone || this.aoMax2 == 0.0 || this.params.distance > this.radius) {
            return;
        }
        boolean bl = this.psi_m == 0 && this.psi_l == 0;
        this.monteCarloDone = true;
        float f = 0.0f;
        this.nTries = 0;
        int n = 0;
        while (n < this.monteCarloCount) {
            block9: {
                float f2;
                block10: {
                    block6: {
                        double d;
                        double d2;
                        double d3;
                        double d4;
                        block8: {
                            block7: {
                                if (this.params.thePlane != null) break block6;
                                if (this.params.distance != 0.0f) break block7;
                                d4 = this.random.nextDouble() * (double)this.radius;
                                d3 = d4 * this.radialPart(d4);
                                if (!(d3 * d3 <= this.aoMax2 * this.random.nextDouble())) break block8;
                                break block9;
                            }
                            d4 = this.params.distance;
                        }
                        d3 = this.random.nextDouble();
                        double d5 = this.random.nextDouble();
                        double d6 = Math.PI * 2 * d3;
                        double d7 = 2.0 * d5 - 1.0;
                        if (!bl && (d2 = this.angularPart(d = Math.acos(d7), d6, this.psi_m)) * d2 <= this.angMax2 * this.random.nextDouble()) break block9;
                        d = Math.sin(Math.acos(d7));
                        d2 = d4 * Math.cos(d6) * d;
                        double d8 = d4 * Math.sin(d6) * d;
                        double d9 = d4 * d7;
                        this.ptPsi.set((float)d2, (float)d8, (float)d9);
                        this.ptPsi.add((Tuple3f)this.center);
                        f2 = this.getValueAtPoint(this.ptPsi);
                        break block10;
                    }
                    this.ptPsi.set((Tuple3f)this.planeU);
                    this.ptPsi.scale(this.random.nextFloat() * this.planeRadius * 2.0f - this.planeRadius);
                    this.ptPsi.scaleAdd(this.random.nextFloat() * this.planeRadius * 2.0f - this.planeRadius, (Tuple3f)this.planeV, (Tuple3f)this.ptPsi);
                    this.ptPsi.add((Tuple3f)this.planeCenter);
                    f2 = this.getValueAtPoint(this.ptPsi);
                    if ((double)(f2 * f2) <= this.aoMax2 * (double)this.random.nextFloat()) break block9;
                }
                f += this.ptPsi.distance(this.center);
                this.addVertexCopy(this.ptPsi, f2, 0);
                ++n;
            }
            ++this.nTries;
        }
        if (this.params.distance == 0.0f) {
            Logger.info((String)("Atomic Orbital mean radius = " + f / (float)this.monteCarloCount + " for " + this.monteCarloCount + " points (" + this.nTries + " tries)"));
        }
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        switch (this.params.dataType) {
            case 1294: {
                if (this.monteCarloCount <= 0) break;
                this.createMonteCarloOrbital();
                return;
            }
            case 70: 
            case 71: {
                this.ptPsi.set(0.0f, 0.0f, this.eccentricityScale / 2.0f);
                this.eccentricityMatrixInverse.transform((Tuple3f)this.ptPsi);
                this.ptPsi.add((Tuple3f)this.center);
                this.addVertexCopy(this.center, 0.0f, 0);
                this.addVertexCopy(this.ptPsi, 0.0f, 0);
                this.addTriangleCheck(0, 0, 0, 0, 0, false, 0);
                return;
            }
        }
        super.readSurfaceData(bl);
    }

    static {
        IsoShapeReader.fact[0] = 1.0f;
        for (int i = 1; i < 20; ++i) {
            IsoShapeReader.fact[i] = fact[i - 1] * (float)i;
        }
    }
}

