/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import java.util.List;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BitSetUtil;
import org.jmol.util.JmolNode;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;

    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    public String getMolecularFormula(String string, boolean bl) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.createTopoMap(null);
            smilesSearch.nodes = smilesSearch.jmolAtoms;
            return smilesSearch.getMolecularFormula(!bl);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(invalidSmilesException.getMessage());
            }
            return null;
        }
    }

    public String getSmiles(JmolNode[] jmolNodeArray, int n, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, String string) {
        InvalidSmilesException.setLastError(null);
        try {
            if (bl) {
                return new SmilesGenerator().getBioSmiles(jmolNodeArray, n, bitSet, bl2, bl3, string);
            }
            return new SmilesGenerator().getSmiles(jmolNodeArray, n, bitSet);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(invalidSmilesException.getMessage());
            }
            return null;
        }
    }

    public int areEqual(String string, String string2) {
        BitSet[] bitSetArray = this.find(string, string2, false, false);
        return bitSetArray == null ? -1 : bitSetArray.length;
    }

    public boolean areEqual(String string, SmilesSearch smilesSearch) {
        BitSet[] bitSetArray = this.find(string, smilesSearch, false, true, true);
        return bitSetArray != null && bitSetArray.length == 1;
    }

    public BitSet[] find(String string, String string2, boolean bl, boolean bl2) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string2, false);
            return this.find(string, smilesSearch, bl, !bl, bl2);
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(exception.getMessage());
            }
            exception.printStackTrace();
            return null;
        }
    }

    public String getRelationship(String string, String string2) {
        int n;
        boolean bl;
        String string3;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string4 = this.getMolecularFormula(string, false);
        if (!string4.equals(string3 = this.getMolecularFormula(string2, false))) {
            return "none";
        }
        int n2 = this.countStereo(string);
        boolean bl2 = bl = n2 == (n = this.countStereo(string2)) && this.areEqual(string2, string) > 0;
        if (!bl) {
            String string5 = string + string2;
            if (string5.indexOf("/") >= 0 || string5.indexOf("\\") >= 0 || string5.indexOf("@") >= 0) {
                if (n2 == n && n2 > 0) {
                    boolean bl3 = bl = this.areEqual(string = this.reverseChirality(string), string2) > 0;
                    if (bl) {
                        return "enantiomers";
                    }
                }
                boolean bl4 = bl = this.areEqual("/nostereo/" + string2, string) > 0;
                if (bl) {
                    return n2 == n ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    public String reverseChirality(String string) {
        string = TextFormat.simpleReplace((String)string, (String)"@@", (String)"!@");
        string = TextFormat.simpleReplace((String)string, (String)"@", (String)"@@");
        string = TextFormat.simpleReplace((String)string, (String)"!@@", (String)"@");
        string = TextFormat.simpleReplace((String)string, (String)"@@SP", (String)"@SP");
        string = TextFormat.simpleReplace((String)string, (String)"@@OH", (String)"@OH");
        string = TextFormat.simpleReplace((String)string, (String)"@@TB", (String)"@TB");
        return string;
    }

    public BitSet getSubstructureSet(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, boolean bl, boolean bl2) {
        return (BitSet)this.match(string, jmolNodeArray, n, bitSet, null, bl, false, bl2, 1);
    }

    public void getSubstructureSets(String[] stringArray, JmolNode[] jmolNodeArray, int n, int n2, BitSet bitSet, List<BitSet> list, List<BitSet>[] listArray) {
        InvalidSmilesException.setLastError(null);
        SmilesParser smilesParser = new SmilesParser(true);
        SmilesSearch smilesSearch = null;
        try {
            smilesSearch = smilesParser.parse("");
            smilesSearch.firstMatchOnly = false;
            smilesSearch.matchAllAtoms = false;
            smilesSearch.jmolAtoms = jmolNodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            smilesSearch.setSelected(bitSet);
            smilesSearch.getRingData(true, n2, listArray);
            smilesSearch.asVector = false;
            smilesSearch.subSearches = new SmilesSearch[1];
            smilesSearch.getSelections();
        }
        catch (InvalidSmilesException invalidSmilesException) {
            // empty catch block
        }
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0 || stringArray[i].startsWith("#")) {
                list.add(null);
                continue;
            }
            try {
                SmilesSearch smilesSearch2;
                smilesSearch.clear();
                smilesSearch.subSearches[0] = smilesSearch2 = smilesParser.getSearch(smilesSearch, SmilesParser.cleanPattern(stringArray[i]), n2);
                BitSet bitSet3 = BitSetUtil.copy((BitSet)((BitSet)smilesSearch.search(false)));
                list.add(bitSet3);
                bitSet2.or(bitSet3);
                if (bitSet2.cardinality() != n) continue;
                return;
            }
            catch (Exception exception) {
                if (InvalidSmilesException.getLastError() == null) {
                    InvalidSmilesException.setLastError(exception.getMessage());
                }
                exception.printStackTrace();
            }
        }
    }

    public BitSet[] getSubstructureSetArray(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        return (BitSet[])this.match(string, jmolNodeArray, n, bitSet, bitSet2, bl, false, bl2, 2);
    }

    public int[][] getCorrelationMaps(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, boolean bl, boolean bl2) {
        return (int[][])this.match(string, jmolNodeArray, n, bitSet, null, bl, false, bl2, 3);
    }

    private BitSet[] find(String string, SmilesSearch smilesSearch, boolean bl, boolean bl2, boolean bl3) {
        BitSet bitSet = new BitSet();
        smilesSearch.createTopoMap(bitSet);
        return (BitSet[])this.match(string, smilesSearch.jmolAtoms, -smilesSearch.jmolAtoms.length, null, bitSet, bl, bl2, bl3, 2);
    }

    private Object match(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, boolean bl3, int n2) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.jmolAtoms = jmolNodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.isSmilesFind = true;
            }
            smilesSearch.setSelected(bitSet);
            smilesSearch.getSelections();
            smilesSearch.bsRequired = null;
            smilesSearch.setRingData(bitSet2);
            smilesSearch.firstMatchOnly = bl3;
            smilesSearch.matchAllAtoms = bl2;
            switch (n2) {
                case 1: {
                    smilesSearch.asVector = false;
                    return smilesSearch.search(false);
                }
                case 2: {
                    smilesSearch.asVector = true;
                    List list = (List)smilesSearch.search(false);
                    return list.toArray(new BitSet[list.size()]);
                }
                case 3: {
                    smilesSearch.getMaps = true;
                    List list = (List)smilesSearch.search(false);
                    return list.toArray((T[])new int[list.size()][]);
                }
            }
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(exception.getMessage());
            }
            exception.printStackTrace();
        }
        return null;
    }

    private int countStereo(String string) {
        string = TextFormat.simpleReplace((String)string, (String)"@@", (String)"@");
        int n = string.lastIndexOf(64) + 1;
        int n2 = 0;
        while (--n >= 0) {
            if (string.charAt(n) != '@') continue;
            ++n2;
        }
        return n2;
    }
}

