/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.Elements;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmilesAtom
extends Point3f
implements JmolNode {
    static final int STEREOCHEMISTRY_DEFAULT = 0;
    static final int STEREOCHEMISTRY_ALLENE = 2;
    static final int STEREOCHEMISTRY_TETRAHEDRAL = 4;
    static final int STEREOCHEMISTRY_TRIGONAL_BIPYRAMIDAL = 5;
    static final int STEREOCHEMISTRY_OCTAHEDRAL = 6;
    static final int STEREOCHEMISTRY_SQUARE_PLANAR = 8;
    static final String UNBRACKETED_SET = "B, C, N, O, P, S, F, Cl, Br, I,";
    SmilesAtom[] atomsOr;
    int nAtomsOr;
    SmilesAtom[] primitives;
    int nPrimitives;
    int index;
    String atomName;
    String residueName;
    String residueChar;
    boolean isBioAtom;
    char bioType;
    boolean isLeadAtom;
    int notBondedIndex = -1;
    boolean notCrossLinked;
    boolean aromaticAmbiguous = true;
    String atomType;
    private int covalentHydrogenCount = -1;
    boolean not;
    boolean selected;
    boolean hasSymbol;
    boolean isFirst = true;
    int jmolIndex = -1;
    short elementNumber = (short)-2;
    int missingHydrogenCount = Integer.MIN_VALUE;
    int implicitHydrogenCount = Integer.MIN_VALUE;
    SmilesAtom parent;
    SmilesBond[] bonds = new SmilesBond[4];
    int bondCount;
    int iNested = 0;
    private short atomicMass = Short.MIN_VALUE;
    private int charge = Integer.MIN_VALUE;
    private int matchingAtom = -1;
    private int chiralClass = Integer.MIN_VALUE;
    private int chiralOrder = Integer.MIN_VALUE;
    private boolean isAromatic;
    int component;
    int atomSite;
    int degree = -1;
    int nonhydrogenDegree = -1;
    int valence = 0;
    int connectivity = -1;
    int ringMembership = Integer.MIN_VALUE;
    int ringSize = Integer.MIN_VALUE;
    int ringConnectivity = -1;

    static int getChiralityClass(String string) {
        return ("0;11;AL;33;TH;TP;OH;77;SP;".indexOf(string) + 1) / 3;
    }

    static boolean allowSmilesUnbracketed(String string) {
        return UNBRACKETED_SET.indexOf(string + ",") >= 0;
    }

    void setBioAtom(char c) {
        this.isBioAtom = c != '\u0000';
        this.bioType = c;
        if (this.parent != null) {
            this.parent.bioType = c;
            this.parent.isBioAtom = this.isBioAtom;
        }
    }

    void setAtomName(String string) {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            this.atomName = string;
        }
        if (string.equals("0")) {
            this.isLeadAtom = true;
        }
        if (this.parent != null) {
            this.parent.atomName = string;
        }
    }

    public void setBonds(SmilesBond[] smilesBondArray) {
        this.bonds = smilesBondArray;
    }

    public SmilesAtom addAtomOr() {
        SmilesAtom[] smilesAtomArray;
        if (this.atomsOr == null) {
            this.atomsOr = new SmilesAtom[2];
        }
        if (this.nAtomsOr >= this.atomsOr.length) {
            smilesAtomArray = new SmilesAtom[this.atomsOr.length * 2];
            System.arraycopy(this.atomsOr, 0, smilesAtomArray, 0, this.atomsOr.length);
            this.atomsOr = smilesAtomArray;
        }
        smilesAtomArray = new SmilesAtom(this.index);
        smilesAtomArray.parent = this;
        this.atomsOr[this.nAtomsOr] = smilesAtomArray;
        ++this.nAtomsOr;
        return smilesAtomArray;
    }

    public SmilesAtom addPrimitive() {
        SmilesAtom[] smilesAtomArray;
        if (this.primitives == null) {
            this.primitives = new SmilesAtom[2];
        }
        if (this.nPrimitives >= this.primitives.length) {
            smilesAtomArray = new SmilesAtom[this.primitives.length * 2];
            System.arraycopy(this.primitives, 0, smilesAtomArray, 0, this.primitives.length);
            this.primitives = smilesAtomArray;
        }
        smilesAtomArray = new SmilesAtom(this.index);
        smilesAtomArray.parent = this;
        this.primitives[this.nPrimitives] = smilesAtomArray;
        this.setSymbol("*");
        this.hasSymbol = false;
        ++this.nPrimitives;
        return smilesAtomArray;
    }

    public String toString() {
        String string;
        String string2 = this.residueChar != null || this.residueName != null ? (this.residueChar == null ? this.residueName : this.residueChar) + "." + this.atomName : (this.elementNumber == -1 ? "A" : (string = this.elementNumber == -2 ? "*" : Elements.elementSymbolFromNumber((int)this.elementNumber)));
        if (this.isAromatic) {
            string = string.toLowerCase();
        }
        return "[" + string + '.' + this.index + (this.matchingAtom >= 0 ? "(" + this.matchingAtom + ")" : "") + "]";
    }

    public SmilesAtom(int n) {
        this.index = n;
    }

    public SmilesAtom(int n, int n2, int n3, short s, int n4) {
        this.component = n;
        this.index = n2;
        this.atomSite = n3;
        this.elementNumber = s;
        this.charge = n4;
    }

    public boolean setHydrogenCount(SmilesSearch smilesSearch) {
        if (this.missingHydrogenCount != Integer.MIN_VALUE) {
            return true;
        }
        int n = SmilesAtom.getDefaultCount(this.elementNumber, this.isAromatic);
        if (n == -2) {
            return false;
        }
        if (n == -1) {
            return true;
        }
        if (this.elementNumber == 7 && this.isAromatic && this.bondCount == 2 && this.bonds[0].order == 1 && this.bonds[1].order == 1) {
            ++n;
        }
        block6: for (int i = 0; i < this.bondCount; ++i) {
            SmilesBond smilesBond = this.bonds[i];
            switch (smilesBond.order) {
                case 81: {
                    if (this.elementNumber == 7) {
                        Logger.info((String)"Ambiguous bonding to aromatic N found -- MF may be in error");
                    }
                    --n;
                    continue block6;
                }
                case 1: 
                case 257: 
                case 513: {
                    --n;
                    continue block6;
                }
                case 2: {
                    n -= this.isAromatic && this.elementNumber == 6 ? 1 : 2;
                    continue block6;
                }
                case 3: {
                    n -= 3;
                }
            }
        }
        if (n > 0) {
            this.missingHydrogenCount = n;
        }
        return true;
    }

    static int getDefaultCount(int n, boolean bl) {
        switch (n) {
            case -1: 
            case 0: {
                return -1;
            }
            case 6: {
                return bl ? 3 : 4;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 7: {
                return bl ? 2 : 3;
            }
            case 5: 
            case 15: {
                return 3;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -2;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isAromatic() {
        return this.isAromatic;
    }

    public boolean setSymbol(String string) {
        this.isAromatic = string.equals(string.toLowerCase());
        this.hasSymbol = true;
        if (string.equals("*")) {
            this.isAromatic = false;
            this.elementNumber = (short)-2;
            return true;
        }
        if (string.equals("Xx")) {
            this.elementNumber = 0;
            return true;
        }
        this.aromaticAmbiguous = false;
        if (string.equals("a") || string.equals("A")) {
            if (this.elementNumber < 0) {
                this.elementNumber = (short)-1;
            }
            return true;
        }
        if (this.isAromatic) {
            string = string.substring(0, 1).toUpperCase() + (string.length() == 1 ? "" : string.substring(1));
        }
        this.elementNumber = Elements.elementNumberFromSymbol((String)string, (boolean)true);
        return this.elementNumber != 0;
    }

    public short getElementNumber() {
        return this.elementNumber;
    }

    public short getAtomicMass() {
        return this.atomicMass;
    }

    public void setAtomicMass(int n) {
        this.atomicMass = (short)n;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int n) {
        this.charge = n;
    }

    public int getMatchingAtom() {
        return this.matchingAtom;
    }

    public void setMatchingAtom(int n) {
        this.matchingAtom = n;
    }

    public int getChiralClass() {
        return this.chiralClass;
    }

    public void setChiralClass(int n) {
        this.chiralClass = n;
    }

    public int getChiralOrder() {
        return this.chiralOrder;
    }

    public void setChiralOrder(int n) {
        this.chiralOrder = n;
    }

    public void setExplicitHydrogenCount(int n) {
        this.missingHydrogenCount = n;
    }

    public void setImplicitHydrogenCount(int n) {
        this.implicitHydrogenCount = n;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public void setNonhydrogenDegree(int n) {
        this.nonhydrogenDegree = n;
    }

    public void setValence(int n) {
        this.valence = n;
    }

    public void setConnectivity(int n) {
        this.connectivity = n;
    }

    public void setRingMembership(int n) {
        this.ringMembership = n;
    }

    public void setRingSize(int n) {
        this.ringSize = n;
    }

    public void setRingConnectivity(int n) {
        this.ringConnectivity = n;
    }

    public int getModelIndex() {
        return this.component;
    }

    public int getAtomSite() {
        return this.atomSite;
    }

    public int getImplicitHydrogenCount() {
        return 0;
    }

    public int getExplicitHydrogenCount() {
        return this.missingHydrogenCount;
    }

    public int getFormalCharge() {
        return this.charge;
    }

    public short getIsotopeNumber() {
        return this.atomicMass;
    }

    public short getAtomicAndIsotopeNumber() {
        return Elements.getAtomicAndIsotopeNumber((int)this.elementNumber, (int)this.atomicMass);
    }

    public String getAtomName() {
        return this.atomName == null ? "" : this.atomName;
    }

    public String getGroup3(boolean bl) {
        return this.residueName == null ? "" : this.residueName;
    }

    public String getGroup1(char c) {
        return this.residueChar == null ? "" : this.residueChar;
    }

    void addBond(SmilesBond smilesBond) {
        if (this.bondCount >= this.bonds.length) {
            SmilesBond[] smilesBondArray = new SmilesBond[this.bonds.length * 2];
            System.arraycopy(this.bonds, 0, smilesBondArray, 0, this.bonds.length);
            this.bonds = smilesBondArray;
        }
        this.bonds[this.bondCount] = smilesBond;
        ++this.bondCount;
    }

    public void setBondArray() {
        Object[] objectArray;
        if (this.bonds.length > this.bondCount) {
            objectArray = new SmilesBond[this.bondCount];
            System.arraycopy(this.bonds, 0, objectArray, 0, this.bondCount);
            this.bonds = objectArray;
        }
        if (this.atomsOr != null && this.atomsOr.length > this.nAtomsOr) {
            objectArray = new SmilesAtom[this.atomsOr.length];
            System.arraycopy(this.atomsOr, 0, objectArray, 0, this.nAtomsOr);
            this.atomsOr = objectArray;
        }
        if (this.primitives != null && this.primitives.length > this.nPrimitives) {
            objectArray = new SmilesAtom[this.primitives.length];
            System.arraycopy(this.primitives, 0, objectArray, 0, this.nPrimitives);
            this.primitives = objectArray;
        }
        for (int i = 0; i < this.bonds.length; ++i) {
            if (this.isBioAtom && this.bonds[i].order == 17) {
                this.bonds[i].order = 112;
            }
            if (this.bonds[i].getAtom1().index <= this.bonds[i].getAtom2().index) continue;
            this.bonds[i].switchAtoms();
        }
    }

    public JmolEdge[] getEdges() {
        return this.parent != null ? this.parent.getEdges() : this.bonds;
    }

    public SmilesBond getBond(int n) {
        return this.parent != null ? this.parent.getBond(n) : (n >= 0 && n < this.bondCount ? this.bonds[n] : null);
    }

    public int getCovalentBondCount() {
        return this.getBondCount();
    }

    public int getBondCount() {
        return this.parent != null ? this.parent.getCovalentBondCount() : this.bondCount;
    }

    public int getMatchingBondedAtom(int n) {
        SmilesBond smilesBond;
        if (this.parent != null) {
            return this.parent.getMatchingBondedAtom(n);
        }
        if (n >= this.bondCount) {
            return -1;
        }
        return ((smilesBond = this.bonds[n]).getAtom1() == this ? smilesBond.getAtom2() : smilesBond.getAtom1()).matchingAtom;
    }

    public int getBondedAtomIndex(int n) {
        return this.parent != null ? this.parent.getBondedAtomIndex(n) : this.bonds[n].getOtherAtom((SmilesAtom)this).index;
    }

    public int getCovalentHydrogenCount() {
        if (this.covalentHydrogenCount >= 0) {
            return this.covalentHydrogenCount;
        }
        if (this.parent != null) {
            return this.parent.getCovalentHydrogenCount();
        }
        this.covalentHydrogenCount = 0;
        for (int i = 0; i < this.bonds.length; ++i) {
            if (this.bonds[i].getOtherAtom((SmilesAtom)this).elementNumber != 1) continue;
            ++this.covalentHydrogenCount;
        }
        return this.covalentHydrogenCount;
    }

    public int getValence() {
        if (this.parent != null) {
            return this.parent.getValence();
        }
        int n = this.valence;
        if (n <= 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        this.valence = n;
        return n;
    }

    SmilesBond getBondTo(SmilesAtom smilesAtom) {
        if (this.parent != null) {
            return this.parent.getBondTo(smilesAtom);
        }
        for (int i = 0; i < this.bonds.length; ++i) {
            SmilesBond smilesBond = this.bonds[i];
            if (smilesBond == null || !(smilesAtom == null ? smilesBond.getAtom2() == this : smilesBond.getOtherAtom(this) == smilesAtom)) continue;
            return smilesBond;
        }
        return null;
    }

    SmilesBond getBondNotTo(SmilesAtom smilesAtom, boolean bl) {
        for (int i = 0; i < this.bonds.length; ++i) {
            SmilesAtom smilesAtom2;
            SmilesBond smilesBond = this.bonds[i];
            if (smilesBond == null || smilesAtom == (smilesAtom2 = smilesBond.getOtherAtom(this)) || !bl && smilesAtom2.elementNumber == 1) continue;
            return smilesBond;
        }
        return null;
    }

    public boolean isLeadAtom() {
        return this.isLeadAtom;
    }

    public int getOffsetResidueAtom(String string, int n) {
        if (this.isBioAtom) {
            for (int i = 0; i < this.bonds.length; ++i) {
                if (this.bonds[i].getAtomIndex1() != this.index || this.bonds[i].order != 96) continue;
                return this.bonds[i].getOtherAtom((SmilesAtom)this).index;
            }
        }
        return -1;
    }

    public void getGroupBits(BitSet bitSet) {
        bitSet.set(this.index);
    }

    public boolean isCrossLinked(JmolNode jmolNode) {
        SmilesBond smilesBond = this.getBondTo((SmilesAtom)jmolNode);
        return smilesBond.isHydrogen();
    }

    public boolean getCrossLinkLeadAtomIndexes(List<Integer> list) {
        for (int i = 0; i < this.bonds.length; ++i) {
            if (this.bonds[i].order != 112) continue;
            list.add(this.bonds[i].getOtherAtom((SmilesAtom)this).index);
        }
        return true;
    }

    public String getBioStructureTypeName() {
        return null;
    }

    public int getResno() {
        return 0;
    }

    public char getChainID() {
        return '\u0000';
    }

    static String getAtomLabel(int n, int n2, int n3, int n4, int n5, boolean bl, String string) {
        int n6;
        String string2 = Elements.elementSymbolFromNumber((int)n);
        if (bl) {
            string2 = string2.toLowerCase();
            if (n != 6) {
                n3 = Integer.MAX_VALUE;
            }
        }
        int n7 = n6 = string.length() > 0 || n2 != 0 || n4 != 0 ? -1 : SmilesAtom.getDefaultCount(n, false);
        return n6 == n3 ? string2 : "[" + (n2 <= 0 ? "" : "" + n2) + string2 + (n4 < 0 ? "" + n4 : (n4 > 0 ? "+" + n4 : "")) + string + (n5 > 1 ? "H" + n5 : (n5 == 1 ? "H" : "")) + "]";
    }

    public boolean isDna() {
        return this.bioType == 'd';
    }

    public boolean isRna() {
        return this.bioType == 'r';
    }

    public boolean isNucleic() {
        return this.bioType == 'n' || this.bioType == 'r' || this.bioType == 'd';
    }

    public boolean isProtein() {
        return this.bioType == 'p';
    }

    public boolean isPurine() {
        return this.residueChar != null && this.isNucleic() && "AG".indexOf(this.residueChar) >= 0;
    }

    public boolean isPyrimidine() {
        return this.residueChar != null && this.isNucleic() && "CTUI".indexOf(this.residueChar) >= 0;
    }

    public boolean isDeleted() {
        return false;
    }

    public void setAtomType(String string) {
        this.atomType = string;
    }

    public String getAtomType() {
        return this.atomType == null ? this.atomName : this.atomType;
    }

    public BitSet findAtomsLike(String string) {
        return null;
    }
}

