/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.util.ColorUtil;
import org.openscience.jmol.app.webexport.JmolInstance;

class Widgets {
    Widget[] widgetList = new Widget[5];

    Widgets() {
        this.widgetList[0] = new SpinOnWidget();
        this.widgetList[1] = new BackgroundColorWidget();
        this.widgetList[2] = new StereoViewWidget();
        this.widgetList[3] = new AnimationWidget();
        this.widgetList[4] = new ConsoleWidget();
    }

    class DownLoadWidget
    extends Widget {
        DownLoadWidget() {
            this.name = GT._("Download view");
        }

        String getJavaScriptFileName() {
            return "none";
        }

        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        String getJavaScript(int n, JmolInstance jmolInstance) {
            return GT._("unimplemented");
        }
    }

    class ConsoleWidget
    extends Widget {
        ConsoleWidget() {
            this.name = GT._("Open Console Button");
        }

        String getJavaScriptFileName() {
            return "none";
        }

        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        String getJavaScript(int n, JmolInstance jmolInstance) {
            return "<button title=\"" + GT.escapeHTML(GT._("launch Jmol console")) + "\" onclick=\"jmolScript('console'," + n + ");\">" + GT.escapeHTML(GT._("Jmol Console")) + "</button>";
        }
    }

    class AnimationWidget
    extends Widget {
        AnimationWidget() {
            this.name = GT._("Animation Control");
        }

        String getJavaScriptFileName() {
            return "JmolAnimationCntrl.js";
        }

        String[] getSupportFileNames() {
            String[] stringArray = new String[9];
            String string = "org/openscience/jmol/app/images/";
            stringArray[0] = string + "lastButton.png";
            stringArray[1] = string + "playButton.png";
            stringArray[2] = string + "playLoopButton.png";
            stringArray[3] = string + "playOnceButton.png";
            stringArray[4] = string + "playPalindromeButton.png";
            stringArray[5] = string + "prevButton.png";
            stringArray[6] = string + "pauseButton.png";
            stringArray[7] = string + "nextButton.png";
            stringArray[8] = string + "firstButton.png";
            return stringArray;
        }

        String getJavaScript(int n, JmolInstance jmolInstance) {
            String string = "<table id=\"AnimContrl\" class=\"AnimContrlCSS\">";
            string = string + "<tbody><tr><td>" + GT.escapeHTML(GT._("Animation")) + "</td></tr><tr><td><table><tbody>";
            string = string + "<tr><td><button title=\"" + GT.escapeHTML(GT._("First Frame")) + "\" onclick=\"void(jmolScriptWait('frame rewind'," + n + "));\">";
            string = string + "<img src = \"firstButton.png\"></button></td>";
            string = string + "<td><button title=\"" + GT.escapeHTML(GT._("Previous Frame")) + "\" onclick=\"void(jmolScriptWait('frame previous'," + n + "));\">";
            string = string + "<img src = \"prevButton.png\" ></button></td>";
            string = string + "<td><button title=\"" + GT.escapeHTML(GT._("Play")) + "\" onclick=\"void(jmolScriptWait('frame play'," + n + "));\">";
            string = string + "<img src = \"playButton.png\"></button></td>";
            string = string + "<td><button title=\"" + GT.escapeHTML(GT._("Next Frame")) + "\" onclick=\"void(jmolScriptWait('frame next'," + n + "));\">";
            string = string + "<img src = \"nextButton.png\"></button></td>";
            string = string + "<td><button title=\"" + GT.escapeHTML(GT._("Pause")) + "\" onclick=\"void(jmolScriptWait('frame pause'," + n + "));\">";
            string = string + "<img src = \"pauseButton.png\"></button></td>";
            string = string + "<td><button title=\"" + GT.escapeHTML(GT._("Last Frame")) + "\" onclick=\"void(jmolScriptWait('frame last'," + n + "));\">";
            string = string + "<img src = \"lastButton.png\"></button></td>";
            string = string + "</tr></tbody></table><table><tbody><tr><td>" + GT.escapeHTML(GT._("Mode:")) + "</td>";
            string = string + "<td id=\"jmol_loop_" + n + "\"><button title=\"" + GT.escapeHTML(GT._("Loop")) + "\" onclick=\"jmol_animationmode('loop'," + n + ");\">";
            string = string + "<img src = \"playLoopButton.png\" ></button></td>";
            string = string + "<td id=\"jmol_palindrome_" + n + "\"><button title=\"" + GT.escapeHTML(GT._("Palindrome")) + "\" onclick=\"jmol_animationmode('palindrome', " + n + ");\">";
            string = string + "<img src = \"playPalindromeButton.png\" ></button></td>";
            string = string + "<td id=\"jmol_playOnce_" + n + "\" style=\"background:blue;\"><button title=\"" + GT.escapeHTML(GT._("Play Once")) + "\" style=\"font-size:0px\" onclick=\"jmol_animationmode('playOnce', " + n + ");\">";
            string = string + "<img src = \"playOnceButton.png\" ></button></td></tr></tbody></table></td></tr></tbody></table>";
            return string;
        }
    }

    class StereoViewWidget
    extends Widget {
        StereoViewWidget() {
            this.name = GT._("Stereo Viewing");
        }

        String getJavaScriptFileName() {
            return "none";
        }

        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        String getJavaScript(int n, JmolInstance jmolInstance) {
            return "<select id=\"StereoMode" + n + "\" title=\"" + GT.escapeHTML(GT._("select stereo type")) + "\"" + "onchange=\"void(jmolScriptWait((this.options[this.selectedIndex]).value," + n + "));\">" + "\n<option selected=\"\" value=\"stereo off\">" + GT.escapeHTML(GT._("Stereo Off")) + " </option>" + "\n<option value=\"stereo REDBLUE\">" + GT.escapeHTML(GT._("Red/Blue")) + "</option>" + "\n<option value=\"stereo REDCYAN\">" + GT.escapeHTML(GT._("Red/Cyan")) + "</option>" + "\n<option value=\"stereo REDGREEN\">" + GT.escapeHTML(GT._("Red/Green")) + "</option>" + "\n</select>";
        }
    }

    class BackgroundColorWidget
    extends Widget {
        BackgroundColorWidget() {
            this.name = GT._("Background Color");
        }

        String getJavaScriptFileName() {
            return "JmolColorPicker.js";
        }

        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        String getJavaScript(int n, JmolInstance jmolInstance) {
            Point3f point3f = ColorUtil.colorPointFromInt2(jmolInstance.bgColor);
            return "<table><tbody><tr><td style=\"min-width:70px;\">" + GT.escapeHTML(GT._("background color:")) + "</td><td style=\"min-width:70px;\"><script type = 'text/javascript'>" + "var scriptStr = 'color background $COLOR$;';" + "jmolColorPickerBox(scriptStr, [" + (int)point3f.x + "," + (int)point3f.y + "," + (int)point3f.z + "], 'backbox" + n + "',  '" + n + "');" + "</script></td></tr></tbody></table>";
        }
    }

    class SpinOnWidget
    extends Widget {
        SpinOnWidget() {
            this.name = GT._("Spin on/off");
        }

        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        String getJavaScriptFileName() {
            return "JmolSpin.js";
        }

        String getJavaScript(int n, JmolInstance jmolInstance) {
            return "<input type=\"checkbox\" id=\"JmolSpinWidget" + n + "\"" + (jmolInstance.spinOn ? " checked=\"\"" : "") + " onclick=\"jmol_spin(this.checked," + n + ");\" " + "title=\"" + GT.escapeHTML(GT._("enable/disable spin")) + "\" />" + "<label for=\"JmolSpinWidget" + n + "\">" + GT.escapeHTML(GT._("Spin on")) + "</label>";
        }
    }

    abstract class Widget {
        String name;

        Widget() {
        }

        abstract String getJavaScript(int var1, JmolInstance var2);

        abstract String getJavaScriptFileName();

        abstract String[] getSupportFileNames();
    }
}

