/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;

class Molecules
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton saveButton;
    JButton MolecopenButton;
    JButton MolecdeleteButton;
    JTextField appletPath;
    JFileChooser fc;
    JList MolecList;
    JComboBox RenderMode;
    JComboBox FormatBox;
    private static final int FromLinks = 1;
    private static final int FromMenu = 2;
    private static final int Wireframe = 1;
    private static final int BallandStick = 2;
    private static final int Spacefilling = 3;

    Molecules() {
    }

    JComponent getPanel() {
        JLabel jLabel = new JLabel("Create a web page with one Jmol Applet to display molecules chosen by user.");
        this.appletPath = new JTextField(20);
        this.appletPath.addActionListener(this);
        this.appletPath.setText("../../Applets/Java/Jmol");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.appletPath, "Last");
        jPanel.setBorder(BorderFactory.createTitledBorder("Relative Path to Jmol Applet:"));
        JLabel jLabel2 = new JLabel("Rendering Mode:");
        String[] stringArray = new String[]{"Wireframe", "BallandStick", "Spacefilling"};
        this.RenderMode = new JComboBox<String>(stringArray);
        this.RenderMode.setSelectedIndex(2);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel2);
        jPanel2.add(this.RenderMode);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "First");
        jPanel3.add((Component)jPanel2, "Last");
        JLabel jLabel3 = new JLabel("Page Format:");
        String[] stringArray2 = new String[]{"Molecules from links (best with 4 or less)", "Molecules from popup menu"};
        this.FormatBox = new JComboBox<String>(stringArray2);
        this.FormatBox.setSelectedIndex(0);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jLabel3);
        jPanel4.add(this.FormatBox);
        this.saveButton = new JButton("Save .html as...");
        this.saveButton.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.saveButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel3, "First");
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "Last");
        this.fc = new JFileChooser();
        ArrayListTransferHandler arrayListTransferHandler = new ArrayListTransferHandler(null);
        DefaultListModel defaultListModel = new DefaultListModel();
        this.MolecList = new JList(defaultListModel);
        this.MolecList.setSelectionMode(1);
        this.MolecList.setTransferHandler(arrayListTransferHandler);
        this.MolecList.setDragEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.MolecList);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.MolecopenButton = new JButton("Add File(s)...");
        this.MolecopenButton.addActionListener(this);
        this.MolecdeleteButton = new JButton("Delete Selected");
        this.MolecdeleteButton.addActionListener(this);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.MolecopenButton);
        jPanel7.add(this.MolecdeleteButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jPanel7, "First");
        jPanel8.add((Component)jScrollPane, "Last");
        jPanel8.setBorder(BorderFactory.createTitledBorder("Molecule Files (Drag to Preferred Order):"));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)jLabel, "First");
        jPanel9.add((Component)jPanel6, "Center");
        jPanel9.add((Component)jPanel8, "After");
        return jPanel9;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.MolecopenButton) {
            this.fc.setMultiSelectionEnabled(true);
            this.fc.setDialogTitle("Choose the Molecule Files:");
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                File[] fileArray = this.fc.getSelectedFiles();
                DefaultListModel defaultListModel = (DefaultListModel)this.MolecList.getModel();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string = fileArray[i].getName();
                    defaultListModel.addElement(string);
                }
            }
        } else if (actionEvent.getSource() == this.MolecdeleteButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.MolecList.getModel();
            int[] nArray = this.MolecList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                defaultListModel.remove(nArray[i]);
            }
        } else if (actionEvent.getSource() == this.saveButton) {
            this.fc.setDialogTitle("Save .html file as:");
            int n = this.fc.showSaveDialog(this);
            if (n == 0) {
                int n2;
                File file = this.fc.getSelectedFile();
                DefaultListModel defaultListModel = (DefaultListModel)this.MolecList.getModel();
                LogPanel.log("Saving: " + file.getName() + ".\n");
                for (n2 = 0; n2 < defaultListModel.getSize(); ++n2) {
                    LogPanel.log("  Molecule file #" + n2 + " is " + defaultListModel.getElementAt(n2) + ".");
                }
                n2 = 1;
                try {
                    n2 = this.molectohtml(this.FormatBox.getSelectedIndex() + 1, this.RenderMode.getSelectedIndex() + 1, file, this.MolecList, this.appletPath.getText()) ? 1 : 0;
                }
                catch (IOException iOException) {
                    LogPanel.log(iOException.getMessage());
                }
                if (n2 == 0) {
                    LogPanel.log("Call to molectohtml unsuccessful.");
                }
            } else {
                LogPanel.log("Save command cancelled by \"user\".");
            }
        }
    }

    private boolean checkformat(int n) throws IOException {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        throw new IOException("Unacceptable format choice for web page.");
    }

    public boolean molectohtml(int n, int n2, File file, JList jList, String string) throws IOException {
        boolean bl = false;
        bl = this.checkformat(n);
        if (bl) {
            PrintStream printStream = null;
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            printStream.println("<html>");
            printStream.println("<head>");
            printStream.println("  <meta content=\"text/html; charset=ISO-8859-1\"");
            printStream.println(" http-equiv=\"content-type\">");
            printStream.println("  <title>Molecules using jmol</title>");
            printStream.println("  <meta content=\"???\" name=\"author\">");
            printStream.println("  <meta content=\"chemistry, Jmol, image, animation, rotatable, live display\" name=\"keywords\">");
            printStream.println("  <meta content=\"Molecule display using jmol\" name=\"description\">");
            printStream.println("  <meta");
            printStream.println(" content=\"Page design and layout by J. Gutow 7-2006, page written by Orbitals to Web.jar\"");
            printStream.println(" name=\"details\">");
            printStream.println("  <meta");
            printStream.println(" content=\"This page is designed to have the text and normal html edited in a standard web design\"");
            printStream.println(" name=\"instr1\">");
            printStream.println("  <meta");
            printStream.println(" content=\"program.  The javascript is to control the jmol applet (see below).  It is best to use\"");
            printStream.println(" name=\"instr2\">");
            printStream.println("  <meta");
            printStream.println(" content=\"the java program to generate the proper java script to allow orbital display.  It is\"");
            printStream.println(" name=\"instr3\">");
            printStream.println("  <meta");
            printStream.println(" content=\"important to have all the gzipped files in the same directory as the .html file.  The\"");
            printStream.println(" name=\"instr4\">");
            printStream.println("  <meta");
            printStream.println(" content=\"files needed are: 1) a gzipped files with the atom coordinates, in any of the formats Jmol\"");
            printStream.println(" name=\"instr5\">");
            printStream.println("  <meta");
            printStream.println(" content=\"can read.\"");
            printStream.println(" name=\"instr6\">");
            printStream.println("  <meta");
            printStream.println(" content=\"It is also recommended that the file names for the molecules correspond to\"");
            printStream.println(" name=\"instr8\">");
            printStream.println("  <meta");
            printStream.println(" content=\"reasonable names for the molecules as the file names are used to generate the menu items\"");
            printStream.println(" name=\"instr9\">");
            printStream.println("  <meta content=\"that appear in the popup menus or as links for selecting molecules.\"");
            printStream.println(" name=\"instr10\">");
            printStream.println("  <meta");
            printStream.println(" content=\"The relative path to Jmol on your server must be correct below!!\"");
            printStream.println(" name=\"instr11\">");
            printStream.println("  <script src=\"" + string + "/Jmol.js\"></script>");
            printStream.println("</head>");
            printStream.println("<body>");
            printStream.println("<div style=\"text-align: center;\"><big><big><span");
            printStream.println(" style=\"font-weight: bold;\">&lt;Replace this text with your title&gt;<br>");
            printStream.println("</span></big></big>");
            printStream.println("<div style=\"text-align: left;\"><big><big><span");
            printStream.println(" style=\"font-weight: bold;\"></span></big></big>&lt;Describe your");
            printStream.println("molecules here. Don't forget to mention that there is a");
            printStream.println("live display below.&nbsp; The user's browser window may be too small to");
            printStream.println("display your text and the table containing the Jmol applet without");
            printStream.println("scrolling.&gt;<br>");
            printStream.println("<br>");
            printStream.println("<big><big><span style=\"font-weight: bold;\"></span></big></big>");
            printStream.println("<table style=\"width: 100%; text-align: left;\" border=\"1\" cellpadding=\"2\"");
            printStream.println(" cellspacing=\"2\">");
            printStream.println("  <tbody>");
            printStream.println("    <tr>");
            printStream.println("      <td style=\"vertical-align: top;\">");
            printStream.println("      <script>");
            printStream.println("jmolInitialize(\"" + string + "\");");
            printStream.println("jmolApplet(300);");
            printStream.println("jmolBr();");
            printStream.println("jmolHtml(\"This image may be rotated and zoomed.  See below for more instructions.\");");
            printStream.println("        </script>");
            printStream.println("      <br>");
            printStream.println("      </td>");
            printStream.println("      <td style=\"vertical-align: top;\">");
            printStream.println("      <div style=\"text-align: right;\"> </div>");
            printStream.println("      <form name=\"appletcontrol\">");
            printStream.println("        <div style=\"text-align: right;\"> </div>");
            printStream.println("        <table style=\"width: 100%; text-align: left;\" border=\"0\"");
            printStream.println(" cellpadding=\"2\" cellspacing=\"2\">");
            printStream.println("          <tbody>");
            switch (n) {
                case 1: {
                    int n3;
                    for (n3 = 0; n3 < jList.getModel().getSize(); ++n3) {
                        printStream.println("            <tr>");
                        printStream.println("              <td colspan=\"1\" rowspan=\"1\"");
                        printStream.println(" style=\"vertical-align: top; white-space: nowrap; text-align: right;\"><span");
                        printStream.println(" style=\"font-weight: bold;\">Molecule Name" + n3 + ":</span><br>");
                        printStream.println("              </td> <td>");
                        int n4 = jList.getModel().getElementAt(n3).toString().indexOf(".");
                        String string2 = jList.getModel().getElementAt(n3).toString().substring(0, n4);
                        printStream.println("                <script>");
                        switch (n2) {
                            case 1: {
                                printStream.println("       jmolLink('load " + jList.getModel().getElementAt(n3) + "; spacefill 0%; wireframe; labels %e; set labeloffset 0 0; background black;',\"" + string2 + "\");");
                                break;
                            }
                            case 2: {
                                printStream.println("       jmolLink('load " + jList.getModel().getElementAt(n3) + "; spacefill 20%; wireframe 0.15; background black; ',\"" + string2 + "\");");
                                break;
                            }
                            case 3: {
                                printStream.println("       jmolLink('load " + jList.getModel().getElementAt(n3) + "; spacefill 100%; wireframe; background black; ',\"" + string2 + "\");");
                            }
                        }
                        printStream.println("              </script></td><td> place holder text");
                        printStream.println("             </td></tr>");
                    }
                    break;
                }
                case 2: {
                    int n3;
                    printStream.println("            <tr>");
                    printStream.println("              <td colspan=\"1\" rowspan=\"1\"");
                    printStream.println(" style=\"vertical-align: top; white-space: nowrap; text-align: right;\"><span");
                    printStream.println(" style=\"font-weight: bold;\">Choose a Molecule:</span><br>");
                    printStream.println("              </td>");
                    printStream.println("              <td style=\"vertical-align: top;\">");
                    printStream.println("              <script>");
                    printStream.println("\t\tjmolMenu([['load empty;','none'],");
                    block19: for (n3 = 0; n3 < jList.getModel().getSize(); ++n3) {
                        int n5 = jList.getModel().getElementAt(n3).toString().indexOf(".");
                        String string3 = jList.getModel().getElementAt(n3).toString().substring(0, n5);
                        switch (n2) {
                            case 1: {
                                printStream.println("       ['load " + jList.getModel().getElementAt(n3) + "; spacefill 0%; wireframe; labels %e; set labeloffset 0 0; background black;',\"" + string3 + "\"],");
                                continue block19;
                            }
                            case 2: {
                                printStream.println("       ['load " + jList.getModel().getElementAt(n3) + "; spacefill 20%; wireframe 0.15; background black; ',\"" + string3 + "\"],");
                                continue block19;
                            }
                            case 3: {
                                printStream.println("       ['load " + jList.getModel().getElementAt(n3) + "; spacefill 100%; wireframe; background black; ',\"" + string3 + "\"],");
                            }
                        }
                    }
                    printStream.println("\t\t]);");
                    printStream.println("\t\t</script>");
                    printStream.println("              <br>");
                    printStream.println("              </td>");
                    printStream.println("            </tr>");
                }
            }
            printStream.println("          </tbody>");
            printStream.println("        </table>");
            printStream.println("      </form>");
            printStream.println("&lt;This space can be used as a short caption for the applet at left.&gt;<br><br>");
            String string4 = "";
            string4 = WebExport.TimeStamp_WebLink();
            printStream.println(string4);
            printStream.println("Original");
            printStream.println("page composed by <a href=\"http://www.uwosh.edu/faculty_staff/gutow/\">J.");
            printStream.println("Gutow 7/2006</a>. </small> </td>");
            printStream.println("    </tr>");
            printStream.println("    <tr>");
            printStream.println("      <td colspan=\"2\" rowspan=\"1\" style=\"vertical-align: top;\">");
            printStream.println("      <div style=\"text-align: center;\"><span style=\"font-weight: bold;\">Instructions");
            printStream.println("for using Jmol to display");
            printStream.println("molecules</span>: <br>");
            printStream.println("      </div>");
            printStream.println("      <ol>");
            printStream.println("        <li>Choose which molecules to display by selecting them using the");
            printStream.println("popup menus or clicking on the appropriate link.");
            printStream.println("        </li>");
            printStream.println("        <li>ROTATE the image by");
            printStream.println("holding");
            printStream.println("down the mouse button while moving the cursor over the image.&nbsp; </li>");
            printStream.println("        <li>ZOOM by holding down the shift key while moving the cursor");
            printStream.println("up");
            printStream.println("(decrease magnification) or down (increase magnification) on top of the");
            printStream.println("image.&nbsp; </li>");
            printStream.println("        <li>Other options are available in the control menu accessible by");
            printStream.println("holding");
            printStream.println("the mouse button down while the cursor is over \"Jmol\" in the lower");
            printStream.println("right corner (right click also works on a multibutton mouse).&nbsp; </li>");
            printStream.println("        <li>For more info about Jmol go to <a target=\"_blank\"");
            printStream.println(" href=\"http://www.jmol.org\">www.jmol.org.</a></li>");
            printStream.println("      </ol>");
            printStream.println("      </td>");
            printStream.println("    </tr>");
            printStream.println("  </tbody>");
            printStream.println("</table>");
            printStream.println("</div>");
            printStream.println("</div>");
            printStream.println("</body>");
            printStream.println("</html>");
            printStream.close();
        }
        return true;
    }
}

