/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolViewer;
import org.jmol.export.history.HistoryFile;
import org.jmol.i18n.GT;
import org.jmol.script.Token;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.openscience.jmol.app.surfacetool.Slice;
import org.openscience.jmol.app.surfacetool.SurfaceStatus;
import org.openscience.jmol.app.surfacetool.SurfaceToolGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceTool {
    private SurfaceToolGUI gui;
    boolean useGUI;
    protected JmolViewer viewer;
    private final Point3f negCorner = new Point3f();
    private final Point3f posCorner = new Point3f();
    private final Point3f center = new Point3f();
    private final Vector3f boxVec = new Vector3f();
    private final List<SurfaceStatus> surfaces = new ArrayList<SurfaceStatus>();
    static final int DEGREES = 0;
    static final int RADIANS = 1;
    static final int GRADIANS = 2;
    static final int CIRCLE_FRACTION = 3;
    static final int UNITS_PI = 4;
    private int angleUnits = 0;
    private String[] angleUnitsList = new String[]{GT._("Degrees"), GT._("Radians"), GT._("Gradians"), GT._("Circle Fraction"), GT._("Units of Pi")};
    private float angleXY;
    private float anglefromZ;
    private float positionMin;
    private float position;
    private float thickness;
    private float thicknessMax;
    private Slice slice = new Slice();
    private boolean leftOn = false;
    private boolean rightOn = false;
    private boolean ghostOn = false;
    private boolean capOn = false;
    private boolean useMolecular = false;
    private boolean usePercent = false;

    public SurfaceTool(JmolViewer jmolViewer, HistoryFile historyFile, String string, boolean bl) {
        this.viewer = jmolViewer;
        this.useGUI = bl;
        this.updateSurfaceInfo();
        this.chooseBestBoundBox();
        this.setSurfaceToolParam();
        this.initSlice();
        this.gui = bl ? new SurfaceToolGUI(jmolViewer, historyFile, string, this) : null;
    }

    public void toFront() {
        this.gui.toFront();
    }

    void toFrontOrGotFocus() {
        this.updateSurfaceInfo();
        this.chooseBestBoundBox();
        this.setSurfaceToolParam();
    }

    private void chooseBestBoundBox() {
        BoxInfo boxInfo = new BoxInfo();
        this.viewer.calcAtomsMinMax(null, boxInfo);
        this.center.set(boxInfo.getBoundBoxCenter());
        this.boxVec.set(boxInfo.getBoundBoxCornerVector());
        this.posCorner.add(this.center, this.boxVec);
        this.negCorner.sub(this.center, this.boxVec);
        Shape[] shapeArray = (Shape[])this.viewer.getProperty("DATA_API", "shapeManager", "getShapes");
        boxInfo = this.checkMeshBB(shapeArray, 23, boxInfo);
        boxInfo = this.checkMeshBB(shapeArray, 27, boxInfo);
        boxInfo = this.checkMeshBB(shapeArray, 26, boxInfo);
        if (boxInfo != null) {
            this.center.set(boxInfo.getBoundBoxCenter());
            this.negCorner.sub(this.center, boxInfo.getBoundBoxCornerVector());
            this.posCorner.add(this.center, boxInfo.getBoundBoxCornerVector());
            this.boxVec.set(boxInfo.getBoundBoxCornerVector());
        }
    }

    BoxInfo checkMeshBB(Shape[] shapeArray, int n, BoxInfo boxInfo) {
        MeshCollection meshCollection = (MeshCollection)shapeArray[n];
        if (meshCollection == null) {
            return boxInfo;
        }
        for (int i = 0; i < meshCollection.meshCount; ++i) {
            Point3f[] point3fArray;
            Mesh mesh = meshCollection.meshes[i];
            if (!mesh.isValid || mesh.vertexCount == 0 && mesh.polygonCount == 0 || mesh.thisID.equalsIgnoreCase("_slicerleft") || mesh.thisID.equalsIgnoreCase("_slicerright") || (point3fArray = mesh.getBoundingBox()) == null) continue;
            boxInfo.addBoundBoxPoint(point3fArray[0]);
            boxInfo.addBoundBoxPoint(point3fArray[1]);
        }
        return boxInfo;
    }

    void setSurfaceToolParam() {
        this.thicknessMax = 2.0f * this.boxVec.length();
        float f = this.position - this.positionMin;
        if (this.useMolecular) {
            if (this.negCorner.x < 0.0f && this.negCorner.y < 0.0f && this.negCorner.z < 0.0f) {
                this.positionMin = -1.0f * this.negCorner.distance(new Point3f(0.0f, 0.0f, 0.0f));
            } else {
                this.positionMin = Math.min(this.negCorner.x, this.negCorner.y);
                this.positionMin = Math.min(this.negCorner.z, this.positionMin);
            }
        } else {
            this.positionMin = -1.0f * this.boxVec.length();
        }
        this.position = this.positionMin + f;
    }

    private void updateSurfaceInfo() {
        Shape[] shapeArray = (Shape[])this.viewer.getProperty("DATA_API", "shapeManager", "getShapes");
        this.setSyncStarting();
        this.updateMeshInfo(shapeArray, 23);
        this.updateMeshInfo(shapeArray, 27);
        this.updateMeshInfo(shapeArray, 26);
        this.syncDone();
    }

    private void setSyncStarting() {
        for (int i = 0; i < this.surfaces.size(); ++i) {
            this.surfaces.get((int)i).foundDuringLastSync = false;
        }
    }

    private void syncDone() {
        for (int i = this.surfaces.size() - 1; i >= 0; --i) {
            if (this.surfaces.get((int)i).foundDuringLastSync) continue;
            this.surfaces.remove(i);
        }
    }

    private void updateMeshInfo(Shape[] shapeArray, int n) {
        block10: {
            int n2;
            MeshCollection meshCollection;
            if (shapeArray == null || (meshCollection = (MeshCollection)shapeArray[n]) == null) break block10;
            int[] nArray = new int[meshCollection.meshCount];
            for (n2 = 0; n2 < meshCollection.meshCount; ++n2) {
                nArray[n2] = -1;
            }
            if (!this.surfaces.isEmpty()) {
                int n3;
                int[] nArray2 = new int[this.surfaces.size()];
                for (n3 = 0; n3 < this.surfaces.size(); ++n3) {
                    nArray2[n3] = -1;
                }
                for (n3 = 0; n3 < meshCollection.meshCount; ++n3) {
                    Mesh mesh = meshCollection.meshes[n3];
                    if (!this.checkMesh(mesh)) {
                        nArray[n3] = -2;
                        continue;
                    }
                    for (int i = 0; i < this.surfaces.size(); ++i) {
                        if (this.surfaces.get((int)i).id != mesh.thisID) continue;
                        nArray2[i] = n3;
                        nArray[n3] = i;
                    }
                }
                for (n3 = 0; n3 < nArray2.length; ++n3) {
                    if (nArray2[n3] < 0) continue;
                    this.surfaces.get(n3).updateExisting(meshCollection.meshes[nArray2[n3]]);
                }
            } else {
                for (n2 = 0; n2 < meshCollection.meshCount; ++n2) {
                    Mesh mesh = meshCollection.meshes[n2];
                    nArray[n2] = !this.checkMesh(mesh) ? -2 : -1;
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != -1) continue;
                this.surfaces.add(new SurfaceStatus(meshCollection.meshes[i], n));
            }
        }
    }

    private boolean checkMesh(Mesh mesh) {
        if (!mesh.isValid || mesh.vertexCount == 0 && mesh.polygonCount == 0) {
            return false;
        }
        return !mesh.thisID.equalsIgnoreCase("_slicerleft") && !mesh.thisID.equalsIgnoreCase("_slicerright");
    }

    void setAngleUnits(int n) {
        this.angleUnits = n;
    }

    Point3f getNegCorner() {
        return this.negCorner;
    }

    Point3f getPosCorner() {
        return this.posCorner;
    }

    private void initSlice() {
        this.angleXY = 0.0f;
        this.anglefromZ = 1.5707964f;
        this.position = 0.0f;
        this.thickness = this.negCorner.distance(this.posCorner) / 5.0f;
        this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
    }

    void showSliceBoundaryPlanes(boolean bl) {
        this.leftOn = this.rightOn = bl;
        StringBuffer stringBuffer = new StringBuffer();
        this.drawSlicePlane(stringBuffer, 1073741996, bl);
        this.drawSlicePlane(stringBuffer, 1073742128, bl);
        this.viewer.evalStringQuiet(stringBuffer.toString());
    }

    void setSlice(float f, float f2, float f3, float f4) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT._("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        this.angleXY = f;
        this.anglefromZ = f2;
        this.position = f3;
        this.thickness = f4;
        this.slice.setSlice(f, f2, f3, f4, this.center, this.boxVec, this.useMolecular);
    }

    void setSliceAngleXY(float f) {
        if (this.angleXY != f) {
            this.angleXY = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSliceAngleXY() {
        return this.angleXY;
    }

    void setSliceAnglefromZ(float f) {
        if (this.anglefromZ != f) {
            this.anglefromZ = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getAnglefromZ() {
        return this.anglefromZ;
    }

    void setSlicePosition(float f) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT._("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        if (this.position != f) {
            this.position = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSlicePosition() {
        return this.position;
    }

    void setSliceThickness(float f) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT._("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        if (this.thickness != f) {
            this.thickness = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSliceThickness() {
        return this.thickness;
    }

    void updateSlices() {
        for (int i = 0; i < this.surfaces.size(); ++i) {
            this.sliceObject(this.surfaces.get((int)i).id, this.surfaces.get((int)i).kind);
        }
    }

    void sliceObject(String string, int n) {
        String string2 = "";
        String string3 = " ID \"" + string + "\"";
        String string4 = this.capOn ? " cap " : " slab ";
        String string5 = this.ghostOn ? "translucent 0.8 mesh " : "";
        switch (n) {
            case 23: {
                string2 = "isosurface";
                break;
            }
            case 27: {
                string2 = "pmesh";
                break;
            }
            case 26: {
                string2 = "mo";
                string3 = "";
                string4 = " slab ";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.drawSlicePlane(stringBuffer, 1073741996, this.leftOn);
        this.drawSlicePlane(stringBuffer, 1073742128, this.rightOn);
        stringBuffer.append(string2).append(string3).append(" slab none;");
        stringBuffer.append(string2).append(string3);
        stringBuffer.append(string4).append(string5).append("-").append(Escape.escape(this.slice.leftPlane));
        stringBuffer.append(";").append(string2).append(string3);
        stringBuffer.append(string4).append(string5).append(Escape.escape(this.slice.rightPlane));
        stringBuffer.append(";");
        this.viewer.evalStringQuiet(stringBuffer.toString());
    }

    private void drawSlicePlane(StringBuffer stringBuffer, int n, boolean bl) {
        String string;
        Point4f point4f;
        String string2 = Token.nameOf(n);
        switch (n) {
            default: {
                point4f = this.slice.leftPlane;
                string = "magenta";
                break;
            }
            case 1073742128: {
                point4f = this.slice.rightPlane;
                string = "cyan";
            }
        }
        stringBuffer.append("isosurface _slicer").append(string2);
        if (bl) {
            stringBuffer.append(" plane ").append(Escape.escape(point4f)).append(" translucent 0.7 ").append(string).append(";");
        } else {
            stringBuffer.append(" off;");
        }
    }

    int getAngleUnits() {
        return this.angleUnits;
    }

    boolean getGhostOn() {
        return this.ghostOn;
    }

    void setGhostOn(boolean bl) {
        this.ghostOn = bl;
    }

    boolean getUseMolecular() {
        return this.useMolecular;
    }

    void setUseMolecular(boolean bl) {
        this.useMolecular = bl;
    }

    float getPositionMin() {
        return this.positionMin;
    }

    float getThicknessMax() {
        return this.thicknessMax;
    }

    Point3f getCenter() {
        return this.center;
    }

    Vector3f getBoxVec() {
        return this.boxVec;
    }

    Point4f getSliceMiddle() {
        return this.slice.getMiddle();
    }

    String[] getAngleUnitsList() {
        return this.angleUnitsList;
    }

    boolean getCapOn() {
        return this.capOn;
    }

    void setCapOn(boolean bl) {
        this.capOn = bl;
    }

    public List<SurfaceStatus> getSurfaces() {
        return this.surfaces;
    }
}

