/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.util.Measure;

class Slice {
    final Point4f leftPlane = new Point4f();
    final Point4f middle = new Point4f();
    final Point4f rightPlane = new Point4f();
    float angleXY;
    float anglefromZ;
    float position;
    float thickness;
    final Point3f boundBoxNegCorner = new Point3f();
    final Point3f boundBoxPosCorner = new Point3f();
    final Point3f boundBoxCenter = new Point3f();
    float diagonal;

    Slice() {
    }

    static void makePlane(float f, float f2, float f3, Point4f point4f) {
        point4f.set((float)(Math.cos(f2) * Math.sin(f3)), (float)(Math.sin(f2) * Math.sin(f3)), (float)Math.cos(f3), -f);
    }

    void setSlice(float f, float f2, float f3, float f4, Point3f point3f, Vector3f vector3f, boolean bl) {
        if (f >= 0.0f && (double)f < Math.PI) {
            this.angleXY = f;
        } else {
            float f5 = (float)Math.floor((double)f / Math.PI);
            this.angleXY = (float)((double)f - (double)f5 * Math.PI);
        }
        if (f2 >= 0.0f && (double)f2 < Math.PI) {
            this.anglefromZ = f2;
        } else {
            double d = Math.floor((double)f2 / Math.PI);
            this.anglefromZ = (float)((double)f2 - d * Math.PI);
        }
        this.position = f3;
        this.thickness = f4;
        this.boundBoxCenter.set(point3f);
        this.boundBoxNegCorner.sub(point3f, vector3f);
        this.boundBoxPosCorner.add(point3f, vector3f);
        this.diagonal = this.boundBoxPosCorner.distance(this.boundBoxNegCorner);
        Slice.makePlane(f3, f, f2, this.middle);
        if (!bl) {
            Point3f point3f2 = new Point3f(this.middle.x, this.middle.y, this.middle.z);
            point3f2.scaleAdd(-this.middle.w, point3f2, point3f);
            Measure.getPlaneThroughPoint(point3f2, new Vector3f(this.middle.x, this.middle.y, this.middle.z), this.middle);
        }
        this.leftPlane.set(this.middle);
        this.leftPlane.w += f4 / 2.0f;
        this.rightPlane.set(this.middle);
        this.rightPlane.w -= f4 / 2.0f;
        System.out.println(f4 + " left:" + this.leftPlane + " right:" + this.rightPlane);
    }

    Slice getSlice() {
        return this;
    }

    Point4f getMiddle() {
        return this.middle;
    }
}

