/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class WhatsNewDialog
extends JDialog
implements HyperlinkListener {
    JEditorPane html;

    public WhatsNewDialog(JFrame jFrame) {
        super(jFrame, GT._("What's New in Jmol"), true);
        Serializable serializable;
        try {
            serializable = this.getClass().getClassLoader().getResource(JmolResourceHandler.getStringX("WhatsNew.changeLogURL"));
            this.html = serializable != null ? new JEditorPane((URL)serializable) : new JEditorPane("text/plain", GT._("Unable to find url \"{0}\".", JmolResourceHandler.getStringX("WhatsNew.changeLogURL")));
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.error("Malformed URL", malformedURLException);
        }
        catch (IOException iOException) {
            Logger.error("IOException", iOException);
        }
        serializable = new JScrollPane();
        ((JComponent)serializable).setPreferredSize(new Dimension(500, 400));
        ((JComponent)serializable).setAlignmentX(0.0f);
        ((JScrollPane)serializable).getViewport().add(this.html);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setAlignmentX(0.0f);
        jPanel.add((Component)serializable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(GT._("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhatsNewDialog.this.OKPressed();
            }
        });
        jPanel2.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
        this.centerDialog();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    public void OKPressed() {
        this.setVisible(false);
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                WhatsNewDialog.this.html.setCursor(this.cursor);
                Container container = WhatsNewDialog.this.html.getParent();
                container.repaint();
            } else {
                Document document = WhatsNewDialog.this.html.getDocument();
                try {
                    WhatsNewDialog.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    WhatsNewDialog.this.html.setDocument(document);
                    WhatsNewDialog.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

