/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3i;
import org.jmol.shapespecial.DotsRenderer;
import org.jmol.shapespecial.GeoSurface;
import org.jmol.util.FastBitSet;
import org.jmol.util.Geodesic;

public class GeoSurfaceRenderer
extends DotsRenderer {
    private Point3i facePt1 = new Point3i();
    private Point3i facePt2 = new Point3i();
    private Point3i facePt3 = new Point3i();

    protected void render() {
        GeoSurface geoSurface = (GeoSurface)this.shape;
        boolean bl = this.iShowSolid = !this.viewer.getInMotion() || geoSurface.ec.getDotsConvexMax() <= 100;
        if (!this.iShowSolid && !this.g3d.setColix((short)4)) {
            return;
        }
        if (this.iShowSolid && this.faceMap == null) {
            this.faceMap = new int[this.screenDotCount];
        }
        this.render1(geoSurface);
    }

    protected void renderConvex(short s, FastBitSet fastBitSet, int n) {
        this.colix = s;
        if (this.iShowSolid) {
            if (this.g3d.setColix(s)) {
                this.renderSurface(fastBitSet);
            }
            return;
        }
        this.renderDots(n);
    }

    private void renderSurface(FastBitSet fastBitSet) {
        if (this.faceMap == null) {
            return;
        }
        short[] sArray = Geodesic.getFaceVertexes(this.screenLevel);
        int[] nArray = this.screenCoordinates;
        int n = fastBitSet.size();
        if (this.screenDotCount < n) {
            n = this.screenDotCount;
        }
        int n2 = 0;
        while (n2 < sArray.length) {
            short s = sArray[n2++];
            short s2 = sArray[n2++];
            short s3 = sArray[n2++];
            if (s >= n || s2 >= n || s3 >= n || !fastBitSet.get(s) || !fastBitSet.get(s2) || !fastBitSet.get(s3)) continue;
            this.facePt1.set(nArray[this.faceMap[s]], nArray[this.faceMap[s] + 1], nArray[this.faceMap[s] + 2]);
            this.facePt2.set(nArray[this.faceMap[s2]], nArray[this.faceMap[s2] + 1], nArray[this.faceMap[s2] + 2]);
            this.facePt3.set(nArray[this.faceMap[s3]], nArray[this.faceMap[s3] + 1], nArray[this.faceMap[s3] + 2]);
            this.g3d.fillTriangle(this.facePt1, this.colix, s, this.facePt2, this.colix, s2, this.facePt3, this.colix, s3);
        }
    }
}

