/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jmol.i18n.GT;
import org.jmol.popup.MainPopupResourceBundle;
import org.jmol.popup.PopupResource;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericPopup {
    protected static final boolean dumpList = false;
    protected static final int UPDATE_NEVER = -1;
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CONFIG = 1;
    private static final int UPDATE_SHOW = 2;
    protected String menuName;
    protected Viewer viewer;
    protected Object frankPopup;
    protected Object popupMenu;
    protected Map<String, Object> htCheckbox = new Hashtable<String, Object>();
    protected boolean asPopup = true;
    protected boolean isModelKit;
    protected int updateMode;
    protected int itemMax = 25;
    protected int titleWidthMax = 20;
    protected Properties menuText = new Properties();
    protected Object buttonGroup;
    protected String currentMenuItemId;
    protected String imagePath;
    protected String strMenuStructure;
    protected int nFrankList = 0;
    protected int thisx;
    protected int thisy;
    private String nullModelSetName;
    private String modelSetName;
    private String modelSetFileName;
    private String modelSetRoot;
    private String currentFrankId = null;
    private String configurationSelected = "";
    private String altlocs;
    private Object[][] frankList = new Object[10][];
    private Map<String, Object> modelSetInfo;
    private Map<String, Object> modelInfo;
    private Map<String, Object> htMenus = new Hashtable<String, Object>();
    private List<Object> NotPDB = new ArrayList<Object>();
    private List<Object> PDBOnly = new ArrayList<Object>();
    private List<Object> FileUnitOnly = new ArrayList<Object>();
    private List<Object> FileMolOnly = new ArrayList<Object>();
    private List<Object> UnitcellOnly = new ArrayList<Object>();
    private List<Object> SingleModelOnly = new ArrayList<Object>();
    private List<Object> FramesOnly = new ArrayList<Object>();
    private List<Object> VibrationOnly = new ArrayList<Object>();
    private List<Object> SymmetryOnly = new ArrayList<Object>();
    private List<Object> SignedOnly = new ArrayList<Object>();
    private List<Object> AppletOnly = new ArrayList<Object>();
    private List<Object> ChargesOnly = new ArrayList<Object>();
    private List<Object> TemperatureOnly = new ArrayList<Object>();
    private boolean allowSignedFeatures;
    private boolean fileHasUnitCell;
    private boolean haveBFactors;
    private boolean haveCharges;
    private boolean isApplet;
    private boolean isLastFrame;
    private boolean isMultiConfiguration;
    private boolean isMultiFrame;
    private boolean isPDB;
    private boolean isSigned;
    private boolean isSymmetry;
    private boolean isUnitCell;
    private boolean isVibration;
    private boolean isZapped;
    private int modelIndex;
    private int modelCount;
    private int atomCount;
    private int aboutComputedMenuBaseCount;
    private String group3List;
    private int[] group3Counts;
    private List<String> cnmrPeaks;
    private List<String> hnmrPeaks;

    GenericPopup() {
    }

    public Object getMenuAsObject() {
        return this.popupMenu;
    }

    protected void set(Viewer viewer) {
        this.asPopup = true;
        this.viewer = viewer;
        this.setMenuListeners();
    }

    protected void build(String string, Object object, PopupResource popupResource) {
        this.htMenus.put(string, object);
        this.allowSignedFeatures = !this.viewer.isApplet() || this.viewer.getBooleanProperty("_signedApplet");
        this.addMenuItems("", string, object, popupResource);
        try {
            this.updateComputedMenus();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected String getMenuText(String string) {
        String string2 = this.menuText.getProperty(string);
        return string2 == null ? string : string2;
    }

    protected static void addItemText(StringBuffer stringBuffer, char c, int n, String string, String string2, String string3, String string4) {
        stringBuffer.append(c).append(n).append('\t').append(string);
        if (string2 == null) {
            stringBuffer.append(".\n");
            return;
        }
        stringBuffer.append("\t").append(string2).append("\t").append(string3 == null || string3.length() == 0 ? "-" : string3).append("\t").append(string4).append("\n");
    }

    private static boolean checkBoolean(Map<String, Object> map, String string) {
        return map != null && !Boolean.FALSE.equals(map.get(string));
    }

    protected void getViewerData() {
        this.isApplet = this.viewer.isApplet();
        this.isSigned = this.viewer.getBooleanProperty("_signedApplet");
        this.modelSetName = this.viewer.getModelSetName();
        this.modelSetFileName = this.viewer.getModelSetFileName();
        int n = this.modelSetFileName.lastIndexOf(".");
        this.isZapped = "zapped".equals(this.modelSetName);
        if (this.isZapped || "string".equals(this.modelSetFileName) || "files".equals(this.modelSetFileName) || "string[]".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.modelSetRoot = this.modelSetFileName.substring(0, n < 0 ? this.modelSetFileName.length() : n);
        if (this.modelSetRoot.length() == 0) {
            this.modelSetRoot = "Jmol";
        }
        this.modelIndex = this.viewer.getDisplayModelIndex();
        this.modelCount = this.viewer.getModelCount();
        this.atomCount = this.viewer.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.viewer.getModelSetAuxiliaryInfo();
        this.modelInfo = this.viewer.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable<String, Object>();
        }
        this.isPDB = GenericPopup.checkBoolean(this.modelSetInfo, "isPDB");
        this.isMultiFrame = this.modelCount > 1;
        this.isSymmetry = GenericPopup.checkBoolean(this.modelInfo, "hasSymmetry");
        this.isUnitCell = GenericPopup.checkBoolean(this.modelInfo, "notionalUnitcell");
        this.fileHasUnitCell = this.isPDB && this.isUnitCell || GenericPopup.checkBoolean(this.modelInfo, "fileHasUnitCell");
        this.isLastFrame = this.modelIndex == this.modelCount - 1;
        this.altlocs = this.viewer.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.viewer.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.viewer.havePartialCharges();
        this.haveBFactors = this.viewer.getBooleanProperty("haveBFactors");
        this.cnmrPeaks = (List)this.modelInfo.get("jdxAtomSelect_13CNMR");
        this.hnmrPeaks = (List)this.modelInfo.get("jdxAtomSelect_1HNMR");
    }

    protected void updateFileTypeDependentMenus() {
        int n;
        for (n = 0; n < this.NotPDB.size(); ++n) {
            this.enableMenu(this.NotPDB.get(n), !this.isPDB);
        }
        for (n = 0; n < this.PDBOnly.size(); ++n) {
            this.enableMenu(this.PDBOnly.get(n), this.isPDB);
        }
        for (n = 0; n < this.UnitcellOnly.size(); ++n) {
            this.enableMenu(this.UnitcellOnly.get(n), this.isUnitCell);
        }
        for (n = 0; n < this.FileUnitOnly.size(); ++n) {
            this.enableMenu(this.FileUnitOnly.get(n), this.isUnitCell || this.fileHasUnitCell);
        }
        for (n = 0; n < this.FileMolOnly.size(); ++n) {
            this.enableMenu(this.FileMolOnly.get(n), this.isUnitCell || this.fileHasUnitCell);
        }
        for (n = 0; n < this.SingleModelOnly.size(); ++n) {
            this.enableMenu(this.SingleModelOnly.get(n), this.isLastFrame);
        }
        for (n = 0; n < this.FramesOnly.size(); ++n) {
            this.enableMenu(this.FramesOnly.get(n), this.isMultiFrame);
        }
        for (n = 0; n < this.VibrationOnly.size(); ++n) {
            this.enableMenu(this.VibrationOnly.get(n), this.isVibration);
        }
        for (n = 0; n < this.SymmetryOnly.size(); ++n) {
            this.enableMenu(this.SymmetryOnly.get(n), this.isSymmetry && this.isUnitCell);
        }
        for (n = 0; n < this.SignedOnly.size(); ++n) {
            this.enableMenu(this.SignedOnly.get(n), this.isSigned || !this.isApplet);
        }
        for (n = 0; n < this.AppletOnly.size(); ++n) {
            this.enableMenu(this.AppletOnly.get(n), this.isApplet);
        }
        for (n = 0; n < this.ChargesOnly.size(); ++n) {
            this.enableMenu(this.ChargesOnly.get(n), this.haveCharges);
        }
        for (n = 0; n < this.TemperatureOnly.size(); ++n) {
            this.enableMenu(this.TemperatureOnly.get(n), this.haveBFactors);
        }
    }

    protected void addMenuItems(String string, String string2, Object object, PopupResource popupResource) {
        String string3;
        String string4;
        String string5 = string + "." + string2;
        String string6 = popupResource.getStructure(string2);
        if (string6 == null) {
            this.addMenuItem(object, "#" + string2, "", "");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string6);
        while (string6.indexOf("@") >= 0) {
            string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = string4 + " " + ((string3 = stringTokenizer.nextToken()).startsWith("@") ? popupResource.getStructure(string3) : string3);
            }
            string6 = string4.substring(1);
            stringTokenizer = new StringTokenizer(string6);
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            string3 = stringTokenizer.nextToken();
            string4 = popupResource.getWord(string3);
            Object object3 = null;
            String string7 = "";
            boolean bl = false;
            if (string4.equals("null")) continue;
            if (string3.indexOf("Menu") >= 0) {
                if (string3.indexOf("more") < 0) {
                    this.buttonGroup = null;
                }
                object2 = this.newMenu(string4, string5 + "." + string3);
                this.addMenuSubMenu(object, object2);
                this.htMenus.put(string3, object2);
                if (string3.indexOf("Computed") < 0) {
                    this.addMenuItems(string5, string3, object2, popupResource);
                }
                this.checkSpecialMenu(string3, object2, string4);
                object3 = object2;
            } else {
                if ("-".equals(string3)) {
                    this.addMenuSeparator(object);
                    continue;
                }
                if (string3.endsWith("Checkbox") || (bl = string3.endsWith("CB") || string3.endsWith("RD"))) {
                    boolean bl2;
                    string7 = popupResource.getStructure(string3);
                    object2 = string3.substring(0, string3.length() - (!bl ? 8 : 2));
                    boolean bl3 = bl2 = bl && string3.endsWith("RD");
                    if (string7 == null || string7.length() == 0 && !bl2) {
                        string7 = "set " + (String)object2 + " T/F";
                    }
                    object3 = this.addCheckboxMenuItem(object, string4, (String)object2 + ":" + string7, string5 + "." + string3, false, bl2);
                    this.rememberCheckbox((String)object2, object3);
                    if (bl2) {
                        this.addButtonGroupItem(object3);
                    }
                } else {
                    string7 = popupResource.getStructure(string3);
                    if (string7 == null) {
                        string7 = string3;
                    }
                    object3 = this.addMenuItem(object, string4, string7, string5 + "." + string3);
                }
            }
            if (!this.allowSignedFeatures && string3.startsWith("SIGNED")) {
                this.enableMenu(object3, false);
            }
            if (string3.indexOf("VARIABLE") >= 0) {
                this.htMenus.put(string3, object3);
            }
            if (string3.indexOf("!PDB") >= 0) {
                this.NotPDB.add(object3);
            } else if (string3.indexOf("PDB") >= 0) {
                this.PDBOnly.add(object3);
            }
            if (string3.indexOf("URL") >= 0) {
                this.AppletOnly.add(object3);
            } else if (string3.indexOf("CHARGE") >= 0) {
                this.ChargesOnly.add(object3);
            } else if (string3.indexOf("BFACTORS") >= 0) {
                this.TemperatureOnly.add(object3);
            } else if (string3.indexOf("UNITCELL") >= 0) {
                this.UnitcellOnly.add(object3);
            } else if (string3.indexOf("FILEUNIT") >= 0) {
                this.FileUnitOnly.add(object3);
            } else if (string3.indexOf("FILEMOL") >= 0) {
                this.FileMolOnly.add(object3);
            }
            if (string3.indexOf("!FRAMES") >= 0) {
                this.SingleModelOnly.add(object3);
            } else if (string3.indexOf("FRAMES") >= 0) {
                this.FramesOnly.add(object3);
            }
            if (string3.indexOf("VIBRATION") >= 0) {
                this.VibrationOnly.add(object3);
            } else if (string3.indexOf("SYMMETRY") >= 0) {
                this.SymmetryOnly.add(object3);
            }
            if (!string3.startsWith("SIGNED")) continue;
            this.SignedOnly.add(object3);
        }
    }

    private void rememberCheckbox(String string, Object object) {
        this.htCheckbox.put(string + "::" + this.htCheckbox.size(), object);
    }

    protected void setCheckBoxValue(Object object, String string, boolean bl) {
        this.checkForCheckBoxScript(object, string, bl);
        if (string.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = string;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
            return;
        }
    }

    private void checkForCheckBoxScript(Object object, String string, boolean bl) {
        if (string.indexOf("##") < 0) {
            int n = string.indexOf(":");
            if (n < 0) {
                Logger.error("check box " + object + " IS " + string);
                return;
            }
            String string2 = string.substring(0, n);
            if (this.viewer.getBooleanProperty(string2) == bl) {
                return;
            }
            if (string2.endsWith("P!")) {
                if (string2.indexOf("??") >= 0) {
                    string = this.setCheckBoxOption(object, string2, string);
                } else {
                    if (string == null) {
                        return;
                    }
                    if (!bl) {
                        return;
                    }
                    string = "set picking " + string2.substring(0, string2.length() - 2);
                }
            } else {
                if ((n = (string = string.substring(n + 1)).indexOf("|")) >= 0) {
                    string = (bl ? string.substring(0, n) : string.substring(n + 1)).trim();
                }
                string = TextFormat.simpleReplace(string, "T/F", bl ? " TRUE" : " FALSE");
            }
        }
        this.viewer.evalStringQuiet(string);
    }

    protected String fixScript(String string, String string2) {
        if (string2 == "" || string.endsWith("Checkbox")) {
            return string2;
        }
        if (string2.indexOf("SELECT") == 0) {
            return "select thisModel and (" + string2.substring(6) + ")";
        }
        int n = string.lastIndexOf("[");
        if (n >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf("]")) >= 0) {
                string = string.substring(0, n);
            }
            string = string.replace('_', ' ');
            if (string2.indexOf("[]") < 0) {
                string2 = "[] " + string2;
            }
            return TextFormat.simpleReplace(string2, "[]", string);
        }
        if (string2.indexOf("?FILEROOT?") >= 0) {
            string2 = TextFormat.simpleReplace(string2, "FILEROOT?", this.modelSetRoot);
        } else if (string2.indexOf("?FILE?") >= 0) {
            string2 = TextFormat.simpleReplace(string2, "FILE?", this.modelSetFileName);
        } else if (string2.indexOf("?PdbId?") >= 0) {
            string2 = TextFormat.simpleReplace(string2, "PdbId?", "=xxxx");
        }
        return string2;
    }

    protected void checkMenuClick(Object object, String string) {
        this.restorePopupMenu();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equals("MAIN")) {
            this.show(this.thisx, this.thisy, true);
            return;
        }
        String string2 = this.getId(object);
        if (string2 != null) {
            string = this.fixScript(string2, string);
            this.currentMenuItemId = string2;
        }
        this.viewer.evalStringQuiet(string);
    }

    private Object addMenuItem(Object object, String string) {
        return this.addMenuItem(object, string, "", null);
    }

    protected abstract void addButtonGroupItem(Object var1);

    protected abstract Object addCheckboxMenuItem(Object var1, String var2, String var3, String var4, boolean var5, boolean var6);

    protected abstract Object addMenuItem(Object var1, String var2, String var3, String var4);

    protected abstract void addMenuSeparator(Object var1);

    protected abstract void addMenuSubMenu(Object var1, Object var2);

    protected abstract void addToMenu(Object var1, Object var2);

    protected abstract void createFrankPopup();

    protected abstract void enableMenu(Object var1, boolean var2);

    protected abstract void enableMenuItem(Object var1, boolean var2);

    protected abstract String getId(Object var1);

    protected abstract Object getImageIcon(URL var1);

    protected abstract void getMenuAsText(StringBuffer var1, int var2, Object var3, String var4);

    protected abstract int getMenuItemCount(Object var1);

    protected abstract Object getParent(Object var1);

    protected abstract int getPosition(Object var1);

    protected abstract void insertMenuSubMenu(Object var1, Object var2, int var3);

    protected abstract Object newMenu(String var1, String var2);

    protected abstract void removeAll(Object var1);

    protected abstract void removeMenuItem(Object var1, int var2);

    protected abstract void renameMenu(Object var1, String var2);

    protected abstract void resetFrankMenu();

    protected abstract void setAutoscrolls(Object var1);

    protected abstract String setCheckBoxOption(Object var1, String var2, String var3);

    protected abstract void setCheckBoxState(Object var1, boolean var2);

    protected abstract void setCheckBoxValue(Object var1);

    protected abstract void setLabel(Object var1, String var2);

    protected abstract void setMenuListeners();

    protected abstract void showPopupMenu(Object var1, int var2, int var3);

    public String getMenuAsString(String string) {
        this.updateForShow();
        int n = string.indexOf("|");
        if (n >= 0) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            if (string2.indexOf("current") >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Object object = this.htMenus.get(this.menuName);
                this.getMenuAsText(stringBuffer, 0, object, "PopupMenu");
                return stringBuffer.toString();
            }
        }
        return new MainPopupResourceBundle(this.strMenuStructure, null).getMenuAsText(string);
    }

    private void checkSpecialMenu(String string, Object object, String string2) {
        if ("aboutComputedMenu".equals(string)) {
            this.aboutComputedMenuBaseCount = this.getMenuItemCount(object);
        } else if ("modelSetMenu".equals(string)) {
            this.nullModelSetName = string2;
            this.enableMenu(object, false);
        }
    }

    public void updateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateFileMenu();
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet(this.modelIndex));
        this.updateHeteroComputedMenu(this.viewer.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Map)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateMode = 1;
        this.updateConfigurationComputedMenu();
        this.updateSYMMETRYComputedMenus();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateLanguageSubmenu();
        this.updateAboutSubmenu();
    }

    private void updateFileMenu() {
        Object object = this.htMenus.get("fileMenu");
        if (object == null) {
            return;
        }
        String string = this.getMenuText("writeFileTextVARIABLE");
        object = this.htMenus.get("writeFileTextVARIABLE");
        if (this.modelSetFileName.equals("zapped") || this.modelSetFileName.equals("")) {
            this.setLabel(object, GT._("No atoms loaded"));
            this.enableMenuItem(object, false);
        } else {
            this.setLabel(object, GT._(string, this.modelSetFileName, true));
            this.enableMenuItem(object, true);
        }
    }

    private void updateSelectMenu() {
        Object object = this.htMenus.get("selectMenuText");
        if (object == null) {
            return;
        }
        this.enableMenu(object, this.atomCount != 0);
        this.setLabel(object, GT._(this.getMenuText("selectMenuText"), this.viewer.getSelectionCount(), true));
    }

    private void updateElementsComputedMenu(BitSet bitSet) {
        String string;
        String string2;
        Object object = this.htMenus.get("elementsComputedMenu");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        this.enableMenu(object, false);
        if (bitSet == null) {
            return;
        }
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            String string3 = Elements.elementNameFromNumber(n);
            string2 = Elements.elementSymbolFromNumber(n);
            string = string2 + " - " + string3;
            this.addMenuItem(object, string, "SELECT " + string3, null);
            n = bitSet.nextSetBit(n + 1);
        }
        for (n = 4; n < Elements.altElementMax; ++n) {
            int n2 = Elements.elementNumberMax + n;
            if (!bitSet.get(n2)) continue;
            n2 = Elements.altElementNumberFromIndex(n);
            string2 = Elements.elementNameFromNumber(n2);
            string = Elements.elementSymbolFromNumber(n2);
            String string4 = string + " - " + string2;
            this.addMenuItem(object, string4, "SELECT " + string2, null);
        }
        this.enableMenu(object, true);
    }

    private void updateSpectraMenu() {
        Object object;
        Object object2 = this.htMenus.get("hnmrMenu");
        Object object3 = this.htMenus.get("cnmrMenu");
        if (object2 != null) {
            this.removeAll(object2);
        }
        if (object3 != null) {
            this.removeAll(object3);
        }
        if ((object = this.htMenus.get("spectraMenu")) == null) {
            return;
        }
        this.removeAll(object);
        boolean bl = this.setSpectraMenu(object2, this.hnmrPeaks) | this.setSpectraMenu(object3, this.cnmrPeaks);
        if (bl) {
            if (object2 != null) {
                this.addMenuSubMenu(object, object2);
            }
            if (object3 != null) {
                this.addMenuSubMenu(object, object3);
            }
        }
        this.enableMenu(object, bl);
    }

    private boolean setSpectraMenu(Object object, List<String> list) {
        int n;
        if (object == null) {
            return false;
        }
        this.enableMenu(object, false);
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            String string2 = Parser.getQuotedAttribute(string, "title");
            String string3 = Parser.getQuotedAttribute(string, "atoms");
            if (string3 == null) continue;
            this.addMenuItem(object, string2, "select visible & (@" + TextFormat.simpleReplace(string3, ",", " or @") + ")", "Focus" + i);
        }
        this.enableMenu(object, true);
        return true;
    }

    private void updateHeteroComputedMenu(Map<String, String> map) {
        Object object = this.htMenus.get("PDBheteroComputedMenu");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        this.enableMenu(object, false);
        if (map == null) {
            return;
        }
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2.length() > 20) {
                string2 = string2.substring(0, 20) + "...";
            }
            String string3 = string + " - " + string2;
            this.addMenuItem(object, string3, "SELECT [" + string + "]", null);
            ++n;
        }
        this.enableMenu(object, n > 0);
    }

    private void updateSurfMoComputedMenu(Map<String, Object> map) {
        Object object = this.htMenus.get("surfMoComputedMenuText");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        List list = map == null ? null : (List)map.get("mos");
        int n = list == null ? 0 : list.size();
        String string = this.getMenuText("surfMoComputedMenuText");
        if (n == 0) {
            this.setLabel(object, GT._(string, ""));
            this.enableMenu(object, false);
            return;
        }
        this.setLabel(object, GT._(string, n));
        this.enableMenu(object, true);
        Object object2 = object;
        int n2 = n % this.itemMax;
        if (n2 == 0) {
            n2 = this.itemMax;
        }
        int n3 = n > this.itemMax ? 0 : Integer.MIN_VALUE;
        int n4 = n;
        while (--n4 >= 0) {
            Object object3;
            if (n3 >= 0 && n3++ % n2 == 0) {
                if (n3 == n2 + 1) {
                    n2 = this.itemMax;
                }
                object3 = "mo" + n3 + "Menu";
                object2 = this.newMenu(Math.max(n4 + 2 - n2, 1) + "..." + (n4 + 1), this.getId(object) + "." + (String)object3);
                this.addMenuSubMenu(object, object2);
                this.htMenus.put((String)object3, object2);
                n3 = 1;
            }
            object3 = (Map)list.get(n4);
            String string2 = "#" + (n4 + 1) + " " + (object3.containsKey("type") ? (String)object3.get("type") + " " : "") + (object3.containsKey("symmetry") ? (String)object3.get("symmetry") + " " : "") + (object3.containsKey("energy") ? object3.get("energy") : "");
            String string3 = "mo " + (n4 + 1);
            this.addMenuItem(object2, string2, string3, null);
        }
    }

    private void updatePDBComputedMenus() {
        Object object = this.htMenus.get("PDBaaResiduesComputedMenu");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        this.enableMenu(object, false);
        Object object2 = this.htMenus.get("PDBnucleicResiduesComputedMenu");
        if (object2 == null) {
            return;
        }
        this.removeAll(object2);
        this.enableMenu(object2, false);
        Object object3 = this.htMenus.get("PDBcarboResiduesComputedMenu");
        if (object3 == null) {
            return;
        }
        this.removeAll(object3);
        this.enableMenu(object3, false);
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] stringArray = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = stringArray == null ? null : stringArray[n];
        int[] nArray = this.group3Counts = stringArray == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int n2 = 0;
        for (int i = 1; i < 24; ++i) {
            n2 += this.updateGroup3List(object, JmolConstants.predefinedGroup3Names[i]);
        }
        this.enableMenu(object, (n2 += this.augmentGroup3List(object, "p>", true)) > 0);
        this.enableMenu(this.htMenus.get("PDBproteinMenu"), n2 > 0);
        n2 = this.augmentGroup3List(object2, "n>", false);
        this.enableMenu(object2, n2 > 0);
        this.enableMenu(this.htMenus.get("PDBnucleicMenu"), n2 > 0);
        n2 = this.augmentGroup3List(object3, "c>", false);
        this.enableMenu(object3, n2 > 0);
        this.enableMenu(this.htMenus.get("PDBcarboMenu"), n2 > 0);
    }

    private int updateGroup3List(Object object, String string) {
        int n = 0;
        int n2 = this.group3Counts[this.group3List.indexOf(string) / 6];
        String string2 = null;
        if (n2 > 0) {
            string2 = "SELECT " + string;
            string = string + "  (" + n2 + ")";
            ++n;
        } else {
            string2 = null;
        }
        Object object2 = this.addMenuItem(object, string, string2, this.getId(object) + "." + string);
        if (n2 == 0) {
            this.enableMenuItem(object2, false);
        }
        return n;
    }

    private int augmentGroup3List(Object object, String string, boolean bl) {
        int n = 138;
        int n2 = 0;
        while ((n = this.group3List.indexOf(string, n)) >= 0) {
            if (n2++ == 0 && bl) {
                this.addMenuSeparator(object);
            }
            int n3 = this.group3Counts[n / 6];
            String string2 = this.group3List.substring(n + 2, n + 5);
            String string3 = string2 + "  (" + n3 + ")";
            this.addMenuItem(object, string3, "SELECT [" + string2 + "]", this.getId(object) + "." + string3);
            ++n;
        }
        return n2;
    }

    private void updateSYMMETRYComputedMenus() {
        this.updateSYMMETRYSelectComputedMenu();
        this.updateSYMMETRYShowComputedMenu();
    }

    private void updateSYMMETRYShowComputedMenu() {
        Object object = this.htMenus.get("SYMMETRYShowComputedMenu");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        this.enableMenu(object, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        Map map = (Map)this.viewer.getProperty("DATA_API", "spaceGroupInfo", null);
        if (map == null) {
            return;
        }
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return;
        }
        String string = (String)map.get("spaceGroupName");
        this.setLabel(object, string == null ? GT._("Space Group") : string);
        Object object2 = object;
        int n = this.itemMax;
        int n2 = objectArray.length > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < objectArray.length; ++i) {
            String string2;
            if (n2 >= 0 && n2++ % n == 0) {
                string2 = "drawsymop" + n2 + "Menu";
                object2 = this.newMenu(i + 1 + "..." + Math.min(i + this.itemMax, objectArray.length), this.getId(object) + "." + string2);
                this.addMenuSubMenu(object, object2);
                this.htMenus.put(string2, object2);
                n2 = 1;
            }
            string2 = i + 1 + " " + objectArray[i][2] + " (" + objectArray[i][0] + ")";
            this.enableMenuItem(this.addMenuItem(object2, string2, "draw SYMOP " + (i + 1), null), true);
        }
        this.enableMenu(object, true);
    }

    private void updateSYMMETRYSelectComputedMenu() {
        Object object = this.htMenus.get("SYMMETRYSelectComputedMenu");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        this.enableMenu(object, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] stringArray = (String[])this.modelInfo.get("symmetryOperations");
        if (stringArray == null) {
            return;
        }
        int[] nArray = (int[])this.modelInfo.get("unitCellRange");
        boolean bl = nArray != null;
        Object object2 = object;
        int n = this.itemMax;
        int n2 = stringArray.length > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "symop" + n2 + "Menu";
                object2 = this.newMenu(i + 1 + "..." + Math.min(i + this.itemMax, stringArray.length), this.getId(object) + "." + string);
                this.addMenuSubMenu(object, object2);
                this.htMenus.put(string, object2);
                n2 = 1;
            }
            string = "symop=" + (i + 1) + " # " + stringArray[i];
            this.enableMenuItem(this.addMenuItem(object2, string, "SELECT symop=" + (i + 1), null), bl);
        }
        this.enableMenu(object, true);
    }

    private void updateFRAMESbyModelComputedMenu() {
        Object object = this.htMenus.get("FRAMESbyModelComputedMenu");
        if (object == null) {
            return;
        }
        this.enableMenu(object, this.modelCount > 0);
        this.setLabel(object, this.modelIndex < 0 ? GT._(this.getMenuText("allModelsText"), this.modelCount, true) : this.getModelLabel());
        this.removeAll(object);
        if (this.modelCount < 1) {
            return;
        }
        if (this.modelCount > 1) {
            this.addCheckboxMenuItem(object, GT._("All", true), "frame 0 ##", null, this.modelIndex < 0, false);
        }
        Object object2 = object;
        int n = this.itemMax;
        int n2 = this.modelCount > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "model" + n2 + "Menu";
                object2 = this.newMenu(i + 1 + "..." + Math.min(i + this.itemMax, this.modelCount), this.getId(object) + "." + string);
                this.addMenuSubMenu(object, object2);
                this.htMenus.put(string, object2);
                n2 = 1;
            }
            string = "" + this.viewer.getModelNumberDotted(i);
            String string2 = this.viewer.getModelName(i);
            String string3 = (String)this.viewer.getModelAuxiliaryInfo(i, "spectrumTypes");
            if (string3 != null && string2.startsWith(string3)) {
                string3 = null;
            }
            if (!string2.equals(string)) {
                int n3 = string2.indexOf(";PATH");
                if (n3 >= 0) {
                    string2 = string2.substring(0, n3);
                }
                if (string2.indexOf("Model[") == 0 && (n3 = string2.indexOf("]:")) >= 0) {
                    string2 = string2.substring(n3 + 2);
                }
                string2 = string + ": " + string2;
            }
            if (string2.length() > 60) {
                string2 = string2.substring(0, 55) + "...";
            }
            if (string3 != null) {
                string2 = string2 + " (" + string3 + ")";
            }
            this.addCheckboxMenuItem(object2, string2, "model " + string + " ##", null, this.modelIndex == i, false);
        }
    }

    private void updateConfigurationComputedMenu() {
        Object object = this.htMenus.get("configurationComputedMenu");
        if (object == null) {
            return;
        }
        this.enableMenu(object, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int n = this.altlocs.length();
        this.setLabel(object, GT._(this.getMenuText("configurationMenuText"), n, true));
        this.removeAll(object);
        String string = "hide none ##CONFIG";
        this.addCheckboxMenuItem(object, GT._("All", true), string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        for (int i = 0; i < n; ++i) {
            string = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String string2 = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.addCheckboxMenuItem(object, string2, string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        }
    }

    private void updateModelSetComputedMenu() {
        Object object = this.htMenus.get("modelSetMenu");
        if (object == null) {
            return;
        }
        this.removeAll(object);
        this.renameMenu(object, this.nullModelSetName);
        this.enableMenu(object, false);
        this.enableMenu(this.htMenus.get("surfaceMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("measureMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("pickingMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("computationMenu"), !this.isZapped);
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = GT._(this.getMenuText("modelSetCollectionText"), this.modelCount);
            if (this.modelSetName.length() > this.titleWidthMax) {
                this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
            }
        } else if (this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > this.titleWidthMax) {
            this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
        }
        this.renameMenu(object, this.modelSetName);
        this.enableMenu(object, true);
        this.enableMenu(this.htMenus.get("computationMenu"), this.atomCount <= 100);
        this.addMenuItem(object, GT._(this.getMenuText("atomsText"), this.atomCount, true));
        this.addMenuItem(object, GT._(this.getMenuText("bondsText"), this.viewer.getBondCountInModel(this.modelIndex), true));
        if (this.isPDB) {
            List list;
            this.addMenuSeparator(object);
            this.addMenuItem(object, GT._(this.getMenuText("groupsText"), this.viewer.getGroupCountInModel(this.modelIndex), true));
            this.addMenuItem(object, GT._(this.getMenuText("chainsText"), this.viewer.getChainCountInModel(this.modelIndex), true));
            this.addMenuItem(object, GT._(this.getMenuText("polymersText"), this.viewer.getPolymerCountInModel(this.modelIndex), true));
            Object object2 = this.htMenus.get("BiomoleculesMenu");
            if (object2 == null) {
                object2 = this.newMenu(GT._(this.getMenuText("biomoleculesMenuText")), this.getId(object) + ".biomolecules");
                this.addMenuSubMenu(object, object2);
            }
            this.removeAll(object2);
            this.enableMenu(object2, false);
            if (this.modelIndex >= 0 && (list = (List)this.viewer.getModelAuxiliaryInfo(this.modelIndex, "biomolecules")) != null) {
                this.enableMenu(object2, true);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i + 1) + "\";restore orientation;";
                    int n2 = (Integer)((Map)list.get(i)).get("atomCount");
                    String string2 = GT._(this.getMenuText(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText"), new Object[]{i + 1, n2});
                    this.addMenuItem(object2, string2, string, null);
                }
            }
        }
        if (this.isApplet && this.viewer.showModelSetDownload() && !this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.addMenuSeparator(object);
            this.addMenuItem(object, GT._(this.getMenuText("viewMenuText"), this.modelSetFileName, true), "show url", null);
        }
    }

    private String getModelLabel() {
        return GT._(this.getMenuText("modelMenuText"), this.modelIndex + 1 + "/" + this.modelCount, true);
    }

    private void updateAboutSubmenu() {
        Object object = this.htMenus.get("aboutComputedMenu");
        if (object == null) {
            return;
        }
        int n = this.getMenuItemCount(object);
        while (--n >= this.aboutComputedMenuBaseCount) {
            this.removeMenuItem(object, n);
        }
        Object object2 = this.newMenu("About molecule", "modelSetMenu");
        this.addMenuSubMenu(object, object2);
        this.htMenus.put("modelSetMenu", object2);
        this.updateModelSetComputedMenu();
        object2 = this.newMenu("Jmol " + JmolConstants.version + (this.isSigned ? " (signed)" : ""), "aboutJmolMenu");
        this.addMenuSubMenu(object, object2);
        this.htMenus.put("aboutJmolMenu", object2);
        this.addMenuItem(object2, JmolConstants.date);
        this.addMenuItem(object2, "http://www.jmol.org", "show url \"http://www.jmol.org\"", null);
        this.addMenuItem(object2, GT._("Mouse Manual"), "show url \"http://wiki.jmol.org/index.php/Mouse_Manual\"", null);
        this.addMenuItem(object2, GT._("Translations"), "show url \"http://wiki.jmol.org/index.php/Internationalisation\"", null);
        object2 = this.newMenu(GT._("System", true), "systemMenu");
        this.addMenuSubMenu(object, object2);
        this.htMenus.put("systemMenu", object2);
        this.addMenuItem(object2, this.viewer.getOperatingSystemName());
        int n2 = Runtime.getRuntime().availableProcessors();
        if (n2 > 0) {
            this.addMenuItem(object2, n2 == 1 ? GT._("1 processor", true) : GT._("{0} processors", n2, true));
        } else {
            this.addMenuItem(object2, GT._("unknown processor count", true));
        }
        this.addMenuSeparator(object2);
        this.addMenuItem(object2, GT._("Java version:", true));
        this.addMenuItem(object2, this.viewer.getJavaVendor());
        this.addMenuItem(object2, this.viewer.getJavaVersion());
        this.addMenuSeparator(object2);
        this.addMenuItem(object2, GT._("Java memory usage:", true));
        Runtime runtime = Runtime.getRuntime();
        long l = this.convertToMegabytes(runtime.totalMemory());
        long l2 = this.convertToMegabytes(runtime.freeMemory());
        long l3 = this.convertToMegabytes(this.maxMemoryForNewerJvm());
        this.addMenuItem(object2, GT._("{0} MB total", new Object[]{new Long(l)}, true));
        this.addMenuItem(object2, GT._("{0} MB free", new Object[]{new Long(l2)}, true));
        if (l3 > 0L) {
            this.addMenuItem(object2, GT._("{0} MB maximum", new Object[]{new Long(l3)}, true));
        } else {
            this.addMenuItem(object2, GT._("unknown maximum", true));
        }
    }

    private void updateLanguageSubmenu() {
        Object object = this.htMenus.get("languageComputedMenu");
        if (object == null) {
            return;
        }
        int n = this.getMenuItemCount(object);
        while (--n >= 0) {
            this.removeMenuItem(object, n);
        }
        String string = GT.getLanguage();
        String string2 = this.getId(object);
        GT.Language[] languageArray = GT.getLanguageList();
        for (int i = 0; i < languageArray.length; ++i) {
            if (string.equals(languageArray[i].code)) {
                languageArray[i].forceDisplay();
            }
            if (!languageArray[i].shouldDisplay()) continue;
            String string3 = languageArray[i].code;
            String string4 = languageArray[i].language;
            String string5 = languageArray[i].nativeLanguage;
            String string6 = string3 + " - " + GT._(string4, true);
            if (string5 != null && !string5.equals(GT._(string4, true))) {
                string6 = string6 + " - " + string5;
            }
            this.addCheckboxMenuItem(object, string6, "language = \"" + string3 + "\" ##" + string4, string2 + "." + string3, string.equals(string3), false);
        }
    }

    private long convertToMegabytes(long l) {
        if (l <= 0x7FFFFFFFFFF7FFFFL) {
            l += 524288L;
        }
        return l / 0x100000L;
    }

    private void updateForShow() {
        if (this.updateMode == -1) {
            return;
        }
        this.getViewerData();
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateSpectraMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
    }

    protected void setFrankMenu(String string) {
        int n;
        if (this.currentFrankId != null && this.currentFrankId == string && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.createFrankPopup();
        }
        this.resetFrankMenu();
        if (string == null) {
            return;
        }
        this.currentFrankId = string;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        this.addMenuItem(this.frankPopup, this.getMenuText("mainMenuText"), "MAIN", "");
        int n2 = string.indexOf(".", 2) + 1;
        while ((n = string.indexOf(".", n2)) >= 0) {
            String string2 = string.substring(n2, n);
            Object object = this.htMenus.get(string2);
            this.frankList[this.nFrankList++] = new Object[]{this.getParent(object), object, this.getPosition(object)};
            this.addMenuSubMenu(this.frankPopup, object);
            n2 = n + 1;
        }
    }

    protected void restorePopupMenu() {
        if (this.nFrankList < 2) {
            return;
        }
        int n = this.nFrankList;
        while (--n > 0) {
            this.insertMenuSubMenu(this.frankList[n][0], this.frankList[n][1], (Integer)this.frankList[n][2]);
        }
        this.nFrankList = 1;
    }

    private long maxMemoryForNewerJvm() {
        return Runtime.getRuntime().maxMemory();
    }

    protected void show(int n, int n2, boolean bl) {
        this.thisx = n;
        this.thisy = n2;
        this.updateForShow();
        for (Map.Entry<String, Object> entry : this.htCheckbox.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            String string2 = string.substring(0, string.indexOf(":"));
            boolean bl2 = this.viewer.getBooleanProperty(string2);
            this.setCheckBoxState(object, bl2);
        }
        if (bl) {
            this.showPopupMenu(this.popupMenu, this.thisx, this.thisy);
        }
    }

    protected boolean menuIsShowable(int n) {
        return this.viewer.haveDisplay && (n >= 0 || this.isModelKit);
    }

    protected Object getEntryIcon(String[] stringArray) {
        if (this.imagePath == null) {
            return null;
        }
        Object object = null;
        String string = stringArray[0];
        if (string.startsWith("<")) {
            int n = string.indexOf(">");
            stringArray[0] = string.substring(n + 1);
            String string2 = this.imagePath + string.substring(1, n);
            URL uRL = this.getClass().getClassLoader().getResource(string2);
            object = uRL == null ? null : this.getImageIcon(uRL);
        }
        return object;
    }
}

