/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import org.jmol.jvxl.data.JvxlCoder;

public class JvxlData {
    public boolean wasJvxl;
    public boolean wasCubic;
    public String jvxlFileTitle;
    public String jvxlFileMessage;
    public String jvxlSurfaceData;
    public String jvxlEdgeData;
    public String jvxlColorData;
    public String jvxlVolumeDataXml;
    public BitSet[] jvxlExcluded = new BitSet[4];
    public Point4f jvxlPlane;
    public boolean isJvxlPrecisionColor;
    public boolean jvxlDataIsColorMapped;
    public boolean jvxlDataIs2dContour;
    public boolean jvxlDataIsColorDensity;
    public boolean isColorReversed;
    public int edgeFractionBase = 35;
    public int edgeFractionRange = 90;
    public int colorFractionBase = 35;
    public int colorFractionRange = 90;
    public boolean dataXYReversed;
    public boolean insideOut;
    public boolean isXLowToHigh;
    public boolean isContoured;
    public boolean isBicolorMap;
    public boolean isTruncated;
    public boolean isCutoffAbsolute;
    public boolean vertexDataOnly;
    public float mappedDataMin;
    public float mappedDataMax;
    public float valueMappedToRed;
    public float valueMappedToBlue;
    public float cutoff;
    public float pointsPerAngstrom;
    public int nPointsX;
    public int nPointsY;
    public int nPointsZ;
    public long nBytes;
    public int nContours;
    public int nEdges;
    public int nSurfaceInts;
    public int vertexCount;
    public List<Object>[] vContours;
    public short[] contourColixes;
    public String contourColors;
    public float[] contourValues;
    public float[] contourValuesUsed;
    public float scale3d;
    public short minColorIndex = (short)-1;
    public short maxColorIndex = 0;
    public String[] title;
    public String version;
    public Point3f[] boundingBox;
    public int excludedTriangleCount;
    public int excludedVertexCount;
    public boolean colorDensity;
    public String moleculeXml;
    public float dataMin;
    public float dataMax;
    public int saveVertexCount;
    public Map<String, BitSet> vertexColorMap;
    public int nVertexColors;
    public String color;
    public String meshColor;
    public float translucency;
    public String colorScheme;
    public String rendering;
    public int slabValue = Integer.MIN_VALUE;
    public boolean isSlabbable;
    public int diameter;
    public String slabInfo;
    public boolean allowVolumeRender;
    public float voxelVolume;

    public void clear() {
        this.allowVolumeRender = true;
        this.jvxlSurfaceData = "";
        this.jvxlEdgeData = "";
        this.jvxlColorData = "";
        this.jvxlVolumeDataXml = "";
        this.color = null;
        this.colorScheme = null;
        this.colorDensity = false;
        this.contourValues = null;
        this.contourValuesUsed = null;
        this.contourColixes = null;
        this.contourColors = null;
        this.isSlabbable = false;
        this.meshColor = null;
        this.nPointsX = 0;
        this.nVertexColors = 0;
        this.slabInfo = null;
        this.slabValue = Integer.MIN_VALUE;
        this.rendering = null;
        this.translucency = 0.0f;
        this.vContours = null;
        this.vertexColorMap = null;
        this.voxelVolume = 0.0f;
    }

    public void setSurfaceInfo(Point4f point4f, int n, String string) {
        this.jvxlSurfaceData = string;
        if (this.jvxlSurfaceData.indexOf("--") == 0) {
            this.jvxlSurfaceData = this.jvxlSurfaceData.substring(2);
        }
        this.jvxlPlane = point4f;
        this.nSurfaceInts = n;
    }

    public void setSurfaceInfoFromBitSet(BitSet bitSet, Point4f point4f) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.nPointsX * this.nPointsY * this.nPointsZ;
        int n2 = point4f != null ? 0 : JvxlCoder.jvxlEncodeBitSet(bitSet, n, stringBuffer);
        this.setSurfaceInfo(point4f, n2, stringBuffer.toString());
    }

    public void jvxlUpdateInfo(String[] stringArray, long l) {
        this.title = stringArray;
        this.nBytes = l;
    }

    public static String updateSurfaceData(String string, float[] fArray, int n, int n2, char c) {
        if (string.length() == 0) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (Float.isNaN(fArray[n3])) {
                cArray[n4] = c;
            }
            n3 += n2;
            ++n4;
        }
        return String.copyValueOf(cArray);
    }
}

