/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GhemicalMMReader
extends AtomSetCollectionReader {
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("!Header")) {
            this.processHeader();
            return true;
        }
        if (this.line.startsWith("!Info")) {
            this.processInfo();
            return true;
        }
        if (this.line.startsWith("!Atoms")) {
            this.processAtoms();
            return true;
        }
        if (this.line.startsWith("!Bonds")) {
            this.processBonds();
            return true;
        }
        if (this.line.startsWith("!Coord")) {
            this.processCoord();
            return true;
        }
        if (this.line.startsWith("!Charges")) {
            this.processCharges();
            return true;
        }
        return true;
    }

    void processHeader() {
    }

    void processInfo() {
    }

    void processAtoms() throws Exception {
        int n = this.parseInt(this.line, 6);
        for (int i = 0; i < n; ++i) {
            if (this.atomSetCollection.getAtomCount() != i) {
                throw new Exception("GhemicalMMReader error #1");
            }
            this.readLine();
            int n2 = this.parseInt(this.line);
            if (n2 != i) {
                throw new Exception("bad atom index in !Atomsexpected: " + i + " saw:" + n2);
            }
            int n3 = this.parseInt();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)n3;
        }
    }

    void processBonds() throws Exception {
        int n = this.parseInt(this.line, 6);
        for (int i = 0; i < n; ++i) {
            this.readLine();
            int n2 = this.parseInt(this.line);
            int n3 = this.parseInt();
            String string = this.parseToken();
            int n4 = 0;
            switch (string.charAt(0)) {
                case 'C': {
                    n4 = 515;
                    break;
                }
                case 'T': {
                    n4 = 3;
                    break;
                }
                case 'D': {
                    n4 = 2;
                    break;
                }
                default: {
                    n4 = 1;
                }
            }
            this.atomSetCollection.addNewBond(n2, n3, n4);
        }
    }

    void processCoord() throws Exception {
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            this.readLine();
            int n2 = this.parseInt(this.line);
            if (n2 != i) {
                throw new Exception("bad atom index in !Coordexpected: " + i + " saw:" + n2);
            }
            this.setAtomCoord(atomArray[i], this.parseFloat() * 10.0f, this.parseFloat() * 10.0f, this.parseFloat() * 10.0f);
        }
    }

    void processCharges() throws Exception {
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            this.readLine();
            int n2 = this.parseInt(this.line);
            if (n2 != i) {
                throw new Exception("bad atom index in !Chargesexpected: " + i + " saw:" + n2);
            }
            atomArray[i].partialCharge = this.parseFloat();
        }
    }
}

