/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import naga.ChannelResponder;
import naga.NIOServerSocket;
import naga.NIOSocket;
import naga.NIOUtils;
import naga.ServerSocketChannelResponder;
import naga.SocketChannelResponder;

public class NIOService {
    private final Selector m_selector = Selector.open();
    private final Queue<Runnable> m_internalEventQueue = new ConcurrentLinkedQueue<Runnable>();

    public synchronized void selectBlocking() throws IOException {
        this.executeQueue();
        if (this.m_selector.select() > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public synchronized void selectNonBlocking() throws IOException {
        this.executeQueue();
        if (this.m_selector.selectNow() > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public synchronized void selectBlocking(long l) throws IOException {
        this.executeQueue();
        if (this.m_selector.select(l) > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public NIOSocket openSocket(String string, int n) throws IOException {
        return this.openSocket(InetAddress.getByName(string), n);
    }

    public NIOSocket openSocket(InetAddress inetAddress, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        socketChannel.connect(inetSocketAddress);
        return this.registerSocketChannel(socketChannel, inetSocketAddress);
    }

    public NIOServerSocket openServerSocket(int n, int n2) throws IOException {
        return this.openServerSocket(new InetSocketAddress(n), n2);
    }

    public NIOServerSocket openServerSocket(int n) throws IOException {
        return this.openServerSocket(n, -1);
    }

    public NIOServerSocket openServerSocket(InetSocketAddress inetSocketAddress, int n) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().setReuseAddress(true);
        serverSocketChannel.socket().bind(inetSocketAddress, n);
        serverSocketChannel.configureBlocking(false);
        ServerSocketChannelResponder serverSocketChannelResponder = new ServerSocketChannelResponder(this, serverSocketChannel, inetSocketAddress);
        this.queue(new RegisterChannelEvent(serverSocketChannelResponder));
        return serverSocketChannelResponder;
    }

    NIOSocket registerSocketChannel(SocketChannel socketChannel, InetSocketAddress inetSocketAddress) throws IOException {
        socketChannel.configureBlocking(false);
        SocketChannelResponder socketChannelResponder = new SocketChannelResponder(this, socketChannel, inetSocketAddress);
        this.queue(new RegisterChannelEvent(socketChannelResponder));
        return socketChannelResponder;
    }

    private void executeQueue() {
        Runnable runnable;
        while ((runnable = this.m_internalEventQueue.poll()) != null) {
            runnable.run();
        }
    }

    private void handleSelectedKeys() {
        Iterator<SelectionKey> iterator = this.m_selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            if (selectionKey.readyOps() == 0) {
                throw new RuntimeException("Not ready!");
            }
            iterator.remove();
            this.handleKey(selectionKey);
        }
    }

    private void handleKey(SelectionKey selectionKey) {
        ChannelResponder channelResponder = (ChannelResponder)selectionKey.attachment();
        try {
            if (selectionKey.isReadable()) {
                channelResponder.socketReadyForRead();
            }
            if (selectionKey.isWritable()) {
                channelResponder.socketReadyForWrite();
            }
            if (selectionKey.isAcceptable()) {
                channelResponder.socketReadyForAccept();
            }
            if (selectionKey.isConnectable()) {
                channelResponder.socketReadyForConnect();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            channelResponder.close(cancelledKeyException);
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.queue(new ShutdownEvent());
    }

    public boolean isOpen() {
        return this.m_selector.isOpen();
    }

    public void queue(Runnable runnable) {
        this.m_internalEventQueue.add(runnable);
        this.wakeup();
    }

    public Queue<Runnable> getQueue() {
        return new LinkedList<Runnable>(this.m_internalEventQueue);
    }

    public void wakeup() {
        this.m_selector.wakeup();
    }

    private class ShutdownEvent
    implements Runnable {
        private ShutdownEvent() {
        }

        @Override
        public void run() {
            if (!NIOService.this.isOpen()) {
                return;
            }
            for (SelectionKey selectionKey : NIOService.this.m_selector.keys()) {
                try {
                    NIOUtils.cancelKeySilently(selectionKey);
                    ((ChannelResponder)selectionKey.attachment()).close();
                }
                catch (Exception exception) {}
            }
            try {
                NIOService.this.m_selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class RegisterChannelEvent
    implements Runnable {
        private final ChannelResponder m_channelResponder;

        private RegisterChannelEvent(ChannelResponder channelResponder) {
            this.m_channelResponder = channelResponder;
        }

        @Override
        public void run() {
            try {
                SelectionKey selectionKey = this.m_channelResponder.getChannel().register(NIOService.this.m_selector, 0);
                this.m_channelResponder.setKey(selectionKey);
                selectionKey.attach(this.m_channelResponder);
            }
            catch (Exception exception) {
                this.m_channelResponder.close(exception);
            }
        }

        public String toString() {
            return "Register[" + this.m_channelResponder + "]";
        }
    }
}

