/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import naga.NIOAbstractSocket;
import naga.NIOService;
import naga.NIOUtils;

abstract class ChannelResponder
implements NIOAbstractSocket {
    private final NIOService m_service;
    private final String m_ip;
    private final InetSocketAddress m_address;
    private final int m_port;
    private final SelectableChannel m_channel;
    private volatile boolean m_open;
    private volatile SelectionKey m_key;
    private volatile int m_interestOps;
    private boolean m_observerSet;

    protected ChannelResponder(NIOService nIOService, SelectableChannel selectableChannel, InetSocketAddress inetSocketAddress) {
        this.m_channel = selectableChannel;
        this.m_service = nIOService;
        this.m_open = true;
        this.m_key = null;
        this.m_interestOps = 0;
        this.m_observerSet = false;
        this.m_address = inetSocketAddress;
        this.m_ip = inetSocketAddress.getAddress().getHostAddress();
        this.m_port = inetSocketAddress.getPort();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.m_address;
    }

    @Override
    public String getIp() {
        return this.m_ip;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    protected NIOService getNIOService() {
        return this.m_service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markObserverSet() {
        ChannelResponder channelResponder = this;
        synchronized (channelResponder) {
            if (this.m_observerSet) {
                throw new IllegalStateException("Listener already set.");
            }
            this.m_observerSet = true;
        }
    }

    void socketReadyForRead() {
        throw new UnsupportedOperationException(this.getClass() + " does not support read.");
    }

    void socketReadyForWrite() {
        throw new UnsupportedOperationException(this.getClass() + " does not support write.");
    }

    void socketReadyForAccept() {
        throw new UnsupportedOperationException(this.getClass() + " does not support accept.");
    }

    void socketReadyForConnect() {
        throw new UnsupportedOperationException(this.getClass() + " does not support connect.");
    }

    protected SelectableChannel getChannel() {
        return this.m_channel;
    }

    void setKey(SelectionKey selectionKey) {
        if (this.m_key != null) {
            throw new IllegalStateException("Tried to set selection key twice");
        }
        this.m_key = selectionKey;
        if (!this.isOpen()) {
            NIOUtils.cancelKeySilently(this.m_key);
            return;
        }
        this.keyInitialized();
        this.synchronizeKeyInterestOps();
    }

    protected SelectionKey getKey() {
        return this.m_key;
    }

    abstract void keyInitialized();

    @Override
    public boolean isOpen() {
        return this.m_open;
    }

    @Override
    public void close() {
        this.close(null);
    }

    protected void close(Exception exception) {
        if (this.isOpen()) {
            this.getNIOService().queue(new CloseEvent(this, exception));
        }
    }

    private void synchronizeKeyInterestOps() {
        if (this.m_key != null) {
            try {
                int n = this.m_key.interestOps();
                if ((this.m_interestOps & 8) != 0) {
                    this.m_key.interestOps(8);
                } else {
                    this.m_key.interestOps(this.m_interestOps);
                }
                if (this.m_key.interestOps() != n) {
                    this.m_service.wakeup();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    protected void deleteInterest(int n) {
        this.m_interestOps &= ~n;
        this.synchronizeKeyInterestOps();
    }

    protected void addInterest(int n) {
        this.m_interestOps |= n;
        this.synchronizeKeyInterestOps();
    }

    public String toString() {
        return this.m_ip + ":" + this.m_port;
    }

    protected abstract void shutdown(Exception var1);

    private static class CloseEvent
    implements Runnable {
        private final ChannelResponder m_responder;
        private final Exception m_exception;

        private CloseEvent(ChannelResponder channelResponder, Exception exception) {
            this.m_responder = channelResponder;
            this.m_exception = exception;
        }

        @Override
        public void run() {
            if (this.m_responder.isOpen()) {
                this.m_responder.m_open = false;
                NIOUtils.closeKeyAndChannelSilently(this.m_responder.getKey(), this.m_responder.getChannel());
                this.m_responder.shutdown(this.m_exception);
            }
        }
    }
}

