/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import jspecview.util.DefaultLogger;
import jspecview.util.LoggerInterface;

public final class Logger {
    private static LoggerInterface _logger = new DefaultLogger();
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_DEBUG = 5;
    public static final int LEVEL_DEBUGHIGH = 6;
    public static final int LEVEL_MAX = 7;
    private static final boolean[] _activeLevels = new boolean[7];
    private static boolean _logLevel = false;
    public static boolean debugging;
    static String strError;
    static long startTime;

    static {
        Logger._activeLevels[6] = Logger.getProperty("debugHigh", false);
        Logger._activeLevels[5] = Logger.getProperty("debug", false);
        Logger._activeLevels[4] = Logger.getProperty("info", true);
        Logger._activeLevels[3] = Logger.getProperty("warn", true);
        Logger._activeLevels[2] = Logger.getProperty("error", true);
        Logger._activeLevels[1] = Logger.getProperty("fatal", true);
        _logLevel = Logger.getProperty("logLevel", false);
        debugging = _logger != null && (_activeLevels[5] || _activeLevels[6]);
    }

    private static boolean getProperty(String level, boolean defaultValue) {
        try {
            String property = System.getProperty("jmol.logger." + level);
            if (property != null) {
                return Boolean.TRUE.equals(Boolean.valueOf(property));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static void setLogger(LoggerInterface logger) {
        _logger = logger;
        debugging = Logger.isActiveLevel(5) || Logger.isActiveLevel(6);
    }

    public static boolean isActiveLevel(int level) {
        return _logger != null && level >= 0 && level < 7 && _activeLevels[level];
    }

    public static void setActiveLevel(int level, boolean active) {
        if (level < 0) {
            level = 0;
        }
        if (level >= 7) {
            level = 6;
        }
        Logger._activeLevels[level] = active;
        debugging = Logger.isActiveLevel(5) || Logger.isActiveLevel(6);
    }

    public static void setLogLevel(int level) {
        int i = 7;
        while (--i >= 0) {
            Logger.setActiveLevel(i, i <= level);
        }
    }

    public static String getLevel(int level) {
        switch (level) {
            case 6: {
                return "DEBUGHIGH";
            }
            case 5: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 3: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
            case 1: {
                return "FATAL";
            }
        }
        return "????";
    }

    public static boolean logLevel() {
        return _logLevel;
    }

    public static void logLevel(boolean log) {
        _logLevel = log;
    }

    public static void debug(String txt) {
        if (!debugging) {
            return;
        }
        try {
            _logger.debug(txt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void info(String txt) {
        try {
            if (Logger.isActiveLevel(4)) {
                _logger.info(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String txt) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.warn(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String txt, Throwable e) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.warn(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String checkForError() {
        if (strError == null) {
            return null;
        }
        String err = strError;
        strError = null;
        return err;
    }

    public static void error(String txt) {
        try {
            strError = txt;
            if (Logger.isActiveLevel(2)) {
                _logger.error(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void error(String txt, Throwable e) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.error(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String txt) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.fatal(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String txt, Throwable e) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.fatal(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void startTimer() {
        startTime = System.currentTimeMillis();
    }

    public static long checkTimer(String msg) {
        long time = System.currentTimeMillis() - startTime;
        if (msg != null) {
            Logger.info(String.valueOf(msg) + ": " + time + " ms");
        }
        return time;
    }

    public static void checkMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long bTotal = runtime.totalMemory();
        long bFree = runtime.freeMemory();
        long bMax = 0L;
        try {
            bMax = runtime.maxMemory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("Memory: Total-Free=" + (bTotal - bFree) + "; Total=" + bTotal + "; Free=" + bFree + "; Max=" + bMax);
    }
}

