/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jspecview.common.Coordinate;
import jspecview.common.GraphSet;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelData {
    JSVPanel owner;
    private ArrayList<PanelListener> listeners = new ArrayList();
    List<GraphSet> graphSets;
    GraphSet currentGraphSet;
    private Map<String, NumberFormat> htFormats = new Hashtable<String, NumberFormat>();
    PlotWidget thisWidget;
    Coordinate coordClicked;
    Coordinate[] coordsClicked;
    Hashtable<ScriptToken, Object> options = new Hashtable();
    protected int defaultHeight = 450;
    protected int defaultWidth = 280;
    protected int leftPlotAreaPos = 80;
    protected int topPlotAreaPos = 30;
    protected int plotAreaWidth;
    protected int plotAreaHeight;
    protected int left = this.leftPlotAreaPos;
    protected int right = 50;
    protected int top = this.topPlotAreaPos;
    protected int bottom = 50;
    protected boolean drawXAxisLeftToRight;
    protected boolean xAxisLeftToRight = true;
    boolean isIntegralDrag;
    protected boolean isOverlaid;
    protected int nSpectra;
    int thisWidth;
    int thisPlotHeight;
    String coordStr = "";
    String startupPinTip = "Click to set.";
    protected String title;
    private String displayFontName;
    private String titleFontName;
    boolean isPrinting;
    String printingFont;
    protected String printGraphPosition = "default";
    boolean titleDrawn;
    boolean display1D;
    private int yStackOffsetPercent;
    private Mouse mouseState;
    public boolean gridOn;
    public boolean titleOn;

    PanelData(JSVPanel owner) {
        this.owner = owner;
    }

    public void dispose() {
        this.owner = null;
        int i = 0;
        while (i < this.graphSets.size()) {
            this.graphSets.get(i).dispose();
            ++i;
        }
        this.graphSets = null;
        this.currentGraphSet = null;
        this.htFormats = null;
        this.coordClicked = null;
        this.coordsClicked = null;
        this.thisWidget = null;
        this.options = null;
        this.listeners = null;
    }

    public boolean isOverlaid() {
        return this.isOverlaid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Object> getInfo(boolean isSelected, String key) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        Set<Map.Entry<ScriptToken, Object>> entries = this.options.entrySet();
        for (Map.Entry<ScriptToken, Object> entry : entries) {
            JDXSpectrum.putInfo(key, info, entry.getKey().name(), entry.getValue());
        }
        JDXSpectrum.putInfo(key, info, "selected", isSelected);
        JDXSpectrum.putInfo(key, info, "type", this.getSpectrumAt(0).getDataType());
        JDXSpectrum.putInfo(key, info, "title", this.title);
        JDXSpectrum.putInfo(key, info, "nSets", this.graphSets.size());
        JDXSpectrum.putInfo(key, info, "userYFactor", this.currentGraphSet.userYFactor);
        ArrayList<Map<String, Object>> sets = new ArrayList<Map<String, Object>>();
        int i = this.graphSets.size();
        while (--i >= 0) {
            sets.add(this.graphSets.get(i).getInfo(key, isSelected && this.graphSets.get(i) == this.currentGraphSet));
        }
        info.put("sets", sets);
        return info;
    }

    public void setBoolean(Parameters parameters, ScriptToken st) {
        if (st == null) {
            Map<ScriptToken, Boolean> booleans = parameters.getBooleans();
            for (Map.Entry<ScriptToken, Boolean> entry : booleans.entrySet()) {
                this.setBoolean(parameters, entry.getKey());
            }
            return;
        }
        Boolean isTrue = parameters.getBoolean(st);
        this.setBoolean(st, isTrue);
    }

    public void setBoolean(ScriptToken st, Boolean isTrue) {
        if (st == ScriptToken.REVERSEPLOT) {
            this.currentGraphSet.setReversePlot(isTrue);
            return;
        }
        this.options.put(st, isTrue);
        switch (st) {
            case DISPLAY1D: 
            case DISPLAY2D: {
                this.thisWidth = 0;
            }
        }
    }

    public boolean getBoolean(ScriptToken st) {
        if (st == ScriptToken.REVERSEPLOT) {
            return this.currentGraphSet.reversePlot;
        }
        Object b = this.options.get((Object)st);
        return b != null && b instanceof Boolean && (Boolean)b == Boolean.TRUE;
    }

    public void setFontName(ScriptToken st, String fontName) {
        switch (st) {
            case DISPLAYFONTNAME: {
                this.displayFontName = fontName;
                break;
            }
            case TITLEFONTNAME: {
                this.titleFontName = fontName;
            }
        }
        if (fontName != null) {
            this.options.put(st, fontName);
        }
    }

    public void setYStackOffsetPercent(int offset) {
        this.yStackOffsetPercent = offset;
    }

    public boolean getDisplay1D() {
        return this.display1D;
    }

    protected void initSingleSpectrum(JDXSpectrum spectrum) {
        ArrayList<JDXSpectrum> spectra = new ArrayList<JDXSpectrum>();
        spectra.add(spectrum);
        this.initJSVPanel(spectra, 0, 0);
    }

    protected void initJSVPanel(List<JDXSpectrum> spectra, int startIndex, int endIndex) {
        this.owner.setupPlatform();
        this.nSpectra = spectra.size();
        this.graphSets = GraphSet.getGraphSets(this.owner, spectra, startIndex, endIndex);
        this.currentGraphSet = this.graphSets.get(0);
        this.setTitle(this.getSpectrum().getTitleLabel());
    }

    protected void setCurrentGraphSet(GraphSet gs) {
        if (this.currentGraphSet == gs) {
            return;
        }
        this.currentGraphSet = gs;
        this.notifySubSpectrumChange(gs.getSpectrum().getSubIndex(), gs.getSpectrum());
    }

    public JDXSpectrum getSpectrum() {
        return this.currentGraphSet.getSpectrum().getCurrentSubSpectrum();
    }

    public void setSpectrum(JDXSpectrum spec) {
        this.currentGraphSet.setSpectrum(spec);
    }

    public JDXSpectrum getSpectrumAt(int index) {
        return this.currentGraphSet.getSpectrumAt(index);
    }

    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        this.currentGraphSet.addHighlight(x1, x2, null, this.owner.getColor(r, g, b, a));
    }

    public void removeHighlight(int index) {
        this.currentGraphSet.removeHighlight(index);
    }

    public void removeHighlight(double x1, double x2) {
        this.currentGraphSet.removeHighlight(x1, x2);
    }

    public void removeAllHighlights() {
        this.currentGraphSet.removeAllHighlights(null);
    }

    public int getNumberOfSpectraTotal() {
        return this.nSpectra;
    }

    public int getNumberOfGraphSets() {
        return this.graphSets.size();
    }

    public int getNumberOfSpectraInCurrentSet() {
        return this.currentGraphSet.getNumberOfSpectra();
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getStartDataPointIndices() {
        return this.currentGraphSet.multiScaleData.startDataPointIndices;
    }

    public int[] getEndDataPointIndices() {
        return this.currentGraphSet.multiScaleData.endDataPointIndices;
    }

    public String getDisplayFontName() {
        return this.displayFontName;
    }

    public String getTitleFontName() {
        return this.titleFontName;
    }

    protected void drawGraph(Object g, int height, int width) {
        boolean withCoords;
        this.display1D = this.getBoolean(ScriptToken.DISPLAY1D);
        if (this.isPrinting) {
            withCoords = false;
        } else {
            withCoords = this.getBoolean(ScriptToken.COORDINATESON);
            this.titleOn = this.getBoolean(ScriptToken.TITLEON);
            this.gridOn = this.getBoolean(ScriptToken.GRIDON);
        }
        this.plotAreaWidth = width - (this.right + this.left);
        this.plotAreaHeight = height - (this.top + this.bottom);
        boolean isResized = this.thisWidth != width || this.thisPlotHeight != this.plotAreaHeight;
        this.thisWidth = width;
        this.thisPlotHeight = this.plotAreaHeight;
        this.titleDrawn = false;
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).drawGraph(g, !this.isPrinting, height, width, this.left, this.right, this.top, this.bottom, isResized, this.yStackOffsetPercent);
        }
        if (this.titleOn && !this.titleDrawn) {
            this.owner.drawTitle(g, height, width, this.getSpectrum().getPeakTitle());
        }
        if (withCoords) {
            this.owner.drawCoordinates(g, height, width);
        }
    }

    NumberFormat getFormatter(String hash) {
        NumberFormat formatter = this.htFormats.get(hash);
        if (formatter == null) {
            formatter = TextFormat.getDecimalFormat(hash);
            this.htFormats.put(hash, formatter);
        }
        return formatter;
    }

    void setFont(Object g, int width, int mode, int size, boolean isLabel) {
        if (isLabel) {
            if (width < 400) {
                size = width * size / 400;
            }
        } else if (width < 250) {
            size = width * size / 250;
        }
        this.owner.setFont(g, this.isPrinting ? this.printingFont : this.displayFontName, mode, size);
    }

    public void setZoom(double x1, double y1, double x2, double y2) {
        this.currentGraphSet.setZoom(x1, y1, x2, y2);
        this.thisWidth = 0;
        this.notifyZoomListeners(x1, y1, x2, y2);
    }

    public void clearViews() {
        this.currentGraphSet.reset();
    }

    public void resetView() {
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).clearViews();
        }
    }

    public void fullView() {
        this.currentGraphSet.setZoomTo(0);
    }

    public void previousView() {
        this.currentGraphSet.previousView();
    }

    public void nextView() {
        this.currentGraphSet.nextView();
    }

    public Coordinate getClickedCoordinate() {
        return this.coordClicked;
    }

    public boolean getPickedCoordinates(Coordinate coord, Coordinate actualCoord) {
        return GraphSet.getPickedCoordinates(this.coordsClicked, this.coordClicked, coord, actualCoord);
    }

    public String getSolutionColorHtml() {
        String color = this.currentGraphSet.getSolutionColor();
        return "<HTML><body bgcolor=rgb(" + color + ")><br />Predicted Solution Colour- RGB(" + color + ")<br /><br /></body></HTML>";
    }

    public void refresh() {
        this.thisWidth = 0;
        this.owner.repaint();
    }

    public void addAnnotation(List<String> tokens) {
        String title = this.currentGraphSet.addAnnotation(tokens, this.getTitle());
        if (title != null) {
            this.setTitle(title);
        }
    }

    public void addPeakHighlight(PeakInfo peakInfo) {
        int i = 0;
        while (i < this.graphSets.size()) {
            this.graphSets.get(i).addPeakHighlight(peakInfo);
            ++i;
        }
    }

    public PeakInfo selectPeakByFileIndex(String fileName, String index) {
        return GraphSet.selectPeakByFileIndex(this.graphSets, fileName, index);
    }

    public void selectSpectrum(String fileName, String type, String model) {
        int i = 0;
        while (i < this.graphSets.size()) {
            this.graphSets.get(i).selectSpectrum(fileName, type, model);
            ++i;
        }
    }

    public boolean hasFileLoaded(String filePath) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            if (!this.graphSets.get(i).hasFileLoaded(filePath)) continue;
            return true;
        }
        return false;
    }

    public void addListener(PanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void notifySubSpectrumChange(int isub, JDXSpectrum spec) {
        this.notifyListeners(new SubSpecChangeEvent(isub, spec == null ? null : spec.getTitleLabel()));
    }

    public void notifyZoomListeners(double x1, double y1, double x2, double y2) {
        this.notifyListeners(new ZoomEvent(x1, y1, x2, y2));
    }

    public void notifyPeakPickedListeners() {
        this.notifyListeners(new PeakPickEvent(this.owner, this.coordClicked, this.getSpectrum().getAssociatedPeakInfo(this.coordClicked)));
    }

    void notifyListeners(Object eventObj) {
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) != null) {
                this.listeners.get(i).panelEvent(eventObj);
            }
            ++i;
        }
    }

    boolean isMouseUp() {
        return this.mouseState == Mouse.UP;
    }

    protected void doMousePressed(int xPixel, int yPixel, boolean isControlDown) {
        this.mouseState = Mouse.DOWN;
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        boolean bl = this.isIntegralDrag = isControlDown && gs.getSpectrum().hasIntegral();
        if (isControlDown && !this.isIntegralDrag) {
            return;
        }
        this.setCurrentGraphSet(gs);
        gs.checkWidgetEvent(xPixel, yPixel, true);
    }

    protected void doMouseMoved(int xPixel, int yPixel) {
        this.mouseState = Mouse.UP;
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        gs.mouseMovedEvent(xPixel, yPixel);
    }

    protected void doMouseDragged(int xPixel, int yPixel) {
        this.mouseState = Mouse.DOWN;
        if (GraphSet.findGraphSet(this.graphSets, xPixel, yPixel) != this.currentGraphSet) {
            return;
        }
        this.currentGraphSet.checkWidgetEvent(xPixel, yPixel, false);
        this.currentGraphSet.mouseMovedEvent(xPixel, yPixel);
    }

    protected void doMouseReleased(boolean isButton1) {
        this.mouseState = Mouse.UP;
        if (this.thisWidget == null || !isButton1) {
            return;
        }
        this.currentGraphSet.mouseReleasedEvent();
        this.thisWidget = null;
    }

    protected void doMouseClicked(int xPixel, int yPixel, int clickCount, boolean isControlDown) {
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        this.setCurrentGraphSet(gs);
        gs.mouseClickEvent(xPixel, yPixel, clickCount, isControlDown);
    }

    public void repaint() {
        this.owner.repaint();
    }

    public void setToolTipText(String s) {
        this.owner.setToolTipText(s);
    }

    public Object getHighlightColor() {
        return this.owner.getColor(ScriptToken.HIGHLIGHTCOLOR);
    }

    public void setHighlightColor(Object color) {
        this.owner.setColor(ScriptToken.HIGHLIGHTCOLOR, color);
    }

    public String getSolutionColor() {
        return this.currentGraphSet.getSolutionColor();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        PeakInfo pi2 = null;
        int i = 0;
        while (i < this.graphSets.size()) {
            pi2 = this.graphSets.get(i).findMatchingPeakInfo(pi);
            if (pi2 != null) break;
            ++i;
        }
        return pi2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mouse {
        UP,
        DOWN;

    }
}

