/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVDialog;
import jspecview.common.JSVPanel;
import jspecview.common.JSVSpecNode;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptCommandTokenizer;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.source.JDXSource;
import jspecview.util.Logger;
import jspecview.util.Parser;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSViewer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean runScriptNow(ScriptInterface si, String script) {
        if (script == null) {
            script = "";
        }
        String msg = null;
        script = script.trim();
        if (Logger.debugging) {
            Logger.info("RUNSCRIPT " + script);
        }
        ScriptCommandTokenizer commandTokens = new ScriptCommandTokenizer(script, ";\n");
        JSVPanel jsvp = si.getSelectedPanel();
        block26: while (commandTokens.hasMoreTokens()) {
            String token = commandTokens.nextToken();
            StringTokenizer eachParam = new StringTokenizer(token);
            String key = ScriptToken.getKey(eachParam);
            if (key == null) continue;
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            try {
                switch (st) {
                    case UNKNOWN: {
                        Logger.info("Unrecognized parameter: " + key);
                        break;
                    }
                    default: {
                        si.getParameters().set(jsvp, st, value);
                        si.updateBoolean(st, Parameters.isTrue(value));
                        break;
                    }
                    case COORDCALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        si.execSetCallback(st, value);
                        break;
                    }
                    case AUTOINTEGRATE: {
                        si.execSetAutoIntegrate(Parameters.isTrue(value));
                        break;
                    }
                    case CLOSE: {
                        si.execClose(value);
                        jsvp = si.getSelectedPanel();
                        break;
                    }
                    case EXPORT: {
                        msg = si.execExport(jsvp, value);
                        return false;
                    }
                    case GETSOLUTIONCOLOR: {
                        if (jsvp == null) continue block26;
                        si.setSolutionColor(true);
                        break;
                    }
                    case HIDDEN: {
                        si.execHidden(Parameters.isTrue(value));
                        break;
                    }
                    case INTEGRATE: {
                        if (jsvp == null) continue block26;
                        JSViewer.execIntegrate(si, value);
                        break;
                    }
                    case INTEGRATIONRATIOS: {
                        si.execSetIntegrationRatios(value);
                        break;
                    }
                    case INTERFACE: {
                        si.execSetInterface(value);
                        break;
                    }
                    case IRMODE: {
                        if (jsvp == null) continue block26;
                        JSViewer.execTAConvert(si, value);
                        break;
                    }
                    case JMOL: {
                        si.syncToJmol(value);
                        break;
                    }
                    case LABEL: {
                        if (jsvp == null) continue block26;
                        jsvp.getPanelData().addAnnotation(ScriptToken.getTokens(value));
                        break;
                    }
                    case LOAD: {
                        msg = si.execLoad(value);
                        jsvp = si.getSelectedPanel();
                        break;
                    }
                    case OVERLAY: {
                        si.execOverlay(value);
                        break;
                    }
                    case PEAK: {
                        try {
                            List<String> tokens = ScriptToken.getTokens(value);
                            value = " type=\"" + tokens.get(0).toUpperCase() + "\" _match=\"" + TextFormat.trimQuotes(tokens.get(1).toUpperCase()) + "\"";
                            if (tokens.size() > 2 && tokens.get(2).equalsIgnoreCase("all")) {
                                value = String.valueOf(value) + " title=\"ALL\"";
                            }
                            JSViewer.processPeakPickEvent(si, new PeakInfo(value), false);
                        }
                        catch (Exception tokens) {}
                        continue block26;
                    }
                    case SPECTRUM: 
                    case SPECTRUMNUMBER: {
                        jsvp = si.execSetSpectrum(value);
                        if (jsvp != null) continue block26;
                        return false;
                    }
                    case STACKOFFSETY: {
                        int offset = Parser.parseInt("" + Parser.parseFloat(value));
                        if (jsvp == null || offset == Integer.MIN_VALUE) continue block26;
                        jsvp.getPanelData().setYStackOffsetPercent(offset);
                        break;
                    }
                    case TEST: {
                        si.execTest(value);
                        break;
                    }
                    case YSCALE: {
                        JSViewer.setYScale(value, si.getSpecNodes(), jsvp, si.getCurrentSource());
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        si.execScriptComplete(msg, true);
        return true;
    }

    private static void execTAConvert(ScriptInterface si, String value) {
        int mode = value.toUpperCase().startsWith("T") ? 2 : (value.toUpperCase().startsWith("A") ? 1 : 3);
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        JDXSpectrum spec = jsvp.getSpectrum();
        JDXSpectrum spec2 = JDXSpectrum.taConvert(spec, mode);
        if (spec2 == spec) {
            return;
        }
        jsvp.setSpectrum(spec2);
        si.execTAConvert(mode);
        jsvp.repaint();
    }

    private static void execIntegrate(ScriptInterface si, String value) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        JDXSpectrum spec = jsvp.getSpectrum();
        spec.checkIntegral(si.getParameters(), value);
        si.execIntegrate(spec);
        jsvp.repaint();
    }

    private static void setYScale(String value, List<JSVSpecNode> specNodes, JSVPanel jsvp, JDXSource currentSource) {
        if (jsvp == null) {
            return;
        }
        List<String> tokens = ScriptToken.getTokens(value);
        int pt = 0;
        boolean isAll = false;
        if (tokens.size() > 1 && tokens.get(0).equalsIgnoreCase("ALL")) {
            isAll = true;
        }
        int n = ++pt;
        double y1 = Double.parseDouble(tokens.get(n));
        double y2 = Double.parseDouble(tokens.get(++pt));
        if (isAll) {
            JDXSpectrum spec = jsvp.getSpectrum();
            int i = specNodes.size();
            while (--i >= 0) {
                JSVSpecNode node = specNodes.get(i);
                if (node.source != currentSource || !JDXSpectrum.areScalesCompatible(spec, node.getSpectrum(), false)) continue;
                node.jsvp.getPanelData().setZoom(Double.NaN, y1, Double.NaN, y2);
            }
        } else {
            jsvp.getPanelData().setZoom(Double.NaN, y1, Double.NaN, y2);
        }
    }

    public static void setOverlayLegendVisibility(ScriptInterface si, JSVPanel jsvp, boolean showLegend) {
        List<JSVSpecNode> specNodes = si.getSpecNodes();
        JSVSpecNode node = JSVSpecNode.findNode(jsvp, specNodes);
        int i = specNodes.size();
        while (--i >= 0) {
            JSViewer.showOverlayLegend(si, specNodes.get(i), specNodes.get(i) == node && showLegend);
        }
    }

    private static void showOverlayLegend(ScriptInterface si, JSVSpecNode node, boolean visible) {
        JSVDialog legend = node.legend;
        if (legend == null && visible) {
            legend = node.setLegend(node.jsvp.getPanelData().getNumberOfSpectraInCurrentSet() > 1 && node.jsvp.getPanelData().getNumberOfGraphSets() == 1 ? si.getOverlayLegend(node.jsvp) : null);
        }
        if (legend != null) {
            legend.setVisible(visible);
        }
    }

    public static void addHighLight(ScriptInterface si, double x1, double x2, int r, int g, int b, int a) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null) {
            jsvp.getPanelData().addHighlight(x1, x2, r, g, b, a);
            jsvp.repaint();
        }
    }

    public static void syncScript(ScriptInterface si, String peakScript) {
        Logger.info("Jmol>JSV " + peakScript);
        if (peakScript.indexOf("<PeakData") < 0) {
            JSViewer.runScriptNow(si, peakScript);
            return;
        }
        String file = Parser.getQuotedAttribute(peakScript, "file");
        String index = Parser.getQuotedAttribute(peakScript, "index");
        if (file == null || index == null) {
            return;
        }
        if (si.getSpecNodes().size() == 0 || !JSViewer.checkFileAlreadyLoaded(si, file)) {
            si.syncLoad(file);
        }
        PeakInfo pi = JSViewer.selectPanelByPeak(si, peakScript, si.getSelectedPanel());
        JSVPanel jsvp = si.getSelectedPanel();
        String type = Parser.getQuotedAttribute(peakScript, "type");
        String model = Parser.getQuotedAttribute(peakScript, "model");
        jsvp.getPanelData().selectSpectrum(file, type, model);
        si.sendFrameChange(jsvp);
        jsvp.getPanelData().addPeakHighlight(pi);
        jsvp.repaint();
        si.syncToJmol(JSViewer.jmolSelect(pi));
    }

    private static boolean checkFileAlreadyLoaded(ScriptInterface si, String fileName) {
        if (si.getSelectedPanel().getPanelData().hasFileLoaded(fileName)) {
            return true;
        }
        List<JSVSpecNode> specNodes = si.getSpecNodes();
        int i = specNodes.size();
        while (--i >= 0) {
            if (!specNodes.get((int)i).jsvp.getPanelData().hasFileLoaded(fileName)) continue;
            si.setSelectedPanel(specNodes.get((int)i).jsvp);
            return true;
        }
        return false;
    }

    private static PeakInfo selectPanelByPeak(ScriptInterface si, String peakScript, JSVPanel jsvp) {
        List<JSVSpecNode> specNodes = si.getSpecNodes();
        if (specNodes == null) {
            return null;
        }
        String file = Parser.getQuotedAttribute(peakScript, "file");
        String index = Parser.getQuotedAttribute(peakScript, "index");
        PeakInfo pi = null;
        int i = specNodes.size();
        while (--i >= 0) {
            specNodes.get((int)i).jsvp.getPanelData().addPeakHighlight(null);
        }
        pi = jsvp.getPanelData().selectPeakByFileIndex(file, index);
        if (pi != null) {
            si.setFrame(JSVSpecNode.findNode(jsvp, specNodes));
        } else {
            i = specNodes.size();
            while (--i >= 0) {
                JSVSpecNode node = specNodes.get(i);
                pi = node.jsvp.getPanelData().selectPeakByFileIndex(file, index);
                if (pi == null) continue;
                si.setFrame(node);
                break;
            }
        }
        return pi;
    }

    public static void processPeakPickEvent(ScriptInterface si, Object eventObj, boolean isApp) {
        PeakInfo pi;
        if (eventObj instanceof PeakInfo) {
            pi = (PeakInfo)eventObj;
            JSVPanel jsvp = si.getSelectedPanel();
            PeakInfo pi2 = jsvp.getPanelData().findMatchingPeakInfo(pi);
            if (pi2 == null) {
                if (!"ALL".equals(pi.getTitle())) {
                    return;
                }
                List<JSVSpecNode> specNodes = si.getSpecNodes();
                JSVSpecNode node = null;
                int i = 0;
                while (i < specNodes.size()) {
                    pi2 = specNodes.get((int)i).jsvp.getPanelData().findMatchingPeakInfo(pi);
                    if (pi2 != null) {
                        node = specNodes.get(i);
                        break;
                    }
                    ++i;
                }
                if (node == null) {
                    return;
                }
                si.setFrame(node);
            }
            pi = pi2;
        } else {
            PeakPickEvent e = (PeakPickEvent)eventObj;
            si.setSelectedPanel((JSVPanel)e.getSource());
            pi = e.getPeakInfo();
        }
        si.getSelectedPanel().getPanelData().addPeakHighlight(pi);
        si.syncToJmol(JSViewer.jmolSelect(pi));
        if (pi.isClearAll()) {
            si.getSelectedPanel().repaint();
        } else {
            si.getSelectedPanel().getPanelData().selectSpectrum(pi.getFilePath(), pi.getType(), pi.getModel());
        }
        si.checkCallbacks(pi.getTitle());
    }

    public static void sendFrameChange(ScriptInterface si, JSVPanel jsvp) {
        PeakInfo pi = jsvp.getSpectrum().getSelectedPeak();
        if (pi == null) {
            pi = jsvp.getSpectrum().getModelPeakInfoForAutoSelectOnLoad();
        }
        if (pi == null) {
            pi = jsvp.getSpectrum().getBasePeakInfo();
        }
        si.getSelectedPanel().getPanelData().addPeakHighlight(pi);
        si.syncToJmol(JSViewer.jmolSelect(pi));
    }

    public static String jmolSelect(PeakInfo pi) {
        String script = null;
        script = "IR".equals(pi.getType()) || "RAMAN".equals(pi.getType()) ? "vibration ON; selectionHalos OFF;" : (pi.getAtoms() != null ? "vibration OFF; selectionhalos ON;" : "vibration OFF; selectionhalos OFF;");
        return "Select: " + pi + " script=\"" + script;
    }

    public static void removeAllHighlights(ScriptInterface si) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null) {
            jsvp.getPanelData().removeAllHighlights();
            jsvp.repaint();
        }
    }

    public static void removeHighlights(ScriptInterface si, double x1, double x2) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null) {
            jsvp.getPanelData().removeHighlight(x1, x2);
            jsvp.repaint();
        }
    }

    public static Map<String, Object> getPropertyAsJavaObject(ScriptInterface si, String key) {
        if ("".equals(key)) {
            key = null;
        }
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>();
        List<JSVSpecNode> specNodes = si.getSpecNodes();
        int i = 0;
        while (i < specNodes.size()) {
            JSVPanel jsvp = specNodes.get((int)i).jsvp;
            if (jsvp != null) {
                info.add(jsvp.getPanelData().getInfo(true, key));
            }
            ++i;
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("items", info);
        return map;
    }

    public static String getCoordinate(ScriptInterface si) {
        Coordinate coord;
        if (si.getSelectedPanel() != null && (coord = si.getSelectedPanel().getPanelData().getClickedCoordinate()) != null) {
            return String.valueOf(coord.getXVal()) + " " + coord.getYVal();
        }
        return "";
    }
}

