/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import jspecview.common.Annotation;
import jspecview.common.CoordComparator;
import jspecview.common.Coordinate;
import jspecview.common.Graph;
import jspecview.common.Integral;
import jspecview.common.JDXSpectrum;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegralGraph
implements Graph {
    public static final double DEFAULT_MINY = 0.1;
    public static final double DEFAULT_FACTOR = 50.0;
    public static final double DEFAULT_OFFSET = 30.0;
    private List<Integral> integrals;
    private JDXSpectrum spectrum;
    private double percentMinY;
    private double percentOffset;
    private double integralFactor;
    private Coordinate[] xyCoords;
    private static Comparator<Coordinate> c;
    public static final int INTEGRATE_MARK = 4;
    public static final int INTEGRATE_TOGGLE = 3;
    public static final int INTEGRATE_ON = 2;
    public static final int INTEGRATE_OFF = 1;

    @Override
    public void dispose() {
        this.integrals = null;
        this.spectrum = null;
    }

    public double getPercentMinimumY() {
        return this.percentMinY;
    }

    public double getPercentOffset() {
        return this.percentOffset;
    }

    public double getIntegralFactor() {
        return this.integralFactor;
    }

    public IntegralGraph(JDXSpectrum spectrum, Parameters parameters, String xUnits, String yUnits) {
        this.spectrum = spectrum;
        this.percentMinY = parameters.integralMinY;
        this.percentOffset = parameters.integralOffset;
        this.integralFactor = parameters.integralFactor;
        this.xyCoords = this.calculateIntegral();
    }

    @Override
    public Coordinate[] getXYCoords() {
        return this.xyCoords;
    }

    public void recalculate() {
        this.xyCoords = this.calculateIntegral();
    }

    private Coordinate[] calculateIntegral() {
        Coordinate[] xyCoords = this.spectrum.getXYCoords();
        Coordinate[] integralCoords = new Coordinate[xyCoords.length];
        double maxY = Coordinate.getMaxY(xyCoords);
        double minYForIntegral = this.percentMinY / 100.0 * maxY;
        double integral = 0.0;
        int i = 0;
        while (i < xyCoords.length) {
            double y = xyCoords[i].getYVal();
            if (y > minYForIntegral) {
                integral += y;
            }
            ++i;
        }
        double factor = this.integralFactor / 100.0 / integral;
        double offset = this.percentOffset / 100.0;
        integral = 0.0;
        int i2 = xyCoords.length;
        int j = 0;
        while (--i2 >= 0) {
            double y = xyCoords[i2].getYVal();
            if (y > minYForIntegral) {
                integral += y;
            }
            integralCoords[i2] = new Coordinate(xyCoords[i2].getXVal(), integral * factor + offset);
            ++j;
        }
        return integralCoords;
    }

    @Override
    public double getPercentYValueAt(double x) {
        double y = this.getYValueAt(x);
        return y * 100.0;
    }

    private double getYValueAt(double x) {
        if (c == null) {
            c = new CoordComparator();
        }
        return Coordinate.getYValueAt(this.xyCoords, x, c);
    }

    public static ArrayList<Annotation> getIntegrationRatiosFromString(String value) {
        ArrayList<Annotation> ratios = new ArrayList<Annotation>();
        StringTokenizer allParamTokens = new StringTokenizer(value, ",");
        while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            StringTokenizer eachParam = new StringTokenizer(token, ":");
            Annotation ratio = new Annotation(Double.parseDouble(eachParam.nextToken()), 0.0, eachParam.nextToken(), true, false, 0, 0);
            ratios.add(ratio);
        }
        return ratios;
    }

    public void addIntegral(double x1, double x2, boolean isFinal) {
        if (Double.isNaN(x1)) {
            this.integrals = null;
            return;
        }
        double intVal = Math.abs(this.getPercentYValueAt(x2) - this.getPercentYValueAt(x1));
        if (isFinal) {
            this.integrals.get((int)0).value = 0.0;
            if (intVal == 0.0) {
                return;
            }
        }
        if (this.integrals == null) {
            this.integrals = new ArrayList<Integral>();
        }
        Integral in = new Integral(intVal, x1, x2, this.getYValueAt(x1), this.getYValueAt(x2));
        this.clearIntegrals(x1, x2);
        if (isFinal || this.integrals.size() == 0) {
            this.integrals.add(in);
        } else {
            this.integrals.set(0, in);
        }
    }

    private void clearIntegrals(double x1, double x2) {
        int i = this.integrals.size();
        while (--i >= 1) {
            Integral in = this.integrals.get(i);
            if (!(Math.min(in.x1, in.x2) < Math.max(x1, x2)) || !(Math.max(in.x1, in.x2) > Math.min(x1, x2))) continue;
            this.integrals.remove(i);
        }
    }

    public List<Integral> getIntegrals() {
        return this.integrals;
    }

    public void addMarks(String ppms) {
        ppms = TextFormat.simpleReplace(" " + ppms, ",", " ");
        ppms = TextFormat.simpleReplace(ppms, " -", " #");
        ppms = TextFormat.simpleReplace(ppms, "--", "-#");
        ppms = ppms.replace('-', '^');
        ppms = ppms.replace('#', '-');
        List<String> tokens = ScriptToken.getTokens(ppms);
        this.addIntegral(0.0, 0.0, false);
        int i = tokens.size();
        while (--i >= 0) {
            String s = tokens.get(i);
            int pt = s.indexOf(94);
            if (pt < 0) continue;
            try {
                double x2 = Double.valueOf(s.substring(0, pt).trim());
                double x1 = Double.valueOf(s.substring(pt + 1).trim());
                this.addIntegral(x1, x2, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IntMode {
        OFF,
        ON,
        TOGGLE,
        MARK;


        static IntMode getMode(String value) {
            IntMode[] intModeArray = IntMode.values();
            int n = intModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IntMode mode = intModeArray[n2];
                if (mode.name().equalsIgnoreCase(value)) {
                    return mode;
                }
                ++n2;
            }
            return OFF;
        }
    }
}

