/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Graph;
import jspecview.common.ImageScaleData;
import jspecview.common.Integral;
import jspecview.common.IntegralGraph;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.MultiScaleData;
import jspecview.common.PanelData;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Visible;
import jspecview.source.JDXSource;
import jspecview.util.Logger;
import jspecview.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GraphSet {
    protected List<Highlight> highlights = new ArrayList<Highlight>();
    protected List<JDXSpectrum> spectra = new ArrayList<JDXSpectrum>(2);
    MultiScaleData multiScaleData;
    protected List<MultiScaleData> zoomInfoList;
    protected ArrayList<Annotation> annotations;
    protected Annotation lastAnnotation;
    protected JDXSource source;
    protected ImageScaleData isd;
    private List<JDXSpectrum> graphsTemp = new ArrayList<JDXSpectrum>();
    protected PlotWidget[] widgets;
    protected PanelData pd;
    protected double fracX = 1.0;
    protected double fracY = 1.0;
    protected double fX0 = 0.0;
    protected double fY0 = 0.0;
    protected PlotWidget zoomBox1D;
    protected PlotWidget zoomBox2D;
    protected PlotWidget pin1Dx0;
    protected PlotWidget pin1Dx1;
    protected PlotWidget pin1Dy0;
    protected PlotWidget pin1Dy1;
    protected PlotWidget pin1Dx01;
    protected PlotWidget pin1Dy01;
    protected PlotWidget pin2Dx0;
    protected PlotWidget pin2Dx1;
    protected PlotWidget pin2Dy0;
    protected PlotWidget pin2Dy1;
    protected PlotWidget pin2Dx01;
    protected PlotWidget pin2Dy01;
    protected PlotWidget cur2Dx0;
    protected PlotWidget cur2Dx1;
    protected PlotWidget cur2Dy;
    protected int xPixel0;
    protected int yPixel0;
    protected int xPixel1;
    protected int yPixel1;
    protected int xPixel00;
    protected int yPixel00;
    protected int xPixel11;
    protected int yPixel11;
    protected int xPixels;
    protected int yPixels;
    protected boolean allowYScale = true;
    protected boolean drawXAxisLeftToRight;
    protected boolean xAxisLeftToRight = true;
    protected boolean doDraw1DObjects = true;
    protected boolean sticky2Dcursor;
    protected boolean reversePlot;
    protected boolean enableZoom;
    protected int currentZoomIndex;
    protected int nSpectra;
    protected int yOffsetPercent;
    protected int iThisSpectrum = -1;
    private double lastClickX;
    double userYFactor = 1.0;
    protected double xFactorForScale;
    protected double yFactorForScale;
    protected double minYScale;
    protected double widthRatio;
    private static final int MIN_DRAG_PIXELS = 5;
    private PeakInfo piMouseOver;
    private final Coordinate coordTemp = new Coordinate();
    static final int minNumOfPointsForZoom = 3;
    protected final int FONT_PLAIN = 0;
    protected final int FONT_BOLD = 1;
    protected final int FONT_ITALIC = 2;

    GraphSet() {
    }

    protected abstract void disposeImage();

    protected abstract void draw2DImage(Object var1);

    protected abstract void drawHandle(Object var1, int var2, int var3, boolean var4);

    protected abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    protected abstract void drawRect(Object var1, int var2, int var3, int var4, int var5);

    protected abstract void drawString(Object var1, String var2, int var3, int var4);

    protected abstract void drawTitle(Object var1, int var2, int var3, String var4);

    protected abstract void fillBox(Object var1, int var2, int var3, int var4, int var5, ScriptToken var6);

    abstract Annotation getAnnotation(double var1, double var3, String var5, boolean var6, boolean var7, int var8, int var9);

    abstract Annotation getAnnotation(List<String> var1, Annotation var2);

    protected abstract boolean get2DImage();

    protected abstract int getFontHeight(Object var1);

    protected abstract GraphSet getGraphSet(Object var1);

    protected abstract String getInput(String var1, String var2, String var3);

    protected abstract int getStringWidth(Object var1, String var2);

    protected abstract void setAnnotationColor(Object var1, Annotation var2, ScriptToken var3);

    protected abstract void setColor(Object var1, ScriptToken var2);

    protected abstract void setCurrentBoxColor(Object var1);

    protected abstract void setPlotColor(Object var1, int var2);

    protected abstract void setColor(Object var1, int var2, int var3, int var4);

    abstract void setPlotColors(Object var1);

    abstract void setPlotColor0(Object var1);

    abstract boolean update2dImage(boolean var1);

    int getNumberOfSpectra() {
        return this.nSpectra;
    }

    void dispose() {
        int i = 0;
        while (i < this.spectra.size()) {
            this.spectra.get(i).dispose();
            ++i;
        }
        this.spectra = null;
        this.multiScaleData = null;
        this.zoomInfoList = null;
        this.annotations = null;
        this.lastAnnotation = null;
        this.source = null;
        this.isd = null;
        this.graphsTemp = null;
        this.widgets = null;
        this.disposeImage();
    }

    PeakInfo selectPeakByFileIndex(String filePath, String index) {
        return this.getSpectrumAt(0).selectPeakByFileIndex(filePath, index);
    }

    JDXSpectrum getSpectrum() {
        return this.getSpectrumAt(this.getSpecIndex()).getCurrentSubSpectrum();
    }

    public void setSpectrum(JDXSpectrum spec) {
        int pt = this.getSpecIndex();
        this.spectra.remove(pt);
        this.spectra.add(pt, spec);
    }

    private int getSpecIndex() {
        return this.iThisSpectrum < 0 || this.iThisSpectrum == Integer.MAX_VALUE ? 0 : this.iThisSpectrum;
    }

    JDXSpectrum getSpectrumAt(int index) {
        return this.spectra.get(index);
    }

    static List<GraphSet> getGraphSets(JSVPanel jsvp, List<JDXSpectrum> spectra, int startIndex, int endIndex) {
        ArrayList<GraphSet> graphSets = new ArrayList<GraphSet>();
        GraphSet graphSet = null;
        JDXSpectrum specLast = null;
        int i = 0;
        while (i < spectra.size()) {
            JDXSpectrum spec = spectra.get(i);
            if (specLast == null || !JDXSpectrum.areScalesCompatible(spec, specLast, false)) {
                graphSet = jsvp.getNewGraphSet();
                graphSets.add(graphSet);
            }
            specLast = spec;
            graphSet.addSpec(specLast);
            ++i;
        }
        GraphSet.setFractionalPositions(graphSets);
        i = graphSets.size();
        while (--i >= 0) {
            ((GraphSet)graphSets.get(i)).initGraphSet(startIndex, endIndex);
            Logger.info("JSVGraphSet " + (i + 1) + " nSpectra = " + ((GraphSet)graphSets.get((int)i)).nSpectra);
        }
        return graphSets;
    }

    protected void addSpec(JDXSpectrum spec) {
        this.spectra.add(spec);
        ++this.nSpectra;
    }

    static void setFractionalPositions(List<GraphSet> graphSets) {
        int n = graphSets.size();
        double f = 0.0;
        boolean n2d = true;
        int i = 0;
        while (i < n) {
            f += (double)(graphSets.get(i).getSpectrumAt(0).is1D() ? true : n2d);
            ++i;
        }
        f = 1.0 / f;
        double x = 0.0;
        int i2 = 0;
        while (i2 < n) {
            double g;
            GraphSet gs = graphSets.get(i2);
            gs.fracY = g = gs.getSpectrumAt(0).is1D() ? f : (double)n2d * f;
            gs.fY0 = x;
            x += g;
            ++i2;
        }
    }

    protected void setPositionForFrame(int width, int height, int left, int right, int top, int bottom) {
        this.xPixel00 = (int)((double)width * this.fX0);
        this.xPixel11 = (int)((double)width * (this.fX0 + this.fracX)) - 1;
        this.yPixel00 = (int)((double)height * this.fY0);
        this.yPixel11 = (int)((double)height * (this.fY0 + this.fracY)) - 1;
        this.xPixel0 = this.xPixel00 + left / (this.xPixel00 == 0 ? 1 : 2);
        this.xPixel1 = this.xPixel11 - right / (this.xPixel11 > width - 2 ? 1 : 2);
        this.yPixel0 = this.yPixel00 + top / (this.yPixel00 == 0 ? 1 : 2);
        this.yPixel1 = this.yPixel11 - bottom / (this.yPixel11 > height - 2 ? 1 : 2);
        this.xPixels = this.xPixel1 - this.xPixel0 + 1;
        this.yPixels = this.yPixel1 - this.yPixel0 + 1;
    }

    protected boolean hasPoint(int xPixel, int yPixel) {
        return xPixel >= this.xPixel00 && xPixel <= this.xPixel11 && yPixel >= this.yPixel00 && yPixel <= this.yPixel11;
    }

    void initGraphSet(int startIndex, int endIndex) {
        this.xAxisLeftToRight = this.getSpectrumAt(0).shouldDisplayXAxisIncreasing();
        this.setDrawXAxis();
        int[] startIndices = new int[this.nSpectra];
        int[] endIndices = new int[this.nSpectra];
        this.allowYScale = true;
        if (endIndex <= 0) {
            endIndex = Integer.MAX_VALUE;
        }
        int i = 0;
        while (i < this.nSpectra) {
            int iLast = this.spectra.get(i).getXYCoords().length - 1;
            startIndices[i] = Coordinate.intoRange(startIndex, 0, iLast);
            endIndices[i] = Coordinate.intoRange(endIndex, 0, iLast);
            this.allowYScale &= this.spectra.get(i).getYUnits().equals(this.spectra.get(0).getYUnits()) && this.spectra.get(i).getUserYFactor() == this.spectra.get(0).getUserYFactor();
            ++i;
        }
        this.allowYScale &= this.fracY == 1.0 && this.fracX == 1.0;
        this.getMultiScaleData(0.0, 0.0, 0.0, 0.0, startIndices, endIndices);
        this.zoomInfoList = new ArrayList<MultiScaleData>();
        this.zoomInfoList.add(this.multiScaleData);
    }

    protected void getMultiScaleData(double x1, double x2, double y1, double y2, int[] startIndices, int[] endIndices) {
        List<JDXSpectrum> graphs = this.graphsTemp.size() == 0 ? this.spectra : this.graphsTemp;
        List<JDXSpectrum> subspecs = this.getSpectrumAt(0).getSubSpectra();
        boolean dontUseSubspecs = subspecs == null || subspecs.size() == 2;
        boolean is2D = !this.getSpectrumAt(0).is1D();
        boolean useFirstSubSpecOnly = false;
        if (is2D && useFirstSubSpecOnly || dontUseSubspecs && y1 == y2) {
            graphs = this.spectra;
        } else if (y1 == y2) {
            this.multiScaleData = new MultiScaleData(subspecs, y1, y2, 10, 10, this.getSpectrum().isContinuous());
            return;
        }
        this.multiScaleData = new MultiScaleData(graphs, y1, y2, startIndices, endIndices, 10, 10, this.getSpectrumAt(0).isContinuous());
        if (x1 != x2) {
            this.multiScaleData.setXRange(x1, x2, 10);
        }
    }

    static GraphSet findGraphSet(List<GraphSet> graphSets, int xPixel, int yPixel) {
        int i = graphSets.size();
        while (--i >= 0) {
            if (!graphSets.get(i).hasPoint(xPixel, yPixel)) continue;
            return graphSets.get(i);
        }
        return null;
    }

    protected boolean isNearby2D(Coordinate a1, Coordinate a2) {
        int xp1 = this.isd.toPixelX(a1.getXVal());
        int yp1 = this.toPixelY(a1.getYVal());
        int xp2 = this.isd.toPixelX(a2.getXVal());
        int yp2 = this.toPixelY(a2.getYVal());
        return Math.abs(xp1 - xp2) + Math.abs(yp1 - yp2) < 10;
    }

    void setReversePlot(boolean val) {
        this.reversePlot = val;
        this.setDrawXAxis();
    }

    boolean getReversePlot() {
        return this.reversePlot;
    }

    protected void setDrawXAxis() {
        this.drawXAxisLeftToRight = this.xAxisLeftToRight ^ this.reversePlot;
        int i = 0;
        while (i < this.spectra.size()) {
            if (this.spectra.get(i) instanceof JDXSpectrum) {
                this.spectra.get(i).setExportXAxisDirection(this.drawXAxisLeftToRight);
            }
            ++i;
        }
    }

    protected void setScaleFactors(MultiScaleData multiScaleData) {
        this.xFactorForScale = (multiScaleData.maxXOnScale - multiScaleData.minXOnScale) / (double)this.xPixels;
        this.yFactorForScale = (multiScaleData.maxYOnScale - multiScaleData.minYOnScale) / (double)this.yPixels;
        this.minYScale = multiScaleData.minYOnScale;
    }

    protected int fixX(int xPixel) {
        return Coordinate.intoRange(xPixel, this.xPixel0, this.xPixel1);
    }

    protected int toPixelX(double dx) {
        int x = (int)((dx - this.multiScaleData.minXOnScale) / this.xFactorForScale);
        return this.drawXAxisLeftToRight ? this.xPixel0 + x : this.xPixel1 - x;
    }

    protected boolean isInTopBar(int xPixel, int yPixel) {
        return xPixel == this.fixX(xPixel) && yPixel > this.pin1Dx0.yPixel0 - 2 && yPixel < this.pin1Dx0.yPixel1;
    }

    protected boolean isInTopBar2D(int xPixel, int yPixel) {
        return this.isd != null && xPixel == this.isd.fixX(xPixel) && yPixel > this.pin2Dx0.yPixel0 - 2 && yPixel < this.pin2Dx0.yPixel1;
    }

    protected boolean isInRightBar(int xPixel, int yPixel) {
        return yPixel == this.fixY(yPixel) && xPixel > this.pin1Dy0.xPixel1 && xPixel < this.pin1Dy0.xPixel0 + 2;
    }

    protected boolean isInRightBar2D(int xPixel, int yPixel) {
        return this.isd != null && yPixel == this.fixY(yPixel) && xPixel > this.pin2Dy0.xPixel1 && xPixel < this.pin2Dy0.xPixel0 + 2;
    }

    protected double toX(int xPixel) {
        if (this.isd != null && this.isd.isXWithinRange(xPixel)) {
            return this.isd.toX(xPixel);
        }
        xPixel = this.fixX(xPixel);
        return this.drawXAxisLeftToRight ? this.multiScaleData.maxXOnScale - (double)(this.xPixel1 - xPixel) * this.xFactorForScale : this.multiScaleData.minXOnScale + (double)(this.xPixel1 - xPixel) * this.xFactorForScale;
    }

    protected double toX0(int xPixel) {
        xPixel = this.fixX(xPixel);
        MultiScaleData multiScaleData = this.zoomInfoList.get(0);
        double factor = (multiScaleData.maxXOnScale - multiScaleData.minXOnScale) / (double)this.xPixels;
        return this.drawXAxisLeftToRight ? multiScaleData.maxXOnScale - (double)(this.xPixel1 - xPixel) * factor : multiScaleData.minXOnScale + (double)(this.xPixel1 - xPixel) * factor;
    }

    protected int toPixelX0(double x) {
        MultiScaleData multiScaleData = this.zoomInfoList.get(0);
        double factor = (multiScaleData.maxXOnScale - multiScaleData.minXOnScale) / (double)this.xPixels;
        return (int)(this.drawXAxisLeftToRight ? (double)this.xPixel1 - (multiScaleData.maxXOnScale - x) / factor : (double)this.xPixel1 - (x - multiScaleData.minXOnScale) / factor);
    }

    protected int fixY(int yPixel) {
        return Coordinate.intoRange(yPixel, this.yPixel0, this.yPixel1);
    }

    protected int toPixelY(double yVal) {
        return Double.isNaN(yVal) ? Integer.MIN_VALUE : this.yPixel1 - (int)((yVal * this.userYFactor - this.minYScale) / this.yFactorForScale);
    }

    protected int toPixelYint(double yVal) {
        return this.yPixel1 - (int)(Double.isNaN(yVal) ? -2.147483648E9 : (double)this.yPixels * yVal);
    }

    protected int toPixelY0(double y) {
        MultiScaleData multiScaleData = this.zoomInfoList.get(0);
        double factor = (multiScaleData.maxYOnScale - multiScaleData.minYOnScale) / (double)this.yPixels;
        return this.fixY((int)((double)this.yPixel0 + (multiScaleData.maxYOnScale - y) / factor));
    }

    protected double toY(int yPixel) {
        return this.multiScaleData.maxYOnScale + (double)(this.yPixel0 - yPixel) * this.yFactorForScale;
    }

    protected double toY0(int yPixel) {
        yPixel = this.fixY(yPixel);
        MultiScaleData multiScaleData = this.zoomInfoList.get(0);
        double factor = (multiScaleData.maxYOnScale - multiScaleData.minYOnScale) / (double)this.yPixels;
        double y = multiScaleData.maxYOnScale + (double)(this.yPixel0 - yPixel) * factor;
        return Math.max(multiScaleData.minY, Math.min(y, multiScaleData.maxY));
    }

    Map<String, Object> getInfo(String key, boolean isSelected) {
        Hashtable<String, Object> spectraInfo = new Hashtable<String, Object>();
        ArrayList<Map<String, Object>> specInfo = new ArrayList<Map<String, Object>>();
        spectraInfo.put("spectra", specInfo);
        int i = 0;
        while (i < this.nSpectra) {
            Map<String, Object> info = this.spectra.get(i).getInfo(key);
            info.put("selected", isSelected);
            specInfo.add(info);
            ++i;
        }
        return spectraInfo;
    }

    String addAnnotation(List<String> args, String title) {
        Annotation annotation;
        if (args.size() == 0 || args.size() == 1 && args.get(0).equalsIgnoreCase("none")) {
            this.annotations = null;
            this.lastAnnotation = null;
            return null;
        }
        if (args.size() < 4 && this.lastAnnotation == null) {
            this.lastAnnotation = this.getAnnotation((this.multiScaleData.maxXOnScale + this.multiScaleData.minXOnScale) / 2.0, (this.multiScaleData.maxYOnScale + this.multiScaleData.minYOnScale) / 2.0, title, false, false, 0, 0);
        }
        if ((annotation = this.getAnnotation(args, this.lastAnnotation)) == null) {
            return null;
        }
        if (this.annotations == null && args.size() == 1 && args.get(0).charAt(0) == '\"') {
            String s = annotation.getText();
            this.getSpectrum().setTitle(s);
            return s;
        }
        this.lastAnnotation = annotation;
        this.addAnnotation(annotation, false);
        return null;
    }

    protected Annotation findAnnotation2D(Coordinate xy) {
        int i = this.annotations.size();
        while (--i >= 0) {
            Annotation a = this.annotations.get(i);
            if (!this.isNearby2D(a, xy)) continue;
            return a;
        }
        return null;
    }

    protected void addAnnotation(Annotation annotation, boolean isToggle) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        boolean removed = false;
        int i = this.annotations.size();
        while (--i >= 0) {
            if (!(annotation.is2D ? this.isNearby2D(this.annotations.get(i), annotation) : annotation.equals(this.annotations.get(i)))) continue;
            removed = true;
            this.annotations.remove(i);
        }
        if (!(annotation.getText().length() <= 0 || removed && isToggle)) {
            this.annotations.add(annotation);
        }
    }

    public void drawGraph(Object og, boolean isInteractive, int height, int width, int left, int right, int top, int bottom, boolean isResized, int yOffsetPercent) {
        this.setPositionForFrame(width, height, left, right, top, bottom);
        JDXSpectrum spec0 = this.getSpectrumAt(0);
        this.userYFactor = this.getSpectrum().getUserYFactor();
        this.setScaleFactors(this.multiScaleData);
        this.enableZoom = this.pd.getBoolean(ScriptToken.ENABLEZOOM);
        if (!this.getSpectrumAt(0).is1D() && this.pd.getBoolean(ScriptToken.DISPLAY2D) && (this.isd != null || this.get2DImage())) {
            this.setImageWindow();
            width = (int)Math.floor(this.widthRatio * (double)this.xPixels * 0.8);
            if (this.pd.display1D) {
                this.xPixels = width;
                this.xPixel1 = this.xPixel0 + this.xPixels - 1;
            } else {
                this.xPixels = 0;
                this.xPixel1 = this.isd.xPixel0 - 30;
            }
            this.setScaleFactors(this.multiScaleData);
        }
        this.setScaleFactors(this.multiScaleData);
        int subIndex = spec0.getSubIndex();
        this.setWidgets(isResized, subIndex);
        this.yOffsetPercent = yOffsetPercent;
        this.drawAll(og, height, width, subIndex, spec0, isInteractive);
    }

    protected boolean doPlot(int i) {
        return this.iThisSpectrum < 0 || this.iThisSpectrum == i;
    }

    protected void setImageWindow() {
        this.isd.setPixelWidthHeight((int)((this.pd.display1D ? 0.6 : 1.0) * (double)this.xPixels), this.yPixels);
        this.widthRatio = this.pd.display1D ? 1.0 * (double)(this.xPixels - this.isd.xPixels) / (double)this.xPixels : 1.0;
        this.isd.setXY0((int)Math.floor(this.xPixel1 - this.isd.xPixels), this.yPixel0);
    }

    void mouseClickEvent(int xPixel, int yPixel, int clickCount, boolean isControlDown) {
        Coordinate xy;
        Annotation a;
        boolean is2D;
        PlotWidget pw = this.getPinSelected(xPixel, yPixel);
        if (pw != null) {
            this.setWidgetValueByUser(pw);
            return;
        }
        boolean bl = is2D = this.isd != null && xPixel == this.isd.fixX(xPixel) && yPixel == this.fixY(yPixel);
        if (isControlDown) {
            this.clearIntegrals();
        } else if (clickCount == 2) {
            if (is2D) {
                if (this.sticky2Dcursor) {
                    this.addAnnotation(this.getAnnotation(this.isd.toX(xPixel), this.isd.toSubspectrumIndex(yPixel), this.pd.coordStr, false, true, 5, 5), true);
                }
                this.sticky2Dcursor = !this.sticky2Dcursor;
                this.set2DCrossHairs(xPixel, yPixel);
                this.pd.repaint();
                return;
            }
            if (this.isInTopBar(xPixel, yPixel)) {
                this.doZoom(this.toX0(this.xPixel0), this.multiScaleData.minY, this.toX0(this.xPixel1), this.multiScaleData.maxY, true, true, false);
            } else if (this.isInRightBar(xPixel, yPixel)) {
                this.doZoom(this.multiScaleData.minXOnScale, this.zoomInfoList.get((int)0).minY, this.multiScaleData.maxXOnScale, this.zoomInfoList.get((int)0).maxY, true, true, false);
            } else if (this.isInTopBar2D(xPixel, yPixel)) {
                this.reset2D(true);
            } else if (this.isInRightBar2D(xPixel, yPixel)) {
                this.reset2D(false);
            }
            return;
        }
        if (is2D && this.annotations != null && (a = this.findAnnotation2D(xy = new Coordinate(this.isd.toX(xPixel), this.isd.toSubspectrumIndex(yPixel)))) != null && this.setAnnotationText(a)) {
            this.pd.repaint();
            return;
        }
        if (is2D) {
            this.sticky2Dcursor = false;
            this.set2DCrossHairs(xPixel, yPixel);
            this.pd.repaint();
            return;
        }
        if (xPixel != this.fixX(xPixel) || yPixel != this.fixY(yPixel)) {
            this.setCoordClicked(Double.NaN, 0.0);
        } else {
            this.setCoordClicked(this.toX(xPixel), this.toY(yPixel));
        }
        this.pd.notifyPeakPickedListeners();
    }

    void mouseReleasedEvent() {
        PlotWidget thisWidget = this.pd.thisWidget;
        if (this.pd.isIntegralDrag) {
            if (GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                this.checkIntegral(this.toX(this.zoomBox1D.xPixel0), this.toX(this.zoomBox1D.xPixel1), true);
                this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
                this.pd.repaint();
            }
            this.pd.isIntegralDrag = false;
        } else if (thisWidget == this.zoomBox2D) {
            if (!GraphSet.isGoodEvent(this.zoomBox2D, null, true)) {
                return;
            }
            this.isd.setZoom(this.zoomBox2D.xPixel0, this.zoomBox2D.yPixel0, this.zoomBox2D.xPixel1, this.zoomBox2D.yPixel1);
            this.zoomBox2D.xPixel1 = this.zoomBox2D.xPixel0;
            this.doZoom(this.isd.toX(this.isd.xPixel0), this.multiScaleData.minY, this.isd.toX(this.isd.xPixel0 + this.isd.xPixels - 1), this.multiScaleData.maxY, true, true, false);
        } else if (thisWidget == this.zoomBox1D) {
            if (!GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                return;
            }
            int x1 = this.zoomBox1D.xPixel1;
            this.doZoom(this.toX(this.zoomBox1D.xPixel0), this.toY(this.zoomBox1D.yPixel0), this.toX(x1), this.toY(this.zoomBox1D.yPixel1), true, true, false);
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
        } else if (thisWidget == this.pin1Dx0 || thisWidget == this.pin1Dx1 || thisWidget == this.cur2Dx0 || thisWidget == this.cur2Dx1) {
            this.addCurrentZoom();
        }
    }

    private static boolean isGoodEvent(PlotWidget zOrP, PlotWidget p, boolean asX) {
        return p == null ? Math.abs(zOrP.xPixel1 - zOrP.xPixel0) > 5 && Math.abs(zOrP.yPixel1 - zOrP.yPixel0) > 5 : (asX ? Math.abs(zOrP.xPixel0 - p.xPixel0) > 5 : Math.abs(zOrP.yPixel0 - p.yPixel0) > 5);
    }

    void mouseMovedEvent(int xPixel, int yPixel) {
        if (!this.pd.isIntegralDrag) {
            this.setToolTipForPixels(xPixel, yPixel);
            if (this.isd == null) {
                JDXSpectrum spec;
                if (this.iThisSpectrum != Integer.MAX_VALUE && (spec = this.pd.getSpectrum()).getPeakList() != null) {
                    this.coordTemp.setXVal(this.toX(xPixel));
                    this.coordTemp.setYVal(this.toY(yPixel));
                    this.piMouseOver = this.pd.getSpectrum().findPeakByCoord(this.coordTemp);
                }
            } else if (!this.pd.display1D && this.sticky2Dcursor) {
                this.set2DCrossHairs(xPixel, yPixel);
            }
        }
        this.pd.repaint();
    }

    boolean checkWidgetEvent(int xPixel, int yPixel, boolean isPress) {
        if (!this.enableZoom) {
            return false;
        }
        PlotWidget widget = this.pd.thisWidget;
        if (isPress) {
            widget = this.getPinSelected(xPixel, yPixel);
            if (widget == null) {
                yPixel = this.fixY(yPixel);
                if (xPixel < this.xPixel1) {
                    xPixel = this.fixX(xPixel);
                    this.zoomBox1D.setX(this.toX(xPixel), xPixel);
                    this.zoomBox1D.yPixel0 = this.pd.isIntegralDrag ? this.yPixel0 : yPixel;
                    widget = this.zoomBox1D;
                } else if (this.isd != null && xPixel < this.isd.xPixel1) {
                    this.zoomBox2D.setX(this.isd.toX(xPixel), this.isd.fixX(xPixel));
                    this.zoomBox2D.yPixel0 = yPixel;
                    widget = this.zoomBox2D;
                }
            }
            this.pd.thisWidget = widget;
            return true;
        }
        if (widget == null) {
            return false;
        }
        if (widget == this.zoomBox1D) {
            this.zoomBox1D.xPixel1 = this.fixX(xPixel);
            int n = this.zoomBox1D.yPixel1 = this.pd.isIntegralDrag ? this.yPixel1 : this.fixY(yPixel);
            if (this.pd.isIntegralDrag && this.zoomBox1D.xPixel0 != this.zoomBox1D.xPixel1) {
                this.checkIntegral(this.zoomBox1D.getXVal(), this.toX(this.zoomBox1D.xPixel1), false);
            }
            return true;
        }
        if (widget == this.zoomBox2D) {
            this.zoomBox2D.xPixel1 = this.isd.fixX(xPixel);
            this.zoomBox2D.yPixel1 = this.fixY(yPixel);
            return true;
        }
        if (widget == this.cur2Dy) {
            this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = (yPixel = this.fixY(yPixel));
            this.setCurrentSubSpectrum(this.isd.toSubspectrumIndex(yPixel));
            return true;
        }
        if (widget == this.cur2Dx0 || widget == this.cur2Dx1) {
            xPixel = this.isd.fixX(xPixel);
            widget.setX(this.isd.toX(xPixel), xPixel);
            this.doZoom(this.cur2Dx0.getXVal(), this.multiScaleData.minY, this.cur2Dx1.getXVal(), this.multiScaleData.maxY, false, false, false);
            return true;
        }
        if (widget == this.pin1Dx0 || widget == this.pin1Dx1 || widget == this.pin1Dx01) {
            xPixel = this.fixX(xPixel);
            widget.setX(this.toX0(xPixel), xPixel);
            if (widget == this.pin1Dx01) {
                int dp = xPixel - (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2 + 1;
                xPixel = this.pin1Dx0.xPixel0 + dp;
                int xPixel1 = this.pin1Dx1.xPixel0 + dp;
                if (this.fixX(xPixel) != xPixel || this.fixX(xPixel1) != xPixel1) {
                    return true;
                }
                this.pin1Dx0.setX(this.toX0(xPixel), xPixel);
                this.pin1Dx1.setX(this.toX0(xPixel1), xPixel1);
            }
            this.doZoom(this.pin1Dx0.getXVal(), this.multiScaleData.minY, this.pin1Dx1.getXVal(), this.multiScaleData.maxY, false, false, false);
            return true;
        }
        if (widget == this.pin1Dy0 || widget == this.pin1Dy1 || widget == this.pin1Dy01) {
            yPixel = this.fixY(yPixel);
            widget.setY(this.toY0(yPixel), yPixel);
            if (widget == this.pin1Dy01) {
                double y1;
                int dp = yPixel - (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2 + 1;
                yPixel = this.pin1Dy0.yPixel0 + dp;
                int yPixel1 = this.pin1Dy1.yPixel0 + dp;
                double y0 = this.toY0(yPixel);
                if (Math.min(y0, y1 = this.toY0(yPixel1)) == this.multiScaleData.minY || Math.max(y0, y1) == this.multiScaleData.maxY) {
                    return true;
                }
                this.pin1Dy0.setY(y0, yPixel);
                this.pin1Dy1.setY(y1, yPixel1);
            }
            this.doZoom(this.multiScaleData.minXOnScale, this.pin1Dy0.getYVal(), this.multiScaleData.maxXOnScale, this.pin1Dy1.getYVal(), false, false, false);
            return true;
        }
        if (widget == this.pin2Dx0 || widget == this.pin2Dx1 || widget == this.pin2Dx01) {
            xPixel = this.isd.fixX(xPixel);
            widget.setX(this.isd.toX0(xPixel), xPixel);
            if (widget == this.pin2Dx01) {
                int dp = xPixel - (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2 + 1;
                xPixel = this.pin2Dx0.xPixel0 + dp;
                int xPixel1 = this.pin2Dx1.xPixel0 + dp;
                if (this.isd.fixX(xPixel) != xPixel || this.isd.fixX(xPixel1) != xPixel1) {
                    return true;
                }
                this.pin2Dx0.setX(this.isd.toX0(xPixel), xPixel);
                this.pin2Dx1.setX(this.isd.toX0(xPixel1), xPixel1);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dx0, this.pin2Dx1, true)) {
                this.reset2D(true);
                return false;
            }
            this.isd.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel0, this.pin2Dy1.yPixel0);
            this.doZoom(this.pin2Dx0.getXVal(), this.multiScaleData.minY, this.pin2Dx1.getXVal(), this.multiScaleData.maxY, false, false, false);
            return true;
        }
        if (widget == this.pin2Dy0 || widget == this.pin2Dy1 || widget == this.pin2Dy01) {
            yPixel = this.fixY(yPixel);
            widget.setY(this.isd.toSubspectrumIndex(yPixel), yPixel);
            if (widget == this.pin2Dy01) {
                int dp = yPixel - (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2 + 1;
                yPixel = this.pin2Dy0.yPixel0 + dp;
                int yPixel1 = this.pin2Dy1.yPixel0 + dp;
                if (yPixel != this.fixY(yPixel) || yPixel1 != this.fixY(yPixel1)) {
                    return true;
                }
                this.pin2Dy0.setY(this.isd.toSubspectrumIndex(yPixel), yPixel);
                this.pin2Dy1.setY(this.isd.toSubspectrumIndex(yPixel1), yPixel1);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dy0, this.pin2Dy1, false)) {
                this.reset2D(false);
                return false;
            }
            this.isd.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel1, this.pin2Dy1.yPixel1);
            return true;
        }
        return false;
    }

    private void setWidgetValueByUser(PlotWidget pw) {
        String sval = pw == this.cur2Dy ? "" + this.isd.toSubspectrumIndex(pw.yPixel0) : (pw == this.pin1Dx01 ? Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) + " - " + Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) : (pw == this.pin1Dy01 ? Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) + " - " + Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) : (pw == this.pin2Dx01 ? Math.min(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) + " - " + Math.max(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) : (pw == this.pin2Dy01 ? (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : "" + pw.getValue()))));
        if ((sval = this.getInput("New value?", "Set Slider", sval)) == null) {
            return;
        }
        sval = sval.trim();
        try {
            if (pw == this.pin1Dx01 || pw == this.pin1Dy01 || pw == this.pin2Dx01 || pw == this.pin2Dy01) {
                int pt = sval.indexOf("-", 1);
                if (pt < 0) {
                    return;
                }
                double val1 = Double.valueOf(sval.substring(0, pt));
                double val2 = Double.valueOf(sval.substring(pt + 1));
                if (pw == this.pin1Dx01) {
                    this.doZoom(val1, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), true, true, false);
                } else if (pw == this.pin1Dy01) {
                    this.doZoom(this.pin1Dx0.getXVal(), val1, this.pin1Dx1.getXVal(), val2, true, true, false);
                } else if (pw == this.pin2Dx01) {
                    this.isd.setView0(this.isd.toPixelX0(val1), this.pin2Dy0.yPixel0, this.isd.toPixelX0(val2), this.pin2Dy1.yPixel0);
                    this.doZoom(val1, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), true, true, false);
                } else if (pw == this.pin2Dy01) {
                    this.isd.setView0(this.pin2Dx0.xPixel0, this.isd.toPixelY0(val1), this.pin2Dx1.xPixel0, this.isd.toPixelY0(val2));
                    this.doZoom(this.isd.toX(this.isd.xPixel0), this.multiScaleData.minY, this.isd.toX(this.isd.xPixel0 + this.isd.xPixels - 1), this.multiScaleData.maxY, true, true, false);
                }
            } else {
                double val = Double.valueOf(sval);
                if (pw.isXtype) {
                    double val2 = pw == this.pin1Dx0 || pw == this.cur2Dx0 || pw == this.pin2Dx0 ? this.pin1Dx1.getXVal() : this.pin1Dx0.getXVal();
                    this.doZoom(val, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), true, true, false);
                } else if (pw == this.cur2Dy) {
                    this.setCurrentSubSpectrum((int)val);
                    this.pd.repaint();
                } else if (pw == this.pin2Dy0 || pw == this.pin2Dy1) {
                    int val2 = pw == this.pin2Dy0 ? this.pin2Dy1.yPixel0 : this.pin2Dy0.yPixel0;
                    this.isd.setView0(this.pin2Dx0.xPixel0, this.isd.toPixelY((int)val), this.pin2Dx1.xPixel0, val2);
                    this.pd.repaint();
                } else {
                    double val2 = pw == this.pin1Dy0 ? this.pin1Dy1.getYVal() : this.pin1Dy0.getYVal();
                    this.doZoom(this.pin1Dx0.getXVal(), val, this.pin1Dx1.getXVal(), val2, true, true, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addPeakHighlight(PeakInfo peakInfo) {
        int i = this.spectra.size();
        while (--i >= 0) {
            String peak;
            JDXSpectrum spec = this.spectra.get(i);
            this.removeAllHighlights(spec);
            if (peakInfo == null || peakInfo.isClearAll() || spec != peakInfo.spectrum || (peak = peakInfo.toString()) == null) continue;
            String xMin = Parser.getQuotedAttribute(peak, "xMin");
            String xMax = Parser.getQuotedAttribute(peak, "xMax");
            if (xMin == null || xMax == null) {
                return;
            }
            float x1 = Parser.parseFloat(xMin);
            float x2 = Parser.parseFloat(xMax);
            if (Float.isNaN(x1) || Float.isNaN(x2)) {
                return;
            }
            this.addHighlight(x1, x2, spec, null);
            if (ScaleData.isWithinRange(x1, this.multiScaleData) && ScaleData.isWithinRange(x2, this.multiScaleData)) {
                this.pd.repaint();
                continue;
            }
            this.reset();
        }
    }

    void selectSpectrum(String filePath, String type, String model) {
        if (this.nSpectra == 1) {
            this.iThisSpectrum = -1;
            return;
        }
        boolean haveFound = false;
        int i = this.spectra.size();
        while (--i >= 0) {
            if (!(this.spectra.get(i) instanceof JDXSpectrum) || filePath != null && !this.getSpectrumAt(i).getFilePathForwardSlash().equals(filePath) || !this.getSpectrumAt(i).matchesPeakTypeModel(type, model)) continue;
            this.iThisSpectrum = i;
            haveFound = true;
        }
        if (!haveFound && this.iThisSpectrum >= 0 && this != this.pd.currentGraphSet) {
            this.iThisSpectrum = Integer.MAX_VALUE;
        }
    }

    void toPeak(int istep) {
        Coordinate coord;
        JDXSpectrum spec = this.getSpectrum();
        int iPeak = spec.setNextPeak(coord = this.setCoordClicked(this.lastClickX, 0.0), istep *= this.drawXAxisLeftToRight ? 1 : -1);
        if (iPeak < 0) {
            return;
        }
        PeakInfo peak = spec.getPeakList().get(iPeak);
        spec.setSelectedPeak(peak);
        this.setCoordClicked(peak.getX(), 0.0);
        this.notifyPeakListeners(peak);
    }

    private Coordinate setCoordClicked(double x, double y) {
        if (Double.isNaN(x)) {
            this.pd.coordClicked = null;
            this.pd.coordsClicked = null;
            return null;
        }
        this.lastClickX = x;
        this.pd.coordClicked = new Coordinate(this.lastClickX, y);
        this.pd.coordsClicked = this.getSpectrum().getXYCoords();
        return this.pd.coordClicked;
    }

    protected void notifyPeakListeners(PeakInfo peak) {
        this.pd.notifyListeners(new PeakPickEvent(this.pd.owner, this.pd.coordClicked, peak == null ? this.pd.getSpectrum().getBasePeakInfo() : peak));
    }

    void escape() {
        this.pd.thisWidget = null;
        this.zoomBox2D.xPixel1 = 0;
        this.zoomBox2D.xPixel0 = 0;
        this.zoomBox1D.xPixel1 = 0;
        this.zoomBox1D.xPixel0 = 0;
    }

    protected void setWidgets(boolean isResized, int subIndex) {
        if (isResized) {
            if (this.zoomBox1D == null) {
                this.newPins();
            } else {
                this.resetPinPositions();
            }
        }
        this.setDerivedPins(subIndex);
        this.setPinSliderPositions();
    }

    protected void newPins() {
        this.zoomBox1D = new PlotWidget("zoomBox1D");
        this.pin1Dx0 = new PlotWidget("pin1Dx0");
        this.pin1Dx1 = new PlotWidget("pin1Dx1");
        this.pin1Dy0 = new PlotWidget("pin1Dy0");
        this.pin1Dy1 = new PlotWidget("pin1Dy1");
        this.pin1Dx01 = new PlotWidget("pin1Dx01");
        this.pin1Dy01 = new PlotWidget("pin1Dy01");
        if (this.isd != null) {
            this.zoomBox2D = new PlotWidget("zoomBox2D");
            this.pin2Dx0 = new PlotWidget("pin2Dx0");
            this.pin2Dx1 = new PlotWidget("pin2Dx1");
            this.pin2Dy0 = new PlotWidget("pin2Dy0");
            this.pin2Dy1 = new PlotWidget("pin2Dy1");
            this.pin2Dx01 = new PlotWidget("pin2Dx01");
            this.pin2Dy01 = new PlotWidget("pin2Dy01");
            this.cur2Dx0 = new PlotWidget("cur2Dx0");
            this.cur2Dx1 = new PlotWidget("cur2Dx1");
            this.cur2Dy = new PlotWidget("cur2Dy");
            this.pin2Dy0.setY(0.0, this.isd.toPixelY0(0.0));
            int n = this.getSpectrumAt(0).getSubSpectra().size();
            this.pin2Dy1.setY(n, this.isd.toPixelY0(n));
        }
        this.pin1Dx0.setX(this.multiScaleData.minX, this.toPixelX0(this.multiScaleData.minX));
        this.pin1Dx1.setX(this.multiScaleData.maxX, this.toPixelX0(this.multiScaleData.maxX));
        this.pin1Dy0.setY(this.multiScaleData.minY, this.toPixelY0(this.multiScaleData.minY));
        this.pin1Dy1.setY(this.multiScaleData.maxY, this.toPixelY0(this.multiScaleData.maxY));
        this.widgets = new PlotWidget[]{this.zoomBox1D, this.zoomBox2D, this.pin1Dx0, this.pin1Dx01, this.pin1Dx1, this.pin1Dy0, this.pin1Dy01, this.pin1Dy1, this.pin2Dx0, this.pin2Dx01, this.pin2Dx1, this.pin2Dy0, this.pin2Dy01, this.pin2Dy1, this.cur2Dx0, this.cur2Dx1, this.cur2Dy};
    }

    protected void resetPinsFromMultiScaleData() {
        if (this.pin1Dx0 == null) {
            return;
        }
        this.pin1Dx0.setX(this.multiScaleData.minXOnScale, this.toPixelX0(this.multiScaleData.minXOnScale));
        this.pin1Dx1.setX(this.multiScaleData.maxXOnScale, this.toPixelX0(this.multiScaleData.maxXOnScale));
        this.pin1Dy0.setY(this.multiScaleData.minY, this.toPixelY0(this.multiScaleData.minY));
        this.pin1Dy1.setY(this.multiScaleData.maxY, this.toPixelY0(this.multiScaleData.maxY));
    }

    protected void resetPinPositions() {
        this.pin1Dx0.setX(this.pin1Dx0.getXVal(), this.toPixelX0(this.pin1Dx0.getXVal()));
        this.pin1Dx1.setX(this.pin1Dx1.getXVal(), this.toPixelX0(this.pin1Dx1.getXVal()));
        this.pin1Dy0.setY(this.pin1Dy0.getYVal(), this.toPixelY0(this.pin1Dy0.getYVal()));
        this.pin1Dy1.setY(this.pin1Dy1.getYVal(), this.toPixelY0(this.pin1Dy1.getYVal()));
        if (this.isd != null) {
            this.pin2Dy0.setY(this.pin2Dy0.getYVal(), this.isd.toPixelY0(this.pin2Dy0.getYVal()));
            this.pin2Dy1.setY(this.pin2Dy1.getYVal(), this.isd.toPixelY0(this.pin2Dy1.getYVal()));
        }
    }

    protected void setPinSliderPositions() {
        this.pin1Dx1.yPixel0 = this.pin1Dx01.yPixel0 = this.yPixel0 - 5;
        this.pin1Dx0.yPixel0 = this.pin1Dx01.yPixel0;
        this.pin1Dx1.yPixel1 = this.pin1Dx01.yPixel1 = this.yPixel0;
        this.pin1Dx0.yPixel1 = this.pin1Dx01.yPixel1;
        this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.xPixel1 + 5;
        this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
        this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.xPixel1;
        this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
        if (this.isd != null) {
            this.pin2Dx1.yPixel0 = this.pin2Dx01.yPixel0 = this.yPixel0 - 5;
            this.pin2Dx0.yPixel0 = this.pin2Dx01.yPixel0;
            this.pin2Dx1.yPixel1 = this.pin2Dx01.yPixel1 = this.yPixel0;
            this.pin2Dx0.yPixel1 = this.pin2Dx01.yPixel1;
            this.pin2Dy1.xPixel0 = this.pin2Dy01.xPixel0 = this.isd.xPixel1 + 5;
            this.pin2Dy0.xPixel0 = this.pin2Dy01.xPixel0;
            this.pin2Dy1.xPixel1 = this.pin2Dy01.xPixel1 = this.isd.xPixel1;
            this.pin2Dy0.xPixel1 = this.pin2Dy01.xPixel1;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 15;
            this.cur2Dx0.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 15;
            this.cur2Dx1.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dy.xPixel0 = this.doDraw1DObjects ? (this.xPixel1 + this.isd.xPixel0) / 2 : this.isd.xPixel0 - 15;
            this.cur2Dy.xPixel1 = this.isd.xPixel1 + 5;
        }
    }

    protected void setDerivedPins(int subIndex) {
        this.pin1Dx01.setX(0.0, (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2);
        this.pin1Dy01.setY(0.0, (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2);
        this.pin1Dx01.setEnabled(Math.min(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) > this.xPixel0 || Math.max(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) < this.xPixel1);
        this.pin1Dy01.setEnabled(Math.min(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) > Math.min(this.toPixelY(this.multiScaleData.minY), this.toPixelY(this.multiScaleData.maxY)) || Math.max(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) < Math.max(this.toPixelY(this.multiScaleData.minY), this.toPixelY(this.multiScaleData.maxY)));
        if (this.isd == null) {
            return;
        }
        double x = this.pin1Dx0.getXVal();
        this.cur2Dx0.setX(x, this.isd.toPixelX(x));
        x = this.pin1Dx1.getXVal();
        this.cur2Dx1.setX(x, this.isd.toPixelX(x));
        x = this.isd.toX(this.isd.xPixel0);
        this.pin2Dx0.setX(x, this.isd.toPixelX0(x));
        x = this.isd.toX(this.isd.xPixel1);
        this.pin2Dx1.setX(x, this.isd.toPixelX0(x));
        this.pin2Dx01.setX(0.0, (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2);
        double y = this.isd.imageHeight - 1 - this.isd.yView1;
        this.pin2Dy0.setY(y, this.isd.toPixelY0(y));
        y = this.isd.imageHeight - 1 - this.isd.yView2;
        this.pin2Dy1.setY(y, this.isd.toPixelY0(y));
        this.pin2Dy01.setY(0.0, (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2);
        this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = this.isd.toPixelY(subIndex);
        this.pin2Dx01.setEnabled(Math.min(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel0) != this.isd.xPixel0 || Math.max(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel1) != this.isd.xPixel1);
        this.pin2Dy01.setEnabled(Math.min(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel0) != this.yPixel0 || Math.max(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel1) != this.yPixel1);
    }

    void setZoom(double x1, double y1, double x2, double y2) {
        this.setZoomTo(0);
        if (Double.isNaN(x1)) {
            x1 = this.multiScaleData.minX;
            x2 = this.multiScaleData.maxX;
            this.isd = null;
        }
        if (x1 != 0.0 || x2 != 0.0) {
            this.doZoom(x1, y1, x2, y2, false, true, false);
            return;
        }
        this.newPins();
        this.isd = null;
    }

    protected synchronized void doZoom(double initX, double initY, double finalX, double finalY, boolean doRepaint, boolean addZoom, boolean checkRange) {
        boolean is2D;
        boolean is2DYScaleChange;
        System.out.println("dozoom y=" + initY + " " + finalY);
        if (!this.enableZoom) {
            return;
        }
        if (initX > finalX) {
            double tempX = initX;
            initX = finalX;
            finalX = tempX;
        }
        if (initY > finalY) {
            double tempY = initY;
            initY = finalY;
            finalY = tempY;
        }
        boolean bl = is2DYScaleChange = this.isd != null && (this.isd.minZ != initY || this.isd.maxZ != finalY);
        if (checkRange) {
            if (!ScaleData.isWithinRange(initX, this.multiScaleData) && !ScaleData.isWithinRange(finalX, this.multiScaleData)) {
                return;
            }
            if (!ScaleData.isWithinRange(initX, this.multiScaleData)) {
                initX = this.multiScaleData.minX;
            } else if (!ScaleData.isWithinRange(finalX, this.multiScaleData)) {
                finalX = this.multiScaleData.maxX;
            }
        } else {
            this.multiScaleData = this.zoomInfoList.get(0);
        }
        int[] startIndices = new int[this.nSpectra];
        int[] endIndices = new int[this.nSpectra];
        this.graphsTemp.clear();
        List<JDXSpectrum> subspecs = this.getSpectrumAt(0).getSubSpectra();
        boolean dontUseSubspecs = subspecs == null || subspecs.size() == 2;
        boolean bl2 = is2D = !this.getSpectrumAt(0).is1D();
        if (!is2D && !dontUseSubspecs) {
            this.graphsTemp.add(this.getSpectrum());
            if (!this.multiScaleData.setDataPointIndices(this.graphsTemp, initX, finalX, 3, startIndices, endIndices, false)) {
                return;
            }
        } else if (!this.multiScaleData.setDataPointIndices(this.spectra, initX, finalX, 3, startIndices, endIndices, false)) {
            return;
        }
        this.getMultiScaleData(initX, finalX, initY, finalY, startIndices, endIndices);
        this.pin1Dx0.setX(initX, this.toPixelX0(initX));
        this.pin1Dx1.setX(finalX, this.toPixelX0(finalX));
        this.pin1Dy0.setY(initY, this.toPixelY0(initY));
        this.pin1Dy1.setY(finalY, this.toPixelY0(finalY));
        if (this.isd != null) {
            int isub = this.getSpectrumAt(0).getSubIndex();
            int ifix = this.isd.fixSubIndex(isub);
            if (ifix != isub) {
                this.setCurrentSubSpectrum(ifix);
            }
            if (is2DYScaleChange) {
                this.update2dImage(true);
            }
        }
        if (addZoom) {
            this.addCurrentZoom();
        }
        if (doRepaint) {
            this.pd.repaint();
        }
    }

    void setCurrentSubSpectrum(int i) {
        JDXSpectrum spec0 = this.getSpectrumAt(0);
        i = spec0.setCurrentSubSpectrum(i);
        if (spec0.isForcedSubset()) {
            this.multiScaleData.setXRange(this.getSpectrum());
        }
        this.pd.notifySubSpectrumChange(i, this.getSpectrum());
    }

    void scaleYBy(double factor) {
        if (!this.allowYScale) {
            return;
        }
        double factor1 = factor;
        double factor2 = factor;
        switch (this.getSpectrum().getYScaleType()) {
            case 0: {
                return;
            }
            case 1: {
                factor1 = 1.0;
                break;
            }
            case 2: {
                factor2 = 1.0;
            }
        }
        this.doZoom(this.multiScaleData.minX, this.multiScaleData.minY / factor1, this.multiScaleData.maxX, this.multiScaleData.maxY / factor2, true, true, false);
    }

    protected void addCurrentZoom() {
        if (this.zoomInfoList.size() > this.currentZoomIndex + 1) {
            int i = this.zoomInfoList.size() - 1;
            while (i > this.currentZoomIndex) {
                this.zoomInfoList.remove(i);
                --i;
            }
        }
        this.zoomInfoList.add(this.multiScaleData);
        ++this.currentZoomIndex;
    }

    void reset() {
        this.setZoomTo(0);
    }

    protected void setZoomTo(int i) {
        this.isd = null;
        this.currentZoomIndex = i;
        this.multiScaleData = this.zoomInfoList.get(i);
        this.resetPinsFromMultiScaleData();
        this.pd.refresh();
    }

    void clearViews() {
        this.reset();
        int i = this.zoomInfoList.size();
        while (--i >= 1) {
            this.zoomInfoList.remove(i);
        }
    }

    void previousView() {
        if (this.currentZoomIndex > 0) {
            this.setZoomTo(this.currentZoomIndex - 1);
        }
    }

    void nextView() {
        if (this.currentZoomIndex + 1 < this.zoomInfoList.size()) {
            this.setZoomTo(this.currentZoomIndex + 1);
        }
    }

    protected void drawAll(Object g, int height, int width, int subIndex, JDXSpectrum spec0, boolean isInteractive) {
        if (this.isd != null) {
            this.draw2DImage(g);
        }
        this.draw2DUnits(g, width, subIndex, spec0);
        boolean bl = this.doDraw1DObjects = this.isd == null || this.pd.display1D;
        if (isInteractive) {
            this.drawFrame(g, height, width);
        }
        if (this.doDraw1DObjects) {
            this.fillBox(g, this.xPixel0, this.yPixel0, this.xPixel1, this.yPixel1, ScriptToken.PLOTAREACOLOR);
            this.drawWidgets(g, subIndex, isInteractive);
            this.drawPeakTabs(g);
            this.drawHighlights(g);
            if (this.pd.gridOn) {
                this.drawGrid(g, height, width);
            }
            if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                this.drawXScale(g, height, width);
            }
            if (this.pd.getBoolean(ScriptToken.XUNITSON)) {
                this.drawXUnits(g, width);
            }
            if (this.allowYScale && this.pd.getBoolean(ScriptToken.YSCALEON)) {
                this.drawYScale(g, height, width);
            }
            if (this.allowYScale && this.pd.getBoolean(ScriptToken.YUNITSON)) {
                this.drawYUnits(g, width);
            }
            int offset = 0;
            int yOffsetPixels = (int)((float)this.yPixels * ((float)this.yOffsetPercent / 100.0f));
            int i = this.nSpectra;
            while (--i >= 0) {
                if (!this.doPlot(i)) continue;
                this.drawSpectrum(g, i, height, width, offset);
                if (this.iThisSpectrum == i && this == this.pd.currentGraphSet) {
                    this.drawTitle(g, height, width, this.spectra.get(i).getPeakTitle());
                    this.pd.titleDrawn = true;
                }
                offset -= yOffsetPixels;
            }
            this.drawIntegralValue(g, width);
        } else {
            this.drawWidgets(g, subIndex, isInteractive);
        }
        if (this.annotations != null) {
            this.drawAnnotations(g, height, width, this.annotations, null);
        }
    }

    private void draw2DUnits(Object g, int width, int subIndex, JDXSpectrum spec0) {
        if (subIndex >= 0 && this.isd != null) {
            this.setColor(g, ScriptToken.PLOTCOLOR);
            this.drawUnits(g, width, spec0.nucleusX, this.isd.xPixel1 + 5, this.yPixel1, 1.0, 1.0);
            this.drawUnits(g, width, spec0.nucleusY, this.isd.xPixel0 - 5, this.yPixel0, 1.0, 0.0);
        }
    }

    private void drawHighlights(Object g) {
        if (this.iThisSpectrum == Integer.MAX_VALUE) {
            return;
        }
        JDXSpectrum spec = this.spectra.get(Math.max(this.iThisSpectrum, 0));
        this.drawHighlights(g, spec);
    }

    private void drawPeakTabs(Object g) {
        ArrayList<PeakInfo> list;
        if (this.iThisSpectrum == Integer.MAX_VALUE) {
            return;
        }
        JDXSpectrum spec = this.spectra.get(Math.max(this.iThisSpectrum, 0));
        ArrayList<PeakInfo> arrayList = list = this.nSpectra == 1 || this.getSpectrum().hasIntegral() || this.iThisSpectrum >= 0 ? spec.getPeakList() : null;
        if (list != null && list.size() > 0) {
            if (this.piMouseOver != null && this.pd.isMouseUp()) {
                this.setColor(g, 240, 240, 240);
                this.drawPeak(g, this.piMouseOver, true);
            }
            this.setColor(g, ScriptToken.HIGHLIGHTCOLOR);
            int i = list.size();
            while (--i >= 0) {
                this.drawPeak(g, list.get(i), false);
            }
        }
    }

    private void drawPeak(Object g, PeakInfo pi, boolean isFull) {
        double xMax;
        double xMin = pi.getXMin();
        if (xMin != (xMax = pi.getXMax())) {
            this.drawBar(g, xMin, xMax, null, isFull);
        }
    }

    private void drawWidgets(Object g, int subIndex, boolean withSliders) {
        if (withSliders) {
            if (this.doDraw1DObjects) {
                this.fillBox(g, this.xPixel0, this.pin1Dx0.yPixel1, this.xPixel1, this.pin1Dx1.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(g, this.pin1Dx0.xPixel0, this.pin1Dx0.yPixel1, this.pin1Dx1.xPixel0, this.pin1Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
            } else {
                this.fillBox(g, this.isd.xPixel0, this.pin2Dx0.yPixel1, this.isd.xPixel1, this.pin2Dx0.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(g, this.pin2Dx0.xPixel0, this.pin2Dx0.yPixel1, this.pin2Dx1.xPixel0, this.pin2Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
                this.fillBox(g, this.pin2Dy0.xPixel1, this.yPixel1, this.pin2Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
                this.fillBox(g, this.pin2Dy0.xPixel1, this.pin2Dy0.yPixel1, this.pin2Dy1.xPixel1 + 2, this.pin2Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
        }
        this.fillBox(g, this.pin1Dy0.xPixel1, this.yPixel1, this.pin1Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
        this.fillBox(g, this.pin1Dy0.xPixel1, this.pin1Dy0.yPixel1, this.pin1Dy1.xPixel1 + 2, this.pin1Dy1.yPixel0, ScriptToken.PLOTCOLOR);
        int i = 0;
        while (i < this.widgets.length) {
            PlotWidget pw = this.widgets[i];
            if (!(pw == null || !pw.isPinOrCursor && !this.enableZoom || pw.isPin && !withSliders || (pw.is2D ? pw == this.cur2Dx0 && !this.doDraw1DObjects : !this.doDraw1DObjects && pw != this.pin1Dy0 && pw != this.pin1Dy1 && pw != this.pin1Dy01))) {
                this.drawWidget(g, pw);
            }
            ++i;
        }
    }

    private void drawWidget(Object g, PlotWidget pw) {
        if (pw == null) {
            return;
        }
        if (pw.isPinOrCursor) {
            this.setColor(g, ScriptToken.PLOTCOLOR);
            this.drawLine(g, pw.xPixel0, pw.yPixel0, pw.xPixel1, pw.yPixel1);
            this.drawHandle(g, pw.xPixel0, pw.yPixel0, !pw.isEnabled);
        } else if (pw.xPixel1 != pw.xPixel0) {
            this.fillBox(g, pw.xPixel0, pw.yPixel0, pw.xPixel1, pw.yPixel1, ScriptToken.ZOOMBOXCOLOR);
        }
    }

    protected void drawBar(Object g, double startX, double endX, ScriptToken whatColor, boolean isFullHeight) {
        int x2;
        int x1 = this.toPixelX(startX);
        if (x1 > (x2 = this.toPixelX(endX))) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if ((x1 = this.fixX(x1)) == (x2 = this.fixX(x2))) {
            return;
        }
        this.fillBox(g, x1, this.yPixel0, x2, this.yPixel0 + (isFullHeight ? this.yPixels : 5), whatColor);
    }

    private void drawSpectrum(Object g, int index, int height, int width, int yOffset) {
        JDXSpectrum spec = this.spectra.get(index);
        this.userYFactor = spec.getUserYFactor();
        this.drawPlot(g, index, spec, height, width, true, spec.isContinuous(), yOffset);
        if (spec.hasIntegral()) {
            this.drawPlot(g, index, spec.getIntegrationGraph(), height, width, false, true, yOffset);
        }
        if (spec.integrationRatios != null) {
            this.drawAnnotations(g, height, width, spec.integrationRatios, ScriptToken.INTEGRALPLOTCOLOR);
        }
    }

    private void drawPlot(Object g, int index, Graph spec, int height, int width, boolean drawY0, boolean isContinuous, int yOffset) {
        boolean fillPeaks;
        Coordinate[] xyCoords = spec.getXYCoords();
        boolean isIntegral = spec instanceof IntegralGraph;
        boolean bl = fillPeaks = !isIntegral && this.pd.isIntegralDrag && this.spectra.get(index).hasIntegral();
        this.setPlotColor(g, isIntegral ? -1 : (this.iThisSpectrum == index ? 0 : index));
        int y0 = this.toPixelY(0.0);
        if (!drawY0 || index != 0 || y0 != this.fixY(y0)) {
            y0 = -1;
        }
        if (isContinuous) {
            int i = this.multiScaleData.startDataPointIndices[index];
            while (i < this.multiScaleData.endDataPointIndices[index]) {
                int y2;
                Coordinate point1 = xyCoords[i];
                Coordinate point2 = xyCoords[i + 1];
                int x1 = this.toPixelX(point1.getXVal());
                int x2 = this.toPixelX(point2.getXVal());
                int y1 = isIntegral ? this.toPixelYint(point1.getYVal()) : this.toPixelY(point1.getYVal());
                int n = y2 = isIntegral ? this.toPixelYint(point2.getYVal()) : this.toPixelY(point2.getYVal());
                if (y1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE) {
                    y1 = yOffset + this.fixY(y1);
                    y2 = yOffset + this.fixY(y2);
                    if (fillPeaks && y0 > 0 && x1 >= this.zoomBox1D.xPixel0 && x1 <= this.zoomBox1D.xPixel1) {
                        this.setColor(g, ScriptToken.INTEGRALPLOTCOLOR);
                        this.drawLine(g, x1, y0, x1, y1);
                        this.setColor(g, ScriptToken.PLOTCOLOR);
                    } else if (y1 != y2 || y1 != this.yPixel0 && y1 != this.yPixel1) {
                        this.drawLine(g, x1, y1, x2, y2);
                    }
                }
                ++i;
            }
        } else {
            int i = this.multiScaleData.startDataPointIndices[index];
            while (i <= this.multiScaleData.endDataPointIndices[index]) {
                Coordinate point = xyCoords[i];
                int x1 = this.toPixelX(point.getXVal());
                int y1 = this.toPixelY(Math.max(this.multiScaleData.minYOnScale, 0.0));
                int y2 = this.toPixelY(point.getYVal());
                if (y2 != Integer.MIN_VALUE && ((y1 = this.fixY(y1)) != (y2 = this.fixY(y2)) || y1 != this.yPixel0 && y1 != this.yPixel1)) {
                    this.drawLine(g, x1, y1, x1, y2);
                }
                ++i;
            }
            if (this.multiScaleData.isYZeroOnScale()) {
                int y = this.toPixelY(0.0);
                this.drawLine(g, this.xPixel1, y, this.xPixel0, y);
            }
        }
    }

    private void drawFrame(Object g, int height, int width) {
        if (!this.pd.gridOn) {
            this.setColor(g, ScriptToken.GRIDCOLOR);
            this.drawRect(g, this.xPixel0, this.yPixel0, this.xPixels, this.yPixels);
        }
        if (this == this.pd.currentGraphSet && this.fracY != 1.0) {
            this.setCurrentBoxColor(g);
            this.drawRect(g, this.xPixel00 + 10, this.yPixel00 + 1, this.xPixel11 - this.xPixel00 - 20, this.yPixel11 - this.yPixel00 - 2);
        }
    }

    private void drawGrid(Object g, int height, int width) {
        int x;
        double val;
        double lastX;
        this.setColor(g, ScriptToken.GRIDCOLOR);
        if (Double.isNaN(this.multiScaleData.firstX)) {
            lastX = this.multiScaleData.maxXOnScale + this.multiScaleData.xStep / 2.0;
            val = this.multiScaleData.minXOnScale;
            while (val < lastX) {
                x = this.toPixelX(val);
                this.drawLine(g, x, this.yPixel0, x, this.yPixel1);
                val += this.multiScaleData.xStep;
            }
        } else {
            lastX = this.multiScaleData.maxXOnScale * 1.0001;
            val = this.multiScaleData.firstX;
            while (val <= lastX) {
                x = this.toPixelX(val);
                this.drawLine(g, x, this.yPixel0, x, this.yPixel1);
                val += this.multiScaleData.xStep;
            }
        }
        val = this.multiScaleData.minYOnScale;
        while (val < this.multiScaleData.maxYOnScale + this.multiScaleData.yStep / 2.0) {
            int y = this.toPixelY(val);
            if (y == this.fixY(y)) {
                this.drawLine(g, this.xPixel0, y, this.xPixel1, y);
            }
            val += this.multiScaleData.yStep;
        }
    }

    private void drawIntegralValue(Object g, int width) {
        List<Integral> integrals = this.getSpectrum().getIntegrals();
        if (integrals == null) {
            return;
        }
        this.pd.setFont(g, width, 1, 12, false);
        NumberFormat formatter = this.pd.getFormatter("#0.0");
        this.setColor(g, ScriptToken.INTEGRALPLOTCOLOR);
        int i = integrals.size();
        while (--i >= 0) {
            Integral in = integrals.get(i);
            if (in.value == 0.0) continue;
            String s = "  " + formatter.format(Math.abs(in.value));
            int x = this.toPixelX(in.x2);
            int y1 = this.toPixelYint(in.y1);
            int y2 = this.toPixelYint(in.y2);
            if (x != this.fixX(x)) continue;
            this.drawLine(g, x, y1, x, y2);
            this.drawLine(g, x + 1, y1, x + 1, y2);
            this.drawString(g, s, x, (y1 + y2) / 2 + this.getFontHeight(g) / 3);
        }
    }

    private void drawXScale(Object g, int height, int width) {
        String hashX = "#";
        String hash1 = "0.00000000";
        if (this.multiScaleData.hashNums[0] <= 0) {
            hashX = hash1.substring(0, Math.abs(this.multiScaleData.hashNums[0]) + 3);
        }
        NumberFormat formatter = this.pd.getFormatter(hashX);
        this.pd.setFont(g, width, 0, 12, false);
        int y1 = this.yPixel1;
        int y2 = this.yPixel1 + 3;
        double maxWidth = Math.abs((double)(this.toPixelX(this.multiScaleData.xStep) - this.toPixelX(0.0)) * 0.95);
        if (Double.isNaN(this.multiScaleData.firstX)) {
            double lastX = this.multiScaleData.maxXOnScale + this.multiScaleData.xStep / 2.0;
            double val = this.multiScaleData.minXOnScale;
            double vald = this.multiScaleData.maxXOnScale;
            while (val < lastX) {
                int x = (int)((double)this.xPixel0 + ((this.drawXAxisLeftToRight ? val : vald) - this.multiScaleData.minXOnScale) / this.xFactorForScale);
                this.setColor(g, ScriptToken.GRIDCOLOR);
                this.drawLine(g, x, y1, x, y2);
                this.setColor(g, ScriptToken.SCALECOLOR);
                String s = formatter.format(val);
                int w = this.getStringWidth(g, s);
                this.drawString(g, s, x - w / 2, y2 + this.getFontHeight(g));
                val += this.multiScaleData.xStep;
                vald -= this.multiScaleData.xStep;
            }
        } else {
            double lastX = this.multiScaleData.maxXOnScale * 1.0001;
            double val = this.multiScaleData.firstX;
            while (val <= lastX) {
                int x = this.toPixelX(val);
                this.setColor(g, ScriptToken.GRIDCOLOR);
                this.drawLine(g, x, y1, x, y2);
                this.setColor(g, ScriptToken.SCALECOLOR);
                String s = formatter.format(val);
                int w = this.getStringWidth(g, s);
                int n = x + w / 2 == this.fixX(x + w / 2) ? 2 : 1;
                this.drawString(g, s, x - w / n, y2 + this.getFontHeight(g));
                val += Math.floor((double)w / maxWidth) * this.multiScaleData.xStep;
                val += this.multiScaleData.xStep;
            }
        }
    }

    private void drawYScale(Object g, int height, int width) {
        String hashY = "#";
        String hash1 = "0.00000000";
        if (this.multiScaleData.hashNums[1] <= 0) {
            hashY = hash1.substring(0, Math.abs(this.multiScaleData.hashNums[1]) + 3);
        }
        NumberFormat formatter = this.pd.getFormatter(hashY);
        this.pd.setFont(g, width, 0, 12, false);
        double max = this.multiScaleData.maxYOnScale + this.multiScaleData.yStep / 2.0;
        double val = this.multiScaleData.minYOnScale;
        while (val < max) {
            int x1 = this.xPixel0;
            int y = this.toPixelY(val * this.userYFactor);
            this.setColor(g, ScriptToken.GRIDCOLOR);
            this.drawLine(g, x1, y, x1 - 3, y);
            this.setColor(g, ScriptToken.SCALECOLOR);
            String s = formatter.format(val);
            this.drawString(g, s, x1 - 4 - this.getStringWidth(g, s), y + this.getFontHeight(g) / 3);
            val += this.multiScaleData.yStep;
        }
    }

    private void drawXUnits(Object g, int width) {
        String units = this.spectra.get(0).getAxisLabel(true);
        if (units != null) {
            this.drawUnits(g, width, units, this.xPixel1, this.yPixel1 + 5, 0.0, 1.0);
        }
    }

    private void drawUnits(Object g, int width, String s, int x, int y, double hOff, double vOff) {
        this.setColor(g, ScriptToken.UNITSCOLOR);
        this.pd.setFont(g, width, 2, 10, false);
        this.drawString(g, s, (int)((double)x - (double)this.getStringWidth(g, s) * hOff), (int)((double)y + (double)this.getFontHeight(g) * vOff));
    }

    private void drawYUnits(Object g, int width) {
        String units = this.spectra.get(0).getAxisLabel(false);
        if (units != null) {
            this.drawUnits(g, width, units, 5, this.yPixel0, 0.0, -1.0);
        }
    }

    void addHighlight(double x1, double x2, JDXSpectrum spec, Object oColor) {
        Highlight hl;
        if (spec == null) {
            spec = this.getSpectrumAt(0);
        }
        if (!this.highlights.contains(hl = new Highlight(x1, x2, spec, oColor == null ? this.pd.getHighlightColor() : oColor))) {
            this.highlights.add(hl);
        }
    }

    void removeHighlight(int index) {
        this.highlights.remove(index);
    }

    void removeHighlight(double x1, double x2) {
        int i = this.highlights.size();
        while (--i >= 0) {
            Highlight h = this.highlights.get(i);
            if (h.x1 != x1 || h.x2 != x2) continue;
            this.highlights.remove(i);
        }
    }

    void removeAllHighlights(JDXSpectrum spec) {
        if (spec == null) {
            this.highlights.clear();
        } else {
            int i = this.highlights.size();
            while (--i >= 0) {
                if (this.highlights.get((int)i).spectrum != spec) continue;
                this.highlights.remove(i);
            }
        }
    }

    void drawHighlights(Object g, JDXSpectrum spec) {
        int i = 0;
        while (i < this.highlights.size()) {
            Highlight hl = this.highlights.get(i);
            if (hl.spectrum == spec) {
                this.pd.setHighlightColor(hl.color);
                this.drawBar(g, hl.x1, hl.x2, ScriptToken.HIGHLIGHTCOLOR, true);
            }
            ++i;
        }
    }

    private void drawAnnotations(Object g, int height, int width, ArrayList<Annotation> annotations, ScriptToken whatColor) {
        this.pd.setFont(g, width, 1, 12, false);
        int i = annotations.size();
        while (--i >= 0) {
            int x;
            Annotation note = annotations.get(i);
            this.setAnnotationColor(g, note, whatColor);
            int n = x = note.is2D ? this.isd.toPixelX(note.getXVal()) : this.toPixelX(note.getXVal());
            int y = note.isPixels() ? (int)((double)(this.yPixel0 + 10) - note.getYVal()) : (note.is2D ? this.isd.toPixelY((int)note.getYVal()) : this.toPixelY(note.getYVal()));
            this.drawString(g, note.getText(), x + note.offsetX, y - note.offsetY);
        }
    }

    PlotWidget getPinSelected(int xPixel, int yPixel) {
        if (this.widgets != null) {
            int i = 0;
            while (i < this.widgets.length) {
                if (this.widgets[i] != null && this.widgets[i].isPinOrCursor && this.widgets[i].selected(xPixel, yPixel)) {
                    return this.widgets[i];
                }
                ++i;
            }
        }
        return null;
    }

    private void set2DCrossHairs(int xPixel, int yPixel) {
        if (xPixel == this.isd.fixX(xPixel) && yPixel == this.fixY(yPixel)) {
            this.pin1Dx1.setX(this.isd.toX(xPixel), this.toPixelX(this.isd.toX(xPixel)));
            this.cur2Dx1.setX(this.isd.toX(xPixel), xPixel);
            this.setCurrentSubSpectrum(this.isd.toSubspectrumIndex(yPixel));
        }
    }

    private void reset2D(boolean isX) {
        if (isX) {
            this.isd.setView0(this.isd.xPixel0, this.pin2Dy0.yPixel0, this.isd.xPixel1, this.pin2Dy1.yPixel0);
            this.doZoom(this.isd.minX, this.multiScaleData.minY, this.isd.maxX, this.multiScaleData.maxY, true, true, false);
        } else {
            this.isd.setView0(this.pin2Dx0.xPixel0, this.isd.yPixel0, this.pin2Dx1.xPixel0, this.isd.yPixel1);
            this.pd.repaint();
        }
    }

    private boolean setAnnotationText(Annotation a) {
        String sval = this.getInput("New text?", "Set Label", a.getText());
        if (sval == null) {
            return false;
        }
        if (sval.length() == 0) {
            this.annotations.remove(a);
        } else {
            a.setText(sval);
        }
        return true;
    }

    private void clearIntegrals() {
        this.checkIntegral(Double.NaN, 0.0, false);
        this.pd.repaint();
    }

    private void checkIntegral(double x1, double x2, boolean isFinal) {
        IntegralGraph ig = this.getSpectrum().getIntegrationGraph();
        if (ig == null) {
            return;
        }
        ig.addIntegral(x1, x2, isFinal);
    }

    private void setToolTipForPixels(int xPixel, int yPixel) {
        String hashX = "#";
        String hash1 = "0.00000000";
        if (this.multiScaleData.hashNums[0] <= 0) {
            hashX = hash1.substring(0, Math.abs(this.multiScaleData.hashNums[0]) + 3);
        }
        NumberFormat formatterX = this.pd.getFormatter(hashX);
        String hashY = "#";
        if (this.multiScaleData.hashNums[1] <= 0) {
            hashY = hash1.substring(0, Math.abs(this.multiScaleData.hashNums[1]) + 3);
        }
        NumberFormat formatterY = this.pd.getFormatter(hashY);
        PlotWidget pw = this.getPinSelected(xPixel, yPixel);
        if (pw != null) {
            String s;
            if (this.setStartupPinTip()) {
                return;
            }
            if (pw == this.pin1Dx01 || pw == this.pin2Dx01) {
                s = String.valueOf(formatterX.format(Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()))) + " - " + formatterX.format(Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()));
            } else if (pw == this.pin1Dy01) {
                s = String.valueOf(formatterY.format(Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()))) + " - " + formatterX.format(Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()));
            } else if (pw == this.cur2Dy) {
                int isub = this.isd.toSubspectrumIndex(pw.yPixel0);
                s = this.get2DYLabel(isub, formatterX);
            } else {
                s = pw == this.pin2Dy01 ? (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : (pw.isXtype ? formatterX.format(pw.getXVal()) : (pw.is2D ? "" + (int)pw.getYVal() : formatterY.format(pw.getYVal())));
            }
            this.pd.setToolTipText(s);
            return;
        }
        if (this.isd != null && this.isd.fixX(xPixel) == xPixel && this.fixY(yPixel) == yPixel) {
            int isub = this.isd.toSubspectrumIndex(yPixel);
            String s = String.valueOf(formatterX.format(this.isd.toX(xPixel))) + " " + this.getSpectrum().getAxisLabel(true) + ",  " + this.get2DYLabel(isub, formatterX);
            this.pd.setToolTipText(this.pd.display1D ? s : "");
            this.pd.coordStr = s;
            return;
        }
        if (this.isd != null && !this.pd.display1D) {
            this.pd.setToolTipText("");
            this.pd.coordStr = "";
            return;
        }
        double xPt = this.toX(this.fixX(xPixel));
        String xx = formatterX.format(xPt);
        double yPt = this.isd != null && this.isd.isXWithinRange(xPixel) ? (double)this.isd.toSubspectrumIndex(this.fixY(yPixel)) : this.toY(this.fixY(yPixel));
        formatterY = this.pd.getFormatter(hashY);
        this.pd.coordStr = "(" + xx + ", " + formatterY.format(yPt) + ")";
        if (xPixel != this.fixX(xPixel) || yPixel != this.fixY(yPixel)) {
            yPt = Double.NaN;
        } else if (this.nSpectra != 1 && this.getSpectrum().hasIntegral()) {
            yPt = this.getSpectrum().getIntegrationGraph().getPercentYValueAt(xPt);
            xx = String.valueOf(xx) + ", " + this.pd.getFormatter("#0.0").format(yPt);
        }
        this.pd.setToolTipText(Double.isNaN(yPt) ? null : xx);
    }

    private boolean setStartupPinTip() {
        if (this.pd.startupPinTip == null) {
            return false;
        }
        this.pd.setToolTipText(this.pd.startupPinTip);
        this.pd.startupPinTip = null;
        return true;
    }

    private String get2DYLabel(int isub, NumberFormat formatterX) {
        JDXSpectrum spec = this.getSpectrumAt(0).getSubSpectra().get(isub);
        return String.valueOf(formatterX.format(spec.getY2D())) + (spec.y2DUnits.equals("HZ") ? " HZ (" + formatterX.format(spec.getY2DPPM()) + " PPM)" : "");
    }

    void advanceSubSpectrum(int dir) {
        JDXSpectrum spec0 = this.getSpectrumAt(0);
        int i = spec0.advanceSubSpectrum(dir);
        if (spec0.isForcedSubset()) {
            this.multiScaleData.setXRange(this.getSpectrum());
        }
        this.pd.notifySubSpectrumChange(i, this.getSpectrum());
    }

    String getSolutionColor() {
        JDXSpectrum spectrum = this.getSpectrum();
        return spectrum.canShowSolutionColor() ? Visible.Colour(spectrum.getXYCoords(), spectrum.getYUnits()) : "255,255,255";
    }

    static boolean getPickedCoordinates(Coordinate[] coordsClicked, Coordinate coordClicked, Coordinate coord, Coordinate actualCoord) {
        if (coordClicked == null) {
            return false;
        }
        double x = coordClicked.getXVal();
        coord.setXVal(x);
        coord.setYVal(coordClicked.getYVal());
        if (actualCoord == null) {
            return true;
        }
        int pt = Coordinate.getNearestIndexForX(coordsClicked, x);
        actualCoord.setXVal(coordsClicked[pt].getXVal());
        actualCoord.setYVal(coordsClicked[pt].getYVal());
        return true;
    }

    static PeakInfo selectPeakByFileIndex(List<GraphSet> graphSets, String fileName, String index) {
        int i = graphSets.size();
        while (--i >= 0) {
            PeakInfo pi = graphSets.get(i).selectPeakByFileIndex(fileName, index);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    public boolean hasFileLoaded(String filePath) {
        int i = this.spectra.size();
        while (--i >= 0) {
            if (!this.spectra.get(i).getFilePathForwardSlash().equals(filePath)) continue;
            return true;
        }
        return false;
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        PeakInfo pi2 = null;
        int i = 0;
        while (i < this.spectra.size()) {
            if (this.spectra.get(i) instanceof JDXSpectrum && (pi2 = this.spectra.get(i).findMatchingPeakInfo(pi)) != null) break;
            ++i;
        }
        return pi2;
    }

    private class Highlight {
        double x1;
        double x2;
        Object color;
        JDXSpectrum spectrum;

        public String toString() {
            return "highlight " + this.x1 + " " + this.x2 + " " + this.spectrum;
        }

        Highlight(double x1, double x2, JDXSpectrum spec, Object color) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
            this.spectrum = spec;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Highlight)) {
                return false;
            }
            Highlight hl = (Highlight)obj;
            return hl.x1 == this.x1 && hl.x2 == this.x2;
        }
    }
}

