/*
 * Decompiled with CFR 0.152.
 */
package jspecview.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jspecview.applet.JSVApplet;
import jspecview.applet.JSVAppletPopupMenu;
import jspecview.application.TextDialog;
import jspecview.common.Annotation;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.Coordinate;
import jspecview.common.IntegralGraph;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVAppletInterface;
import jspecview.common.JSVContainer;
import jspecview.common.JSVDialog;
import jspecview.common.JSVDropTargetListener;
import jspecview.common.JSVPanel;
import jspecview.common.JSVSpecNode;
import jspecview.common.JSViewer;
import jspecview.common.OverlayLegendDialog;
import jspecview.common.PanelData;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.PrintLayoutDialog;
import jspecview.common.ScriptCommandTokenizer;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.exception.JSpecViewException;
import jspecview.export.Exporter;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.Escape;
import jspecview.util.FileManager;
import jspecview.util.Logger;
import jspecview.util.Parser;
import jspecview.util.TextFormat;
import netscape.javascript.JSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVAppletPrivate
implements PanelListener,
ScriptInterface,
JSVAppletInterface {
    protected JSVApplet jsvApplet;
    int nOverlays;
    private JSVPanel prevPanel;
    private ArrayList<Annotation> integrationRatios;
    private int startIndex = -1;
    private int endIndex = -1;
    private int spectrumNumber = -1;
    private int irMode = 0;
    private boolean autoIntegrate;
    private String coordCallbackFunctionName;
    private String peakCallbackFunctionName;
    private String syncCallbackFunctionName;
    private String appletReadyCallbackFunctionName;
    private AwtParameters parameters = new AwtParameters("applet");
    boolean isStandalone;
    private String appletID;
    private String syncID;
    private Thread commandWatcherThread;
    private Boolean obscureTitleFromUser;
    private JFileChooser jFileChooser;
    private JFrame offWindowFrame;
    private JSVAppletPanel appletPanel;
    private JSVAppletPopupMenu appletPopupMenu;
    private List<JSVSpecNode> specNodes;
    private List<JSVSpecNode> specNodesSaved;
    private int currentSpectrumIndex;
    private String recentFileName = "";
    private JSVPanel selectedPanel;
    private JDXSource currentSource;
    private DropTargetListener dtl;
    private ActionListener compoundMenuChooseListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JSVAppletPrivate.this.resetSaved();
            StringBuffer msgStrBuffer = new StringBuffer();
            msgStrBuffer.append("Choose a number between 1 and ");
            msgStrBuffer.append(JSVAppletPrivate.this.specNodes.size());
            msgStrBuffer.append(" to display another spectrum");
            String str = JOptionPane.showInputDialog(JSVAppletPrivate.this.jsvApplet, msgStrBuffer.toString(), "Spectrum Chooser", -1);
            if (str != null) {
                int index = 0;
                try {
                    index = Integer.parseInt(str) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (index > 0 && index < JSVAppletPrivate.this.specNodes.size()) {
                    JSVAppletPrivate.this.showSpectrum(index);
                    JSVAppletPrivate.this.writeStatus(" ");
                } else {
                    JSVAppletPrivate.this.writeStatus("Invalid Spectrum Number");
                }
            }
        }
    };
    private ActionListener compoundMenuSelectionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JSVAppletPrivate.this.compoundMenu_itemStateChanged(e);
        }
    };
    private String fullName;
    private boolean allowMenu = true;
    private boolean compoundMenuOn;
    private boolean allowCompoundMenu = true;
    private String dirLastExported;
    private boolean interfaceOverlaid;
    private List<String> scriptQueue;

    JSVApplet getJsvApplet() {
        return this.jsvApplet;
    }

    JSVAppletPrivate(JSVApplet jsvApplet) {
        this.jsvApplet = jsvApplet;
        this.init();
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isPro() {
        return this.isSigned();
    }

    JDXSource getSource() {
        return this.currentSource;
    }

    void dispose() {
        this.jFileChooser = null;
        try {
            int i;
            if (this.commandWatcherThread != null) {
                this.commandWatcherThread.interrupt();
                this.commandWatcherThread = null;
            }
            if (this.specNodes != null) {
                i = this.specNodes.size();
                while (--i >= 0) {
                    this.specNodes.get(i).dispose();
                    this.specNodes.remove(i);
                }
            }
            if (this.specNodesSaved != null) {
                i = this.specNodesSaved.size();
                while (--i >= 0) {
                    this.specNodesSaved.get(i).dispose();
                    this.specNodesSaved.remove(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return JSViewer.getPropertyAsJavaObject(this, key);
    }

    @Override
    public String getPropertyAsJSON(String key) {
        Map<String, Object> map = this.getPropertyAsJavaObject(key);
        return Escape.toJSON(null, map);
    }

    @Override
    public String getCoordinate() {
        return JSViewer.getCoordinate(this);
    }

    @Override
    public void loadInline(String data) {
        this.newAppletPanel();
        this.openDataOrFile(data, null, null, null);
        this.jsvApplet.getContentPane().validate();
        this.appletPanel.validate();
    }

    @Override
    public String export(String type, int n) {
        return ((AwtPanel)this.getSelectedPanel()).export(type, n);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.runScript("load " + Escape.escape(tmpFilePath));
    }

    @Override
    public void setSpectrumNumber(int n) {
        this.runScript((Object)((Object)ScriptToken.SPECTRUMNUMBER) + " " + n);
    }

    @Override
    public void reversePlot() {
        this.toggle(ScriptToken.REVERSEPLOT);
    }

    @Override
    public void toggleGrid() {
        this.toggle(ScriptToken.GRIDON);
    }

    @Override
    public void toggleCoordinate() {
        this.toggle(ScriptToken.COORDINATESON);
    }

    @Override
    public void toggleIntegration() {
        this.toggle(ScriptToken.INTEGRATE);
    }

    private void toggle(ScriptToken st) {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp != null) {
            this.runScript((Object)((Object)st) + " TOGGLE");
        }
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        JSViewer.addHighLight(this, x1, x2, r, g, b, a);
    }

    @Override
    public void removeAllHighlights() {
        JSViewer.removeAllHighlights(this);
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        JSViewer.removeHighlights(this, x1, x2);
    }

    @Override
    public void syncScript(String peakScript) {
        JSViewer.syncScript(this, peakScript);
    }

    @Override
    public void writeStatus(String msg) {
        Logger.info(msg);
    }

    private void init() {
        this.scriptQueue = new ArrayList<String>();
        this.commandWatcherThread = new Thread(new CommandWatcher());
        this.commandWatcherThread.setName("CommmandWatcherThread");
        this.commandWatcherThread.start();
        this.initParams(this.jsvApplet.getParameter("script"));
        if (this.appletReadyCallbackFunctionName != null && this.fullName != null) {
            this.callToJavaScript(this.appletReadyCallbackFunctionName, new Object[]{this.appletID, this.fullName, Boolean.TRUE});
        }
        if (this.isSigned()) {
            new DropTarget(this.jsvApplet, this.getDropListener());
        }
    }

    private DropTargetListener getDropListener() {
        if (this.dtl == null) {
            this.dtl = new JSVDropTargetListener(this, false);
        }
        return this.dtl;
    }

    void initParams(String params) {
        this.parseInitScript(params);
        this.newAppletPanel();
        this.appletPopupMenu = new JSVAppletPopupMenu(this, this.allowMenu, this.parameters.getBoolean(ScriptToken.ENABLEZOOM));
        this.runScriptNow(params);
    }

    private void newAppletPanel() {
        this.jsvApplet.getContentPane().removeAll();
        this.appletPanel = new JSVAppletPanel(new BorderLayout());
        this.jsvApplet.getContentPane().add(this.appletPanel);
    }

    private void compoundMenu_itemStateChanged(ActionEvent e) {
        String txt = ((JMenuItem)e.getSource()).getText();
        this.resetSaved();
        this.showSpectrum(Parser.parseInt(txt) - 1);
    }

    private void showSpectrum(int index) {
        JSVPanel jsvp = this.specNodes.get((int)index).jsvp;
        if (jsvp != this.getSelectedPanel()) {
            this.setSelectedPanel(jsvp);
        }
        System.out.println("showSpectrum sending frame change..." + index);
        this.sendFrameChange(jsvp);
    }

    @Override
    public void sendFrameChange(JSVPanel jsvp) {
        if (jsvp == this.prevPanel) {
            return;
        }
        this.prevPanel = jsvp;
        JSViewer.sendFrameChange(this, jsvp);
    }

    protected void showOverlayKey(boolean visible) {
        JSViewer.setOverlayLegendVisibility(this, this.getSelectedPanel(), visible);
    }

    void showHeader() {
        JDXSpectrum spectrum = this.getSelectedPanel().getSpectrum();
        Object[][] rowData = spectrum.getHeaderRowDataAsArray();
        Object[] columnNames = new String[]{"Label", "Description"};
        JTable table = new JTable(rowData, columnNames);
        table.setPreferredScrollableViewportSize(new Dimension(400, 195));
        JScrollPane scrollPane = new JScrollPane(table);
        JOptionPane.showMessageDialog(this.jsvApplet, scrollPane, "Header Information", -1);
    }

    void print() {
        if (this.offWindowFrame == null) {
            System.err.println("Use the View/Window menu to lift the spectrum off the page first.");
            return;
        }
        JSVPanel jsvp = this.getSelectedPanel();
        PrintLayoutDialog ppd = new PrintLayoutDialog(this.offWindowFrame);
        PrintLayoutDialog.PrintLayout pl = ppd.getPrintLayout();
        if (pl != null) {
            ((AwtPanel)jsvp).printSpectrum(pl);
        }
    }

    void newWindow(boolean isSelected) {
        if (isSelected) {
            this.offWindowFrame = new JFrame("JSpecView");
            this.offWindowFrame.setSize(this.jsvApplet.getSize());
            final Dimension d = this.appletPanel.getSize();
            this.offWindowFrame.add(this.appletPanel);
            this.offWindowFrame.validate();
            this.offWindowFrame.setVisible(true);
            this.jsvApplet.remove(this.appletPanel);
            this.jsvApplet.validate();
            this.jsvApplet.repaint();
            this.offWindowFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JSVAppletPrivate.this.appletPanel.setSize(d);
                    JSVAppletPrivate.this.jsvApplet.getContentPane().add(JSVAppletPrivate.this.appletPanel);
                    JSVAppletPrivate.this.jsvApplet.setVisible(true);
                    JSVAppletPrivate.this.jsvApplet.validate();
                    JSVAppletPrivate.this.jsvApplet.repaint();
                    JSVAppletPrivate.this.offWindowFrame.removeAll();
                    JSVAppletPrivate.this.offWindowFrame.dispose();
                    ((JSVAppletPrivate)JSVAppletPrivate.this).appletPopupMenu.windowMenuItem.setSelected(false);
                }
            });
        } else {
            this.jsvApplet.getContentPane().add(this.appletPanel);
            this.jsvApplet.validate();
            this.jsvApplet.repaint();
            this.offWindowFrame.removeAll();
            this.offWindowFrame.dispose();
        }
    }

    void exportSpectrumViaMenu(String type) {
        if (this.isSigned()) {
            this.dirLastExported = Exporter.exportSpectra(this.getSelectedPanel(), this.offWindowFrame, this.jFileChooser, type, this.recentFileName, this.dirLastExported);
        } else {
            Logger.info(this.export(type, -1));
        }
    }

    @Override
    public void syncLoad(String filePath) {
        this.newAppletPanel();
        this.openDataOrFile(null, null, null, filePath);
        this.jsvApplet.getContentPane().validate();
        this.appletPanel.validate();
    }

    private void callToJavaScript(String function, Object[] params) {
        try {
            JSObject.getWindow((Applet)this.jsvApplet).call(function, params);
        }
        catch (Exception npe) {
            Logger.warn("EXCEPTION-> " + npe.getMessage());
        }
    }

    private void parseInitScript(String params) {
        if (params == null) {
            params = "";
        }
        ScriptCommandTokenizer allParamTokens = new ScriptCommandTokenizer(params, ";\n");
        if (Logger.debugging) {
            Logger.info("Running in DEBUG mode");
        }
        block18: while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            StringTokenizer eachParam = new StringTokenizer(token);
            String key = eachParam.nextToken();
            if (key.equalsIgnoreCase("SET")) {
                key = eachParam.nextToken();
            }
            key = key.toUpperCase();
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            if (Logger.debugging) {
                Logger.info("KEY-> " + key + " VALUE-> " + value + " : " + (Object)((Object)st));
            }
            try {
                switch (st) {
                    default: {
                        this.parameters.set(null, st, value);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case VERSION: {
                        break;
                    }
                    case OBSCURE: {
                        if (this.obscureTitleFromUser != null) continue block18;
                        this.obscureTitleFromUser = Boolean.valueOf(value);
                        break;
                    }
                    case SYNCID: {
                        this.syncID = value;
                        this.fullName = String.valueOf(this.appletID) + "__" + this.syncID + "__";
                        break;
                    }
                    case APPLETID: {
                        this.appletID = value;
                        this.fullName = String.valueOf(this.appletID) + "__" + this.syncID + "__";
                        break;
                    }
                    case APPLETREADYCALLBACKFUNCTIONNAME: {
                        this.appletReadyCallbackFunctionName = value;
                        break;
                    }
                    case MENUON: {
                        this.allowMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case COMPOUNDMENUON: {
                        this.allowCompoundMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case INTERFACE: {
                        if (!value.equalsIgnoreCase("single") && !value.equalsIgnoreCase("overlay")) continue block18;
                        this.interfaceOverlaid = value.equalsIgnoreCase("overlay");
                        break;
                    }
                    case ENDINDEX: {
                        this.endIndex = Integer.parseInt(value);
                        break;
                    }
                    case STARTINDEX: {
                        this.startIndex = Integer.parseInt(value);
                        break;
                    }
                    case SPECTRUMNUMBER: {
                        this.spectrumNumber = Integer.parseInt(value);
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = AwtParameters.isTrue(value);
                        break;
                    }
                    case IRMODE: {
                        this.irMode = value.toUpperCase().startsWith("T") ? 2 : 1;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void openDataOrFile(String data, String name, List<JDXSpectrum> specs, String filePath) {
        this.appletPanel.removeAll();
        String fileName = null;
        URL base = null;
        boolean isOverlay = false;
        if (specs != null) {
            fileName = "Overlay" + ++this.nOverlays;
            isOverlay = true;
        } else if (data == null) {
            if (filePath != null) {
                try {
                    URL url = new URL(this.jsvApplet.getCodeBase(), filePath);
                    fileName = url.toString();
                    this.recentFileName = url.getFile();
                    base = this.jsvApplet.getDocumentBase();
                }
                catch (MalformedURLException e) {
                    Logger.warn("problem: " + e.getMessage());
                    fileName = filePath;
                }
            } else {
                this.writeStatus("Please set the 'filepath' or 'load file' parameter");
                return;
            }
        }
        try {
            this.currentSource = isOverlay ? JDXSource.createOverlay(fileName, specs) : FileReader.createJDXSource(FileManager.getBufferedReaderForString(data), fileName, base, this.obscureTitleFromUser == Boolean.TRUE, -1, -1);
            this.currentSource.setFilePath(fileName);
        }
        catch (Exception e) {
            this.writeStatus(e.getMessage());
            e.printStackTrace();
            return;
        }
        specs = this.currentSource.getSpectra();
        JDXSpectrum.process(specs, this.irMode, this.autoIntegrate, this.parameters);
        boolean isOverlaid = isOverlay && !name.equals("NONE");
        this.compoundMenuOn = this.allowCompoundMenu && this.currentSource.isCompoundSource;
        try {
            this.initPanels(specs, isOverlaid);
        }
        catch (JSpecViewException e1) {
            this.writeStatus(e1.getMessage());
            return;
        }
        this.initInterface(isOverlaid);
        Logger.info(String.valueOf(this.jsvApplet.getAppletInfo()) + " File " + fileName + " Loaded Successfully");
        if (!isOverlaid && (this.interfaceOverlaid || specs.get(0).isAutoOverlayFromJmolClick() && this.startIndex == this.endIndex)) {
            this.execOverlay("*");
        }
    }

    private void initPanels(List<JDXSpectrum> specs, boolean isOverlay) throws JSpecViewException {
        this.specNodes = new ArrayList<JSVSpecNode>();
        if (isOverlay) {
            AwtPanel jsvp = AwtPanel.getJSVPanel(specs, this.startIndex, this.endIndex, this.appletPopupMenu);
            this.startIndex = -1;
            this.endIndex = -1;
            this.initProperties(jsvp);
            this.specNodes.add(new JSVSpecNode("specs", this.currentSource.getFilePath(), this.currentSource, this.appletPanel, jsvp));
        } else {
            try {
                int i = 0;
                while (i < specs.size()) {
                    JDXSpectrum spec = specs.get(i);
                    ArrayList<JDXSpectrum> list = new ArrayList<JDXSpectrum>();
                    list.add(spec);
                    AwtPanel jsvp = AwtPanel.getJSVPanel(list, this.startIndex, this.endIndex, this.appletPopupMenu);
                    this.specNodes.add(new JSVSpecNode("" + (i + 1), this.currentSource.getFilePath(), this.currentSource, this.appletPanel, jsvp));
                    this.initProperties(jsvp);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setSelectedPanel(this.specNodes.get((int)0).jsvp);
    }

    private void initProperties(JSVPanel jsvp) {
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, null, true);
    }

    private void initInterface(boolean isOverlaid) {
        int spectrumIndex;
        int numberOfPanels = this.specNodes.size();
        if (numberOfPanels == 0) {
            return;
        }
        boolean showSpectrumNumber = this.spectrumNumber != -1 && this.spectrumNumber <= numberOfPanels;
        int n = spectrumIndex = showSpectrumNumber ? this.spectrumNumber - 1 : 0;
        if (spectrumIndex >= this.specNodes.size()) {
            spectrumIndex = 0;
        }
        this.setSelectedPanel(this.specNodes.get((int)spectrumIndex).jsvp);
        if (isOverlaid && this.currentSource.isCompoundSource) {
            this.specNodes.get((int)spectrumIndex).jsvp.setTitle(this.currentSource.getTitle());
        }
        this.appletPanel.add((Component)((AwtPanel)this.specNodes.get((int)spectrumIndex).jsvp), "Center");
        this.appletPopupMenu.setCompoundMenu(this.currentSource, spectrumIndex, this.specNodesSaved == null ? this.specNodes : this.specNodesSaved, this.compoundMenuOn && this.currentSource.isCompoundSource, this.compoundMenuSelectionListener, this.compoundMenuChooseListener);
    }

    protected void processCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void runScriptNow(String params) {
        JSViewer.runScriptNow(this, params);
    }

    private void setSaved(boolean isOverlay) {
        if (isOverlay) {
            if (this.specNodesSaved == null) {
                this.specNodesSaved = this.specNodes;
            }
        } else {
            this.specNodesSaved = null;
        }
    }

    private void resetSaved() {
        if (this.specNodesSaved != null) {
            this.specNodes = this.specNodesSaved;
        }
    }

    private void checkCallbacks() {
        Coordinate actualCoord;
        if (this.coordCallbackFunctionName == null && this.peakCallbackFunctionName == null) {
            return;
        }
        Coordinate coord = new Coordinate();
        Coordinate coordinate = actualCoord = this.peakCallbackFunctionName == null ? null : new Coordinate();
        if (!this.getSelectedPanel().getPanelData().getPickedCoordinates(coord, actualCoord)) {
            return;
        }
        if (actualCoord == null) {
            this.callToJavaScript(this.coordCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), this.currentSpectrumIndex + 1});
        } else {
            this.callToJavaScript(this.peakCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), actualCoord.getXVal(), actualCoord.getYVal(), this.currentSpectrumIndex + 1});
        }
    }

    @Override
    public void setSelectedPanel(JSVPanel jsvp) {
        if (jsvp != this.selectedPanel) {
            if (this.selectedPanel != null) {
                this.appletPanel.remove((AwtPanel)this.selectedPanel);
                this.jsvApplet.removeKeyListener((AwtPanel)this.selectedPanel);
            }
            this.appletPanel.add((Component)((AwtPanel)jsvp), "Center");
            this.jsvApplet.addKeyListener((AwtPanel)jsvp);
            this.selectedPanel = jsvp;
            this.appletPanel.validate();
        }
        int i = this.specNodes.size();
        while (--i >= 0) {
            if (this.specNodes.get((int)i).jsvp == jsvp) {
                this.currentSpectrumIndex = i;
                continue;
            }
            this.specNodes.get((int)i).jsvp.setEnabled(false);
        }
        jsvp.setEnabled(true);
    }

    void doAdvanced(String filePath) {
    }

    @Override
    public void panelEvent(Object eventObj) {
        if (eventObj instanceof PeakPickEvent) {
            JSViewer.processPeakPickEvent(this, eventObj, false);
        } else if (!(eventObj instanceof ZoomEvent)) {
            boolean cfr_ignored_0 = eventObj instanceof SubSpecChangeEvent;
        }
    }

    @Override
    public JSVPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    @Override
    public void runScript(String script) {
        if (this.scriptQueue == null) {
            this.processCommand(script);
        } else {
            this.scriptQueue.add(script);
        }
    }

    @Override
    public String execExport(JSVPanel jsvp, String value) {
        if (jsvp != null && this.isPro()) {
            this.writeStatus(Exporter.exportCmd(jsvp, ScriptToken.getTokens(value), false));
        }
        return null;
    }

    @Override
    public JDXSource getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public List<JSVSpecNode> getSpecNodes() {
        return this.specNodes;
    }

    @Override
    public void execSetIntegrationRatios(String value) {
        this.integrationRatios = IntegralGraph.getIntegrationRatiosFromString(value);
    }

    @Override
    public void execIntegrate(JDXSpectrum spec) {
        if (spec.hasIntegral() && this.integrationRatios != null) {
            spec.setIntegrationRatios(this.integrationRatios);
        }
        this.integrationRatios = null;
    }

    @Override
    public void execTAConvert(int comm) {
    }

    @Override
    public void execSetCallback(ScriptToken st, String value) {
        switch (st) {
            case PEAKCALLBACKFUNCTIONNAME: {
                this.peakCallbackFunctionName = value;
                break;
            }
            case SYNCCALLBACKFUNCTIONNAME: {
                this.syncCallbackFunctionName = value;
                break;
            }
            case COORDCALLBACKFUNCTIONNAME: {
                this.coordCallbackFunctionName = value;
            }
        }
    }

    @Override
    public String getSolnColour() {
        return this.getSelectedPanel().getPanelData().getSolutionColor();
    }

    @Override
    public String setSolutionColor(boolean showMessage) {
        if (showMessage) {
            String msg = this.getSelectedPanel().getPanelData().getSolutionColorHtml();
            JOptionPane.showMessageDialog(this.jsvApplet, msg, "Predicted Colour", 1);
        }
        return this.getSelectedPanel().getPanelData().getSolutionColor();
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void execClose(String value) {
        this.setSaved(false);
    }

    @Override
    public String execLoad(String value) {
        this.setSaved(false);
        this.openDataOrFile(null, null, null, TextFormat.trimQuotes(value));
        this.setSpectrumIndex(0);
        return null;
    }

    @Override
    public void execHidden(boolean b) {
    }

    @Override
    public void execSetInterface(String value) {
        this.interfaceOverlaid = value.equalsIgnoreCase("overlay");
    }

    @Override
    public void execScriptComplete(String msg, boolean isOK) {
        this.jsvApplet.repaint();
    }

    @Override
    public JSVPanel execSetSpectrum(String value) {
        return this.setSpectrumIndex(Parser.parseInt(value) - 1);
    }

    @Override
    public void execSetAutoIntegrate(boolean b) {
        this.autoIntegrate = b;
    }

    @Override
    public void execTest(String value) {
    }

    @Override
    public PanelData getPanelData() {
        return this.getSelectedPanel().getPanelData();
    }

    @Override
    public JSVDialog getOverlayLegend(JSVPanel jsvp) {
        return new OverlayLegendDialog(null, this.getSelectedPanel());
    }

    @Override
    public JSVPanel setSpectrumIndex(int i) {
        if (i < 0 || i > this.specNodes.size()) {
            return null;
        }
        if (this.getSelectedPanel() != null) {
            this.showSpectrum(i);
            this.appletPanel.validate();
            this.jsvApplet.repaint();
        }
        return this.getSelectedPanel();
    }

    @Override
    public void execOverlay(String value) {
        this.setSaved(true);
        ArrayList<JDXSpectrum> list = new ArrayList<JDXSpectrum>();
        String s = JSVSpecNode.fillSpecList(this.specNodesSaved, value, list, null, "");
        if (list.size() > 1) {
            this.openDataOrFile(null, s, list, null);
            this.setSpectrumIndex(0);
        }
    }

    @Override
    public boolean syncToJmol(String msg) {
        if (this.syncCallbackFunctionName == null) {
            return false;
        }
        System.out.println("JSV>Jmol " + msg);
        this.callToJavaScript(this.syncCallbackFunctionName, new Object[]{this.fullName, msg});
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        this.appletPanel.setVisible(b);
    }

    @Override
    public void setFrame(JSVSpecNode node) {
        this.setSpectrumIndex(JSVSpecNode.getNodeIndex(this.specNodes, node));
    }

    @Override
    public void showProperties() {
        TextDialog.showProperties(this.jsvApplet, this.getPanelData().getSpectrum());
    }

    @Override
    public void updateBoolean(ScriptToken st, boolean TF) {
    }

    @Override
    public void checkCallbacks(String title) {
        this.checkCallbacks();
    }

    static /* synthetic */ Thread access$4(JSVAppletPrivate jSVAppletPrivate) {
        return jSVAppletPrivate.commandWatcherThread;
    }

    static /* synthetic */ List access$5(JSVAppletPrivate jSVAppletPrivate) {
        return jSVAppletPrivate.scriptQueue;
    }

    static /* synthetic */ void access$6(JSVAppletPrivate jSVAppletPrivate, Thread thread) {
        jSVAppletPrivate.commandWatcherThread = thread;
    }

    private class CommandWatcher
    implements Runnable {
        private CommandWatcher() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            Thread.currentThread().setPriority(1);
            commandDelay = 200;
            while (JSVAppletPrivate.access$4(JSVAppletPrivate.this) != null) {
                try {
                    Thread.sleep(commandDelay);
                    if (JSVAppletPrivate.access$4(JSVAppletPrivate.this) == null || JSVAppletPrivate.access$5(JSVAppletPrivate.this).size() <= 0 || (scriptItem = (String)JSVAppletPrivate.access$5(JSVAppletPrivate.this).remove(0)) == null) continue;
                    JSVAppletPrivate.this.processCommand(scriptItem);
                    continue;
                }
                catch (InterruptedException ie) {
                    Logger.info("CommandWatcher InterruptedException!");
                    break;
                }
                catch (Exception ie) {
                    s = "script processing ERROR:\n\n" + ie.toString();
                    i = 0;
                    ** while (i < ie.getStackTrace().length)
                }
lbl-1000:
                // 1 sources

                {
                    s = String.valueOf(s) + "\n" + ie.getStackTrace()[i].toString();
                    ++i;
                    continue;
                }
lbl19:
                // 1 sources

                Logger.info("CommandWatcher Exception! " + s);
                break;
            }
            JSVAppletPrivate.access$6(JSVAppletPrivate.this, null);
        }
    }

    private class JSVAppletPanel
    extends JPanel
    implements JSVContainer {
        private static final long serialVersionUID = 1L;

        private JSVAppletPanel(BorderLayout borderLayout) {
            super(borderLayout);
        }

        public void dispose() {
        }

        public String getTitle() {
            return null;
        }

        public void setTitle(String title) {
        }
    }
}

