/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class Quaternion {
    public float q0;
    public float q1;
    public float q2;
    public float q3;
    private Matrix3f mat;
    private static final Point4f qZero = new Point4f();

    public Quaternion() {
        this.q0 = 1.0f;
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(Tuple3f tuple3f, float f) {
        this.set(tuple3f, f);
    }

    public Quaternion(Matrix3f matrix3f) {
        this.set(matrix3f);
    }

    public Quaternion(AxisAngle4f axisAngle4f) {
        this.set(axisAngle4f);
    }

    public Quaternion(Point4f point4f) {
        this.set(point4f);
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        if (f < -1.0f) {
            this.q0 = -1.0f;
            return;
        }
        if (f > 1.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = f;
        this.q1 = f2;
        this.q2 = f3;
        this.q3 = f4;
    }

    public void set(Quaternion quaternion) {
        this.q0 = quaternion.q0;
        this.q1 = quaternion.q1;
        this.q2 = quaternion.q2;
        this.q3 = quaternion.q3;
    }

    private void set(Point4f point4f) {
        float f;
        float f2 = f = point4f == null ? 0.0f : point4f.distance(qZero);
        if (f == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = point4f.w / f;
        this.q1 = point4f.x / f;
        this.q2 = point4f.y / f;
        this.q3 = point4f.z / f;
    }

    public void set(Tuple3f tuple3f, float f) {
        if (tuple3f.x == 0.0f && tuple3f.y == 0.0f && tuple3f.z == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        double d = Math.sin((double)(f / 2.0f) * Math.PI / 180.0) / Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
        this.q0 = (float)Math.cos((double)(f / 2.0f) * Math.PI / 180.0);
        this.q1 = (float)((double)tuple3f.x * d);
        this.q2 = (float)((double)tuple3f.y * d);
        this.q3 = (float)((double)tuple3f.z * d);
    }

    public void set(AxisAngle4f axisAngle4f) {
        AxisAngle4f axisAngle4f2 = new AxisAngle4f(axisAngle4f);
        if (axisAngle4f2.angle == 0.0f) {
            axisAngle4f2.y = 1.0f;
        }
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.set(axisAngle4f2);
        this.set(matrix3f);
    }

    public void set(Matrix3f matrix3f) {
        double d;
        double d2;
        double d3;
        double d4;
        this.mat = matrix3f;
        double d5 = matrix3f.m00 + matrix3f.m11 + matrix3f.m22;
        if (d5 >= 0.5) {
            d4 = Math.sqrt(1.0 + d5);
            d3 = (double)(matrix3f.m21 - matrix3f.m12) / d4;
            d2 = (double)(matrix3f.m02 - matrix3f.m20) / d4;
            d = (double)(matrix3f.m10 - matrix3f.m01) / d4;
        } else {
            double d6;
            double d7 = (double)(matrix3f.m00 + matrix3f.m00) - d5;
            if (d6 >= 0.5) {
                d3 = Math.sqrt(1.0 + d7);
                d4 = (double)(matrix3f.m21 - matrix3f.m12) / d3;
                d2 = (double)(matrix3f.m10 + matrix3f.m01) / d3;
                d = (double)(matrix3f.m20 + matrix3f.m02) / d3;
            } else {
                d7 = (double)(matrix3f.m11 + matrix3f.m11) - d5;
                if (d7 >= 0.5 || matrix3f.m11 > matrix3f.m22) {
                    d2 = Math.sqrt(1.0 + d7);
                    d4 = (double)(matrix3f.m02 - matrix3f.m20) / d2;
                    d3 = (double)(matrix3f.m10 + matrix3f.m01) / d2;
                    d = (double)(matrix3f.m21 + matrix3f.m12) / d2;
                } else {
                    d = Math.sqrt(1.0 + (double)matrix3f.m22 + (double)matrix3f.m22 - d5);
                    d4 = (double)(matrix3f.m10 - matrix3f.m01) / d;
                    d3 = (double)(matrix3f.m20 + matrix3f.m02) / d;
                    d2 = (double)(matrix3f.m21 + matrix3f.m12) / d;
                }
            }
        }
        this.q0 = (float)(d4 * 0.5);
        this.q1 = (float)(d3 * 0.5);
        this.q2 = (float)(d2 * 0.5);
        this.q3 = (float)(d * 0.5);
    }

    public void setRef(Quaternion quaternion) {
        if (quaternion == null) {
            this.mul(this.getFixFactor());
            return;
        }
        if (this.dot(quaternion) >= 0.0f) {
            return;
        }
        this.q0 *= -1.0f;
        this.q1 *= -1.0f;
        this.q2 *= -1.0f;
        this.q3 *= -1.0f;
    }

    public static final Quaternion getQuaternionFrame(Point3f point3f, Tuple3f tuple3f, Tuple3f tuple3f2) {
        Vector3f vector3f = new Vector3f(tuple3f);
        vector3f.sub(point3f);
        Vector3f vector3f2 = new Vector3f(tuple3f2);
        vector3f2.sub(point3f);
        return Quaternion.getQuaternionFrame(vector3f, vector3f2, null, false);
    }

    public static final Quaternion getQuaternionFrame(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, boolean bl) {
        if (vector3f3 == null) {
            vector3f3 = new Vector3f();
            vector3f3.cross(vector3f, vector3f2);
            if (bl) {
                vector3f.cross(vector3f2, vector3f3);
            }
        }
        Vector3f vector3f4 = new Vector3f();
        vector3f4.cross(vector3f3, vector3f);
        vector3f.normalize();
        vector3f4.normalize();
        vector3f3.normalize();
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.setColumn(0, vector3f);
        matrix3f.setColumn(1, vector3f4);
        matrix3f.setColumn(2, vector3f3);
        Quaternion quaternion = new Quaternion(matrix3f);
        return quaternion;
    }

    public Matrix3f getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new Matrix3f();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0f * this.q1 * this.q2 - 2.0f * this.q0 * this.q3;
        this.mat.m02 = 2.0f * this.q1 * this.q3 + 2.0f * this.q0 * this.q2;
        this.mat.m10 = 2.0f * this.q1 * this.q2 + 2.0f * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0f * this.q2 * this.q3 - 2.0f * this.q0 * this.q1;
        this.mat.m20 = 2.0f * this.q1 * this.q3 - 2.0f * this.q0 * this.q2;
        this.mat.m21 = 2.0f * this.q2 * this.q3 + 2.0f * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Quaternion add(float f) {
        return new Quaternion(this.getNormal(), this.getTheta() + f);
    }

    public Quaternion mul(float f) {
        return f == 1.0f ? new Quaternion(this.q0, this.q1, this.q2, this.q3) : new Quaternion(this.getNormal(), this.getTheta() * f);
    }

    public Quaternion mul(Quaternion quaternion) {
        return new Quaternion(this.q0 * quaternion.q0 - this.q1 * quaternion.q1 - this.q2 * quaternion.q2 - this.q3 * quaternion.q3, this.q0 * quaternion.q1 + this.q1 * quaternion.q0 + this.q2 * quaternion.q3 - this.q3 * quaternion.q2, this.q0 * quaternion.q2 + this.q2 * quaternion.q0 + this.q3 * quaternion.q1 - this.q1 * quaternion.q3, this.q0 * quaternion.q3 + this.q3 * quaternion.q0 + this.q1 * quaternion.q2 - this.q2 * quaternion.q1);
    }

    public Quaternion div(Quaternion quaternion) {
        return this.mul(quaternion.inv());
    }

    public Quaternion divLeft(Quaternion quaternion) {
        return this.inv().mul(quaternion);
    }

    public float dot(Quaternion quaternion) {
        return this.q0 * quaternion.q0 + this.q1 * quaternion.q1 + this.q2 * quaternion.q2 + this.q3 * quaternion.q3;
    }

    public Quaternion inv() {
        return new Quaternion(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public Quaternion negate() {
        return new Quaternion(-this.q0, -this.q1, -this.q2, -this.q3);
    }

    private float getFixFactor() {
        return this.q0 < 0.0f || this.q0 == 0.0f && (this.q1 < 0.0f || this.q1 == 0.0f && (this.q2 < 0.0f || this.q2 == 0.0f && this.q3 < 0.0f)) ? -1 : 1;
    }

    public Vector3f getVector(int n) {
        return this.getVector(n, 1.0f);
    }

    private Vector3f getVector(int n, float f) {
        if (n == -1) {
            return new Vector3f(this.q1 * (f *= this.getFixFactor()), this.q2 * f, this.q3 * f);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        Vector3f vector3f = new Vector3f();
        this.mat.getColumn(n, vector3f);
        if (f != 1.0f) {
            vector3f.scale(f);
        }
        return vector3f;
    }

    public Vector3f getNormal() {
        Vector3f vector3f = Quaternion.getRawNormal(this);
        vector3f.scale(this.getFixFactor());
        return vector3f;
    }

    private static Vector3f getRawNormal(Quaternion quaternion) {
        Vector3f vector3f = new Vector3f(quaternion.q1, quaternion.q2, quaternion.q3);
        if (vector3f.length() == 0.0f) {
            return new Vector3f(0.0f, 0.0f, 1.0f);
        }
        vector3f.normalize();
        return vector3f;
    }

    public float getTheta() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0 * 180.0 / Math.PI);
    }

    public float getThetaRadians() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0);
    }

    public Vector3f getNormalDirected(Vector3f vector3f) {
        Vector3f vector3f2 = this.getNormal();
        if (vector3f2.x * vector3f.x + vector3f2.y * vector3f.y + vector3f2.z * vector3f.z < 0.0f) {
            vector3f2.scale(-1.0f);
        }
        return vector3f2;
    }

    public Vector3f get3dProjection(Vector3f vector3f) {
        vector3f.set(this.q1, this.q2, this.q3);
        return vector3f;
    }

    public Point4f getThetaDirected(Point4f point4f) {
        float f = this.getTheta();
        Vector3f vector3f = this.getNormal();
        if (point4f.x * this.q1 + point4f.y * this.q2 + point4f.z * this.q3 < 0.0f) {
            vector3f.scale(-1.0f);
            f = -f;
        }
        point4f.set(vector3f.x, vector3f.y, vector3f.z, f);
        return point4f;
    }

    public float getThetaDirected(Vector3f vector3f) {
        float f = this.getTheta();
        Vector3f vector3f2 = this.getNormal();
        if (vector3f.x * this.q1 + vector3f.y * this.q2 + vector3f.z * this.q3 < 0.0f) {
            vector3f2.scale(-1.0f);
            f = -f;
        }
        return f;
    }

    public Point4f toPoint4f() {
        return new Point4f(this.q1, this.q2, this.q3, this.q0);
    }

    public AxisAngle4f toAxisAngle4f() {
        double d = 2.0 * Math.acos(Math.abs(this.q0));
        double d2 = Math.sin(d / 2.0);
        Vector3f vector3f = this.getNormal();
        if (d2 < 0.0) {
            vector3f.scale(-1.0f);
            d = Math.PI - d;
        }
        return new AxisAngle4f(vector3f, (float)d);
    }

    public Point3f transform(Point3f point3f) {
        if (this.mat == null) {
            this.setMatrix();
        }
        Point3f point3f2 = new Point3f(point3f);
        this.mat.transform(point3f2);
        return point3f2;
    }

    public void transform(Tuple3f tuple3f, Tuple3f tuple3f2) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.transform(tuple3f, tuple3f2);
    }

    public Vector3f transform(Vector3f vector3f) {
        if (this.mat == null) {
            this.setMatrix();
        }
        Vector3f vector3f2 = new Vector3f(vector3f);
        this.mat.transform(vector3f2);
        return vector3f2;
    }

    public Quaternion leftDifference(Quaternion quaternion) {
        Quaternion quaternion2 = this.dot(quaternion) < 0.0f ? quaternion.negate() : quaternion;
        return this.inv().mul(quaternion2);
    }

    public Quaternion rightDifference(Quaternion quaternion) {
        Quaternion quaternion2 = this.dot(quaternion) < 0.0f ? quaternion.negate() : quaternion;
        return this.mul(quaternion2.inv());
    }

    public String getInfo() {
        AxisAngle4f axisAngle4f = this.toAxisAngle4f();
        return TextFormat.sprintf("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", new Object[]{new float[]{this.q0, this.q1, this.q2, this.q3, (float)((double)(axisAngle4f.angle * 180.0f) / Math.PI), axisAngle4f.x, axisAngle4f.y, axisAngle4f.z}});
    }

    public String draw(String string, String string2, Point3f point3f, float f) {
        String string3 = " VECTOR " + Escape.escape(point3f) + " ";
        if (f == 0.0f) {
            f = 1.0f;
        }
        return "draw " + string + "x" + string2 + string3 + Escape.escape(this.getVector(0, f)) + " color red\n" + "draw " + string + "y" + string2 + string3 + Escape.escape(this.getVector(1, f)) + " color green\n" + "draw " + string + "z" + string2 + string3 + Escape.escape(this.getVector(2, f)) + " color blue\n";
    }

    public String toString() {
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public static Quaternion[] div(Quaternion[] quaternionArray, Quaternion[] quaternionArray2, int n, boolean bl) {
        int n2;
        if (quaternionArray == null || quaternionArray2 == null || (n2 = Math.min(quaternionArray.length, quaternionArray2.length)) == 0) {
            return null;
        }
        if (n > 0 && n2 > n) {
            n2 = n;
        }
        Quaternion[] quaternionArray3 = new Quaternion[n2];
        for (int i = 0; i < n2; ++i) {
            if (quaternionArray[i] == null || quaternionArray2[i] == null) {
                return null;
            }
            quaternionArray3[i] = bl ? quaternionArray[i].divLeft(quaternionArray2[i]) : quaternionArray[i].div(quaternionArray2[i]);
        }
        return quaternionArray3;
    }

    public static Quaternion sphereMean(Quaternion[] quaternionArray, float[] fArray, float f) {
        if (quaternionArray == null || quaternionArray.length == 0) {
            return new Quaternion();
        }
        if (fArray == null) {
            fArray = new float[1];
        }
        if (quaternionArray.length == 1) {
            fArray[0] = 0.0f;
            return new Quaternion(quaternionArray[0]);
        }
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        Quaternion quaternion = Quaternion.simpleAverage(quaternionArray);
        int n = 100;
        int n2 = 0;
        while (f2 > f && f3 != 0.0f && n2 < n) {
            quaternion = Quaternion.newMean(quaternionArray, quaternion);
            fArray[0] = Quaternion.stdDev(quaternionArray, quaternion);
            f2 = Math.abs(fArray[0] - f3);
            f3 = fArray[0];
            Logger.info(++n2 + " sphereMean " + quaternion + " stddev=" + f3 + " diff=" + f2);
        }
        return quaternion;
    }

    private static Quaternion simpleAverage(Quaternion[] quaternionArray) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f2 = quaternionArray[0].getNormal();
        vector3f.add(vector3f2);
        int n = quaternionArray.length;
        while (--n >= 0) {
            vector3f.add(quaternionArray[n].getNormalDirected(vector3f));
        }
        vector3f.sub(vector3f2);
        vector3f.normalize();
        float f = 0.0f;
        int n2 = quaternionArray.length;
        while (--n2 >= 0) {
            f += Math.abs(quaternionArray[n2].get3dProjection(vector3f2).dot(vector3f));
        }
        if (f != 0.0f) {
            vector3f.scale(f / (float)quaternionArray.length);
        }
        if (Float.isNaN(f = (float)Math.sqrt(1.0f - vector3f.lengthSquared()))) {
            f = 0.0f;
        }
        return new Quaternion(new Point4f(vector3f.x, vector3f.y, vector3f.z, f));
    }

    private static Quaternion newMean(Quaternion[] quaternionArray, Quaternion quaternion) {
        Vector3f vector3f = new Vector3f();
        int n = quaternionArray.length;
        while (--n >= 0) {
            Quaternion quaternion2 = quaternionArray[n];
            Quaternion quaternion3 = quaternion2.div(quaternion);
            Vector3f vector3f2 = quaternion3.getNormal();
            vector3f2.scale(quaternion3.getTheta());
            vector3f.add(vector3f2);
        }
        vector3f.scale(1.0f / (float)quaternionArray.length);
        Quaternion quaternion4 = new Quaternion(vector3f, vector3f.length());
        return quaternion4.mul(quaternion);
    }

    private static float stdDev(Quaternion[] quaternionArray, Quaternion quaternion) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = n = quaternionArray.length;
        while (--n2 >= 0) {
            Quaternion quaternion2 = quaternionArray[n2].div(quaternion);
            float f = quaternion2.getTheta();
            d += (double)f;
            d2 += (double)(f * f);
        }
        if ((d2 -= d * d / (double)n) < 0.0) {
            d2 = 0.0;
        }
        return (float)Math.sqrt(d2 / (double)(n - 1));
    }
}

